<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;

class PeriodLock extends Model
{
    protected $table = 'ar_period_locks';

    protected $guarded = ['id'];

    protected $casts = [
        'period_start' => 'date',
        'period_end' => 'date',
        'is_locked' => 'boolean',
        'locked_at' => 'datetime',
        'unlocked_at' => 'datetime',
    ];

    /**
     * Relationships
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    public function lockedBy()
    {
        return $this->belongsTo(\App\User::class, 'locked_by');
    }

    public function unlockedBy()
    {
        return $this->belongsTo(\App\User::class, 'unlocked_by');
    }

    /**
     * Check if a date falls within a locked period
     */
    public static function isDateLocked($businessId, $date)
    {
        return static::where('business_id', $businessId)
            ->where('is_locked', true)
            ->where('period_start', '<=', $date)
            ->where('period_end', '>=', $date)
            ->exists();
    }
}


