<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;

class LedgerRollup extends Model
{
    protected $table = 'ar_ledger_rollups';

    protected $guarded = ['id'];

    protected $casts = [
        'period_date' => 'date',
        'computed_at' => 'datetime',
        'opening_debit' => 'decimal:4',
        'opening_credit' => 'decimal:4',
        'opening_balance' => 'decimal:4',
        'period_debit' => 'decimal:4',
        'period_credit' => 'decimal:4',
        'closing_debit' => 'decimal:4',
        'closing_credit' => 'decimal:4',
        'closing_balance' => 'decimal:4',
    ];

    /**
     * Relationships
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    public function account()
    {
        return $this->belongsTo(ChartOfAccount::class, 'account_id');
    }

    public function location()
    {
        return $this->belongsTo(\App\BusinessLocation::class, 'location_id');
    }
}


