<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DirectIncomeName extends Model
{
    use SoftDeletes;

    protected $table = 'ar_direct_income_names';

    protected $fillable = [
        'business_id',
        'name',
        'description',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the business that owns the income name
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    /**
     * Get the user who created this income name
     */
    public function creator()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }
}


