<?php

namespace Modules\AccountingReports\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChequeBookEntry extends Model
{
    use SoftDeletes;

    protected $table = 'ar_cheque_book_entries';

    protected $guarded = ['id'];

    protected $casts = [
        'cheque_date' => 'date',
        'amount' => 'decimal:4',
        'cleared_date' => 'date',
        'presented_date' => 'date',
        'bounced_date' => 'date',
        'bank_statement_date' => 'date',
    ];

    /**
     * Relationships
     */
    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    public function account()
    {
        return $this->belongsTo(\App\Account::class, 'account_id');
    }

    public function transaction()
    {
        return $this->belongsTo(\App\Transaction::class, 'transaction_id');
    }

    public function transactionPayment()
    {
        return $this->belongsTo(\App\TransactionPayment::class, 'transaction_payment_id');
    }

    public function location()
    {
        return $this->belongsTo(\App\BusinessLocation::class, 'location_id');
    }

    public function chequeBook()
    {
        return $this->belongsTo(ChequeBook::class, 'cheque_book_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }

    /**
     * Scopes
     */
    public function scopeIssued($query)
    {
        return $query->where('type', 'issued');
    }

    public function scopeReceived($query)
    {
        return $query->where('type', 'received');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeCleared($query)
    {
        return $query->where('status', 'cleared');
    }

    public function scopeBounced($query)
    {
        return $query->where('status', 'bounced');
    }

    public function scopeByAccount($query, $account_id)
    {
        return $query->where('account_id', $account_id);
    }

    public function scopeByDateRange($query, $start_date, $end_date)
    {
        return $query->whereBetween('cheque_date', [$start_date, $end_date]);
    }
}

