<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_cheque_book_entries', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            // Bank account reference
            $table->integer('account_id')->unsigned();
            $table->foreign('account_id')->references('id')->on('accounts')->onDelete('cascade');
            
            // Cheque details
            $table->string('cheque_no', 100);
            $table->date('cheque_date');
            $table->decimal('amount', 22, 4);
            $table->enum('type', ['issued', 'received'])->default('issued');
            $table->enum('status', ['pending', 'cleared', 'bounced', 'cancelled', 'deposited'])->default('pending');
            
            // Transaction details
            $table->string('payee_name')->nullable()->comment('Person/company receiving the cheque');
            $table->text('narration')->nullable();
            $table->string('reference_no')->nullable();
            
            // Related transaction (optional)
            $table->integer('transaction_id')->unsigned()->nullable();
            $table->foreign('transaction_id')->references('id')->on('transactions')->onDelete('set null');
            $table->integer('transaction_payment_id')->unsigned()->nullable();
            $table->foreign('transaction_payment_id')->references('id')->on('transaction_payments')->onDelete('set null');
            
            // Clearing details
            $table->date('cleared_date')->nullable();
            $table->date('presented_date')->nullable();
            $table->date('bounced_date')->nullable();
            $table->text('bounce_reason')->nullable();
            
            // Bank statement matching
            $table->string('bank_statement_ref', 255)->nullable();
            $table->date('bank_statement_date')->nullable();
            
            $table->integer('location_id')->unsigned()->nullable();
            $table->foreign('location_id')->references('id')->on('business_locations')->onDelete('set null');
            
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['business_id', 'account_id', 'status']);
            $table->index(['business_id', 'account_id', 'cheque_date']);
            $table->index(['cheque_no', 'account_id']);
            $table->unique(['business_id', 'account_id', 'cheque_no'], 'unique_cheque_no_per_account');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_cheque_book_entries');
    }
};

