<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ar_direct_expenses', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('amount', 20, 2);
            $table->date('expense_date');
            
            $table->integer('location_id')->unsigned()->nullable();
            $table->foreign('location_id')->references('id')->on('business_locations')->onDelete('set null');
            
            $table->integer('account_id')->unsigned()->nullable();
            $table->foreign('account_id')->references('id')->on('accounts')->onDelete('set null');
            
            $table->string('reference_no')->nullable();
            $table->string('document')->nullable();
            
            // Payment fields
            $table->decimal('payment_amount', 20, 2)->nullable();
            $table->string('payment_method')->nullable();
            $table->integer('payment_account_id')->unsigned()->nullable();
            $table->foreign('payment_account_id')->references('id')->on('accounts')->onDelete('set null');
            $table->datetime('paid_on')->nullable();
            $table->string('payment_note')->nullable();
            $table->string('payment_status')->default('due')->nullable(); // due, partial, paid
            
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['business_id', 'expense_date']);
            $table->index(['location_id']);
            $table->index(['account_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ar_direct_expenses');
    }
};

