@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_product_in_out_statement'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_product_in_out_statement') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductInOutStatement']), 'method' => 'get', 'id' => 'date_wise_product_in_out_statement_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @php
                            $date_range_value = '';
                            if (!empty($start_date) && !empty($end_date)) {
                                $date_range_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y') . ' - ' . \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } elseif (!empty(request()->date_range)) {
                                $date_range_value = request()->date_range;
                            }
                        @endphp
                        {!! Form::text('date_range', $date_range_value, ['placeholder' => __('businessmanagement::lang.select_date_range'), 'class' => 'form-control', 'id' => 'date_wise_product_in_out_statement_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('businessmanagement::lang.all_categories'), 'single' => __('businessmanagement::lang.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('businessmanagement::lang.all_products'), 'single' => __('businessmanagement::lang.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductInOutStatement']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseProductInOutStatement'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $category_name => $items)
                            <h4 style="margin-top: 20px; margin-bottom: 10px; font-weight: bold; color: #2c3e50; font-size: 16px; text-decoration: underline;">{{ $category_name }}</h4>
                            <table class="table table-bordered table-striped" style="font-size: 12px; margin-bottom: 20px;">
                                <thead>
                                    <tr>
                                        <th style="width: 50px;">SL</th>
                                        <th>Product Description</th>
                                        <th style="text-align: right;">Opening Stock</th>
                                        <th style="text-align: right;">Stock In</th>
                                        <th style="text-align: right;">Sales</th>
                                        <th style="text-align: right;">Others Stock Out</th>
                                        <th style="text-align: right;">Closing Stock</th>
                                        <th>UoM</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $serial = 1;
                                        $category_total_qty1 = 0;
                                        $category_total_qty2 = 0;
                                        $category_total_qty3 = 0;
                                        $category_total_qty4 = 0;
                                        $category_total_qty5 = 0;
                                    @endphp
                                    @foreach($items as $item)
                                        @php
                                            $category_total_qty1 += $item->qty1;
                                            $category_total_qty2 += $item->qty2;
                                            $category_total_qty3 += $item->qty3;
                                            $category_total_qty4 += $item->qty4;
                                            $category_total_qty5 += $item->qty5;
                                        @endphp
                                        <tr>
                                            <td>{{ $serial++ }}</td>
                                            <td>{{ $item->product_description }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->qty1, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->qty2, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->qty3, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->qty4, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->qty5, false, null, true) }}</td>
                                            <td>{{ $item->unit }}</td>
                                        </tr>
                                    @endforeach
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="2"><strong>Sub Total:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty1, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty2, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty3, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty4, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_qty5, false, null, true) }}</strong></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <tbody>
                                <tr style="background-color: #d4edda; font-weight: bold; font-size: 16px;">
                                    <td colspan="2"><strong>Grand Total</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty1, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty2, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty3, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty4, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_qty5, false, null, true) }}</strong></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No product in/out data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#date_wise_product_in_out_statement_date_range').daterangepicker({
            autoUpdateInput: false,
            locale: {
                format: 'DD/MM/YYYY',
                separator: ' - ',
            }
        });

        $('#date_wise_product_in_out_statement_date_range').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('DD/MM/YYYY'));
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });

        $('#date_wise_product_in_out_statement_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });
    });
</script>
@endsection

