<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Product Wise Sales</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 70%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 15%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 8pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 5px 4px;
            text-align: center;
            font-weight: 600;
            font-size: 8pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 4px 3px;
            font-size: 8pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .product-group-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 9pt;
        }
        
        .product-group-row td {
            border: 1px solid #2c3e50;
            padding: 5px 4px;
            text-align: center;
        }
        
        .subtotal-row {
            background-color: #e8e8e8 !important;
            font-weight: 600;
            font-size: 9pt;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 6px 4px;
        }
        
        .grand-total-row {
            background-color: #d3d3d3 !important;
            font-weight: 700;
            font-size: 9pt;
            border-top: 1px solid #000;
        }
        
        .grand-total-row td {
            border: 1px solid #2c3e50;
            padding: 7px 4px;
        }
        
        .grand-total-row td:nth-child(5),
        .grand-total-row td:last-child {
            border-bottom: 2px solid #000;
        }
        
        .grand-total-row td:last-child {
            border-top: 2px solid #000;
        }
        
        .data-row-separator {
            border-bottom: 1px dotted #999;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .product-group-row {
                page-break-inside: avoid;
            }
            
            .subtotal-row {
                page-break-inside: avoid;
            }
            
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Product Wise Sales</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @elseif(!empty($end_date))
                {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Table -->
        @if(count($sell_lines) > 0)
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Invoice No</th>
                            <th>Customer Name</th>
                            <th>Purchase Invoice</th>
                            <th>Ref. No.</th>
                            <th>Qty</th>
                            <th>Unit Price</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($grouped_data as $product_name => $product_lines)
                            <tr class="product-group-row">
                                <td colspan="7" style="text-align: center; font-weight: bold;">{{ $product_name }}</td>
                            </tr>
                            @foreach($product_lines as $index => $line)
                                <tr class="{{ $index < count($product_lines) - 1 ? 'data-row-separator' : '' }}">
                                    <td>
                                        <div style="font-size: 7pt; color: #666;">{{ $util->format_date($line->transaction_date, false) }}</div>
                                        <div>{{ $line->invoice_no }}</div>
                                    </td>
                                    <td>
                                        @if(!empty($line->supplier_business_name))
                                            {{ $line->supplier_business_name }}
                                        @elseif(!empty($line->customer_name))
                                            {{ $line->customer_name }}
                                        @else
                                            WALKING CUSTOMER
                                        @endif
                                    </td>
                                    <td>{{ $line->purchase_invoice ?? '' }}</td>
                                    <td>{{ $line->ref_no ?? '' }}</td>
                                    <td class="text-right">{{ number_format($line->quantity, 2) }}</td>
                                    <td class="text-right">{{ number_format($line->unit_price_inc_tax, 2) }}</td>
                                    <td class="text-right">{{ number_format($line->quantity * $line->unit_price_inc_tax, 2) }}</td>
                                </tr>
                            @endforeach
                        @endforeach
                    </tbody>
                    <tfoot>
                        <!-- Sub Total -->
                        <tr class="subtotal-row">
                            <td colspan="4" class="text-right">Sub Total :</td>
                            <td class="text-right">{{ number_format($sub_total_qty, 2) }}</td>
                            <td></td>
                            <td class="text-right">{{ number_format($sub_total_amount, 2) }}</td>
                        </tr>
                        <!-- Grand Total -->
                        <tr class="grand-total-row">
                            <td colspan="4" class="text-right">Grand Total :</td>
                            <td class="text-right">{{ number_format($grand_total_qty, 2) }}</td>
                            <td></td>
                            <td class="text-right">{{ number_format($grand_total_amount, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @else
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>No sales data found for the selected filters.</p>
            </div>
        @endif
    </div>
</body>
</html>
