<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date wise Net Product Sales</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
        }
        
        table tbody td:nth-child(1) {
            text-align: left;
        }
        
        table tbody td:nth-child(2),
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7),
        table tbody td:nth-child(8),
        table tbody td:nth-child(9) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .category-header-row {
            background-color: #f5f7fa !important;
            font-weight: 700;
            font-size: 11pt;
            text-transform: uppercase;
        }
        
        .category-header-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
        }
        
        .brand-header-row {
            background-color: #e8ecf1 !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .brand-header-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
        }
        
        .brand-subtotal-row {
            background-color: #f9fafb !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .brand-subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .brand-subtotal-row td:first-child {
            text-align: left;
        }
        
        .brand-subtotal-row td:nth-child(2),
        .brand-subtotal-row td:nth-child(3),
        .brand-subtotal-row td:nth-child(4),
        .brand-subtotal-row td:nth-child(5),
        .brand-subtotal-row td:nth-child(6),
        .brand-subtotal-row td:nth-child(7),
        .brand-subtotal-row td:nth-child(8),
        .brand-subtotal-row td:nth-child(9) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .category-subtotal-row {
            background-color: #e8ecf1 !important;
            font-weight: 600;
            font-size: 10pt;
            border-top: 1px solid #2c3e50;
        }
        
        .category-subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .category-subtotal-row td:first-child {
            text-align: left;
        }
        
        .category-subtotal-row td:nth-child(2),
        .category-subtotal-row td:nth-child(3),
        .category-subtotal-row td:nth-child(4),
        .category-subtotal-row td:nth-child(5),
        .category-subtotal-row td:nth-child(6),
        .category-subtotal-row td:nth-child(7),
        .category-subtotal-row td:nth-child(8),
        .category-subtotal-row td:nth-child(9) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">Phone: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">Email: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <div class="report-title">Date wise Net Product Sales</div>
        
        <div class="report-info">
            @if($start_date && $end_date)
                @php
                    $start_formatted = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                    $end_formatted = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                @endphp
                {{ $start_formatted }} To {{ $end_formatted }}
            @endif
        </div>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Product Description</th>
                        <th>Sale Qty</th>
                        <th>Unit Price</th>
                        <th>Sales Amount</th>
                        <th>Return Qty</th>
                        <th>Return Price</th>
                        <th>Return Amount</th>
                        <th>Net Qty</th>
                        <th>Net Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categories_data as $category_id => $category_data)
                        <!-- Category Header -->
                        <tr class="category-header-row">
                            <td colspan="9"><strong>{{ $category_data['category_name'] }}</strong></td>
                        </tr>
                        
                        @foreach($category_data['brands'] as $brand_id => $brand_data)
                            <!-- Brand Header -->
                            <tr class="brand-header-row">
                                <td colspan="9"><strong>{{ $brand_data['brand_name'] }}</strong></td>
                            </tr>
                            
                            @foreach($brand_data['products'] as $product)
                                <tr>
                                    <td>{{ $product['product_description'] }}</td>
                                    <td>{{ $util->num_f($product['sale_qty'], true) }}</td>
                                    <td>{{ $util->num_f($product['unit_price'], true) }}</td>
                                    <td>{{ $util->num_f($product['sales_amount'], true) }}</td>
                                    <td>{{ $util->num_f($product['return_qty'], true) }}</td>
                                    <td>{{ $util->num_f($product['return_price'], true) }}</td>
                                    <td>{{ $util->num_f($product['return_amount'], true) }}</td>
                                    <td>{{ $util->num_f($product['net_qty'], true) }}</td>
                                    <td>{{ $util->num_f($product['net_amount'], true) }}</td>
                                </tr>
                            @endforeach
                            
                            <!-- Brand Wise Sub Total -->
                            <tr class="brand-subtotal-row">
                                <td><strong>Brand Wise Sub Tota</strong></td>
                                <td><strong>{{ $util->num_f($brand_data['total_sale_qty'], true) }}</strong></td>
                                <td></td>
                                <td><strong>{{ $util->num_f($brand_data['total_sales_amount'], true) }}</strong></td>
                                <td><strong>{{ $util->num_f($brand_data['total_return_qty'], true) }}</strong></td>
                                <td></td>
                                <td><strong>{{ $util->num_f($brand_data['total_return_amount'], true) }}</strong></td>
                                <td><strong>{{ $util->num_f($brand_data['total_net_qty'], true) }}</strong></td>
                                <td><strong>{{ $util->num_f($brand_data['total_net_amount'], true) }}</strong></td>
                            </tr>
                        @endforeach
                        
                        <!-- Group Wise Sub Total -->
                        <tr class="category-subtotal-row">
                            <td><strong>Group Wise Sub Tota</strong></td>
                            <td><strong>{{ $util->num_f($category_data['total_sale_qty'], true) }}</strong></td>
                            <td></td>
                            <td><strong>{{ $util->num_f($category_data['total_sales_amount'], true) }}</strong></td>
                            <td><strong>{{ $util->num_f($category_data['total_return_qty'], true) }}</strong></td>
                            <td></td>
                            <td><strong>{{ $util->num_f($category_data['total_return_amount'], true) }}</strong></td>
                            <td><strong>{{ $util->num_f($category_data['total_net_qty'], true) }}</strong></td>
                            <td><strong>{{ $util->num_f($category_data['total_net_amount'], true) }}</strong></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>

