<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Daily Sales Details</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 70%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 15%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 8pt;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tfoot {
            display: table-footer-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 5px 4px;
            text-align: left;
            font-weight: 600;
            font-size: 8pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 4px 3px;
            font-size: 8pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        .text-right {
            text-align: right !important;
        }
        
        /* Subtotal Row */
        .subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: bold;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 5px 4px;
        }
        
        /* Footer */
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 8pt;
            color: #6a6a6a;
            text-align: center;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            thead {
                display: table-header-group;
            }
            
            tfoot {
                display: table-footer-group;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->phone))
                    <div class="company-contact">{{ $business->phone }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Daily Sales Details</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Report Content -->
        @if(count($customers_data) > 0)
            <table>
                <thead>
                    <tr>
                        <th>Customer Name</th>
                        <th>Product Description</th>
                        <th>Invoice No</th>
                        <th style="text-align: right;">Qty</th>
                        <th style="text-align: right;">Rate</th>
                        <th style="text-align: right;">Total Amount</th>
                        <th style="text-align: right;">Service Charges</th>
                        <th style="text-align: right;">Received with Cheque</th>
                        <th style="text-align: right;">Prev. Balance</th>
                        <th style="text-align: right;">Balance</th>
                        <th>Narration</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($customers_data as $contact_id => $customer_data)
                        @foreach($customer_data['lines'] as $line)
                            <tr>
                                <td>{{ $customer_data['customer_name'] }}</td>
                                <td>{{ $line['product_description'] }}</td>
                                <td>{{ $line['invoice_no'] }}</td>
                                <td class="text-right">{{ number_format($line['qty'], 2) }} {{ strtoupper($line['unit_name'] ?? 'PCS') }}</td>
                                <td class="text-right">{{ $util->num_f($line['rate'], true) }}</td>
                                <td class="text-right">{{ $util->num_f($line['line_total'], true) }}</td>
                                <td class="text-right">{{ $util->num_f(0, true) }}</td>
                                <td class="text-right">-</td>
                                <td class="text-right">-</td>
                                <td class="text-right">-</td>
                                <td>-</td>
                            </tr>
                        @endforeach
                        <tr class="subtotal-row">
                            <td colspan="3"><strong>Sub Total:</strong></td>
                            <td class="text-right">{{ number_format($customer_data['customer_total_qty'], 2) }}</td>
                            <td class="text-right">-</td>
                            <td class="text-right">{{ $util->num_f($customer_data['customer_total_amount'], true) }}</td>
                            <td class="text-right">{{ $util->num_f($customer_data['customer_service_charges'], true) }}</td>
                            <td class="text-right">{{ $util->num_f($customer_data['received_with_cheque'], true) }}</td>
                            <td class="text-right">{{ $util->num_f($customer_data['prev_balance'], true) }}</td>
                            <td class="text-right">{{ $util->num_f($customer_data['current_balance'], true) }}</td>
                            <td>-</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif

        <!-- Footer -->
        <div class="footer">
            <div>{{ date('m/d/Y h:i:sA') }}</div>
        </div>
    </div>
</body>
</html>

