@extends('layouts.app')
@section('title', 'Customer wise Statement')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Customer wise Statement</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseStatement']), 'method' => 'get', 'id' => 'customer_wise_statement_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'customer_wise_statement_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', ['all' => __('lang_v1.all_customers'), 'single' => __('lang_v1.single_customer')], !empty($customer_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="customer_select_wrapper" style="display: {{ !empty($customer_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseStatement']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseStatement'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id, 'customer_id' => $customer_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($table_data) > 0)
                        @foreach($grouped_data as $group_name => $group_customers)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; font-weight: bold; color: #2c3e50;">{{ $group_name }}</h4>
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th>TraderName</th>
                                        <th style="text-align: right;">Opening</th>
                                        <th style="text-align: right;">Sales</th>
                                        <th style="text-align: right;">S.Return</th>
                                        <th style="text-align: right;">Net Sales</th>
                                        <th style="text-align: right;">Sales Qty</th>
                                        <th style="text-align: right;">S.Return Qty</th>
                                        <th style="text-align: right;">Purchase Qty</th>
                                        <th style="text-align: right;">P.Return Qty</th>
                                        <th style="text-align: right;">Purchase</th>
                                        <th style="text-align: right;">Pur.Return</th>
                                        <th style="text-align: right;">Receive</th>
                                        <th style="text-align: right;">Payment</th>
                                        <th style="text-align: right;">Other Cr</th>
                                        <th style="text-align: right;">Other Dr</th>
                                        <th style="text-align: right;">Discount</th>
                                        <th style="text-align: right;">Due</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $subtotal_opening = 0;
                                        $subtotal_sales = 0;
                                        $subtotal_sales_return = 0;
                                        $subtotal_net_sales = 0;
                                        $subtotal_sales_qty = 0;
                                        $subtotal_sales_return_qty = 0;
                                        $subtotal_purchase_qty = 0;
                                        $subtotal_purchase_return_qty = 0;
                                        $subtotal_purchase = 0;
                                        $subtotal_purchase_return = 0;
                                        $subtotal_receive = 0;
                                        $subtotal_payment = 0;
                                        $subtotal_other_cr = 0;
                                        $subtotal_other_dr = 0;
                                        $subtotal_discount = 0;
                                        $subtotal_due = 0;
                                    @endphp
                                    @foreach($group_customers as $row)
                                        @php
                                            $subtotal_opening += $row['opening_balance'];
                                            $subtotal_sales += $row['sales'];
                                            $subtotal_sales_return += $row['sales_return'];
                                            $subtotal_net_sales += $row['net_sales'];
                                            $subtotal_sales_qty += $row['sales_qty'];
                                            $subtotal_sales_return_qty += $row['sales_return_qty'];
                                            $subtotal_purchase_qty += $row['purchase_qty'];
                                            $subtotal_purchase_return_qty += $row['purchase_return_qty'];
                                            $subtotal_purchase += $row['purchase'];
                                            $subtotal_purchase_return += $row['purchase_return'];
                                            $subtotal_receive += $row['receive'];
                                            $subtotal_payment += $row['payment'];
                                            $subtotal_other_cr += $row['other_cr'];
                                            $subtotal_other_dr += $row['other_dr'];
                                            $subtotal_discount += $row['discount'];
                                            $subtotal_due += $row['due'];
                                        @endphp
                                        <tr>
                                            <td>{{ $row['customer_name'] }}</td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['opening_balance'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['sales'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['sales_return'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['net_sales'] }}</span>
                                            </td>
                                            <td style="text-align: right;">{{ number_format($row['sales_qty'], 2) }}</td>
                                            <td style="text-align: right;">{{ number_format($row['sales_return_qty'], 2) }}</td>
                                            <td style="text-align: right;">{{ number_format($row['purchase_qty'], 2) }}</td>
                                            <td style="text-align: right;">{{ number_format($row['purchase_return_qty'], 2) }}</td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['purchase'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['purchase_return'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['receive'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['payment'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['other_cr'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['other_dr'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['discount'] }}</span>
                                            </td>
                                            <td style="text-align: right;">
                                                <span class="display_currency" data-currency_symbol="true">{{ $row['due'] }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                    <!-- Sub Total Row -->
                                    <tr style="background-color: #f5f5f5; font-weight: bold;">
                                        <td style="text-align: right;">Sub Total:</td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_opening }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_sales }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_sales_return }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_net_sales }}</span>
                                        </td>
                                        <td style="text-align: right;">{{ number_format($subtotal_sales_qty, 2) }}</td>
                                        <td style="text-align: right;">{{ number_format($subtotal_sales_return_qty, 2) }}</td>
                                        <td style="text-align: right;">{{ number_format($subtotal_purchase_qty, 2) }}</td>
                                        <td style="text-align: right;">{{ number_format($subtotal_purchase_return_qty, 2) }}</td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_purchase }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_purchase_return }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_receive }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_payment }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_other_cr }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_other_dr }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_discount }}</span>
                                        </td>
                                        <td style="text-align: right;">
                                            <span class="display_currency" data-currency_symbol="true">{{ $subtotal_due }}</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No customer data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#customer_wise_statement_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#customer_wise_statement_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#customer_wise_statement_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#customer_wise_statement_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val('').trigger('change');
            }
        });

        // Reload when date range changes
        $('#customer_wise_statement_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection


