@extends('layouts.app')
@section('title', 'Customer wise Sales')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Customer wise Sales</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSales']), 'method' => 'get', 'id' => 'customer_wise_sales_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_filter', 'Customer Filter' . ':') !!}
                        {!! Form::select('customer_filter', ['all' => 'All Customer', 'single' => 'Single Customer'], 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="customer_select_wrapper" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('customer_id', 'Customer' . ':') !!}
                        {!! Form::select('customer_id', $customers, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => 'Select Customer', 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('invoice_no', 'Invoice No' . ':') !!}
                        {!! Form::text('invoice_no', null, ['class' => 'form-control', 'placeholder' => 'Invoice No', 'id' => 'invoice_no']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'customer_wise_sales_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="customer_wise_sales_table">
                        <thead>
                            <tr>
                                <th>@lang('sale.date')</th>
                                <th>@lang('sale.invoice_no')</th>
                                <th>@lang('contact.customer')</th>
                                <th>Product Description</th>
                                <th>Qty</th>
                                <th>Unit Price</th>
                                <th>Discount</th>
                                <th>Net Unit Price</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#customer_wise_sales_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#customer_wise_sales_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
            }
        );

        $('#customer_wise_sales_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val('').trigger('change');
            }
        });

        var customer_wise_sales_table = $('#customer_wise_sales_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "customerWiseSales"]) }}',
                data: function(d) {
                    d.customer_id = $('#customer_filter').val() == 'single' ? $('#customer_id').val() : '';
                    d.invoice_no = $('#invoice_no').val();
                    d.location_id = $('#location_id').val();
                    if ($('#customer_wise_sales_date_range').val()) {
                        var start = $('#customer_wise_sales_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#customer_wise_sales_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'customer_name', name: 'customer_name' },
                { data: 'product_description', name: 'product_description' },
                { data: 'quantity', name: 'quantity' },
                { data: 'unit_price', name: 'unit_price', orderable: false },
                { data: 'discount', name: 'discount', orderable: false },
                { data: 'net_unit_price', name: 'net_unit_price', orderable: false },
                { data: 'line_total', name: 'line_total', orderable: false },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#customer_wise_sales_table'));
            },
        });

        // Apply filters button
        $('#apply_filters').on('click', function() {
            customer_wise_sales_table.ajax.reload();
            checkPrintButton();
        });

        // Reset filters button
        $('#reset_filters').on('click', function() {
            $('#customer_filter').val('all').trigger('change');
            $('#customer_id').val('').trigger('change');
            $('#invoice_no').val('');
            $('#location_id').val('').trigger('change');
            $('#customer_wise_sales_date_range').val('');
            customer_wise_sales_table.ajax.reload();
            checkPrintButton();
        });

        // Auto-reload on filter change
        $('#customer_id, #location_id').on('change', function() {
            customer_wise_sales_table.ajax.reload(null, false);
        });

        // Reload when date range changes
        $('#customer_wise_sales_date_range').on('apply.daterangepicker', function(ev, picker) {
            customer_wise_sales_table.ajax.reload(null, false);
            checkPrintButton();
        });

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#customer_wise_sales_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Print button click
        $('#print_report').on('click', function() {
            var customer_id = '';
            if ($('#customer_filter').val() == 'single') {
                customer_id = $('#customer_id').val() || '';
            }
            var invoice_no = $('#invoice_no').val() || '';
            var location_id = $('#location_id').val() || '';
            var start_date = '';
            var end_date = '';
            
            if ($('#customer_wise_sales_date_range').val()) {
                start_date = $('#customer_wise_sales_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#customer_wise_sales_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
            
            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "printCustomerWiseSales"]) }}';
            url += '?customer_id=' + customer_id;
            url += '&invoice_no=' + invoice_no;
            url += '&location_id=' + location_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;
            
            window.open(url, '_blank');
        });

        // Initial check
        checkPrintButton();
    });
</script>
@endsection


