@extends('layouts.app')
@section('title', 'Purchased Product Movement')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Purchased Product Movement</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'purchased_product_movement_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_filter', 'Date Filter:') !!}
                        {!! Form::select('date_filter', ['date_wise' => 'Date wise'], 'date_wise', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'date_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'purchased_product_movement_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_id',  __('product.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_categories'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('invoice_filter', 'Invoice Filter:') !!}
                        {!! Form::select('invoice_filter', ['all' => 'All Invoice', 'single' => 'Invoice wise'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'invoice_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="invoice_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('invoice_no', 'Invoice No:') !!}
                        {!! Form::text('invoice_no', null, ['class' => 'form-control', 'placeholder' => 'Enter Invoice No', 'id' => 'invoice_no']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('supplier_filter', 'Supplier Filter:') !!}
                        {!! Form::select('supplier_filter', ['all' => 'All Supplier', 'single' => 'Single Supplier'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'supplier_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="supplier_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('supplier_id',  __('purchase.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_supplier'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="purchased_product_movement_table">
                        <thead>
                            <tr>
                                <th>@lang('purchase.supplier')</th>
                                <th>@lang('product.category')</th>
                                <th>@lang('sale.product')</th>
                                <th>@lang('purchase.invoice_no')</th>
                                <th>@lang('sale.date')</th>
                                <th>Transaction</th>
                                <th>@lang('sale.qty')</th>
                                <th>Unit Price</th>
                                <th>Unit Cost</th>
                                <th>Cost Amount</th>
                                <th>Amount</th>
                                <th>Profit</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#purchased_product_movement_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#purchased_product_movement_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }
        );
        $('#purchased_product_movement_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        // Show/hide invoice input based on filter
        $('#invoice_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#invoice_select_container').show();
            } else {
                $('#invoice_select_container').hide();
                $('#invoice_no').val('');
            }
        });

        // Show/hide supplier select based on filter
        $('#supplier_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#supplier_select_container').show();
            } else {
                $('#supplier_select_container').hide();
                $('#supplier_id').val(null).trigger('change');
            }
        });

        // Initialize DataTable
        var table = $('#purchased_product_movement_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'purchasedProductMovement']) }}",
                data: function(d) {
                    d.date_range = $('#purchased_product_movement_date_range').val();
                    d.category_id = $('#category_id').val();
                    d.invoice_filter = $('#invoice_filter').val();
                    d.invoice_no = $('#invoice_no').val();
                    d.supplier_filter = $('#supplier_filter').val();
                    d.supplier_id = $('#supplier_id').val();
                    d.location_id = $('#location_id').val();
                }
            },
            columns: [
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'category_name', name: 'category_name' },
                { data: 'product_name', name: 'product_name' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'transaction_type', name: 'transaction_type' },
                { data: 'quantity', name: 'quantity' },
                { data: 'unit_price', name: 'unit_price' },
                { data: 'unit_cost', name: 'unit_cost' },
                { data: 'cost_amount', name: 'cost_amount' },
                { data: 'amount', name: 'amount' },
                { data: 'profit', name: 'profit' }
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#purchased_product_movement_table'));
            },
        });

        // Apply filters
        $('#apply_filters').on('click', function() {
            table.ajax.reload();
            $('#print_report').show();
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#purchased_product_movement_filter_form')[0].reset();
            $('#purchased_product_movement_date_range').val('');
            $('#category_id').val(null).trigger('change');
            $('#invoice_filter').val('all').trigger('change');
            $('#invoice_no').val('');
            $('#supplier_filter').val('all').trigger('change');
            $('#supplier_id').val(null).trigger('change');
            $('#location_id').val(null).trigger('change');
            $('#invoice_select_container').hide();
            $('#supplier_select_container').hide();
            table.ajax.reload();
            $('#print_report').hide();
        });

        // Print report
        $('#print_report').on('click', function() {
            var date_range = $('#purchased_product_movement_date_range').val();
            var category_id = $('#category_id').val();
            var invoice_filter = $('#invoice_filter').val();
            var invoice_no = $('#invoice_no').val();
            var supplier_filter = $('#supplier_filter').val();
            var supplier_id = $('#supplier_id').val();
            var location_id = $('#location_id').val();

            var url = "{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printPurchasedProductMovement']) }}";
            url += '?date_range=' + encodeURIComponent(date_range);
            if (category_id) {
                url += '&category_id=' + category_id;
            }
            url += '&invoice_filter=' + invoice_filter;
            if (invoice_no) {
                url += '&invoice_no=' + encodeURIComponent(invoice_no);
            }
            url += '&supplier_filter=' + supplier_filter;
            if (supplier_id) {
                url += '&supplier_id=' + supplier_id;
            }
            if (location_id) {
                url += '&location_id=' + location_id;
            }

            window.open(url, '_blank');
        });
    });
</script>
@endsection

