@extends('layouts.app')
@section('title', 'Product wise Purchase')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Product wise Purchase</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'product_wise_purchase_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('report_type', 'Report Type:') !!}
                        {!! Form::select('report_type', ['date_wise' => 'Date wise'], 'date_wise', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'report_type']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', 'Product Filter:') !!}
                        {!! Form::select('product_filter', ['all' => 'All Product', 'category' => 'Category wise'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_container">
                    <div class="form-group">
                        {!! Form::label('category_id',  __('product.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_categories'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_wise_purchase_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('amount_filter', 'Amount Filter:') !!}
                        {!! Form::select('amount_filter', ['all' => 'All Amount', 'range' => 'Amount Range'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'amount_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="amount_range_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('min_amount', 'Min Amount:') !!}
                        {!! Form::text('min_amount', null, ['class' => 'form-control', 'placeholder' => '0.00', 'id' => 'min_amount']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="amount_range_container_max" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('max_amount', 'Max Amount:') !!}
                        {!! Form::text('max_amount', null, ['class' => 'form-control', 'placeholder' => '0.00', 'id' => 'max_amount']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="product_wise_purchase_table">
                        <thead>
                            <tr>
                                <th>@lang('sale.date')</th>
                                <th>@lang('purchase.invoice_no')</th>
                                <th>@lang('purchase.ref_no')</th>
                                <th>@lang('product.category')</th>
                                <th>@lang('purchase.supplier')</th>
                                <th>@lang('sale.product')</th>
                                <th>@lang('sale.qty')</th>
                                <th>@lang('lang_v1.unit')</th>
                                <th>@lang('sale.unit_price')</th>
                                <th>@lang('sale.total')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#product_wise_purchase_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#product_wise_purchase_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                checkPrintButton();
            }
        );

        $('#product_wise_purchase_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            checkPrintButton();
        });

        // Show/hide category select based on filter
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'category') {
                $('#category_select_container').show();
            } else {
                $('#category_select_container').hide();
                $('#category_id').val('').trigger('change');
            }
        });

        // Show/hide amount range inputs based on filter
        $('#amount_filter').on('change', function() {
            if ($(this).val() == 'range') {
                $('#amount_range_container').show();
                $('#amount_range_container_max').show();
            } else {
                $('#amount_range_container').hide();
                $('#amount_range_container_max').hide();
                $('#min_amount').val('');
                $('#max_amount').val('');
            }
        });

        // Initial state
        if ($('#product_filter').val() == 'all') {
            $('#category_select_container').hide();
        }
        if ($('#amount_filter').val() == 'all') {
            $('#amount_range_container').hide();
            $('#amount_range_container_max').hide();
        }

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#product_wise_purchase_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Print button click
        $('#print_report').on('click', function() {
            var category_id = '';
            if ($('#product_filter').val() == 'category') {
                category_id = $('#category_id').val() || '';
            }
            var location_id = $('#location_id').val() || '';
            var start_date = '';
            var end_date = '';
            var min_amount = '';
            var max_amount = '';

            if ($('#product_wise_purchase_date_range').val()) {
                start_date = $('#product_wise_purchase_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#product_wise_purchase_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }

            if ($('#amount_filter').val() == 'range') {
                min_amount = $('#min_amount').val() || '';
                max_amount = $('#max_amount').val() || '';
            }

            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "printProductWisePurchase"]) }}';
            url += '?category_id=' + category_id;
            url += '&location_id=' + location_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;
            url += '&min_amount=' + min_amount;
            url += '&max_amount=' + max_amount;

            window.open(url, '_blank');
        });

        // Initialize DataTable
        var product_wise_purchase_table = $('#product_wise_purchase_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "productWisePurchase"]) }}',
                data: function(d) {
                    d.category_id = '';
                    if ($('#product_filter').val() == 'category') {
                        d.category_id = $('#category_id').val() || '';
                    }
                    d.location_id = $('#location_id').val();
                    if ($('#product_wise_purchase_date_range').val()) {
                        var start = $('#product_wise_purchase_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#product_wise_purchase_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    if ($('#amount_filter').val() == 'range') {
                        d.min_amount = $('#min_amount').val() || '';
                        d.max_amount = $('#max_amount').val() || '';
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'ref_no', name: 'ref_no' },
                { data: 'category_name', name: 'category_name' },
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'product_description', name: 'product_description' },
                { data: 'quantity', name: 'quantity' },
                { data: 'unit_name', name: 'unit_name' },
                { data: 'unit_price', name: 'unit_price' },
                { data: 'line_total', name: 'line_total' },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#product_wise_purchase_table'));
            },
        });

        // Initial check
        checkPrintButton();

        // Check on filter changes
        $('#apply_filters').on('click', function() {
            product_wise_purchase_table.ajax.reload();
            setTimeout(checkPrintButton, 500);
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#report_type').val('date_wise').trigger('change');
            $('#product_filter').val('all').trigger('change');
            $('#category_id').val('').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#amount_filter').val('all').trigger('change');
            $('#min_amount').val('');
            $('#max_amount').val('');
            $('#product_wise_purchase_date_range').val('');
            $('#print_report').hide();
            product_wise_purchase_table.ajax.reload();
        });
    });
</script>
@endsection



