@extends('layouts.app')
@section('title', __('businessmanagement::lang.day_book'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.day_book') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dayBook']), 'method' => 'get', 'id' => 'day_book_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'day_book_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'day_book_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('transaction_type', __('businessmanagement::lang.transaction_type') . ':') !!}
                        {!! Form::select('transaction_type', [
                            'all' => __('businessmanagement::lang.all'),
                            'everything' => __('businessmanagement::lang.everything'),
                            'credit_voucher' => __('businessmanagement::lang.credit_voucher'),
                            'debit_voucher' => __('businessmanagement::lang.debit_voucher'),
                            'purchase' => __('purchase.purchase'),
                            'sales' => __('sale.sale'),
                            'sales_return' => __('businessmanagement::lang.sales_return'),
                        ], $transaction_type ?? 'all', ['class' => 'form-control select2', 'style' => 'width:100%']); !!}
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dayBook']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDayBook'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'location_id' => $location_id ?? '', 'transaction_type' => $transaction_type ?? 'all']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    <table class="table table-bordered" style="font-size: 12px; width: 100%;">
                        <thead>
                            <tr>
                                <th style="text-align: left;">InvoiceNO</th>
                                <th style="text-align: left;">TraderName</th>
                                <th style="text-align: left;">Ref No</th>
                                <th style="text-align: left;">Narration</th>
                                <th style="text-align: right;">Debit</th>
                                <th style="text-align: right;">Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $total_debit = 0;
                                $total_credit = 0;
                            @endphp
                            
                            <!-- Credit Voucher Section -->
                            @if(count($credit_vouchers) > 0)
                                <tr>
                                    <td colspan="6" style="font-weight: bold; background-color: #f0f0f0;">Credit voucher</td>
                                </tr>
                                <tr>
                                    <td colspan="6" style="font-weight: bold; padding-left: 20px;">Receipt</td>
                                </tr>
                                @foreach($credit_vouchers as $voucher)
                                    <tr>
                                        <td>{{ $voucher->voucher_id }}</td>
                                        <td>{{ $voucher->trader_name }}</td>
                                        <td>{{ $voucher->ref_no }}</td>
                                        <td>{{ $voucher->narration }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($voucher->debit, true, null) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($voucher->credit, true, null) }}</td>
                                    </tr>
                                    @php
                                        $total_credit += (float) $voucher->credit;
                                    @endphp
                                @endforeach
                                <tr style="border-top: 1px solid #000;">
                                    <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                    <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                    <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($total_credit, true, null) }}</td>
                                </tr>
                            @endif
                            
                            <!-- Debit Voucher Section -->
                            @if(count($payment_vouchers) > 0 || count($general_payment_vouchers) > 0)
                                <tr>
                                    <td colspan="6" style="font-weight: bold; background-color: #f0f0f0;">Debit voucher</td>
                                </tr>
                                
                                @if(count($payment_vouchers) > 0)
                                    <tr>
                                        <td colspan="6" style="font-weight: bold; padding-left: 20px;">Payment</td>
                                    </tr>
                                    @php $payment_total_debit = 0; @endphp
                                    @foreach($payment_vouchers as $voucher)
                                        <tr>
                                            <td>{{ $voucher->voucher_id }}</td>
                                            <td>{{ $voucher->trader_name }}</td>
                                            <td>{{ $voucher->ref_no }}</td>
                                            <td>{{ $voucher->narration }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($voucher->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($voucher->credit, true, null) }}</td>
                                        </tr>
                                        @php
                                            $payment_total_debit += (float) $voucher->debit;
                                            $total_debit += (float) $voucher->debit;
                                        @endphp
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($payment_total_debit, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                    </tr>
                                @endif
                                
                                @if(count($general_payment_vouchers) > 0)
                                    <tr>
                                        <td colspan="6" style="font-weight: bold; padding-left: 20px;">General Payment</td>
                                    </tr>
                                    @php $general_payment_total_debit = 0; @endphp
                                    @foreach($general_payment_vouchers as $voucher)
                                        <tr>
                                            <td>{{ $voucher->voucher_id }}</td>
                                            <td>{{ $voucher->trader_name }}</td>
                                            <td>{{ $voucher->ref_no }}</td>
                                            <td>{{ $voucher->narration }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($voucher->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($voucher->credit, true, null) }}</td>
                                        </tr>
                                        @php
                                            $general_payment_total_debit += (float) $voucher->debit;
                                            $total_debit += (float) $voucher->debit;
                                        @endphp
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($general_payment_total_debit, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                    </tr>
                                @endif
                                
                                @php
                                    $debit_voucher_total = $payment_total_debit + $general_payment_total_debit;
                                @endphp
                                <tr style="border-top: 1px solid #000;">
                                    <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                    <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($debit_voucher_total, true, null) }}</td>
                                    <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                </tr>
                            @endif
                            
                            <!-- Purchase Section -->
                            @if(count($cash_purchases) > 0 || count($credit_purchases) > 0)
                                <tr>
                                    <td colspan="6" style="font-weight: bold; background-color: #f0f0f0;">Purchase</td>
                                </tr>
                                
                                @if(count($cash_purchases) > 0)
                                    <tr>
                                        <td colspan="6" style="font-weight: bold; padding-left: 20px;">Cash</td>
                                    </tr>
                                    @php $cash_purchase_total = 0; @endphp
                                    @foreach($cash_purchases as $purchase)
                                        <tr>
                                            <td>{{ $purchase->voucher_id }}</td>
                                            <td>{{ $purchase->trader_name }}</td>
                                            <td>{{ $purchase->ref_no }}</td>
                                            <td>{{ $purchase->narration }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($purchase->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($purchase->credit, true, null) }}</td>
                                        </tr>
                                        @php
                                            $cash_purchase_total += (float) $purchase->debit;
                                            $total_debit += (float) $purchase->debit;
                                        @endphp
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($cash_purchase_total, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                    </tr>
                                @endif
                                
                                @if(count($credit_purchases) > 0)
                                    <tr>
                                        <td colspan="6" style="font-weight: bold; padding-left: 20px;">Credit</td>
                                    </tr>
                                    @php $credit_purchase_total = 0; @endphp
                                    @foreach($credit_purchases as $purchase)
                                        <tr>
                                            <td>{{ $purchase->voucher_id }}</td>
                                            <td>{{ $purchase->trader_name }}</td>
                                            <td>{{ $purchase->ref_no }}</td>
                                            <td>{{ $purchase->narration }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($purchase->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($purchase->credit, true, null) }}</td>
                                        </tr>
                                        @php
                                            $credit_purchase_total += (float) $purchase->debit;
                                            $total_debit += (float) $purchase->debit;
                                        @endphp
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($credit_purchase_total, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                    </tr>
                                @endif
                                
                                @php
                                    $purchase_total = $cash_purchase_total + $credit_purchase_total;
                                @endphp
                                <tr style="border-top: 1px solid #000;">
                                    <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                    <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($purchase_total, true, null) }}</td>
                                    <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                </tr>
                            @endif
                            
                            <!-- Sales Section -->
                            @if(count($cash_sales) > 0 || count($credit_sales) > 0)
                                <tr>
                                    <td colspan="6" style="font-weight: bold; background-color: #f0f0f0;">Sales</td>
                                </tr>
                                
                                @if(count($cash_sales) > 0)
                                    <tr>
                                        <td colspan="6" style="font-weight: bold; padding-left: 20px;">Cash</td>
                                    </tr>
                                    @php $cash_sales_total = 0; @endphp
                                    @foreach($cash_sales as $sale)
                                        <tr>
                                            <td>{{ $sale->voucher_id }}</td>
                                            <td>{{ $sale->trader_name }}</td>
                                            <td>{{ $sale->ref_no }}</td>
                                            <td>{{ $sale->narration }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($sale->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($sale->credit, true, null) }}</td>
                                        </tr>
                                        @php
                                            $cash_sales_total += (float) $sale->credit;
                                            $total_credit += (float) $sale->credit;
                                        @endphp
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($cash_sales_total, true, null) }}</td>
                                    </tr>
                                @endif
                                
                                @if(count($credit_sales) > 0)
                                    <tr>
                                        <td colspan="6" style="font-weight: bold; padding-left: 20px;">Credit</td>
                                    </tr>
                                    @php $credit_sales_total = 0; @endphp
                                    @foreach($credit_sales as $sale)
                                        <tr>
                                            <td>{{ $sale->voucher_id }}</td>
                                            <td>{{ $sale->trader_name }}</td>
                                            <td>{{ $sale->ref_no }}</td>
                                            <td>{{ $sale->narration }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($sale->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($sale->credit, true, null) }}</td>
                                        </tr>
                                        @php
                                            $credit_sales_total += (float) $sale->credit;
                                            $total_credit += (float) $sale->credit;
                                        @endphp
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($credit_sales_total, true, null) }}</td>
                                    </tr>
                                @endif
                            @endif
                            
                            <!-- Sales Return Section -->
                            @if(count($cash_sales_returns) > 0 || count($credit_sales_returns) > 0)
                                <tr>
                                    <td colspan="6" style="font-weight: bold; background-color: #f0f0f0;">Sales Return</td>
                                </tr>
                                
                                @if(count($cash_sales_returns) > 0)
                                    <tr>
                                        <td colspan="6" style="font-weight: bold; padding-left: 20px;">Cash</td>
                                    </tr>
                                    @php $cash_sales_return_total = 0; @endphp
                                    @foreach($cash_sales_returns as $return)
                                        <tr>
                                            <td>{{ $return->voucher_id }}</td>
                                            <td>{{ $return->trader_name }}</td>
                                            <td>{{ $return->ref_no }}</td>
                                            <td>{{ $return->narration }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($return->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($return->credit, true, null) }}</td>
                                        </tr>
                                        @php
                                            $cash_sales_return_total += (float) $return->debit;
                                            $total_debit += (float) $return->debit;
                                        @endphp
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td colspan="4" style="font-weight: bold;">Sub Total:</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f($cash_sales_return_total, true, null) }}</td>
                                        <td style="text-align: right; font-weight: bold; border-top: 1px solid #000;">{{ $util->num_f(0, true, null) }}</td>
                                    </tr>
                                @endif
                            @endif
                            
                            <!-- Grand Total -->
                            <tr style="border-top: 2px double #000;">
                                <td colspan="3"></td>
                                <td style="font-weight: bold;">Grand Total:</td>
                                <td style="text-align: right; font-weight: bold; border-top: 2px double #000;">{{ $util->num_f($grand_total_debit, true, null) }}</td>
                                <td style="text-align: right; font-weight: bold; border-top: 2px double #000;">{{ $util->num_f($grand_total_credit, true, null) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#day_book_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#day_book_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#day_book_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#day_book_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#day_book_filter_form').on('submit', function() {
            var start_date_val = $('#day_book_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#day_book_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

