@extends('layouts.app')
@section('title', __('businessmanagement::lang.all_customers_due_list'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.all_customers_due_list') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'allCustomersDueList']), 'method' => 'get', 'id' => 'all_customers_due_list_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date', __('businessmanagement::lang.date') . ':') !!}
                        @php
                            $date_value = '';
                            if (!empty($date)) {
                                $date_value = \Carbon\Carbon::parse($date)->format('d/m/Y');
                            } else {
                                $date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('date_display', $date_value, ['class' => 'form-control date-picker', 'id' => 'all_customers_due_list_date', 'readonly']); !!}
                        {!! Form::hidden('date', $date ?? date('Y-m-d'), ['id' => 'hidden_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', [
                            'all' => __('businessmanagement::lang.all_customers'),
                            'single' => __('businessmanagement::lang.single_customer')
                        ], $customer_filter ?? 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="customer_select_wrapper" style="display: {{ ($customer_filter ?? 'all') == 'single' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'allCustomersDueList']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printAllCustomersDueList'], ['date' => !empty($date) ? \Carbon\Carbon::parse($date)->format('Y-m-d') : date('Y-m-d'), 'customer_filter' => $customer_filter ?? 'all', 'customer_id' => $customer_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($due_data) > 0)
                        <table class="table table-bordered table-striped" style="font-size: 12px;">
                            <thead>
                                <tr>
                                    <th style="width: 50px;">SL</th>
                                    <th>Customer Name</th>
                                    <th>Address</th>
                                    <th>Mobile</th>
                                    <th style="text-align: right;">Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $serial = 1;
                                @endphp
                                @foreach($due_data as $item)
                                    <tr>
                                        <td>{{ $serial++ }}</td>
                                        <td>{{ $item->contact_name }}</td>
                                        <td>{{ $item->address }}</td>
                                        <td>{{ $item->mobile }}</td>
                                        <td style="text-align: right;"><span class="display_currency" data-currency_symbol="true">{{ $item->due_amount }}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <tbody>
                                <tr style="background-color: #f8f9fa; font-weight: bold;">
                                    <td colspan="4" style="text-align: right;"><strong>Group Wise Sub Total:</strong></td>
                                    <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $grand_total }}</span></strong></td>
                                </tr>
                                <tr style="background-color: #d4edda; font-weight: bold;">
                                    <td colspan="4" style="text-align: right;"><strong>Receivable Sub Total:</strong></td>
                                    <td style="text-align: right;"><strong><span class="display_currency" data-currency_symbol="true">{{ $grand_total }}</span></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No customer due amounts found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('#all_customers_due_list_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#all_customers_due_list_date').on('changeDate', function(e) {
            var selected_date = e.format('yyyy-mm-dd');
            $('#hidden_date').val(selected_date);
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date field is populated before form submission
        $('#all_customers_due_list_filter_form').on('submit', function() {
            var date_val = $('#all_customers_due_list_date').val();
            if (date_val) {
                var date_parts = date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

