<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date Wise Stock (Combined)</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 10pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            color: #4a4a4a;
        }
        
        .report-title {
            font-size: 16pt;
            font-weight: 700;
            text-align: center;
            margin: 15px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
        }
        
        .report-date {
            font-size: 11pt;
            text-align: center;
            margin-bottom: 10px;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            font-size: 10pt;
        }
        
        table thead {
            background-color: #f5f5f5;
        }
        
        table th {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: left;
            font-weight: 600;
            font-size: 10pt;
        }
        
        table th:last-child {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 5px 4px;
            font-size: 10pt;
        }
        
        table td:last-child {
            text-align: right;
        }
        
        .category-header-row {
            background-color: #f0f0f0;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .subtotal-row {
            background-color: #f8f9fa;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .text-right {
            text-align: right;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->landmark ?? '' }}, {{ $business->city ?? '' }}, {{ $business->state ?? '' }}, {{ $business->country ?? '' }}</div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Tel: {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        E-mail: {{ $business->email }}
                    @endif
                </div>
            </div>
            <div class="header-contact">
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Date Wise Stock (Combined)</div>
        <div class="report-date">Date: {{ !empty($stock_date) ? \Carbon\Carbon::parse($stock_date)->format('d/m/Y') : date('d/m/Y') }}</div>
        
        <!-- Report Content -->
        @if(count($grouped_data) > 0)
            <table>
                <thead>
                    <tr>
                        <th>ModelNo</th>
                        <th>Product Description</th>
                        <th class="text-right">Qty</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($grouped_data as $category_name => $items)
                        <tr class="category-header-row">
                            <td colspan="3" style="padding: 6px 8px;">{{ $category_name }}</td>
                        </tr>
                        @php
                            $category_total_qty = 0;
                        @endphp
                        @foreach($items as $item)
                            @php
                                $category_total_qty += $item->qty;
                            @endphp
                            <tr>
                                <td></td>
                                <td>{{ $item->product_description }}</td>
                                <td class="text-right">{{ $util->num_f($item->qty, false, null, true) }}</td>
                            </tr>
                        @endforeach
                        <tr class="subtotal-row">
                            <td colspan="2"><strong>Sub Total : {{ $category_name }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_qty, false, null, true) }}</strong></td>
                        </tr>
                    @endforeach
                    <tr style="background-color: #d4edda; font-weight: 700; font-size: 11pt;">
                        <td colspan="2"><strong>Grand Total</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_qty, false, null, true) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        @else
            <div class="no-data">No stock data found for the selected filters.</div>
        @endif
    </div>
</body>
</html>

