<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date Wise Product Status</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 10pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 2px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            color: #4a4a4a;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 16pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 6px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 11pt;
            text-align: center;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .report-location {
            font-size: 11pt;
            text-align: center;
            margin-bottom: 10px;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            font-size: 10pt;
        }
        
        table thead {
            background-color: #f5f5f5;
        }
        
        table th {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: left;
            font-weight: 600;
            font-size: 10pt;
        }
        
        table th:first-child {
            text-align: left;
        }
        
        table th:not(:first-child) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 5px 4px;
            font-size: 10pt;
        }
        
        table td:first-child {
            text-align: left;
        }
        
        table td:not(:first-child) {
            text-align: right;
        }
        
        .category-header {
            font-size: 12pt;
            font-weight: 700;
            margin-top: 12px;
            margin-bottom: 6px;
            color: #1a1a1a;
        }
        
        .subtotal-row {
            background-color: #f8f9fa;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .grand-total-row {
            background-color: #d4edda;
            font-weight: 700;
            font-size: 11pt;
        }
        
        .text-right {
            text-align: right;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->landmark ?? '' }}, {{ $business->city ?? '' }}, {{ $business->state ?? '' }}, {{ $business->country ?? '' }}</div>
            </div>
            <div class="header-right">
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Tel: {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <br>E-mail: {{ $business->email }}
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Date Wise Product Status</div>
        <div class="report-date">{{ !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : date('d/m/Y') }} To {{ !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : date('d/m/Y') }}</div>
        <div class="report-location">{{ $location_name ?? 'All Locations' }}</div>
        
        <!-- Report Content -->
        @if(count($grouped_data) > 0)
            @foreach($grouped_data as $category_name => $items)
                <table>
                    <thead>
                        <tr>
                            <th>Model No</th>
                            <th class="text-right">Opening</th>
                            <th class="text-right">Purchase</th>
                            <th class="text-right">P. Return</th>
                            <th class="text-right">Sales</th>
                            <th class="text-right">S. Return</th>
                            <th class="text-right">Menu. In</th>
                            <th class="text-right">Menu. Out</th>
                            <th class="text-right">Item Issue</th>
                            <th class="text-right">Others In</th>
                            <th class="text-right">Others Out</th>
                            <th class="text-right">Transferred</th>
                            <th class="text-right">Received</th>
                            <th class="text-right">Closing</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $category_total_opening = 0;
                            $category_total_purchase = 0;
                            $category_total_p_return = 0;
                            $category_total_sales = 0;
                            $category_total_s_return = 0;
                            $category_total_menu_in = 0;
                            $category_total_menu_out = 0;
                            $category_total_item_issue = 0;
                            $category_total_others_in = 0;
                            $category_total_others_out = 0;
                            $category_total_transferred = 0;
                            $category_total_received = 0;
                            $category_total_closing = 0;
                        @endphp
                        @foreach($items as $item)
                            @php
                                $category_total_opening += $item->opening;
                                $category_total_purchase += $item->purchase;
                                $category_total_p_return += $item->p_return;
                                $category_total_sales += $item->sales;
                                $category_total_s_return += $item->s_return;
                                $category_total_menu_in += $item->menu_in;
                                $category_total_menu_out += $item->menu_out;
                                $category_total_item_issue += $item->item_issue;
                                $category_total_others_in += $item->others_in;
                                $category_total_others_out += $item->others_out;
                                $category_total_transferred += $item->transferred;
                                $category_total_received += $item->received;
                                $category_total_closing += $item->closing;
                            @endphp
                            <tr>
                                <td>{{ $item->model_no }}</td>
                                <td class="text-right">{{ $util->num_f($item->opening, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->purchase, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->p_return, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->sales, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->s_return, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->menu_in, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->menu_out, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->item_issue, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->others_in, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->others_out, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->transferred, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->received, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->closing, false, null, true) }}</td>
                            </tr>
                        @endforeach
                        <tr class="subtotal-row">
                            <td><strong>Brand Wise Sub Total</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_opening, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_purchase, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_p_return, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_sales, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_s_return, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_menu_in, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_menu_out, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_item_issue, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_others_in, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_others_out, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_transferred, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_received, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_closing, false, null, true) }}</strong></td>
                        </tr>
                    </tbody>
                </table>
            @endforeach
            
            <table style="margin-top: 10px;">
                <colgroup>
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                    <col style="width: auto;">
                </colgroup>
                <thead style="display: none; visibility: hidden;">
                    <tr>
                        <th>Model No</th>
                        <th class="text-right">Opening</th>
                        <th class="text-right">Purchase</th>
                        <th class="text-right">P. Return</th>
                        <th class="text-right">Sales</th>
                        <th class="text-right">S. Return</th>
                        <th class="text-right">Menu. In</th>
                        <th class="text-right">Menu. Out</th>
                        <th class="text-right">Item Issue</th>
                        <th class="text-right">Others In</th>
                        <th class="text-right">Others Out</th>
                        <th class="text-right">Transferred</th>
                        <th class="text-right">Received</th>
                        <th class="text-right">Closing</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="grand-total-row">
                        <td><strong>Grand Total</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_opening, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_purchase, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_p_return, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_sales, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_s_return, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_menu_in, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_menu_out, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_item_issue, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_others_in, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_others_out, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_transferred, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_received, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_closing, false, null, true) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        @else
            <div class="no-data">No product status data found for the selected filters.</div>
        @endif
    </div>
</body>
</html>

