<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date Wise Product In Out Statement (Combined)</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 13pt;
            font-weight: 700;
            text-align: center;
            margin: 10px 0 5px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table thead {
            background-color: #f5f5f5;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: left;
            font-weight: 600;
            font-size: 8pt;
        }
        
        table th:first-child {
            width: 40px;
        }
        
        table th:nth-child(3),
        table th:nth-child(4),
        table th:nth-child(5),
        table th:nth-child(6),
        table th:nth-child(7) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 3px;
            font-size: 8pt;
        }
        
        table td:nth-child(3),
        table td:nth-child(4),
        table td:nth-child(5),
        table td:nth-child(6),
        table td:nth-child(7) {
            text-align: right;
        }
        
        .subtotal-row {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        
        .grand-total-row {
            background-color: #d4edda;
            font-weight: 700;
            font-size: 9pt;
        }
        
        .text-right {
            text-align: right;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->landmark ?? '' }}, {{ $business->city ?? '' }}, {{ $business->state ?? '' }}, {{ $business->country ?? '' }}</div>
            </div>
            <div class="header-right">
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Tel: {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <br>E-mail: {{ $business->email }}
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Date Wise Product In Out Statement (Combined)</div>
        <div class="report-date">{{ !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : date('d/m/Y') }} To {{ !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : date('d/m/Y') }}</div>
        
        <!-- Report Content -->
        @if(count($grouped_data) > 0)
            @foreach($grouped_data as $category_name => $items)
                <div style="font-size: 11pt; font-weight: 700; margin-top: 15px; margin-bottom: 8px; text-decoration: underline; color: #1a1a1a;">{{ $category_name }}</div>
                <table>
                    <thead>
                        <tr>
                            <th>SL</th>
                            <th>Product Description</th>
                            <th class="text-right">Opening Stock</th>
                            <th class="text-right">Stock In</th>
                            <th class="text-right">Sales</th>
                            <th class="text-right">Others Stock Out</th>
                            <th class="text-right">Closing Stock</th>
                            <th>UoM</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $serial = 1;
                            $category_total_qty1 = 0;
                            $category_total_qty2 = 0;
                            $category_total_qty3 = 0;
                            $category_total_qty4 = 0;
                            $category_total_qty5 = 0;
                        @endphp
                        @foreach($items as $item)
                            @php
                                $category_total_qty1 += $item->qty1;
                                $category_total_qty2 += $item->qty2;
                                $category_total_qty3 += $item->qty3;
                                $category_total_qty4 += $item->qty4;
                                $category_total_qty5 += $item->qty5;
                            @endphp
                            <tr>
                                <td>{{ $serial++ }}</td>
                                <td>{{ $item->product_description }}</td>
                                <td class="text-right">{{ $util->num_f($item->qty1, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->qty2, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->qty3, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->qty4, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->qty5, false, null, true) }}</td>
                                <td>{{ $item->unit }}</td>
                            </tr>
                        @endforeach
                        <tr class="subtotal-row">
                            <td colspan="2"><strong>Sub Total:</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_qty1, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_qty2, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_qty3, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_qty4, false, null, true) }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($category_total_qty5, false, null, true) }}</strong></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            @endforeach
            <table style="margin-top: 10px;">
                <thead style="display: none;">
                    <tr>
                        <th>SL</th>
                        <th>Product Description</th>
                        <th class="text-right">Opening Stock</th>
                        <th class="text-right">Stock In</th>
                        <th class="text-right">Sales</th>
                        <th class="text-right">Others Stock Out</th>
                        <th class="text-right">Closing Stock</th>
                        <th>UoM</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="grand-total-row">
                        <td colspan="2"><strong>Grand Total</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_qty1, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_qty2, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_qty3, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_qty4, false, null, true) }}</strong></td>
                        <td class="text-right"><strong>{{ $util->num_f($grand_total_qty5, false, null, true) }}</strong></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        @else
            <div class="no-data">No product in/out data found for the selected filters.</div>
        @endif
    </div>
</body>
</html>

