@extends('layouts.app')
@section('title', __('businessmanagement::lang.stock_register'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); padding: 30px 20px; margin: -20px -15px 30px -15px; border-radius: 0;">
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-md-12 text-center">
                <h1 style="color: #fff; font-size: 32px; font-weight: 700; margin: 0; display: flex; align-items: center; justify-content: center; gap: 15px;">
                    <i class="fa fa-cubes" style="font-size: 36px;"></i>
                    Stock Register Reports
                </h1>
                <p style="color: rgba(255,255,255,0.9); font-size: 16px; margin: 10px 0 0 0;">
                    Comprehensive stock tracking and inventory analysis reports
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Current Stock (Combined) Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="28a745,20c997">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-boxes"></i>
                    </div>
                    <div class="card-content">
                        <h3>Current Stock (Combined)</h3>
                        <p>Comprehensive current stock report with cost analysis, grouped by category and brand with detailed breakdown.</p>
                        <div class="card-tags">
                            <span>Date Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockCombined']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Current Stock (c) Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="17a2b8,138496">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-warehouse"></i>
                    </div>
                    <div class="card-content">
                        <h3>Current Stock (c)</h3>
                        <p>Current stock report showing product quantities grouped by category and brand with unit of measurement.</p>
                        <div class="card-tags">
                            <span>Date Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockC']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Current Stock With Serial Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="6f42c1,5a32a3">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-barcode"></i>
                    </div>
                    <div class="card-content">
                        <h3>Current Stock With Serial</h3>
                        <p>Current stock report with serial numbers, showing invoice numbers and product details for each serialized item.</p>
                        <div class="card-tags">
                            <span>Date Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'currentStockWithSerial']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Combined Current Stock (All BR Summary) Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="fd7e14,e8650e">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-building"></i>
                    </div>
                    <div class="card-content">
                        <h3>Combined Current Stock (All BR Summary)</h3>
                        <p>Combined stock report from all branches/locations with product ID, description, quantity, unit cost, and total cost.</p>
                        <div class="card-tags">
                            <span>Date Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'combinedCurrentStockAllBrSummary']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Product Status Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="007bff,0056b3">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-calendar-alt"></i>
                    </div>
                    <div class="card-content">
                        <h3>Date Wise Product Status</h3>
                        <p>Comprehensive product status report showing opening, purchase, sales, returns, transfers, and closing stock for a date range.</p>
                        <div class="card-tags">
                            <span>Date Range Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductStatus']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Stock Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="ffc107,ff9800">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-calendar"></i>
                    </div>
                    <div class="card-content">
                        <h3>Date Wise Stock</h3>
                        <p>Stock report as of a specific date showing product descriptions and quantities grouped by category.</p>
                        <div class="card-tags">
                            <span>Date Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStock']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Product Price List Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="e83e8c,d91a72">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-tags"></i>
                    </div>
                    <div class="card-content">
                        <h3>Product Price List</h3>
                        <p>Comprehensive product price list showing purchase price, MRP, lower price, and dealer/retailer prices grouped by product group.</p>
                        <div class="card-tags">
                            <span>Date Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'productPriceList']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Supplier Wise Current Stock Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="dc3545,c82333">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-truck"></i>
                    </div>
                    <div class="card-content">
                        <h3>Supplier Wise Current Stock</h3>
                        <p>Current stock report grouped by supplier and category, showing product ID, description, quantity, unit cost, and total cost.</p>
                        <div class="card-tags">
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'supplierWiseCurrentStock']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Product In Out Statement Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="6610f2,520dc2">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-exchange-alt"></i>
                    </div>
                    <div class="card-content">
                        <h3>Date Wise Product In Out Statement</h3>
                        <p>Product in/out statement showing opening stock, purchase, sales, returns, and closing stock for a date range.</p>
                        <div class="card-tags">
                            <span>Date Range Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductInOutStatement']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Stock Serial (M) Report Card -->
            <div class="col-md-4">
                <div class="stock-report-card" data-gradient="20c997,17a2b8">
                    <div class="card-icon-wrapper">
                        <i class="fa fa-barcode"></i>
                    </div>
                    <div class="card-content">
                        <h3>Date Wise Stock Serial (M)</h3>
                        <p>Date-wise stock report with serial numbers and cost, grouped by supplier, showing invoice details and purchase information.</p>
                        <div class="card-tags">
                            <span>Date Filter</span>
                            <span>Location Filter</span>
                            <span>Category Filter</span>
                            <span>Product Filter</span>
                            <span>Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseStockSerialM']) }}" class="card-btn">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div class="card-footer">
                            <span class="status-available"><i class="fa fa-check-circle"></i> Available</span>
                            <span class="version">Report Version 1.0.0</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .stock-report-card {
        background: #ffffff;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.07), 0 1px 3px rgba(0, 0, 0, 0.06);
        margin-bottom: 30px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        height: 100%;
        position: relative;
        overflow: hidden;
        border: 1px solid #e9ecef;
    }

    .stock-report-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(135deg, var(--gradient-start), var(--gradient-end));
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .stock-report-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15), 0 4px 8px rgba(0, 0, 0, 0.1);
        border-color: transparent;
    }

    .stock-report-card:hover::before {
        opacity: 1;
    }

    .stock-report-card[data-gradient="28a745,20c997"] {
        --gradient-start: #28a745;
        --gradient-end: #20c997;
    }

    .stock-report-card[data-gradient="17a2b8,138496"] {
        --gradient-start: #17a2b8;
        --gradient-end: #138496;
    }

    .stock-report-card[data-gradient="6f42c1,5a32a3"] {
        --gradient-start: #6f42c1;
        --gradient-end: #5a32a3;
    }

    .stock-report-card[data-gradient="fd7e14,e8650e"] {
        --gradient-start: #fd7e14;
        --gradient-end: #e8650e;
    }

    .stock-report-card[data-gradient="007bff,0056b3"] {
        --gradient-start: #007bff;
        --gradient-end: #0056b3;
    }

    .stock-report-card[data-gradient="ffc107,ff9800"] {
        --gradient-start: #ffc107;
        --gradient-end: #ff9800;
    }

    .stock-report-card[data-gradient="e83e8c,d91a72"] {
        --gradient-start: #e83e8c;
        --gradient-end: #d91a72;
    }

    .stock-report-card[data-gradient="dc3545,c82333"] {
        --gradient-start: #dc3545;
        --gradient-end: #c82333;
    }

    .stock-report-card[data-gradient="6610f2,520dc2"] {
        --gradient-start: #6610f2;
        --gradient-end: #520dc2;
    }

    .stock-report-card[data-gradient="20c997,17a2b8"] {
        --gradient-start: #20c997;
        --gradient-end: #17a2b8;
    }

    .card-icon-wrapper {
        width: 70px;
        height: 70px;
        background: linear-gradient(135deg, var(--gradient-start), var(--gradient-end));
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        transition: transform 0.3s ease;
    }

    .stock-report-card:hover .card-icon-wrapper {
        transform: scale(1.1) rotate(5deg);
    }

    .card-icon-wrapper i {
        color: #fff;
        font-size: 32px;
    }

    .card-content {
        padding: 30px;
    }

    .card-content h3 {
        margin: 0 0 12px 0;
        font-size: 22px;
        font-weight: 700;
        color: #1a202c;
        line-height: 1.3;
    }

    .card-content p {
        color: #64748b;
        font-size: 14px;
        line-height: 1.6;
        margin-bottom: 20px;
        min-height: 48px;
    }

    .card-tags {
        display: flex;
        flex-wrap: wrap;
        gap: 8px;
        margin-bottom: 24px;
    }

    .card-tags span {
        background: #f1f5f9;
        color: #475569;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.2s ease;
    }

    .stock-report-card:hover .card-tags span {
        background: #e2e8f0;
        color: #334155;
    }

    .card-btn {
        width: 100%;
        background: linear-gradient(135deg, var(--gradient-start), var(--gradient-end));
        border: none;
        padding: 14px 20px;
        font-weight: 600;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        color: #fff;
        text-decoration: none;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        font-size: 15px;
    }

    .card-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        color: #fff;
        text-decoration: none;
    }

    .card-btn:active {
        transform: translateY(0);
    }

    .card-footer {
        margin-top: 20px;
        padding-top: 20px;
        border-top: 1px solid #e2e8f0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .status-available {
        display: flex;
        align-items: center;
        color: #10b981;
        font-size: 13px;
        font-weight: 600;
        gap: 6px;
    }

    .status-available i {
        font-size: 14px;
    }

    .version {
        color: #ef4444;
        font-size: 12px;
        font-weight: 600;
    }

    @media (max-width: 768px) {
        .card-content {
            padding: 20px;
        }

        .card-content h3 {
            font-size: 18px;
        }

        .card-icon-wrapper {
            width: 60px;
            height: 60px;
        }

        .card-icon-wrapper i {
            font-size: 26px;
        }
    }
</style>

@endsection
