@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_product_status'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_product_status') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductStatus']), 'method' => 'get', 'id' => 'date_wise_product_status_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @php
                            $date_range_value = '';
                            if (!empty($start_date) && !empty($end_date)) {
                                $date_range_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y') . ' - ' . \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } elseif (!empty(request()->date_range)) {
                                $date_range_value = request()->date_range;
                            }
                        @endphp
                        {!! Form::text('date_range', $date_range_value, ['placeholder' => __('businessmanagement::lang.select_date_range'), 'class' => 'form-control', 'id' => 'date_wise_product_status_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('businessmanagement::lang.all_categories'), 'single' => __('businessmanagement::lang.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('businessmanagement::lang.all_products'), 'single' => __('businessmanagement::lang.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'dateWiseProductStatus']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'printDateWiseProductStatus'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($grouped_data) > 0)
                        @foreach($grouped_data as $category_name => $items)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; font-weight: bold; color: #2c3e50; font-size: 16px;">{{ $category_name }}</h4>
                            <table class="table table-bordered table-striped" style="font-size: 13px;">
                                <thead>
                                    <tr>
                                        <th>Model No</th>
                                        <th style="text-align: right;">Opening</th>
                                        <th style="text-align: right;">Purchase</th>
                                        <th style="text-align: right;">P. Return</th>
                                        <th style="text-align: right;">Sales</th>
                                        <th style="text-align: right;">S. Return</th>
                                        <th style="text-align: right;">Menu. In</th>
                                        <th style="text-align: right;">Menu. Out</th>
                                        <th style="text-align: right;">Item Issue</th>
                                        <th style="text-align: right;">Others In</th>
                                        <th style="text-align: right;">Others Out</th>
                                        <th style="text-align: right;">Transferred</th>
                                        <th style="text-align: right;">Received</th>
                                        <th style="text-align: right;">Closing</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $category_total_opening = 0;
                                        $category_total_purchase = 0;
                                        $category_total_p_return = 0;
                                        $category_total_sales = 0;
                                        $category_total_s_return = 0;
                                        $category_total_menu_in = 0;
                                        $category_total_menu_out = 0;
                                        $category_total_item_issue = 0;
                                        $category_total_others_in = 0;
                                        $category_total_others_out = 0;
                                        $category_total_transferred = 0;
                                        $category_total_received = 0;
                                        $category_total_closing = 0;
                                    @endphp
                                    @foreach($items as $item)
                                        @php
                                            $category_total_opening += $item->opening;
                                            $category_total_purchase += $item->purchase;
                                            $category_total_p_return += $item->p_return;
                                            $category_total_sales += $item->sales;
                                            $category_total_s_return += $item->s_return;
                                            $category_total_menu_in += $item->menu_in;
                                            $category_total_menu_out += $item->menu_out;
                                            $category_total_item_issue += $item->item_issue;
                                            $category_total_others_in += $item->others_in;
                                            $category_total_others_out += $item->others_out;
                                            $category_total_transferred += $item->transferred;
                                            $category_total_received += $item->received;
                                            $category_total_closing += $item->closing;
                                        @endphp
                                        <tr>
                                            <td>{{ $item->model_no }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->opening, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->purchase, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->p_return, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->sales, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->s_return, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->menu_in, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->menu_out, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->item_issue, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->others_in, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->others_out, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->transferred, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->received, false, null, true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->closing, false, null, true) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td><strong>Brand Wise Sub Total</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_opening, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_purchase, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_p_return, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_sales, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_s_return, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_menu_in, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_menu_out, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_item_issue, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_others_in, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_others_out, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_transferred, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_received, false, null, true) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($category_total_closing, false, null, true) }}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                        <table class="table table-bordered" style="font-size: 14px; margin-top: 20px;">
                            <thead style="display: none;">
                                <tr>
                                    <th>Model No</th>
                                    <th style="text-align: right;">Opening</th>
                                    <th style="text-align: right;">Purchase</th>
                                    <th style="text-align: right;">P. Return</th>
                                    <th style="text-align: right;">Sales</th>
                                    <th style="text-align: right;">S. Return</th>
                                    <th style="text-align: right;">Menu. In</th>
                                    <th style="text-align: right;">Menu. Out</th>
                                    <th style="text-align: right;">Item Issue</th>
                                    <th style="text-align: right;">Others In</th>
                                    <th style="text-align: right;">Others Out</th>
                                    <th style="text-align: right;">Transferred</th>
                                    <th style="text-align: right;">Received</th>
                                    <th style="text-align: right;">Closing</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr style="background-color: #d4edda; font-weight: bold; font-size: 16px;">
                                    <td><strong>Grand Total</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_opening, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_purchase, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_p_return, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_sales, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_s_return, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_menu_in, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_menu_out, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_item_issue, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_others_in, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_others_out, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_transferred, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_received, false, null, true) }}</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_closing, false, null, true) }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No product status data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#date_wise_product_status_date_range').daterangepicker({
            autoUpdateInput: false,
            locale: {
                format: 'DD/MM/YYYY',
                separator: ' - ',
            }
        });

        $('#date_wise_product_status_date_range').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('DD/MM/YYYY'));
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });

        $('#date_wise_product_status_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });
    });
</script>
@endsection

