@extends('layouts.app')
@section('title', 'Product Wise Sales with Serial')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Product Wise Sales with Serial</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesWithSerial']), 'method' => 'get', 'id' => 'product_wise_sales_with_serial_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @php
                            $date_range_value = '';
                            if (!empty($start_date) && !empty($end_date)) {
                                $date_range_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y') . ' ~ ' . \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } elseif (!empty(request()->date_range)) {
                                $date_range_value = request()->date_range;
                            }
                        @endphp
                        {!! Form::text('date_range', $date_range_value , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_wise_sales_with_serial_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('lang_v1.all_categories'), 'single' => __('lang_v1.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('lang_v1.all_products'), 'single' => __('lang_v1.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesWithSerial']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseSalesWithSerial'], ['start_date' => $start_date, 'end_date' => $end_date, 'category_id' => $category_id, 'product_id' => $product_id, 'location_id' => $location_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($products_data) > 0)
                        @foreach($products_data as $product_id_key => $product_data)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; font-weight: bold; text-align: center; color: #2c3e50;">{{ $product_data['product_name'] }}</h4>
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th>Invoice No</th>
                                        <th>Product Description</th>
                                        <th>Customer Name</th>
                                        <th>Ref. No.</th>
                                        <th style="text-align: right;">Qty</th>
                                        <th style="text-align: right;">Unit Price</th>
                                        <th style="text-align: right;">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($product_data['lines'] as $line)
                                        <tr>
                                            <td>{{ $util->format_date($line['transaction_date'], false) }} {{ $line['invoice_no'] }}</td>
                                            <td>{{ $line['product_description'] }}</td>
                                            <td>{{ $line['customer_name'] }}</td>
                                            <td>{{ $line['ref_no'] }}</td>
                                            <td style="text-align: right;">{{ number_format($line['qty'], 2) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($line['unit_price'], true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($line['amount'], true) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr style="background-color: #f5f5f5; font-weight: bold;">
                                        <td colspan="4"><strong>Sub Total:</strong></td>
                                        <td style="text-align: right;">{{ number_format($product_data['product_total_qty'], 2) }}</td>
                                        <td style="text-align: right;">-</td>
                                        <td style="text-align: right;">{{ $util->num_f($product_data['product_total_amount'], true) }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        var date_range_val = '{{ $date_range_value ?? "" }}';

        if (date_range_val) {
            $('#product_wise_sales_with_serial_date_range').val(date_range_val);
        } else if (start_date && end_date) {
            $('#product_wise_sales_with_serial_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#product_wise_sales_with_serial_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#product_wise_sales_with_serial_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#product_wise_sales_with_serial_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Reload when date range changes
        $('#product_wise_sales_with_serial_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });

        // Ensure hidden fields are set before form submission
        $('#product_wise_sales_with_serial_filter_form').on('submit', function(e) {
            var date_range_val = $('#product_wise_sales_with_serial_date_range').val();
            if (date_range_val) {
                var dates = date_range_val.split(' ~ ');
                if (dates.length == 2) {
                    var start = moment(dates[0].trim(), moment_date_format);
                    var end = moment(dates[1].trim(), moment_date_format);
                    if (start.isValid() && end.isValid()) {
                        $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                        $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
                    }
                }
            } else {
                $('input[name="start_date"]').val('');
                $('input[name="end_date"]').val('');
            }
        });
    });
</script>
@endsection

