<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date wise Sales Summary</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        .date-section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        
        .date-header {
            font-size: 11pt;
            font-weight: 600;
            margin-bottom: 10px;
            color: #1a1a1a;
            text-align: center;
        }
        
        .invoice-section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        
        .customer-header {
            background-color: #f5f5f5;
            padding: 8px;
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 10pt;
            border: 1px solid #ddd;
        }
        
        .invoice-details {
            margin-bottom: 8px;
            font-size: 9pt;
            padding: 5px;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 9pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 6px 4px;
            text-align: center;
            font-weight: 600;
            font-size: 9pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 5px 4px;
            font-size: 9pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 9pt;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 6px 4px;
        }
        
        .summary-box {
            margin-bottom: 15px;
            padding: 10px;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            font-size: 9pt;
        }
        
        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        
        .summary-row.net-payable {
            margin-top: 10px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-weight: 600;
        }
        
        .narration-box {
            margin-bottom: 15px;
            padding: 5px;
            font-size: 9pt;
        }
        
        .divider {
            border-top: 2px dashed #ddd;
            margin: 20px 0;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .date-header {
                page-break-inside: avoid;
            }
            
            .customer-header {
                page-break-inside: avoid;
            }
            
            .invoice-section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Date wise Sales Summary.</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Date Sections -->
        @if(count($transactions) > 0)
            @foreach($grouped_data as $date => $date_transactions)
                <div class="date-section">
                    <div class="date-header">
                        {{ $util->format_date($date, false) }}
                    </div>
                    
                    @foreach($date_transactions as $transaction)
                        @php
                            $customer_name = 'WALKING CUSTOMER';
                            if (!empty($transaction->contact)) {
                                $customer_name = !empty($transaction->contact->supplier_business_name) 
                                    ? $transaction->contact->supplier_business_name 
                                    : ($transaction->contact->name ?? 'WALKING CUSTOMER');
                            }
                            
                            $total_qty = $transaction->sell_lines->sum(function($line) {
                                return $line->quantity - $line->quantity_returned;
                            });
                            
                            $total_amount = $transaction->total_before_tax ?? 0;
                            $vat = $transaction->tax_amount ?? 0;
                            $discount = $transaction->discount_amount ?? 0;
                            $extra_charges = ($transaction->shipping_charges ?? 0) + ($transaction->additional_expense_value_1 ?? 0) + ($transaction->additional_expense_value_2 ?? 0);
                            $net_payable = $transaction->final_total ?? 0;
                        @endphp
                        
                        <div class="invoice-section">
                            <!-- Customer Header -->
                            <div class="customer-header">
                                {{ $customer_name }}
                            </div>
                            
                            <!-- Invoice Details -->
                            <div class="invoice-details">
                                <strong>Invoice No:</strong> {{ $transaction->invoice_no }} | 
                                <strong>Ref No:</strong> {{ $transaction->ref_no ?? '' }} | 
                                <strong>Date:</strong> {{ $util->format_date($transaction->transaction_date, false) }}
                            </div>
                            
                            <!-- Product Table -->
                            <div class="table-container">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Product Caption</th>
                                            <th>Qty</th>
                                            <th>Unit Price</th>
                                            <th>Discount</th>
                                            <th>Net Unit Price</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transaction->sell_lines as $line)
                                            @php
                                                $qty = $line->quantity - $line->quantity_returned;
                                                $product_name = $line->product->name ?? 'N/A';
                                                if ($line->product && $line->product->type == 'variable' && $line->variations) {
                                                    $variation_name = $line->variations->name ?? '';
                                                    $product_variation_name = $line->variations->product_variation->name ?? '';
                                                    if ($variation_name || $product_variation_name) {
                                                        $product_name .= ' - ' . ($product_variation_name ? $product_variation_name . ' - ' : '') . $variation_name;
                                                    }
                                                }
                                                $unit_price = $line->unit_price_before_discount ?? $line->unit_price_inc_tax ?? 0;
                                                $line_discount = method_exists($line, 'get_discount_amount') ? $line->get_discount_amount() : ($line->line_discount_amount ?? 0);
                                                $net_unit_price = $line->unit_price_inc_tax ?? 0;
                                                $line_amount = $qty * $net_unit_price;
                                            @endphp
                                            <tr>
                                                <td>{{ $product_name }}</td>
                                                <td class="text-right">{{ number_format($qty, 2) }}</td>
                                                <td class="text-right">{{ number_format($unit_price, 2) }}</td>
                                                <td class="text-right">{{ number_format($line_discount, 2) }}</td>
                                                <td class="text-right">{{ number_format($net_unit_price, 2) }}</td>
                                                <td class="text-right">{{ number_format($line_amount, 2) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr class="subtotal-row">
                                            <td class="text-right"><strong>Sub Total:</strong></td>
                                            <td class="text-right"><strong>{{ number_format($total_qty, 2) }}</strong></td>
                                            <td colspan="4"></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            
                            <!-- Summary of Charges -->
                            <div class="summary-box">
                                <div class="summary-row">
                                    <strong>Total Amount:</strong>
                                    <span>{{ number_format($total_amount, 2) }}</span>
                                </div>
                                <div class="summary-row">
                                    <strong>VAT:</strong>
                                    <span>{{ number_format($vat, 2) }}</span>
                                </div>
                                <div class="summary-row">
                                    <strong>Less Discount:</strong>
                                    <span>{{ number_format($discount, 2) }}</span>
                                </div>
                                <div class="summary-row">
                                    <strong>Extra Charge:</strong>
                                    <span>{{ number_format($extra_charges, 2) }}</span>
                                </div>
                                <div class="summary-row net-payable">
                                    <strong>Net Payable Amount:</strong>
                                    <span>{{ number_format($net_payable, 2) }}</span>
                                </div>
                            </div>
                            
                            <!-- Narration -->
                            <div class="narration-box">
                                <strong>Narration :</strong> {{ $transaction->additional_notes ?? '' }}
                            </div>
                        </div>
                        
                        @if(!$loop->last)
                            <div class="divider"></div>
                        @endif
                    @endforeach
                </div>
            @endforeach
        @else
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>No sales data found for the selected filters.</p>
            </div>
        @endif
    </div>
</body>
</html>

