<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date wise Sales</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tfoot {
            display: table-footer-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        /* Column alignments */
        table tbody td:nth-child(1),
        table tbody td:nth-child(2),
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5) {
            text-align: left;
        }
        
        table tbody td:nth-child(6),
        table tbody td:nth-child(7),
        table tbody td:nth-child(8),
        table tbody td:nth-child(9),
        table tbody td:nth-child(10) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .date-header-row {
            background-color: #f5f7fa !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .date-header-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
        }
        
        .bill-type-header-row {
            background-color: #e8ecf1 !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .bill-type-header-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
        }
        
        .subtotal-row {
            background-color: #f9fafb !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .subtotal-row td:first-child {
            text-align: left;
        }
        
        .subtotal-row td:nth-child(6),
        .subtotal-row td:nth-child(7),
        .subtotal-row td:nth-child(8),
        .subtotal-row td:nth-child(9),
        .subtotal-row td:nth-child(10) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .grand-total-row {
            background-color: #e8ecf1 !important;
            font-weight: 700;
            font-size: 11pt;
            border-top: 2px solid #2c3e50;
        }
        
        .grand-total-row td {
            border: 1px solid #2c3e50;
            padding: 10px 6px;
        }
        
        .grand-total-row td:first-child {
            text-align: left;
        }
        
        .grand-total-row td:nth-child(6),
        .grand-total-row td:nth-child(7),
        .grand-total-row td:nth-child(8),
        .grand-total-row td:nth-child(9),
        .grand-total-row td:nth-child(10) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .link-cell {
            text-align: center !important;
        }
        
        .link-cell a {
            color: #007bff;
            text-decoration: none;
            font-weight: 500;
        }
        
        .link-cell a:hover {
            text-decoration: underline;
        }
        
        @media print {
            .date-section {
                page-break-inside: avoid;
            }
            
            .bill-type-section {
                page-break-inside: avoid;
            }
            
            .subtotal-row {
                page-break-inside: avoid;
            }
            
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ __('lang_v1.mobile') }}: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ __('lang_v1.alternate_number') }}: {{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ __('business.email') }}: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Date wise Sales</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if($start_date && $end_date)
                @php
                    $start_formatted = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                    $end_formatted = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                @endphp
                {{ $start_formatted }} To {{ $end_formatted }}
            @endif
            @if($is_single_customer && !empty($customer_name))
                <br>{{ __('contact.customer') }}: {{ $customer_name }}
            @endif
        </div>

        <!-- Table Container -->
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Ref No</th>
                        <th>Trader Name</th>
                        <th>Entered by</th>
                        <th>Total Amt</th>
                        <th>Discount</th>
                        <th>Ex. Char.</th>
                        <th>VAT</th>
                        <th>Amount</th>
                        <th>Link</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $grand_total_before_tax = 0;
                        $grand_total_discount = 0;
                        $grand_total_extra_charges = 0;
                        $grand_total_tax = 0;
                        $grand_total_amount = 0;
                    @endphp
                    
                    @foreach($sales_by_date as $date => $bill_types)
                        @php
                            $date_total_before_tax = 0;
                            $date_total_discount = 0;
                            $date_total_extra_charges = 0;
                            $date_total_tax = 0;
                            $date_total_amount = 0;
                        @endphp
                        
                        <!-- Date Header -->
                        <tr class="date-header-row">
                            <td colspan="10"><strong>Date: {{ $date }}</strong></td>
                        </tr>
                        
                        @foreach($bill_types as $bill_type => $sales_list)
                            @php
                                $bill_type_total_before_tax = 0;
                                $bill_type_total_discount = 0;
                                $bill_type_total_extra_charges = 0;
                                $bill_type_total_tax = 0;
                                $bill_type_total_amount = 0;
                            @endphp
                            
                            <!-- Bill Type Header -->
                            <tr class="bill-type-header-row">
                                <td colspan="10"><strong>{{ $bill_type }}</strong></td>
                            </tr>
                            
                            @foreach($sales_list as $sale)
                                @php
                                    $discount = $sale->discount_amount ?? 0;
                                    if (!empty($discount) && $sale->discount_type == 'percentage') {
                                        $discount = $sale->total_before_tax * ($discount / 100);
                                    }
                                    
                                    $extra_charges = $sale->shipping_charges ?? 0;
                                    $extra_charges += $sale->additional_expense_value_1 ?? 0;
                                    $extra_charges += $sale->additional_expense_value_2 ?? 0;
                                    $extra_charges += $sale->additional_expense_value_3 ?? 0;
                                    $extra_charges += $sale->additional_expense_value_4 ?? 0;
                                    
                                    $trader_name = $sale->customer_name ?? 'Walking Customer';
                                    if (!empty($sale->supplier_business_name)) {
                                        $trader_name = $sale->supplier_business_name . ' - ' . $trader_name;
                                    }
                                    
                                    $bill_type_total_before_tax += $sale->total_before_tax;
                                    $bill_type_total_discount += $discount;
                                    $bill_type_total_extra_charges += $extra_charges;
                                    $bill_type_total_tax += $sale->tax_amount ?? 0;
                                    $bill_type_total_amount += $sale->final_total;
                                @endphp
                                
                                <tr>
                                    <td>{{ $sale->invoice_no ?? '' }}</td>
                                    <td>{{ $sale->ref_no ?? '' }}</td>
                                    <td>{{ $trader_name }}</td>
                                    <td>{{ $sale->entered_by ?? '' }}</td>
                                    <td>{{ $util->num_f($sale->total_before_tax, true) }}</td>
                                    <td>{{ $util->num_f($discount, true) }}</td>
                                    <td>{{ $util->num_f($extra_charges, true) }}</td>
                                    <td>{{ $util->num_f($sale->tax_amount ?? 0, true) }}</td>
                                    <td>{{ $util->num_f($sale->final_total, true) }}</td>
                                    <td class="link-cell">
                                        <a href="{{ action([\App\Http\Controllers\SellController::class, 'show'], [$sale->id]) }}" target="_blank">Click</a>
                                    </td>
                                </tr>
                            @endforeach
                            
                            <!-- Bill Type Subtotal -->
                            <tr class="subtotal-row">
                                <td colspan="4"><strong>Sub Total ({{ $bill_type }}):</strong></td>
                                <td><strong>{{ $util->num_f($bill_type_total_before_tax, true) }}</strong></td>
                                <td><strong>{{ $util->num_f($bill_type_total_discount, true) }}</strong></td>
                                <td><strong>{{ $util->num_f($bill_type_total_extra_charges, true) }}</strong></td>
                                <td><strong>{{ $util->num_f($bill_type_total_tax, true) }}</strong></td>
                                <td><strong>{{ $util->num_f($bill_type_total_amount, true) }}</strong></td>
                                <td class="link-cell">
                                    @if(count($sales_list) > 0)
                                        <a href="{{ action([\App\Http\Controllers\SellController::class, 'show'], [$sales_list[0]->id]) }}" target="_blank">Click</a>
                                    @endif
                                </td>
                            </tr>
                            
                            @php
                                $date_total_before_tax += $bill_type_total_before_tax;
                                $date_total_discount += $bill_type_total_discount;
                                $date_total_extra_charges += $bill_type_total_extra_charges;
                                $date_total_tax += $bill_type_total_tax;
                                $date_total_amount += $bill_type_total_amount;
                            @endphp
                        @endforeach
                        
                        @php
                            $grand_total_before_tax += $date_total_before_tax;
                            $grand_total_discount += $date_total_discount;
                            $grand_total_extra_charges += $date_total_extra_charges;
                            $grand_total_tax += $date_total_tax;
                            $grand_total_amount += $date_total_amount;
                        @endphp
                    @endforeach
                    
                    <!-- Grand Total -->
                    <tr class="grand-total-row">
                        <td colspan="4"><strong>Grand Total:</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_before_tax, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_discount, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_extra_charges, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_tax, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_amount, true) }}</strong></td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>


