<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date wise Gross Profit</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 11pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 22pt;
            font-weight: 700;
            margin-bottom: 6px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #000;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #000;
        }
        
        .report-title {
            font-size: 16pt;
            font-weight: 700;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #000;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        .report-info {
            font-size: 11pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 600;
            color: #000;
        }
        
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 11pt;
            page-break-inside: auto;
            border: 1px solid #000;
        }
        
        thead {
            display: table-header-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #fff !important;
            color: #000 !important;
            border: 1px solid #000;
            padding: 8px 6px;
            text-align: center;
            font-weight: 700;
            font-size: 11pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
            font-family: Arial, Helvetica, sans-serif;
        }
        
        table thead th:nth-child(1),
        table thead th:nth-child(2) {
            text-align: left;
        }
        
        table thead th:nth-child(3),
        table thead th:nth-child(4),
        table thead th:nth-child(5),
        table thead th:nth-child(6),
        table thead th:nth-child(7),
        table thead th:nth-child(8),
        table thead th:nth-child(9),
        table thead th:nth-child(10),
        table thead th:nth-child(11) {
            text-align: right;
        }
        
        table tbody td {
            border: 1px solid #000;
            padding: 6px 5px;
            font-size: 11pt;
            text-align: left;
            vertical-align: middle;
            color: #000;
            font-family: Arial, Helvetica, sans-serif;
        }
        
        /* Invoice No and Trader Name - left aligned */
        table tbody td:nth-child(1),
        table tbody td:nth-child(2) {
            text-align: left;
        }
        
        /* All numerical columns - right aligned */
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7),
        table tbody td:nth-child(8),
        table tbody td:nth-child(9),
        table tbody td:nth-child(10),
        table tbody td:nth-child(11) {
            text-align: right;
            font-family: Arial, Helvetica, sans-serif;
        }
        
        .text-red {
            color: #ff0000 !important;
        }
        
        .grand-total-row {
            background-color: #fff !important;
            font-weight: 700;
            font-size: 12pt;
        }
        
        .grand-total-row td {
            border-top: 3px double #000;
            border-bottom: 3px double #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            padding: 8px 6px;
            font-family: Arial, Helvetica, sans-serif;
        }
        
        .grand-total-row td:first-child,
        .grand-total-row td:nth-child(2) {
            text-align: left;
        }
        
        .grand-total-row td:nth-child(3),
        .grand-total-row td:nth-child(4),
        .grand-total-row td:nth-child(5),
        .grand-total-row td:nth-child(6),
        .grand-total-row td:nth-child(7),
        .grand-total-row td:nth-child(8),
        .grand-total-row td:nth-child(9),
        .grand-total-row td:nth-child(10),
        .grand-total-row td:nth-child(11) {
            text-align: right;
            font-family: Arial, Helvetica, sans-serif;
        }
        
        @media print {
            .text-red {
                color: #ff0000 !important;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ __('lang_v1.mobile') }}: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ __('lang_v1.alternate_number') }}: {{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ __('business.email') }}: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Date wise Gross Profit</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if($start_date && $end_date)
                @php
                    $start_formatted = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                    $end_formatted = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                @endphp
                {{ $start_formatted }} To {{ $end_formatted }}
            @endif
        </div>

        <!-- Table Container -->
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Trader Name</th>
                        <th>Total Amount</th>
                        <th>Discount</th>
                        <th>Extra Charges</th>
                        <th>AIT</th>
                        <th>VAT</th>
                        <th>Net Payable Amount</th>
                        <th>Total Cost</th>
                        <th>Gross Profit</th>
                        <th>Profit %</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($transactions as $transaction)
                        @php
                            $discount = $transaction->discount_amount ?? 0;
                            if (!empty($discount) && $transaction->discount_type == 'percentage') {
                                $discount = ($transaction->total_before_tax ?? 0) * ($discount / 100);
                            }
                            
                            $trader_name = $transaction->trader_name ?? 'Walking Customer';
                            if (!empty($transaction->supplier_business_name)) {
                                $trader_name = $transaction->supplier_business_name . ' - ' . $trader_name;
                            }
                            
                            $net_payable = $transaction->final_total ?? 0;
                            $total_cost = $transaction->total_cost ?? 0;
                            $gross_profit = $net_payable - $total_cost;
                            $profit_percent = 0;
                            if ($net_payable != 0) {
                                $profit_percent = ($gross_profit / $net_payable) * 100;
                            }
                        @endphp
                        <tr>
                            <td>{{ $transaction->invoice_no ?? '' }}</td>
                            <td>{{ $trader_name }}</td>
                            <td>{{ $util->num_f($transaction->total_before_tax ?? 0, true) }}</td>
                            <td>{{ $util->num_f($discount, true) }}</td>
                            @php
                                $extra_charges = ($transaction->shipping_charges ?? 0) + 
                                                ($transaction->additional_expense_value_1 ?? 0) + 
                                                ($transaction->additional_expense_value_2 ?? 0) + 
                                                ($transaction->additional_expense_value_3 ?? 0) + 
                                                ($transaction->additional_expense_value_4 ?? 0);
                            @endphp
                            <td>{{ $util->num_f($extra_charges, true) }}</td>
                            <td>{{ $util->num_f(0, true) }}</td>
                            <td>{{ $util->num_f($transaction->tax_amount ?? 0, true) }}</td>
                            <td>{{ $util->num_f($net_payable, true) }}</td>
                            <td>{{ $util->num_f($total_cost, true) }}</td>
                            <td class="{{ $gross_profit < 0 ? 'text-red' : '' }}">{{ $util->num_f($gross_profit, true) }}</td>
                            <td class="{{ $profit_percent < 0 ? 'text-red' : '' }}">{{ $util->num_f($profit_percent, true) }}%</td>
                        </tr>
                    @endforeach
                    
                    <!-- Grand Total -->
                    <tr class="grand-total-row">
                        <td colspan="2"><strong>Grand Total:</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_amount, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_discount, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_extra_charges, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_ait, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_vat, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_net_payable, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_cost, true) }}</strong></td>
                        <td class="{{ $grand_total_gross_profit < 0 ? 'text-red' : '' }}"><strong>{{ $util->num_f($grand_total_gross_profit, true) }}</strong></td>
                        <td class="{{ $grand_total_profit_percent < 0 ? 'text-red' : '' }}"><strong>{{ $util->num_f($grand_total_profit_percent, true) }}%</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>

