@extends('layouts.app')
@section('title', 'Date wise Sales Return')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Date wise Sales Return</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesReturn']), 'method' => 'get', 'id' => 'date_wise_sales_return_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_wise_sales_return_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesReturn']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseSalesReturn'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Invoice No</th>
                                <th>Customer Name</th>
                                <th>Narration</th>
                                <th>Bill Type</th>
                                <th>RefNo</th>
                                <th style="text-align: right;">Total Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($sales_returns) > 0)
                                @foreach($sales_returns as $return)
                                <tr>
                                    <td>
                                        <div>{{ $util->format_date($return->transaction_date, false) }}</div>
                                        <div><strong>{{ $return->invoice_no }}</strong></div>
                                    </td>
                                    <td>
                                        @if(!empty($return->supplier_business_name))
                                            {{ $return->supplier_business_name }} - 
                                        @endif
                                        {{ $return->customer_name ?? 'Walking Customer' }}
                                    </td>
                                    <td>{{ $return->additional_notes ?? '' }}</td>
                                    <td>
                                        @if($return->payment_status == 'paid')
                                            <span class="label label-success">Cash</span>
                                        @elseif($return->payment_status == 'due')
                                            <span class="label label-warning">Credit</span>
                                        @elseif($return->payment_status == 'partial')
                                            <span class="label label-info">Partial</span>
                                        @else
                                            <span class="label label-default">{{ ucfirst($return->payment_status) }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $return->ref_no ?? '' }}</td>
                                    <td style="text-align: right;">
                                        <span class="display_currency" data-currency_symbol="true">{{ $return->final_total }}</span>
                                    </td>
                                </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="6" class="text-center">No sales return found for the selected date range.</td>
                                </tr>
                            @endif
                        </tbody>
                        <tfoot>
                            <tr style="background-color: #f5f5f5; font-weight: bold;">
                                <td colspan="5" style="text-align: right;">Sub Total:</td>
                                <td style="text-align: right;">
                                    <span class="display_currency" data-currency_symbol="true">{{ $grand_total }}</span>
                                </td>
                            </tr>
                            <tr style="background-color: #e8e8e8; font-weight: bold; border-top: 2px solid #000;">
                                <td colspan="5" style="text-align: right;">Grand Total:</td>
                                <td style="text-align: right;">
                                    <span class="display_currency" data-currency_symbol="true">{{ $grand_total }}</span>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#date_wise_sales_return_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#date_wise_sales_return_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#date_wise_sales_return_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#date_wise_sales_return_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Reload when date range changes
        $('#date_wise_sales_return_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection


