@extends('layouts.app')
@section('title', __('businessmanagement::lang.purchase_register'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); padding: 30px 20px; margin: -20px -15px 30px -15px; border-radius: 0;">
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-md-12 text-center">
                <h1 style="color: #fff; font-size: 32px; font-weight: 700; margin: 0; display: flex; align-items: center; justify-content: center; gap: 15px;">
                    <i class="fa fa-chart-bar" style="font-size: 36px;"></i>
                    Purchase Register Reports
                </h1>
                <p style="color: rgba(255,255,255,0.9); font-size: 16px; margin: 10px 0 0 0;">
                    Comprehensive purchase tracking and analysis reports
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Date wise Purchase Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-calendar-alt" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date wise Purchase</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Detailed purchase analysis grouped by date with supplier and location filtering options
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date grouping</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Supplier filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchase']) }}" 
                           class="btn btn-primary" 
                           style="width: 100%; background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Supplier wise Purchase Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-users" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Supplier wise Purchase</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Supplier-specific purchase analysis with detailed transaction breakdown and performance metrics
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Supplier analysis</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Transaction details</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Performance metrics</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchase']) }}" 
                           class="btn btn-info" 
                           style="width: 100%; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Supplier wise Purchase Without Price Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #fd7e14 0%, #e8650e 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-file-alt" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Supplier wise Purchase (WOP)</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Supplier-specific purchase report without price information, focusing on quantities and product details
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">No price</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Quantity focus</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date wise</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchaseWOP']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #fd7e14 0%, #e8650e 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product wise Purchase Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-cubes" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product wise Purchase</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-based purchase analysis grouped by category and product model with detailed breakdown
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category grouping</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Product analysis</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Model totals</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'productWisePurchase']) }}" 
                           class="btn btn-success" 
                           style="width: 100%; background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product wise Purchase Without Price Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-cube" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product wise Purchase (WOP)</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-based purchase report without price information, focusing on quantities and product details
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">No price</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Product filter</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'productWisePurchaseWOP']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Location Wise Net Product Purchase Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-store" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Location Wise Net Product Purchase</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Location-based net purchase analysis with purchase and return quantities, grouped by category and brand
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Net purchase</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Returns</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Brand wise</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'locationWiseNetProductPurchase']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date Wise Net Product Purchase Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-calendar-alt" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date Wise Net Product Purchase</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Date-based net purchase analysis with purchase and return quantities, grouped by date, category, and brand
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date wise</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Net purchase</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Brand wise</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWiseNetProductPurchase']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Supplier Wise Statement Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-file-invoice-dollar" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Supplier Wise Statement</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Comprehensive supplier account statement showing opening balance, purchases, returns, payments, and closing balance
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Account balance</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Payments</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Statement</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWiseStatement']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Supplier and Product Wise Purchase Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #9c27b0 0%, #7b1fa2 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-shopping-cart" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Supplier and Product Wise Purchase</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Combined supplier and product analysis with flexible grouping by category, supplier, and product filters
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Supplier & Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Flexible grouping</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierAndProductWisePurchase']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #9c27b0 0%, #7b1fa2 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Purchased Product Movement Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #e91e63 0%, #c2185b 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-chart-line" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Purchased Product Movement</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Track product movement with profit analysis showing purchase, sales, stock in hand, and profit calculations grouped by supplier and product
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Profit Analysis</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Stock Tracking</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Movement Report</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'purchasedProductMovement']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #e91e63 0%, #c2185b 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Supplier wise Purchase Return Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-undo" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Supplier wise Purchase Return</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Detailed purchase return analysis grouped by supplier and date with invoice details, quantities, and amounts
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date wise</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Supplier filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchaseReturn']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date wise Purchase Return Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #fd7e14 0%, #e85d00 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-calendar-times" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date wise Purchase Return</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Purchase return analysis grouped by date with supplier details, amounts, discounts, and charges
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date wise</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Location filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchaseReturn']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #fd7e14 0%, #e85d00 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product wise Purchase Return Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-cube" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product wise Purchase Return</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Purchase return analysis grouped by product with supplier details, quantities, and amounts
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date wise</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'productWisePurchaseReturn']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date wise Purchase Order Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-file-invoice" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date wise Purchase Order</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Purchase order analysis grouped by date with order details, requisition numbers, products, and quantities
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date wise</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Location filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchaseOrder']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Supplier wise Purchase Order Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-users" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Supplier wise Purchase Order</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Purchase order analysis grouped by supplier with order details, requisition numbers, products, and quantities
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date wise</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Supplier filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Product filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'supplierWisePurchaseOrder']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.15) !important;
    }
</style>

@endsection
