@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_receipt_payment_statement'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_receipt_payment_statement') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceiptPaymentStatement']), 'method' => 'get', 'id' => 'receipt_payment_statement_filter_form' ]) !!}
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'receipt_payment_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'receipt_payment_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('receipt_payment_filter', 'Receipt & Payment:') !!}
                        {!! Form::select('receipt_payment_filter', [
                            'all' => 'All Receipt & Payment',
                            'receipt_all' => 'All Receipt',
                            'receipt_single' => 'Single Receipt',
                            'payment_all' => 'All Payment',
                            'payment_single' => 'Single Payment'
                        ], $receipt_payment_filter ?? 'all', ['class' => 'form-control', 'id' => 'receipt_payment_filter']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="receipt_account_wrapper" style="display: {{ in_array($receipt_payment_filter ?? 'all', ['receipt_single']) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('receipt_account_id', 'Receipt Account:') !!}
                        {!! Form::select('receipt_account_id', $receipt_accounts, $receipt_account_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => 'Select Account', 'id' => 'receipt_account_id']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="payment_account_wrapper" style="display: {{ in_array($receipt_payment_filter ?? 'all', ['payment_single']) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('payment_account_id', 'Payment Account:') !!}
                        {!! Form::select('payment_account_id', $payment_accounts, $payment_account_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => 'Select Account', 'id' => 'payment_account_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceiptPaymentStatement']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseReceiptPaymentStatement'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'receipt_payment_filter' => $receipt_payment_filter ?? 'all', 'receipt_account_id' => $receipt_account_id ?? '', 'payment_account_id' => $payment_account_id ?? '', 'location_id' => $location_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    <table class="table table-bordered table-striped" style="font-size: 12px;">
                        <thead>
                            <tr>
                                <th style="text-align: left; width: 40%;">Particulars</th>
                                <th style="text-align: right; width: 20%;">Cash</th>
                                <th style="text-align: right; width: 20%;">Bank</th>
                                <th style="text-align: right; width: 20%;">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Opening Section -->
                            <tr style="background-color: #f5f5f5; font-weight: bold;">
                                <td>Opening</td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td style="padding-left: 20px;">Opening Balance</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_total, true, null) }}</td>
                            </tr>
                            <tr style="font-weight: bold;">
                                <td style="padding-left: 20px;">Opening Balance Sub Total:</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_total, true, null) }}</td>
                            </tr>
                            <tr style="font-weight: bold;">
                                <td>Opening Sub Total:</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($opening_total, true, null) }}</td>
                            </tr>
                            
                            <!-- Receive Section -->
                            <tr style="background-color: #f5f5f5; font-weight: bold;">
                                <td>Receive</td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            @foreach($receipt_data as $account_name => $data)
                                <tr>
                                    <td style="padding-left: 20px;">{{ $account_name }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['cash'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['bank'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['total'], true, null) }}</td>
                                </tr>
                                <tr style="font-weight: bold;">
                                    <td style="padding-left: 20px;">{{ $account_name }} Sub Total:</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['cash'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['bank'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['total'], true, null) }}</td>
                                </tr>
                            @endforeach
                            <tr style="font-weight: bold;">
                                <td>Receive Sub Total:</td>
                                <td style="text-align: right;">{{ $util->num_f($total_receipt_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($total_receipt_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($total_receipt_total, true, null) }}</td>
                            </tr>
                            
                            <!-- Payment Section -->
                            <tr style="background-color: #f5f5f5; font-weight: bold;">
                                <td>Payment</td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            @foreach($payment_data as $category_name => $data)
                                <tr>
                                    <td style="padding-left: 20px;">{{ $category_name }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['cash'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['bank'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['total'], true, null) }}</td>
                                </tr>
                                @if(!empty($data['items']))
                                    @foreach($data['items'] as $item)
                                        <tr>
                                            <td style="padding-left: 40px;">{{ $item['name'] }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item['cash'], true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item['bank'], true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item['total'], true, null) }}</td>
                                        </tr>
                                    @endforeach
                                @endif
                                <tr style="font-weight: bold;">
                                    <td style="padding-left: 20px;">{{ $category_name }} Sub Total:</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['cash'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['bank'], true, null) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($data['total'], true, null) }}</td>
                                </tr>
                            @endforeach
                            <tr style="font-weight: bold;">
                                <td>Payment Sub Total:</td>
                                <td style="text-align: right;">{{ $util->num_f($total_payment_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($total_payment_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($total_payment_total, true, null) }}</td>
                            </tr>
                            
                            <!-- Closing Section -->
                            <tr style="background-color: #f5f5f5; font-weight: bold;">
                                <td>Closing</td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td style="padding-left: 20px;">Closing Balance</td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td style="padding-left: 20px;">Closing Balance</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_total, true, null) }}</td>
                            </tr>
                            <tr style="font-weight: bold;">
                                <td style="padding-left: 20px;">Closing Balance Sub Total:</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_total, true, null) }}</td>
                            </tr>
                            <tr style="font-weight: bold;">
                                <td>Closing Sub Total:</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_cash, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_bank, true, null) }}</td>
                                <td style="text-align: right;">{{ $util->num_f($closing_total, true, null) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#receipt_payment_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#receipt_payment_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#receipt_payment_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#receipt_payment_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Receipt Payment filter toggle
        $('#receipt_payment_filter').on('change', function() {
            var filter_value = $(this).val();
            
            // Hide both wrappers first
            $('#receipt_account_wrapper').hide();
            $('#payment_account_wrapper').hide();
            $('#receipt_account_id').val(null).trigger('change');
            $('#payment_account_id').val(null).trigger('change');
            
            // Show appropriate wrapper based on selection
            if (filter_value == 'receipt_single') {
                $('#receipt_account_wrapper').show();
            } else if (filter_value == 'payment_single') {
                $('#payment_account_wrapper').show();
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#receipt_payment_statement_filter_form').on('submit', function() {
            var start_date_val = $('#receipt_payment_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#receipt_payment_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

