@extends('layouts.app')
@section('title', __('businessmanagement::lang.customer_accounts_ledger'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.customer_accounts_ledger') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerAccountsLedger']), 'method' => 'get', 'id' => 'customer_accounts_ledger_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'customer_accounts_ledger_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'customer_accounts_ledger_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('contact_type', __('businessmanagement::lang.contact_type') . ':') !!}
                        {!! Form::select('contact_type', [
                            'customer' => __('contact.customer'),
                            'supplier' => __('contact.supplier')
                        ], $contact_type ?? 'customer', ['class' => 'form-control', 'id' => 'contact_type']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="customer_select_wrapper" style="display: {{ ($contact_type ?? 'customer') == 'customer' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="supplier_select_wrapper" style="display: {{ ($contact_type ?? 'customer') == 'supplier' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('supplier_id', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, $supplier_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_supplier'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerAccountsLedger']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if((!empty($customer_id) && ($contact_type ?? 'customer') == 'customer') || (!empty($supplier_id) && ($contact_type ?? 'customer') == 'supplier'))
                                <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCustomerAccountsLedger'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'contact_type' => $contact_type ?? 'customer', 'customer_id' => $customer_id ?? '', 'supplier_id' => $supplier_id ?? '', 'location_id' => $location_id ?? '']) }}" 
                                   target="_blank" 
                                   class="btn btn-success">
                                    <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                @php
                    $has_contact = false;
                    if (($contact_type ?? 'customer') == 'supplier' && !empty($supplier_id) && !empty($customer)) {
                        $has_contact = true;
                    } elseif (($contact_type ?? 'customer') == 'customer' && !empty($customer_id) && !empty($customer)) {
                        $has_contact = true;
                    }
                @endphp
                @if($has_contact)
                    <div class="table-responsive" style="overflow-x: auto;">
                        @if(count($ledger_data) > 0)
                            <table class="table table-bordered table-striped" style="font-size: 12px;">
                                <thead>
                                    <tr>
                                        <th style="text-align: left;">Date</th>
                                        <th style="text-align: left;">Type</th>
                                        <th style="text-align: left;">Transaction Mode</th>
                                        <th style="text-align: left;">A/C Name</th>
                                        <th style="text-align: left;">Ref No.</th>
                                        <th style="text-align: left;">Voucher No</th>
                                        <th style="text-align: right;">Debit</th>
                                        <th style="text-align: right;">Credit</th>
                                        <th style="text-align: right;">Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($ledger_data as $item)
                                        <tr>
                                            <td>{{ $util->format_date($item->date, false) }}</td>
                                            <td>{{ $item->type }}</td>
                                            <td>{{ $item->transaction_mode }}</td>
                                            <td>{{ $item->ac_name }}</td>
                                            <td>{{ $item->ref_no }}</td>
                                            <td>{{ $item->voucher_no }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->debit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->credit, true, null) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item->balance, true, null) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr style="background-color: #f8f9fa; font-weight: bold;">
                                        <td colspan="6" style="text-align: right;"><strong>Grand Total :</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_debit ?? 0, true, null) }}</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($grand_total_credit ?? 0, true, null) }}</strong></td>
                                        <td style="text-align: right;"></td>
                                    </tr>
                                    <tr style="background-color: #e9ecef; font-weight: bold;">
                                        <td colspan="8" style="text-align: right;"><strong>Closing Balance:</strong></td>
                                        <td style="text-align: right;"><strong>{{ $util->num_f($closing_balance ?? 0, true, null) }}</strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                        @else
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No transactions found for the selected {{ ($contact_type ?? 'customer') == 'supplier' ? 'supplier' : 'customer' }} and date range.
                            </div>
                        @endif
                    </div>
                @else
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i> Please select a customer or supplier to view the accounts ledger.
                    </div>
                @endif
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#customer_accounts_ledger_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#customer_accounts_ledger_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#customer_accounts_ledger_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#customer_accounts_ledger_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Contact type filter toggle
        $('#contact_type').on('change', function() {
            if ($(this).val() == 'supplier') {
                $('#customer_select_wrapper').hide();
                $('#supplier_select_wrapper').show();
                $('#customer_id').val(null).trigger('change');
            } else {
                $('#customer_select_wrapper').show();
                $('#supplier_select_wrapper').hide();
                $('#supplier_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#customer_accounts_ledger_filter_form').on('submit', function() {
            var start_date_val = $('#customer_accounts_ledger_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#customer_accounts_ledger_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

