<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Supplier wise Current Stock</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 50%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 30%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            color: #4a4a4a;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 15px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            font-size: 9pt;
        }
        
        table thead {
            background-color: #f5f5f5;
        }
        
        table th {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: left;
            font-weight: 600;
            font-size: 9pt;
        }
        
        table th:nth-child(3),
        table th:nth-child(4),
        table th:nth-child(5) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 5px 4px;
            font-size: 9pt;
        }
        
        table td:nth-child(3),
        table td:nth-child(4),
        table td:nth-child(5) {
            text-align: right;
        }
        
        .supplier-header {
            font-size: 12pt;
            font-weight: 700;
            margin-top: 20px;
            margin-bottom: 10px;
            color: #1a1a1a;
        }
        
        .category-header {
            font-size: 11pt;
            font-weight: 600;
            margin-top: 15px;
            margin-bottom: 8px;
            color: #2c3e50;
        }
        
        .subtotal-row {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        
        .supplier-total-row {
            background-color: #d4edda;
            font-weight: 700;
            font-size: 10pt;
        }
        
        .text-right {
            text-align: right;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->landmark ?? '' }}, {{ $business->city ?? '' }}, {{ $business->state ?? '' }}, {{ $business->country ?? '' }}</div>
            </div>
            <div class="header-right">
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Tel: {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <br>E-mail: {{ $business->email }}
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Supplier wise Current Stock</div>
        
        <!-- Report Content -->
        @if(count($grouped_data) > 0)
            @foreach($grouped_data as $supplier_name => $categories)
                <div class="supplier-header">{{ $supplier_name }}</div>
                @foreach($categories as $category_name => $items)
                    <div class="category-header">{{ $category_name }}</div>
                    <table>
                        <thead>
                            <tr>
                                <th>Product ID</th>
                                <th>Product Description</th>
                                <th class="text-right">Qty</th>
                                <th class="text-right">Unit Cost</th>
                                <th class="text-right">Total Cost</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $category_total_qty = 0;
                                $category_total_cost = 0;
                            @endphp
                            @foreach($items as $item)
                                @php
                                    $category_total_qty += $item->qty;
                                    $category_total_cost += $item->total_cost;
                                @endphp
                                <tr>
                                    <td>{{ $item->product_id }}</td>
                                    <td>{{ $item->product_description }}</td>
                                    <td class="text-right">{{ $util->num_f($item->qty, false, null, true) }}</td>
                                    <td class="text-right">{{ $util->num_f($item->unit_cost, true) }}</td>
                                    <td class="text-right">{{ $util->num_f($item->total_cost, true) }}</td>
                                </tr>
                            @endforeach
                            <tr class="subtotal-row">
                                <td colspan="2"><strong>Sub Total:</strong></td>
                                <td class="text-right"><strong>{{ $util->num_f($category_total_qty, false, null, true) }}</strong></td>
                                <td></td>
                                <td class="text-right"><strong>{{ $util->num_f($category_total_cost, true) }}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                @endforeach
                @php
                    $supplier_total_qty = 0;
                    $supplier_total_cost = 0;
                    foreach ($categories as $category_items) {
                        foreach ($category_items as $item) {
                            $supplier_total_qty += $item->qty;
                            $supplier_total_cost += $item->total_cost;
                        }
                    }
                @endphp
                <table style="margin-top: 10px;">
                    <tbody>
                        <tr class="supplier-total-row">
                            <td colspan="2"><strong>Sub Total : {{ $supplier_name }}</strong></td>
                            <td class="text-right"><strong>{{ $util->num_f($supplier_total_qty, false, null, true) }}</strong></td>
                            <td></td>
                            <td class="text-right"><strong>{{ $util->num_f($supplier_total_cost, true) }}</strong></td>
                        </tr>
                    </tbody>
                </table>
            @endforeach
        @else
            <div class="no-data">No stock data found for the selected filters.</div>
        @endif
    </div>
</body>
</html>

