@extends('layouts.app')
@section('title', __('businessmanagement::lang.product_wise_gross_profit'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.product_wise_gross_profit') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseGrossProfit']), 'method' => 'get', 'id' => 'product_wise_gross_profit_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_wise_gross_profit_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ' ' . __('lang_v1.filter') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('lang_v1.all_products'), 'single' => __('lang_v1.single_product')], 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_categories'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="product_wise_gross_profit_table">
                        <thead>
                            <tr>
                                <th>{{ __('businessmanagement::lang.product_model') }}</th>
                                <th>{{ __('businessmanagement::lang.qty') }}</th>
                                <th>{{ __('businessmanagement::lang.unit_price') }}</th>
                                <th>{{ __('businessmanagement::lang.total_price') }}</th>
                                <th>{{ __('businessmanagement::lang.unit_cost') }}</th>
                                <th>{{ __('businessmanagement::lang.total_cost') }}</th>
                                <th>{{ __('businessmanagement::lang.gross_profit') }}</th>
                                <th>{{ __('businessmanagement::lang.profit_percent') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#product_wise_gross_profit_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#product_wise_gross_profit_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
            }
        );

        $('#product_wise_gross_profit_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val('').trigger('change');
            }
        });

        var product_wise_gross_profit_table = $('#product_wise_gross_profit_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "productWiseGrossProfit"]) }}',
                data: function(d) {
                    d.product_id = $('#product_filter').val() == 'single' ? $('#product_id').val() : '';
                    d.category_id = $('#category_id').val();
                    d.location_id = $('#location_id').val();
                    if ($('#product_wise_gross_profit_date_range').val()) {
                        var start = $('#product_wise_gross_profit_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#product_wise_gross_profit_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'product_model', name: 'product_model' },
                { data: 'qty', name: 'qty', orderable: false },
                { data: 'unit_price', name: 'unit_price', orderable: false },
                { data: 'total_price', name: 'total_price', orderable: false },
                { data: 'unit_cost', name: 'unit_cost', orderable: false },
                { data: 'total_cost', name: 'total_cost', orderable: false },
                { data: 'gross_profit', name: 'gross_profit', orderable: false },
                { data: 'profit_percent', name: 'profit_percent', orderable: false },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#product_wise_gross_profit_table'));
            },
        });

        // Apply filters button
        $('#apply_filters').on('click', function() {
            product_wise_gross_profit_table.ajax.reload();
            checkPrintButton();
        });

        // Reset filters button
        $('#reset_filters').on('click', function() {
            $('#product_filter').val('all').trigger('change');
            $('#product_id').val('').trigger('change');
            $('#category_id').val('').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#product_wise_gross_profit_date_range').val('');
            product_wise_gross_profit_table.ajax.reload();
            checkPrintButton();
        });

        // Auto-reload on filter change
        $('#product_id, #category_id, #location_id').on('change', function() {
            product_wise_gross_profit_table.ajax.reload(null, false);
        });

        // Reload when date range changes
        $('#product_wise_gross_profit_date_range').on('apply.daterangepicker', function(ev, picker) {
            product_wise_gross_profit_table.ajax.reload(null, false);
            checkPrintButton();
        });

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#product_wise_gross_profit_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Print button click
        $('#print_report').on('click', function() {
            var product_id = '';
            if ($('#product_filter').val() == 'single') {
                product_id = $('#product_id').val() || '';
            }
            var category_id = $('#category_id').val() || '';
            var location_id = $('#location_id').val() || '';
            var start_date = '';
            var end_date = '';
            
            if ($('#product_wise_gross_profit_date_range').val()) {
                start_date = $('#product_wise_gross_profit_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#product_wise_gross_profit_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
            
            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, "printProductWiseGrossProfit"]) }}';
            url += '?product_id=' + product_id;
            url += '&category_id=' + category_id;
            url += '&location_id=' + location_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;
            
            window.open(url, '_blank');
        });

        // Initial check
        checkPrintButton();
    });
</script>
@endsection





