<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Customer Wise Statement</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 85%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Category Section */
        .category-section {
            margin-bottom: 15px;
            page-break-inside: avoid;
        }
        
        .category-header {
            font-size: 11pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            padding: 4px;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 8pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 5px 4px;
            text-align: center;
            font-weight: 600;
            font-size: 8pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 4px 3px;
            font-size: 8pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 8pt;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 5px 4px;
        }
        
        .grand-total-row {
            background-color: #e8e8e8 !important;
            font-weight: 700;
            font-size: 9pt;
            border-top: 2px solid #2c3e50;
        }
        
        .grand-total-row td {
            border: 1px solid #2c3e50;
            padding: 6px 4px;
        }
        
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 8pt;
            color: #6a6a6a;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            vertical-align: top;
            width: 70%;
        }
        
        .footer-right {
            display: table-cell;
            vertical-align: top;
            width: 30%;
            text-align: right;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .category-header {
                page-break-inside: avoid;
            }
            
            .subtotal-row {
                page-break-inside: avoid;
            }
            
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Customer Wise Statement</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Category Sections -->
        @if(count($table_data) > 0)
            @php
                $grand_total_opening = 0;
                $grand_total_sales = 0;
                $grand_total_sales_return = 0;
                $grand_total_net_sales = 0;
                $grand_total_sales_qty = 0;
                $grand_total_sales_return_qty = 0;
                $grand_total_purchase_qty = 0;
                $grand_total_purchase_return_qty = 0;
                $grand_total_purchase = 0;
                $grand_total_purchase_return = 0;
                $grand_total_receive = 0;
                $grand_total_payment = 0;
                $grand_total_other_cr = 0;
                $grand_total_other_dr = 0;
                $grand_total_discount = 0;
                $grand_total_due = 0;
            @endphp
            
            @foreach($grouped_data as $group_name => $group_customers)
                <div class="category-section">
                    <!-- Category Header -->
                    <div class="category-header">
                        {{ $group_name }}
                    </div>

                    <!-- Customer Table -->
                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>TraderName</th>
                                    <th>Opening</th>
                                    <th>Sales</th>
                                    <th>S.Return</th>
                                    <th>Net Sales</th>
                                    <th>Sales Qty</th>
                                    <th>S.Return Qty</th>
                                    <th>Purchase Qty</th>
                                    <th>P.Return Qty</th>
                                    <th>Purchase</th>
                                    <th>Pur.Return</th>
                                    <th>Receive</th>
                                    <th>Payment</th>
                                    <th>Other Cr</th>
                                    <th>Other Dr</th>
                                    <th>Discount</th>
                                    <th>Due</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $subtotal_opening = 0;
                                    $subtotal_sales = 0;
                                    $subtotal_sales_return = 0;
                                    $subtotal_net_sales = 0;
                                    $subtotal_sales_qty = 0;
                                    $subtotal_sales_return_qty = 0;
                                    $subtotal_purchase_qty = 0;
                                    $subtotal_purchase_return_qty = 0;
                                    $subtotal_purchase = 0;
                                    $subtotal_purchase_return = 0;
                                    $subtotal_receive = 0;
                                    $subtotal_payment = 0;
                                    $subtotal_other_cr = 0;
                                    $subtotal_other_dr = 0;
                                    $subtotal_discount = 0;
                                    $subtotal_due = 0;
                                @endphp
                                @foreach($group_customers as $row)
                                    @php
                                        $subtotal_opening += $row['opening_balance'];
                                        $subtotal_sales += $row['sales'];
                                        $subtotal_sales_return += $row['sales_return'];
                                        $subtotal_net_sales += $row['net_sales'];
                                        $subtotal_sales_qty += $row['sales_qty'];
                                        $subtotal_sales_return_qty += $row['sales_return_qty'];
                                        $subtotal_purchase_qty += $row['purchase_qty'];
                                        $subtotal_purchase_return_qty += $row['purchase_return_qty'];
                                        $subtotal_purchase += $row['purchase'];
                                        $subtotal_purchase_return += $row['purchase_return'];
                                        $subtotal_receive += $row['receive'];
                                        $subtotal_payment += $row['payment'];
                                        $subtotal_other_cr += $row['other_cr'];
                                        $subtotal_other_dr += $row['other_dr'];
                                        $subtotal_discount += $row['discount'];
                                        $subtotal_due += $row['due'];
                                    @endphp
                                    <tr>
                                        <td>{{ $row['customer_name'] }}</td>
                                        <td class="text-right">{{ number_format($row['opening_balance'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['sales'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['sales_return'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['net_sales'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['sales_qty'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['sales_return_qty'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['purchase_qty'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['purchase_return_qty'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['purchase'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['purchase_return'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['receive'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['payment'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['other_cr'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['other_dr'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['discount'], 2) }}</td>
                                        <td class="text-right">{{ number_format($row['due'], 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="subtotal-row">
                                    <td class="text-right"><strong>Sub Total:</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_opening, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_sales, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_sales_return, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_net_sales, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_sales_qty, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_sales_return_qty, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_purchase_qty, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_purchase_return_qty, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_purchase, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_purchase_return, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_receive, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_payment, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_other_cr, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_other_dr, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_discount, 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subtotal_due, 2) }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                
                @php
                    $grand_total_opening += $subtotal_opening;
                    $grand_total_sales += $subtotal_sales;
                    $grand_total_sales_return += $subtotal_sales_return;
                    $grand_total_net_sales += $subtotal_net_sales;
                    $grand_total_sales_qty += $subtotal_sales_qty;
                    $grand_total_sales_return_qty += $subtotal_sales_return_qty;
                    $grand_total_purchase_qty += $subtotal_purchase_qty;
                    $grand_total_purchase_return_qty += $subtotal_purchase_return_qty;
                    $grand_total_purchase += $subtotal_purchase;
                    $grand_total_purchase_return += $subtotal_purchase_return;
                    $grand_total_receive += $subtotal_receive;
                    $grand_total_payment += $subtotal_payment;
                    $grand_total_other_cr += $subtotal_other_cr;
                    $grand_total_other_dr += $subtotal_other_dr;
                    $grand_total_discount += $subtotal_discount;
                    $grand_total_due += $subtotal_due;
                @endphp
            @endforeach
            
            <!-- Grand Total -->
            <div class="table-container" style="margin-top: 15px;">
                <table>
                    <tfoot>
                        <tr class="grand-total-row">
                            <td class="text-right"><strong>Grand Total:</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_opening, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_sales, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_sales_return, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_net_sales, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_sales_qty, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_sales_return_qty, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_purchase_qty, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_purchase_return_qty, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_purchase, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_purchase_return, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_receive, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_payment, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_other_cr, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_other_dr, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_discount, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_due, 2) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @else
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>No customer data found for the selected filters.</p>
            </div>
        @endif
        
        <!-- Footer -->
        <div class="footer">
            <div class="footer-left">
            </div>
            <div class="footer-right">
                Print Date & Time: {{ date('m/d/Y h:i:s A') }}<br>
                Page 1 of 1
            </div>
        </div>
    </div>
</body>
</html>

