<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Customer Wise Sales Summary</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        .customer-section {
            margin-bottom: 30px;
            page-break-after: always;
        }
        
        .customer-section:last-child {
            page-break-after: auto;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        .customer-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
        }
        
        .customer-info-left {
            width: 50%;
        }
        
        .customer-info-right {
            width: 50%;
            text-align: right;
        }
        
        .customer-info-row {
            margin-bottom: 5px;
            font-size: 9pt;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 9pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 6px 4px;
            text-align: center;
            font-weight: 600;
            font-size: 9pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 5px 4px;
            font-size: 9pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .invoice-header-row {
            background-color: #d3d3d3 !important;
            padding: 8px;
            border: 1px solid #000;
            border-top: none;
            display: flex;
            justify-content: space-between;
            font-weight: 600;
            font-size: 9pt;
        }
        
        .summary-box {
            width: 300px;
            margin-top: 10px;
            margin-left: auto;
            margin-bottom: 15px;
            font-size: 9pt;
        }
        
        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        
        .summary-row.net-payable {
            margin-top: 10px;
            padding-top: 10px;
            border-top: 1px solid #000;
            font-weight: 600;
        }
        
        .grand-total-footer {
            background-color: #d3d3d3;
            padding: 10px;
            margin-top: 20px;
            border: 1px solid #000;
            font-size: 9pt;
            display: flex;
            justify-content: space-between;
        }
        
        .divider {
            border-top: 1px solid #000;
            margin: 10px 0;
        }
        
        @media print {
            .customer-section {
                page-break-inside: avoid;
            }
            
            .report-title {
                page-break-after: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        @if(count($transactions) > 0)
            @foreach($grouped_data as $contact_id => $customer_transactions)
                @php
                    $customer = $customer_transactions->first()->contact;
                    $customer_name = 'WALKING CUSTOMER';
                    $customer_address = '';
                    $customer_email = '';
                    
                    if (!empty($customer)) {
                        $customer_name = !empty($customer->supplier_business_name) 
                            ? $customer->supplier_business_name 
                            : ($customer->name ?? 'WALKING CUSTOMER');
                        $customer_address = $customer->address_line_1 ?? '';
                        if (!empty($customer->address_line_2)) {
                            $customer_address .= ($customer_address ? ', ' : '') . $customer->address_line_2;
                        }
                        if (!empty($customer->city)) {
                            $customer_address .= ($customer_address ? ', ' : '') . $customer->city;
                        }
                        $customer_email = $customer->email ?? '';
                    }
                @endphp
                
                <div class="customer-section">
                    <!-- Report Title -->
                    <div class="report-title">Customer Wise Sales Summary</div>
                    
                    <!-- Report Info -->
                    <div class="report-info">
                        @if(!empty($start_date) && !empty($end_date))
                            {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
                        @endif
                    </div>
                    
                    <!-- Customer Info -->
                    <div class="customer-info">
                        <div class="customer-info-left">
                            <div class="customer-info-row"><strong>Name :</strong> {{ $customer_name }}</div>
                            <div class="customer-info-row"><strong>Address :</strong> {{ $customer_address }}</div>
                        </div>
                        <div class="customer-info-right">
                            <div class="customer-info-row"><strong>Email :</strong> {{ $customer_email }}</div>
                        </div>
                    </div>
                    
                    <div class="divider"></div>
                    
                    <!-- Product Table Header -->
                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Product Caption</th>
                                    <th>Qty</th>
                                    <th>Unit Price</th>
                                    <th>Discount</th>
                                    <th>Net Unit Price</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    
                    <div class="divider"></div>
                    
                    @foreach($customer_transactions as $transaction)
                        @php
                            $total_qty = $transaction->sell_lines->sum(function($line) {
                                return $line->quantity - $line->quantity_returned;
                            });
                            
                            $total_amount = $transaction->total_before_tax ?? 0;
                            $vat = $transaction->tax_amount ?? 0;
                            $discount = $transaction->discount_amount ?? 0;
                            $service_charge = ($transaction->shipping_charges ?? 0) + ($transaction->additional_expense_value_1 ?? 0) + ($transaction->additional_expense_value_2 ?? 0);
                            $net_payable = $transaction->final_total ?? 0;
                        @endphp
                        
                        <!-- Invoice Details Row -->
                        <div class="invoice-header-row">
                            <div><strong>Invoice No.</strong> {{ $transaction->invoice_no }}</div>
                            <div><strong>Ref No.</strong> {{ $transaction->ref_no ?? '' }}</div>
                            <div><strong>Date :</strong> {{ $util->format_date($transaction->transaction_date, false) }}</div>
                        </div>
                        
                        <!-- Product Lines -->
                        <div class="table-container">
                            <table>
                                <tbody>
                                    @foreach($transaction->sell_lines as $line)
                                        @php
                                            $qty = $line->quantity - $line->quantity_returned;
                                            $product_name = $line->product->name ?? 'N/A';
                                            if ($line->product && $line->product->type == 'variable' && $line->variations) {
                                                $variation_name = $line->variations->name ?? '';
                                                $product_variation_name = $line->variations->product_variation->name ?? '';
                                                if ($variation_name || $product_variation_name) {
                                                    $product_name .= ' - ' . ($product_variation_name ? $product_variation_name . ' - ' : '') . $variation_name;
                                                }
                                            }
                                            $unit_price = $line->unit_price_before_discount ?? $line->unit_price_inc_tax ?? 0;
                                            $line_discount = method_exists($line, 'get_discount_amount') ? $line->get_discount_amount() : ($line->line_discount_amount ?? 0);
                                            $net_unit_price = $line->unit_price_inc_tax ?? 0;
                                            $line_amount = $qty * $net_unit_price;
                                        @endphp
                                        <tr>
                                            <td>{{ $product_name }}</td>
                                            <td class="text-right">{{ number_format($qty, 2) }}</td>
                                            <td class="text-right">{{ number_format($unit_price, 2) }}</td>
                                            <td class="text-right">{{ number_format($line_discount, 2) }}</td>
                                            <td class="text-right">{{ number_format($net_unit_price, 2) }}</td>
                                            <td class="text-right">{{ number_format($line_amount, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Summary Section -->
                        <div class="summary-box">
                            <div class="summary-row">
                                <strong>Total Amount</strong>
                                <span>{{ number_format($total_amount, 2) }}</span>
                            </div>
                            <div class="summary-row">
                                <strong>VAT</strong>
                                <span>{{ number_format($vat, 2) }}</span>
                            </div>
                            <div class="summary-row">
                                <strong>Less Discount</strong>
                                <span>{{ number_format($discount, 2) }}</span>
                            </div>
                            <div class="summary-row">
                                <strong>Service Charge</strong>
                                <span>{{ number_format($service_charge, 2) }}</span>
                            </div>
                            <div class="summary-row net-payable">
                                <strong>Net Payable Amount</strong>
                                <span>{{ number_format($net_payable, 2) }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endforeach
            
            <!-- Grand Totals Footer -->
            <div class="grand-total-footer">
                <div>
                    <strong>Total VAT:</strong> {{ number_format($grand_total_vat, 2) }} | 
                    <strong>Total AIT:</strong> {{ number_format($grand_total_ait, 2) }} | 
                    <strong>Total Discount:</strong> {{ number_format($grand_total_discount, 2) }} | 
                    <strong>Total Service Charge:</strong> {{ number_format($grand_total_service_charge, 2) }}
                </div>
                <div>
                    <strong>Total:</strong> {{ number_format($grand_total, 2) }}
                </div>
            </div>
        @else
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>No sales data found for the selected filters.</p>
            </div>
        @endif
    </div>
</body>
</html>


