<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Customer Wise Net Product Sales</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 11pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 700;
            margin-bottom: 6px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #000;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #000;
        }
        
        .report-title {
            font-size: 16pt;
            font-weight: 700;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #000;
            letter-spacing: 1px;
        }
        
        .report-info {
            font-size: 11pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 600;
            color: #000;
        }
        
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 11pt;
            page-break-inside: auto;
            border: 1px solid #000;
        }
        
        thead {
            display: table-header-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #fff !important;
            color: #000 !important;
            border: 1px solid #000;
            padding: 8px 6px;
            text-align: center;
            font-weight: 700;
            font-size: 12pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
            font-family: 'Times New Roman', Times, serif;
        }
        
        table thead th:nth-child(1) {
            text-align: center;
        }
        
        table thead th:nth-child(2) {
            text-align: left;
        }
        
        table thead th:nth-child(3),
        table thead th:nth-child(4),
        table thead th:nth-child(5),
        table thead th:nth-child(6),
        table thead th:nth-child(7),
        table thead th:nth-child(8),
        table thead th:nth-child(9),
        table thead th:nth-child(10) {
            text-align: right;
        }
        
        table tbody td {
            border: 1px solid #000;
            padding: 6px 5px;
            font-size: 11pt;
            text-align: left;
            vertical-align: middle;
            color: #000;
            font-family: 'Times New Roman', Times, serif;
        }
        
        /* SL column - center aligned */
        table tbody td:nth-child(1) {
            text-align: center;
        }
        
        /* Product Description - left aligned */
        table tbody td:nth-child(2) {
            text-align: left;
        }
        
        /* All numerical columns - right aligned */
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7),
        table tbody td:nth-child(8),
        table tbody td:nth-child(9),
        table tbody td:nth-child(10) {
            text-align: right;
            font-family: 'Times New Roman', Times, serif;
        }
        
        .customer-header-row {
            background-color: #fff !important;
            font-weight: 700;
            font-size: 12pt;
        }
        
        .customer-header-row td {
            border: 1px solid #000;
            padding: 7px 6px;
            text-align: left;
            font-family: 'Times New Roman', Times, serif;
        }
        
        .customer-subtotal-row {
            background-color: #fff !important;
            font-weight: 700;
            font-size: 12pt;
        }
        
        .customer-subtotal-row td {
            border: 1px solid #000;
            padding: 7px 6px;
            font-family: 'Times New Roman', Times, serif;
        }
        
        .customer-subtotal-row td:first-child {
            text-align: center;
        }
        
        .customer-subtotal-row td:nth-child(2) {
            text-align: left;
        }
        
        .customer-subtotal-row td:nth-child(3),
        .customer-subtotal-row td:nth-child(4),
        .customer-subtotal-row td:nth-child(5),
        .customer-subtotal-row td:nth-child(6),
        .customer-subtotal-row td:nth-child(7),
        .customer-subtotal-row td:nth-child(8),
        .customer-subtotal-row td:nth-child(9),
        .customer-subtotal-row td:nth-child(10) {
            text-align: right;
            font-family: 'Times New Roman', Times, serif;
        }
        
        .grand-total-row {
            background-color: #fff !important;
            font-weight: 700;
            font-size: 14pt;
        }
        
        .grand-total-row td {
            border-top: 3px double #000;
            border-bottom: 3px double #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            padding: 9px 6px;
            font-family: 'Times New Roman', Times, serif;
        }
        
        .grand-total-row td:first-child {
            text-align: center;
        }
        
        .grand-total-row td:nth-child(2) {
            text-align: left;
        }
        
        .grand-total-row td:nth-child(3),
        .grand-total-row td:nth-child(4),
        .grand-total-row td:nth-child(5),
        .grand-total-row td:nth-child(6),
        .grand-total-row td:nth-child(7),
        .grand-total-row td:nth-child(8),
        .grand-total-row td:nth-child(9),
        .grand-total-row td:nth-child(10) {
            text-align: right;
            font-family: 'Times New Roman', Times, serif;
        }
        
        @media print {
            .customer-section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ __('lang_v1.mobile') }}: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ __('lang_v1.alternate_number') }}: {{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ __('business.email') }}: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Customer Wise Net Sales({{ $is_single_customer ? strtoupper($customer_name) : 'ALL' }})</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if($start_date && $end_date)
                @php
                    $start_formatted = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                    $end_formatted = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                @endphp
                {{ $start_formatted }} To {{ $end_formatted }}
            @endif
        </div>

        <!-- Table Container -->
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>SL</th>
                        <th>Product Description</th>
                        <th>Sales Qty</th>
                        <th>Unit Price</th>
                        <th>Sales Amount</th>
                        <th>Return Qty</th>
                        <th>Unit Price (Return)</th>
                        <th>Return Amount</th>
                        <th>Net Qty</th>
                        <th>Net Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $sl = 1;
                    @endphp
                    @foreach($customers_data as $customer_id => $customer_data)
                        <!-- Customer Header -->
                        <tr class="customer-header-row">
                            <td colspan="10"><strong>{{ $customer_data['customer_name'] }}</strong></td>
                        </tr>
                        
                        @foreach($customer_data['products'] as $product)
                            <tr>
                                <td>{{ $product['sl'] }}</td>
                                <td>{{ $product['product_description'] }}</td>
                                <td>{{ $util->num_f($product['sale_qty'], true) }}</td>
                                <td>{{ $util->num_f($product['unit_price'], true) }}</td>
                                <td>{{ $util->num_f($product['sales_amount'], true) }}</td>
                                <td>{{ $util->num_f($product['return_qty'], true) }}</td>
                                <td>{{ $util->num_f($product['return_price'], true) }}</td>
                                <td>{{ $util->num_f($product['return_amount'], true) }}</td>
                                <td>{{ $util->num_f($product['net_qty'], true) }}</td>
                                <td>{{ $util->num_f($product['net_amount'], true) }}</td>
                            </tr>
                        @endforeach
                        
                        <!-- Customer Sub Total -->
                        <tr class="customer-subtotal-row">
                            <td colspan="2"><strong>Sub Total</strong></td>
                            <td><strong>{{ $util->num_f($customer_data['total_sale_qty'], true) }}</strong></td>
                            <td></td>
                            <td><strong>{{ $util->num_f($customer_data['total_sales_amount'], true) }}</strong></td>
                            <td><strong>{{ $util->num_f($customer_data['total_return_qty'], true) }}</strong></td>
                            <td></td>
                            <td><strong>{{ $util->num_f($customer_data['total_return_amount'], true) }}</strong></td>
                            <td><strong>{{ $util->num_f($customer_data['total_net_qty'], true) }}</strong></td>
                            <td><strong>{{ $util->num_f($customer_data['total_net_amount'], true) }}</strong></td>
                        </tr>
                    @endforeach
                    
                    <!-- Grand Total -->
                    <tr class="grand-total-row">
                        <td colspan="2"><strong>Grand Total</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_sale_qty, true) }}</strong></td>
                        <td></td>
                        <td><strong>{{ $util->num_f($grand_total_sales_amount, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_return_qty, true) }}</strong></td>
                        <td></td>
                        <td><strong>{{ $util->num_f($grand_total_return_amount, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_net_qty, true) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_net_amount, true) }}</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
