@extends('layouts.app')
@section('title', __('businessmanagement::lang.sales_register'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header" style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); padding: 30px 20px; margin: -20px -15px 30px -15px; border-radius: 0;">
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-md-12 text-center">
                <h1 style="color: #fff; font-size: 32px; font-weight: 700; margin: 0; display: flex; align-items: center; justify-content: center; gap: 15px;">
                    <i class="fa fa-chart-line" style="font-size: 36px;"></i>
                    Sales Register Reports
                </h1>
                <p style="color: rgba(255,255,255,0.9); font-size: 16px; margin: 10px 0 0 0;">
                    Comprehensive sales tracking and analysis reports
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Date wise Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-calendar-alt" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date wise Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Detailed sales analysis grouped by date with customer and location filtering options
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date grouping</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Customer filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSales']) }}" 
                           class="btn btn-danger" 
                           style="width: 100%; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product wise Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-cubes" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product wise Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-based sales analysis with flexible filtering by product, category, date, and location
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSales']) }}" 
                           class="btn btn-info" 
                           style="width: 100%; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer wise Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-users" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer wise Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Customer-based sales analysis with invoice and date grouping, showing product details and totals
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Invoice Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSales']) }}" 
                           class="btn btn-success" 
                           style="width: 100%; background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date wise Net Product Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-chart-pie" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date wise Net Product Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Net product sales analysis grouped by category and brand with sales and returns comparison
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Net Sales</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseNetProductSales']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Wise Net Product Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-users-cog" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer Wise Net Product Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Customer-based net sales analysis with sales, returns, and net calculations grouped by customer
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Net Sales</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseNetProductSales']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date Wise Gross Profit Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-chart-line" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date Wise Gross Profit</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Detailed gross profit analysis per invoice with cost, profit, and profit percentage calculations
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Gross Profit</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Profit %</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Cost Analysis</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseGrossProfit']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #20c997 0%, #17a2b8 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Wise Gross Profit Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-box" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product Wise Gross Profit</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-based gross profit analysis grouped by category with cost, profit, and profit percentage
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category Wise</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseGrossProfit']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date Wise Sales Return Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-undo" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date wise Sales Return</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Detailed sales return analysis grouped by date with customer, invoice, and location filtering options
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Location Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesReturn']) }}" 
                           class="btn btn-danger" 
                           style="width: 100%; background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Wise Sales Return Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #9b59b6 0%, #8e44ad 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-cube" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product wise Sales Return</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-based sales return analysis with date, category, and location filtering options
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesReturn']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #9b59b6 0%, #8e44ad 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Wise Sales Return Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #3498db 0%, #2980b9 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-user-friends" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer wise Sales Return</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Customer-based sales return analysis grouped by customer and date with product details and totals
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesReturn']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #3498db 0%, #2980b9 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Explicit Product Wise Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #16a085 0%, #138d75 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-list-alt" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Explicit Product wise Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Detailed product-based sales analysis grouped by product and date with purchase invoice tracking
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'explicitProductWiseSales']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #16a085 0%, #138d75 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Wise Statement Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #e67e22 0%, #d35400 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-file-invoice-dollar" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer wise Statement</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Comprehensive customer account statement with opening balance, sales, payments, quantities, and due amounts
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseStatement']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #e67e22 0%, #d35400 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Group Wise Net Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #27ae60 0%, #229954 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-layer-group" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product Group wise Net Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Net sales analysis grouped by product brand with sales quantities, returns, and net amounts
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productGroupWiseNetSales']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #27ae60 0%, #229954 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Wise Sales Summary Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #8e44ad 0%, #7d3c98 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-list-ul" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product Wise Sales Summary</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Comprehensive sales summary listing all products sold with invoice details, customer, quantities, prices, discounts, and amounts
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Location Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesSummary']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #8e44ad 0%, #7d3c98 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date Wise Sales Summary Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-calendar-check" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date wise Sales Summary</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Invoice-wise sales summary grouped by date with complete invoice details, product lines, charges summary, and narration
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Invoice Wise</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesSummary']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Group Wise Net Sales (MPO) Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #2ecc71 0%, #27ae60 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-tags" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product Group Wise Net Sales (MPO)</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Category-based net sales analysis with separate unit prices for sales and returns, including discount and net summary
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Location Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productGroupWiseNetSalesMPO']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #2ecc71 0%, #27ae60 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Wise Sales Summary Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #3498db 0%, #2980b9 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-user-tie" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer Wise Sales Summary</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Customer-wise invoice summary with product details, charges breakdown, and net payable amounts grouped by customer
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesSummary']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #3498db 0%, #2980b9 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Wise Invoice Status Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #9b59b6 0%, #8e44ad 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-file-invoice" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer Wise Invoice Status</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Invoice status report with ageing information showing outstanding invoices, received amounts, and age in days grouped by customer
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Ageing</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseInvoiceStatus']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #9b59b6 0%, #8e44ad 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Wise Sales Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-cubes" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product Wise Sales</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-wise sales report showing invoice details, customer names, purchase invoices, quantities, unit prices, and amounts grouped by product
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSales']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Date Wise Sales Invoice Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #16a085 0%, #138d75 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-file-invoice-dollar" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Date Wise Sales Invoice</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Complete sales invoices grouped by date with all invoice details, customer information, product details, and summary totals
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Location</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesInvoice']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #16a085 0%, #138d75 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Wise Gross Profit Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-chart-line" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer Wise Gross Profit</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Customer-wise gross profit analysis showing sales amounts, costs, gross profits, and profit percentages grouped by customer and invoice
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">All Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Single Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseGrossProfit']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Wise Net Profit Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #9b59b6 0%, #8e44ad 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-money-bill-wave" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product Wise Net Profit</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-wise net profit analysis showing sales, costs, profits, returns, and net total profit grouped by category, brand, and product
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseNetProfit']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #9b59b6 0%, #8e44ad 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Customer wise Sales with Serial Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-barcode" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Customer wise Sales with Serial</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Customer-wise sales report with product serial numbers, grouped by customer and invoice with detailed breakdown.
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Customer</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Serial Numbers</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesWithSerial']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Product Wise Sales with Serial Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #fd7e14 0%, #e8650e 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-barcode" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Product Wise Sales with Serial</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Product-wise sales report with serial numbers, grouped by product with invoice details and customer information.
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Category</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Product</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Serial Numbers</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseSalesWithSerial']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #fd7e14 0%, #e8650e 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Daily Sales Details Report Card -->
            <div class="col-md-4">
                <div class="card" style="border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.1); border-radius: 8px; margin-bottom: 30px; transition: transform 0.3s ease, box-shadow 0.3s ease; height: 100%;">
                    <div class="card-body" style="padding: 25px;">
                        <div style="display: flex; align-items: center; margin-bottom: 20px;">
                            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #20c997 0%, #17a085 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                                <i class="fa fa-calendar-day" style="color: #fff; font-size: 28px;"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 20px; font-weight: 600; color: #2c3e50;">Daily Sales Details</h3>
                            </div>
                        </div>
                        <p style="color: #6c757d; font-size: 14px; line-height: 1.6; margin-bottom: 20px;">
                            Comprehensive daily sales report with customer details, product information, balances, and payment tracking.
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 20px;">
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Date Filter</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Balance Tracking</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Payment Details</span>
                            <span style="background: #f8f9fa; color: #495057; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 500;">Print Preview</span>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dailySalesDetails']) }}" 
                           class="btn" 
                           style="width: 100%; background: linear-gradient(135deg, #20c997 0%, #17a085 100%); border: none; padding: 12px; font-weight: 600; border-radius: 6px; display: flex; align-items: center; justify-content: center; gap: 8px; color: #fff;">
                            <i class="fa fa-chart-bar"></i> View Report
                        </a>
                        <div style="margin-top: 15px; display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; color: #28a745; font-size: 13px; font-weight: 500;">
                                <i class="fa fa-check-circle" style="margin-right: 5px;"></i> Available
                            </div>
                            <div style="color: #dc3545; font-size: 13px; font-weight: 500;">
                                Report Version 1.0.0
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.15) !important;
    }
</style>

@endsection

