@extends('layouts.app')
@section('title', 'Date Wise Sales Invoice')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Date Wise Sales Invoice</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesInvoice']), 'method' => 'get', 'id' => 'date_wise_sales_invoice_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_wise_sales_invoice_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'dateWiseSalesInvoice']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printDateWiseSalesInvoice'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($transactions) > 0)
                        @foreach($grouped_data as $date => $date_transactions)
                            <h3 style="margin-top: 20px; margin-bottom: 10px; color: #2c3e50;">
                                {{ $util->format_date($date, false) }}
                            </h3>
                            @foreach($date_transactions as $transaction)
                                <div style="border: 1px solid #ddd; margin-bottom: 20px; padding: 15px; background: #fff;">
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 15px;">
                                        <div>
                                            <strong>Invoice No:</strong> {{ $transaction->invoice_no }}<br>
                                            <strong>Date & Time:</strong> {{ $util->format_date($transaction->transaction_date, true) }}<br>
                                            <strong>Order No:</strong> {{ $transaction->ref_no ?? '' }}<br>
                                            <strong>Prepared By:</strong> {{ $transaction->sales_person->user_full_name ?? '' }}
                                        </div>
                                        <div style="text-align: right;">
                                            <strong>Customer:</strong> 
                                            @if(!empty($transaction->contact))
                                                {{ !empty($transaction->contact->supplier_business_name) ? $transaction->contact->supplier_business_name : ($transaction->contact->name ?? 'WALKING CUSTOMER') }}
                                            @else
                                                WALKING CUSTOMER
                                            @endif
                                            <br>
                                            <strong>Address:</strong> {{ $transaction->contact->address ?? '' }}<br>
                                            <strong>Mobile:</strong> {{ $transaction->contact->mobile ?? '' }}<br>
                                            <strong>SR Name:</strong> {{ $transaction->contact->custom_field1 ?? '' }}
                                        </div>
                                    </div>
                                    <table class="table table-bordered" style="font-size: 12px; margin-bottom: 10px;">
                                        <thead>
                                            <tr>
                                                <th>SL</th>
                                                <th>Product Code</th>
                                                <th>Product Description</th>
                                                <th style="text-align: right;">Qty</th>
                                                <th style="text-align: right;">Unit Price</th>
                                                <th style="text-align: right;">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($transaction->sell_lines as $index => $line)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>
                                                        @if($line->product)
                                                            {{ $line->product->sku ?? ($line->variations->sub_sku ?? '') }}
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($line->product)
                                                            @if($line->product->type == 'variable' && $line->variations)
                                                                {{ $line->product->name }} - {{ $line->variations->name }}
                                                            @else
                                                                {{ $line->product->name }}
                                                            @endif
                                                        @else
                                                            N/A
                                                        @endif
                                                    </td>
                                                    <td style="text-align: right;">{{ number_format($line->quantity - $line->quantity_returned, 2) }}</td>
                                                    <td style="text-align: right;">
                                                        <span class="display_currency" data-currency_symbol="true">{{ $line->unit_price_inc_tax }}</span>
                                                    </td>
                                                    <td style="text-align: right;">
                                                        <span class="display_currency" data-currency_symbol="true">{{ ($line->quantity - $line->quantity_returned) * $line->unit_price_inc_tax }}</span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="3" style="text-align: right;"><strong>Total Qty:</strong></td>
                                                <td style="text-align: right;">
                                                    <strong>{{ number_format($transaction->sell_lines->sum(function($l) { return $l->quantity - $l->quantity_returned; }), 2) }}</strong>
                                                </td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td colspan="3" style="text-align: right;"><strong>Taka in word:</strong></td>
                                                <td colspan="3">
                                                    <strong>{{ ucwords($util->numToWord($transaction->final_total, 'en', 'international')) }} Only</strong>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="3" style="text-align: right;"><strong>Total Amount:</strong></td>
                                                <td colspan="3" style="text-align: right;">
                                                    <strong><span class="display_currency" data-currency_symbol="true">{{ $transaction->total_before_tax }}</span></strong>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="3" style="text-align: right;"><strong>Less Discount:</strong></td>
                                                <td colspan="3" style="text-align: right;">
                                                    <strong><span class="display_currency" data-currency_symbol="true">{{ $transaction->discount_amount ?? 0 }}</span></strong>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="3" style="text-align: right;"><strong>Add Extra Charges:</strong></td>
                                                <td colspan="3" style="text-align: right;">
                                                    <strong><span class="display_currency" data-currency_symbol="true">{{ ($transaction->shipping_charges ?? 0) + ($transaction->packing_charge ?? 0) }}</span></strong>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #f5f5f5;">
                                                <td colspan="3" style="text-align: right;"><strong>Net Payable Amount:</strong></td>
                                                <td colspan="3" style="text-align: right;">
                                                    <strong><span class="display_currency" data-currency_symbol="true">{{ $transaction->final_total }}</span></strong>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            @endforeach
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No invoices found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#date_wise_sales_invoice_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        } else if (end_date) {
            $('#date_wise_sales_invoice_date_range').val(
                moment(end_date).format(moment_date_format)
            );
        }
        
        $('#date_wise_sales_invoice_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#date_wise_sales_invoice_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#date_wise_sales_invoice_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Reload when date range changes
        $('#date_wise_sales_invoice_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection

