@extends('layouts.app')
@section('title', 'Customer wise Sales with Serial')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Customer wise Sales with Serial</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesWithSerial']), 'method' => 'get', 'id' => 'customer_wise_sales_with_serial_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @php
                            $date_range_value = '';
                            if (!empty($start_date) && !empty($end_date)) {
                                $date_range_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y') . ' ~ ' . \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } elseif (!empty(request()->date_range)) {
                                $date_range_value = request()->date_range;
                            }
                        @endphp
                        {!! Form::text('date_range', $date_range_value , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'customer_wise_sales_with_serial_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', ['all' => __('lang_v1.all_customers'), 'single' => __('lang_v1.single_customer')], !empty($customer_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="customer_select_wrapper" style="display: {{ !empty($customer_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseSalesWithSerial']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseSalesWithSerial'], ['start_date' => $start_date, 'end_date' => $end_date, 'customer_id' => $customer_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($customers_data) > 0)
                        @foreach($customers_data as $contact_id => $customer_data)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; font-weight: bold; color: #2c3e50;">{{ $customer_data['customer_name'] }}</h4>
                            @foreach($customer_data['transactions'] as $transaction_id => $transaction_data)
                                <h5 style="margin-top: 15px; margin-bottom: 10px; font-weight: 600; color: #34495e; padding-left: 10px;">
                                    Date: {{ $util->format_date($transaction_data['transaction_date'], false) }} | Invoice No: {{ $transaction_data['invoice_no'] }}
                                </h5>
                                <table class="table table-bordered table-striped" style="font-size: 12px;">
                                    <thead>
                                        <tr>
                                            <th>Invoice No</th>
                                            <th>Product Description</th>
                                            <th style="text-align: right;">Qty</th>
                                            <th style="text-align: right;">Unit Price</th>
                                            <th style="text-align: right;">Discount</th>
                                            <th style="text-align: right;">Net Unit Price</th>
                                            <th style="text-align: right;">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transaction_data['products'] as $product)
                                            <tr>
                                                <td>{{ $transaction_data['invoice_no'] }}</td>
                                                <td>{{ $product['product_description'] }}</td>
                                                <td style="text-align: right;">{{ number_format($product['qty'], 2) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['unit_price'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['discount'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['net_unit_price'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['amount'], true) }}</td>
                                            </tr>
                                        @endforeach
                                        <tr style="background-color: #f5f5f5; font-weight: bold;">
                                            <td colspan="2"><strong>Invoice wise Total Amount:</strong></td>
                                            <td style="text-align: right;">{{ number_format($transaction_data['invoice_total_qty'], 2) }}</td>
                                            <td style="text-align: right;">-</td>
                                            <td style="text-align: right;">-</td>
                                            <td style="text-align: right;">-</td>
                                            <td style="text-align: right;">{{ $util->num_f($transaction_data['invoice_total_amount'], true) }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            @endforeach
                            <table class="table table-bordered" style="font-size: 12px; margin-top: 10px;">
                                <tbody>
                                    <tr style="background-color: #e8e8e8; font-weight: bold;">
                                        <td colspan="2"><strong>Customer wise Total Amount:</strong></td>
                                        <td style="text-align: right;">{{ number_format($customer_data['customer_total_qty'], 2) }}</td>
                                        <td style="text-align: right;">-</td>
                                        <td style="text-align: right;">-</td>
                                        <td style="text-align: right;">-</td>
                                        <td style="text-align: right;">{{ $util->num_f($customer_data['customer_total_amount'], true) }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        var date_range_val = '{{ $date_range_value ?? "" }}';

        if (date_range_val) {
            $('#customer_wise_sales_with_serial_date_range').val(date_range_val);
        } else if (start_date && end_date) {
            $('#customer_wise_sales_with_serial_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        }
        
        $('#customer_wise_sales_with_serial_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#customer_wise_sales_with_serial_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#customer_wise_sales_with_serial_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Reload when date range changes
        $('#customer_wise_sales_with_serial_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val(null).trigger('change');
            }
        });

        // Ensure hidden fields are set before form submission
        $('#customer_wise_sales_with_serial_filter_form').on('submit', function(e) {
            var date_range_val = $('#customer_wise_sales_with_serial_date_range').val();
            if (date_range_val) {
                var dates = date_range_val.split(' ~ ');
                if (dates.length == 2) {
                    var start = moment(dates[0].trim(), moment_date_format);
                    var end = moment(dates[1].trim(), moment_date_format);
                    if (start.isValid() && end.isValid()) {
                        $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                        $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
                    }
                }
            } else {
                $('input[name="start_date"]').val('');
                $('input[name="end_date"]').val('');
            }
        });
    });
</script>
@endsection

