@extends('layouts.app')
@section('title', 'Supplier wise Purchase (WOP)')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Supplier wise Purchase (WOP)</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'supplier_wise_purchase_wop_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('report_type', 'Report Type:') !!}
                        {!! Form::select('report_type', ['date_wise' => 'Date wise'], 'date_wise', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'report_type']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('supplier_filter', 'Supplier Filter:') !!}
                        {!! Form::select('supplier_filter', ['all' => 'All Supplier', 'single' => 'Single Supplier'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'supplier_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="supplier_select_container">
                    <div class="form-group">
                        {!! Form::label('supplier_id',  __('purchase.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_suppliers'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'supplier_wise_purchase_wop_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="supplier_wise_purchase_wop_table">
                        <thead>
                            <tr>
                                <th>@lang('sale.date')</th>
                                <th>@lang('purchase.invoice_no')</th>
                                <th>@lang('purchase.ref_no')</th>
                                <th>@lang('purchase.supplier')</th>
                                <th>@lang('sale.product')</th>
                                <th>@lang('sale.qty')</th>
                                <th>@lang('lang_v1.unit')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#supplier_wise_purchase_wop_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#supplier_wise_purchase_wop_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                checkPrintButton();
            }
        );

        $('#supplier_wise_purchase_wop_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            checkPrintButton();
        });

        // Show/hide supplier select based on filter
        $('#supplier_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#supplier_select_container').show();
            } else {
                $('#supplier_select_container').hide();
                $('#supplier_id').val('').trigger('change');
            }
        });

        // Initial state
        if ($('#supplier_filter').val() == 'all') {
            $('#supplier_select_container').hide();
        }

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#supplier_wise_purchase_wop_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Print button click
        $('#print_report').on('click', function() {
            var supplier_id = '';
            if ($('#supplier_filter').val() == 'single') {
                supplier_id = $('#supplier_id').val() || '';
            }
            var location_id = $('#location_id').val() || '';
            var start_date = '';
            var end_date = '';

            if ($('#supplier_wise_purchase_wop_date_range').val()) {
                start_date = $('#supplier_wise_purchase_wop_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#supplier_wise_purchase_wop_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }

            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "printSupplierWisePurchaseWOP"]) }}';
            url += '?supplier_id=' + supplier_id;
            url += '&location_id=' + location_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;

            window.open(url, '_blank');
        });

        // Initial check
        checkPrintButton();

        // Initialize DataTable
        var supplier_wise_purchase_wop_table = $('#supplier_wise_purchase_wop_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "supplierWisePurchaseWOP"]) }}',
                data: function(d) {
                    d.supplier_id = '';
                    if ($('#supplier_filter').val() == 'single') {
                        d.supplier_id = $('#supplier_id').val() || '';
                    }
                    d.location_id = $('#location_id').val();
                    if ($('#supplier_wise_purchase_wop_date_range').val()) {
                        var start = $('#supplier_wise_purchase_wop_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#supplier_wise_purchase_wop_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'ref_no', name: 'ref_no' },
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'product_description', name: 'product_description' },
                { data: 'quantity', name: 'quantity' },
                { data: 'unit_name', name: 'unit_name' },
            ],
        });

        // Check on filter changes
        $('#apply_filters').on('click', function() {
            supplier_wise_purchase_wop_table.ajax.reload();
            setTimeout(checkPrintButton, 500);
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#report_type').val('date_wise').trigger('change');
            $('#supplier_filter').val('all').trigger('change');
            $('#supplier_id').val('').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#supplier_wise_purchase_wop_date_range').val('');
            $('#print_report').hide();
            supplier_wise_purchase_wop_table.ajax.reload();
        });
    });
</script>
@endsection

