@extends('layouts.app')
@section('title', 'Supplier wise Purchase Return')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Supplier wise Purchase Return</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => '#', 'method' => 'get', 'id' => 'supplier_wise_purchase_return_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'supplier_wise_purchase_return_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('supplier_filter', 'Supplier Filter:') !!}
                        {!! Form::select('supplier_filter', ['all' => 'All Supplier', 'single' => 'Single Supplier'], 'all', ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'supplier_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="supplier_select_container" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('supplier_id',  __('purchase.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_supplier'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="supplier_wise_purchase_return_table">
                        <thead>
                            <tr>
                                <th>@lang('purchase.supplier')</th>
                                <th>@lang('sale.date')</th>
                                <th>@lang('purchase.invoice_no')</th>
                                <th>@lang('sale.product')</th>
                                <th>@lang('sale.qty')</th>
                                <th>Unit Price</th>
                                <th>Discount</th>
                                <th>Net Unit Price</th>
                                <th>@lang('sale.total')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#supplier_wise_purchase_return_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#supplier_wise_purchase_return_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }
        );

        // Show/hide supplier select based on filter
        $('#supplier_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#supplier_select_container').show();
            } else {
                $('#supplier_select_container').hide();
                $('#supplier_id').val(null).trigger('change');
            }
        });

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#supplier_wise_purchase_return_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Initialize DataTable
        var supplier_wise_purchase_return_table = $('#supplier_wise_purchase_return_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "supplierWisePurchaseReturn"]) }}',
                data: function(d) {
                    d.supplier_filter = $('#supplier_filter').val();
                    d.supplier_id = '';
                    if ($('#supplier_filter').val() == 'single') {
                        d.supplier_id = $('#supplier_id').val() || '';
                    }
                    d.location_id = $('#location_id').val();
                    if ($('#supplier_wise_purchase_return_date_range').val()) {
                        var start = $('#supplier_wise_purchase_return_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#supplier_wise_purchase_return_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'supplier_name', name: 'supplier_name' },
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'product_name', name: 'product_name' },
                { data: 'quantity', name: 'quantity' },
                { data: 'unit_price', name: 'unit_price' },
                { data: 'discount', name: 'discount' },
                { data: 'net_unit_price', name: 'net_unit_price' },
                { data: 'amount', name: 'amount' },
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#supplier_wise_purchase_return_table'));
            },
        });

        // Apply filters
        $('#apply_filters').on('click', function() {
            supplier_wise_purchase_return_table.ajax.reload();
            setTimeout(checkPrintButton, 500);
        });

        // Reset filters
        $('#reset_filters').on('click', function() {
            $('#supplier_filter').val('all').trigger('change');
            $('#supplier_id').val('').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#supplier_wise_purchase_return_date_range').val('');
            $('#print_report').hide();
            supplier_wise_purchase_return_table.ajax.reload();
        });

        // Print report
        $('#print_report').on('click', function() {
            var date_range = $('#supplier_wise_purchase_return_date_range').val();
            var supplier_filter = $('#supplier_filter').val();
            var supplier_id = $('#supplier_id').val();
            var location_id = $('#location_id').val();

            var url = "{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'printSupplierWisePurchaseReturn']) }}";
            url += '?date_range=' + encodeURIComponent(date_range);
            url += '&supplier_filter=' + supplier_filter;
            if (supplier_id) {
                url += '&supplier_id=' + supplier_id;
            }
            if (location_id) {
                url += '&location_id=' + location_id;
            }

            window.open(url, '_blank');
        });

        // Update date range picker callback
        $('#supplier_wise_purchase_return_date_range').on('apply.daterangepicker', function(ev, picker) {
            checkPrintButton();
        });

        $('#supplier_wise_purchase_return_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            checkPrintButton();
        });

        // Initial check
        checkPrintButton();
    });
</script>
@endsection

