<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Purchased Products Movement with Profit</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
            text-decoration: underline;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Supplier Section */
        .supplier-section {
            margin-bottom: 30px;
            page-break-inside: avoid;
        }
        
        .supplier-header {
            font-size: 13pt;
            font-weight: 600;
            margin-bottom: 12px;
            color: #1a1a1a;
            padding: 8px;
            background-color: #f5f7fa;
            border-left: 4px solid #2c3e50;
        }
        
        /* Product Model Section */
        .product-model-section {
            margin-bottom: 20px;
            margin-left: 15px;
        }
        
        .product-model-header {
            font-size: 11pt;
            font-weight: 600;
            margin-bottom: 8px;
            color: #2c3e50;
            padding: 6px;
            background-color: #e9ecef;
            border-left: 3px solid #17a2b8;
        }
        
        .product-info {
            font-size: 10pt;
            margin-bottom: 8px;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 15px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 9.5pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 7px 5px;
            text-align: center;
            font-weight: 600;
            font-size: 9.5pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 6px 5px;
            font-size: 9.5pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td:nth-child(1) {
            text-align: left;
        }
        
        table tbody td:nth-child(2),
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        /* Total Profit Row */
        .total-profit-row {
            background-color: #f8f9fa !important;
            font-weight: 600;
            border-top: 2px solid #2c3e50;
        }
        
        .total-profit-row td {
            border: 1px solid #ddd;
            color: #1a1a1a;
        }
        
        .total-profit-label {
            text-align: right !important;
            padding-right: 10px;
        }
        
        .total-profit-value {
            text-align: right !important;
            font-weight: 700;
        }
        
        /* Footer */
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px solid #2c3e50;
            text-align: center;
            font-size: 9pt;
            color: #6a6a6a;
        }
        
        @media print {
            .supplier-section {
                page-break-inside: avoid;
            }
            
            .product-model-section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if($logo)
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if($business->landmark)
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if($business->city || $business->state || $business->country)
                    <div class="company-address">
                        @if($business->city){{ $business->city }}, @endif
                        @if($business->state){{ $business->state }}, @endif
                        @if($business->country){{ $business->country }}@endif
                    </div>
                @endif
                @if($business->mobile)
                    <div class="company-contact">Phone: {{ $business->mobile }}</div>
                @endif
                @if($business->email)
                    <div class="company-contact">Email: {{ $business->email }}</div>
                @endif
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Purchased Products Movement with Profit</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if($start_date && $end_date)
                {{ $util->format_date($start_date, true) }} To {{ $util->format_date($end_date, true) }}
            @else
                All Time
            @endif
        </div>
        
        @if(empty($grouped_data) || count($grouped_data) == 0)
            <div style="text-align: center; padding: 40px; color: #6a6a6a; font-size: 12pt;">
                <p><strong>No data found for the selected criteria.</strong></p>
                <p>Please adjust your filters and try again.</p>
            </div>
        @else
        <!-- Supplier Sections -->
        @php
            $current_supplier = null;
        @endphp
        
        @foreach($grouped_data as $key => $group)
            @php
                $supplier_name = $group['supplier_name'];
                $is_new_supplier = ($current_supplier !== $supplier_name);
            @endphp
            
            @if($is_new_supplier)
                @if($current_supplier !== null)
                    </div>
                @endif
                <div class="supplier-section">
                    <div class="supplier-header">{{ $supplier_name ?: 'UNKNOWN SUPPLIER' }}</div>
                @php
                    $current_supplier = $supplier_name;
                @endphp
            @endif
            
            <!-- Product Model Section -->
            <div class="product-model-section">
                <div class="product-model-header">Product Model: {{ $group['product_name'] }}</div>
                
                @php
                    $first_transaction = collect($group['transactions'])->first();
                    $invoice_no = $first_transaction['invoice_no'] ?? '';
                    $date = $first_transaction['date'] ?? '';
                @endphp
                
                @if($invoice_no || $date)
                    <div class="product-info">
                        @if($invoice_no)
                            <strong>Invoice No.:</strong> {{ $invoice_no }}
                        @endif
                        @if($date)
                            <strong style="margin-left: 20px;">Date:</strong> {{ $util->format_date($date, true) }}
                        @endif
                    </div>
                @endif
                
                <!-- Transaction Table -->
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 15%;">Transaction</th>
                                <th style="width: 12%;">Qty</th>
                                <th style="width: 12%;">Unit Price</th>
                                <th style="width: 12%;">Unit Cost</th>
                                <th style="width: 13%;">Cost Amount</th>
                                <th style="width: 13%;">Amount</th>
                                <th style="width: 13%;">Profit</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $purchase_transactions = collect($group['transactions'])->where('type', 'Purchase');
                                $sales_transactions = collect($group['transactions'])->where('type', 'Sales');
                                $return_transactions = collect($group['transactions'])->where('type', 'Sales Return');
                            @endphp
                            
                            <!-- Purchase Row -->
                            @if($purchase_transactions->count() > 0)
                                @php
                                    $purchase_qty = $purchase_transactions->sum('qty');
                                    $purchase_cost = $purchase_transactions->sum('cost_amount');
                                    $purchase_amount = $purchase_transactions->sum('amount');
                                @endphp
                                <tr>
                                    <td>Purchase</td>
                                    <td>{{ number_format($purchase_qty, 2) }}</td>
                                    <td>{{ $purchase_qty > 0 ? number_format($purchase_amount / $purchase_qty, 2) : '0.00' }}</td>
                                    <td>{{ $purchase_qty > 0 ? number_format($purchase_cost / $purchase_qty, 2) : '0.00' }}</td>
                                    <td>{{ number_format($purchase_cost, 2) }}</td>
                                    <td>{{ number_format($purchase_amount, 2) }}</td>
                                    <td>0.00</td>
                                </tr>
                            @endif
                            
                            <!-- Sales Rows -->
                            @foreach($sales_transactions as $trans)
                                <tr>
                                    <td>Sales</td>
                                    <td>{{ number_format($trans['qty'], 2) }}</td>
                                    <td>{{ number_format($trans['unit_price'], 2) }}</td>
                                    <td>{{ number_format($trans['unit_cost'], 2) }}</td>
                                    <td>{{ number_format($trans['cost_amount'], 2) }}</td>
                                    <td>{{ number_format($trans['amount'], 2) }}</td>
                                    <td>{{ number_format($trans['profit'], 2) }}</td>
                                </tr>
                            @endforeach
                            
                            <!-- Sales Return Rows -->
                            @foreach($return_transactions as $trans)
                                <tr>
                                    <td>Sales Return</td>
                                    <td>{{ number_format($trans['qty'], 2) }}</td>
                                    <td>{{ number_format($trans['unit_price'], 2) }}</td>
                                    <td>{{ number_format($trans['unit_cost'], 2) }}</td>
                                    <td>{{ number_format($trans['cost_amount'], 2) }}</td>
                                    <td>{{ number_format($trans['amount'], 2) }}</td>
                                    <td>{{ number_format($trans['profit'], 2) }}</td>
                                </tr>
                            @endforeach
                            
                            
                            <!-- Stock in Hand Row -->
                            @if(isset($group['stock_in_hand']))
                                <tr>
                                    <td>Stock in Hand</td>
                                    <td>{{ number_format($group['stock_in_hand']['qty'], 2) }}</td>
                                    <td>{{ number_format($group['stock_in_hand']['unit_price'], 2) }}</td>
                                    <td>{{ number_format($group['stock_in_hand']['unit_cost'], 2) }}</td>
                                    <td>{{ number_format($group['stock_in_hand']['cost_amount'], 2) }}</td>
                                    <td>{{ number_format($group['stock_in_hand']['amount'], 2) }}</td>
                                    <td>0.00</td>
                                </tr>
                            @endif
                            
                            <!-- Total Profit Row -->
                            <tr class="total-profit-row">
                                <td colspan="6" class="total-profit-label"><strong>Total Profit:</strong></td>
                                <td class="total-profit-value">{{ number_format($group['total_profit'], 2) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        @endforeach
        
        @if($current_supplier !== null)
            </div>
        @endif
        @endif
        
        <!-- Footer -->
        <div class="footer">
            <div>Generated on: {{ date('d/m/Y H:i:s') }}</div>
        </div>
    </div>
</body>
</html>

