@extends('layouts.app')
@section('title', __('businessmanagement::lang.accounts_payable'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.accounts_payable') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'accountsPayable']), 'method' => 'get', 'id' => 'accounts_payable_filter_form' ]) !!}
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'accounts_payable_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'accounts_payable_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('supplier_filter', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_filter', [
                            'all' => __('businessmanagement::lang.all_suppliers'),
                            'single' => __('businessmanagement::lang.single_supplier')
                        ], $supplier_filter ?? 'all', ['class' => 'form-control', 'id' => 'supplier_filter']); !!}
                    </div>
                </div>
                <div class="col-md-2" id="supplier_select_wrapper" style="display: {{ ($supplier_filter ?? 'all') == 'single' ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('supplier_id', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, $supplier_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.select_supplier'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'accountsPayable']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printAccountsPayable'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'supplier_filter' => $supplier_filter ?? 'all', 'supplier_id' => $supplier_id ?? '', 'location_id' => $location_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($payable_data) > 0)
                        <table class="table table-bordered table-striped" style="font-size: 12px;">
                            <thead>
                                <tr>
                                    <th style="width: 50px; text-align: center;">SL</th>
                                    <th style="text-align: left;">Accounts Name</th>
                                    <th style="text-align: left;">Proprietor</th>
                                    <th style="text-align: left;">Address</th>
                                    <th style="text-align: left;">Mobile</th>
                                    <th style="text-align: right;">Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $serial = 1;
                                @endphp
                                @foreach($payable_data as $supplier)
                                    <tr>
                                        <td style="text-align: center;">{{ $serial++ }}</td>
                                        <td>{{ $supplier->accounts_name }}</td>
                                        <td>{{ $supplier->proprietor }}</td>
                                        <td>{{ $supplier->address }}</td>
                                        <td>{{ $supplier->mobile }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($supplier->balance, true, null) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr style="border-top: 2px double #000; font-weight: bold; background-color: #f8f9fa;">
                                    <td colspan="5" style="text-align: right; border-top: 2px double #000;">Grand Total</td>
                                    <td style="text-align: right; border-top: 2px double #000;">{{ $util->num_f($grand_total, true, null) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No accounts payable found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#accounts_payable_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#accounts_payable_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#accounts_payable_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#accounts_payable_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Supplier filter toggle
        $('#supplier_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#supplier_select_wrapper').show();
            } else {
                $('#supplier_select_wrapper').hide();
                $('#supplier_id').val(null).trigger('change');
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#accounts_payable_filter_form').on('submit', function() {
            var start_date_val = $('#accounts_payable_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#accounts_payable_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

