<?php

namespace Modules\BusinessManagement\Http\Controllers;

use Illuminate\Routing\Controller;
use Menu;
use App\Utils\ModuleUtil;

class DataController extends Controller
{
    /**
     * Defines user permissions for the module.
     * @return array
     */
    public function user_permissions()
    {
        return [
            // Main Module Access
            [
                'value' => 'businessmanagement.view',
                'label' => __('businessmanagement::lang.view_businessmanagement'),
                'default' => false
            ],
            
            // Purchase Register - Heading
            [
                'value' => '',
                'label' => __('businessmanagement::lang.purchase_register'),
                'is_heading' => true
            ],
            // Purchase Register - General
            [
                'value' => 'businessmanagement.purchase_register',
                'label' => __('businessmanagement::lang.view_purchase_register'),
                'default' => false
            ],
            // Purchase Register - Reports
            [
                'value' => 'businessmanagement.purchase_register.date_wise_purchase',
                'label' => __('businessmanagement::lang.date_wise_purchase'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.supplier_wise_purchase',
                'label' => __('businessmanagement::lang.supplier_wise_purchase'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.supplier_wise_purchase_wop',
                'label' => __('businessmanagement::lang.supplier_wise_purchase_wop'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.product_wise_purchase',
                'label' => __('businessmanagement::lang.product_wise_purchase'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.product_wise_purchase_wop',
                'label' => __('businessmanagement::lang.product_wise_purchase_wop'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.location_wise_net_product_purchase',
                'label' => __('businessmanagement::lang.location_wise_net_product_purchase'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.date_wise_net_product_purchase',
                'label' => __('businessmanagement::lang.date_wise_net_product_purchase'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.supplier_wise_statement',
                'label' => __('businessmanagement::lang.supplier_wise_statement'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.supplier_and_product_wise_purchase',
                'label' => __('businessmanagement::lang.supplier_and_product_wise_purchase'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.purchased_product_movement',
                'label' => __('businessmanagement::lang.purchased_product_movement'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.supplier_wise_purchase_return',
                'label' => __('businessmanagement::lang.supplier_wise_purchase_return'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.date_wise_purchase_return',
                'label' => __('businessmanagement::lang.date_wise_purchase_return'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.product_wise_purchase_return',
                'label' => __('businessmanagement::lang.product_wise_purchase_return'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.date_wise_purchase_order',
                'label' => __('businessmanagement::lang.date_wise_purchase_order'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register.supplier_wise_purchase_order',
                'label' => __('businessmanagement::lang.supplier_wise_purchase_order'),
                'default' => false,
                'end_group' => true
            ],
            
            // Sales Register - Heading
            [
                'value' => '',
                'label' => __('businessmanagement::lang.sales_register'),
                'is_heading' => true
            ],
            // Sales Register - General
            [
                'value' => 'businessmanagement.sales_register',
                'label' => __('businessmanagement::lang.view_sales_register'),
                'default' => false
            ],
            // Sales Register - Reports
            [
                'value' => 'businessmanagement.sales_register.date_wise_sales',
                'label' => __('businessmanagement::lang.date_wise_sales'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_wise_sales',
                'label' => __('businessmanagement::lang.product_wise_sales'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_sales',
                'label' => __('businessmanagement::lang.customer_wise_sales'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.date_wise_net_product_sales',
                'label' => __('businessmanagement::lang.date_wise_net_product_sales'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_net_product_sales',
                'label' => __('businessmanagement::lang.customer_wise_net_product_sales'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.date_wise_gross_profit',
                'label' => __('businessmanagement::lang.date_wise_gross_profit'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_wise_gross_profit',
                'label' => __('businessmanagement::lang.product_wise_gross_profit'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.date_wise_sales_return',
                'label' => __('businessmanagement::lang.date_wise_sales_return'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_wise_sales_return',
                'label' => __('businessmanagement::lang.product_wise_sales_return'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_sales_return',
                'label' => __('businessmanagement::lang.customer_wise_sales_return'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.explicit_product_wise_sales',
                'label' => __('businessmanagement::lang.explicit_product_wise_sales'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_statement',
                'label' => __('businessmanagement::lang.customer_wise_statement'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_group_wise_net_sales',
                'label' => __('businessmanagement::lang.product_group_wise_net_sales'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_wise_sales_summary',
                'label' => __('businessmanagement::lang.product_wise_sales_summary'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.date_wise_sales_summary',
                'label' => __('businessmanagement::lang.date_wise_sales_summary'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_group_wise_net_sales_mpo',
                'label' => __('businessmanagement::lang.product_group_wise_net_sales_mpo'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_sales_summary',
                'label' => __('businessmanagement::lang.customer_wise_sales_summary'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_invoice_status',
                'label' => __('businessmanagement::lang.customer_wise_invoice_status'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.date_wise_sales_invoice',
                'label' => __('businessmanagement::lang.date_wise_sales_invoice'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_gross_profit',
                'label' => __('businessmanagement::lang.customer_wise_gross_profit'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_wise_net_profit',
                'label' => __('businessmanagement::lang.product_wise_net_profit'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.customer_wise_sales_with_serial',
                'label' => __('businessmanagement::lang.customer_wise_sales_with_serial'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.product_wise_sales_with_serial',
                'label' => __('businessmanagement::lang.product_wise_sales_with_serial'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register.daily_sales_details',
                'label' => __('businessmanagement::lang.daily_sales_details'),
                'default' => false,
                'end_group' => true
            ],
            
            // Stock Register - Heading
            [
                'value' => '',
                'label' => __('businessmanagement::lang.stock_register'),
                'is_heading' => true
            ],
            // Stock Register - General
            [
                'value' => 'businessmanagement.stock_register',
                'label' => __('businessmanagement::lang.view_stock_register'),
                'default' => false
            ],
            // Stock Register - Reports
            [
                'value' => 'businessmanagement.stock_register.current_stock_combined',
                'label' => __('businessmanagement::lang.current_stock_combined'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.current_stock_c',
                'label' => __('businessmanagement::lang.current_stock_c'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.current_stock_with_serial',
                'label' => __('businessmanagement::lang.current_stock_with_serial'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.combined_current_stock_all_br_summary',
                'label' => __('businessmanagement::lang.combined_current_stock_all_br_summary'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.date_wise_product_status',
                'label' => __('businessmanagement::lang.date_wise_product_status'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.date_wise_stock',
                'label' => __('businessmanagement::lang.date_wise_stock'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.product_price_list',
                'label' => __('businessmanagement::lang.product_price_list'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.supplier_wise_current_stock',
                'label' => __('businessmanagement::lang.supplier_wise_current_stock'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.date_wise_product_in_out_statement',
                'label' => __('businessmanagement::lang.date_wise_product_in_out_statement'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register.date_wise_stock_serial_m',
                'label' => __('businessmanagement::lang.date_wise_stock_serial_m'),
                'default' => false,
                'end_group' => true
            ],
            
            // Accounts Register - Heading
            [
                'value' => '',
                'label' => __('businessmanagement::lang.accounts_register'),
                'is_heading' => true
            ],
            // Accounts Register - General
            [
                'value' => 'businessmanagement.accounts_register',
                'label' => __('businessmanagement::lang.view_accounts_register'),
                'default' => false
            ],
            // Accounts Register - Reports
            [
                'value' => 'businessmanagement.accounts_register.due_list',
                'label' => __('businessmanagement::lang.due_list'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.all_customers_due_list',
                'label' => __('businessmanagement::lang.all_customers_due_list'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.supplier_due_list',
                'label' => __('businessmanagement::lang.supplier_due_list'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.customer_accounts_ledger',
                'label' => __('businessmanagement::lang.customer_accounts_ledger'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.cash_book',
                'label' => __('businessmanagement::lang.cash_book'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.date_wise_credit_voucher',
                'label' => __('businessmanagement::lang.date_wise_credit_voucher'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.date_wise_debit_voucher',
                'label' => __('businessmanagement::lang.date_wise_debit_voucher'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.income_statement',
                'label' => __('businessmanagement::lang.income_statement'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.day_book',
                'label' => __('businessmanagement::lang.day_book'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.due_list_without_treatment',
                'label' => __('businessmanagement::lang.due_list_without_treatment'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.date_wise_sales_received',
                'label' => __('businessmanagement::lang.date_wise_sales_received'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.balance_sheet',
                'label' => __('businessmanagement::lang.balance_sheet'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.date_wise_general_expenses',
                'label' => __('businessmanagement::lang.date_wise_general_expenses'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.accounts_receivable',
                'label' => __('businessmanagement::lang.accounts_receivable'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.accounts_payable',
                'label' => __('businessmanagement::lang.accounts_payable'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.customer_due_with_ageing',
                'label' => __('businessmanagement::lang.customer_due_with_ageing'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.cash_flows',
                'label' => __('businessmanagement::lang.cash_flows'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.date_wise_receipt_payment_statement',
                'label' => __('businessmanagement::lang.date_wise_receipt_payment_statement'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.date_wise_receive',
                'label' => __('businessmanagement::lang.date_wise_receive'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register.date_wise_sales_with_profit',
                'label' => __('businessmanagement::lang.date_wise_sales_with_profit'),
                'default' => false,
                'end_group' => true
            ],
        ];
    }

    /**
     * Superadmin package permissions
     *
     * @return array
     */
    public function superadmin_package()
    {
        return [
            [
                'name' => 'businessmanagement_module',
                'label' => __('businessmanagement::lang.businessmanagement_module'),
                'default' => false,
            ],
        ];
    }

    /**
     * Modify admin menu to add Business Management menu item
     */
    public function modifyAdminMenu()
    {
        try {
            $module_util = new ModuleUtil();
            $business_id = session()->get('user.business_id');

            // Check if module is enabled in subscription
            if (auth()->user()->can('superadmin')) {
                $is_businessmanagement_enabled = $module_util->isModuleInstalled('BusinessManagement');
            } else {
                $is_businessmanagement_enabled = (bool) $module_util->hasThePermissionInSubscription($business_id, 'businessmanagement_module');
            }

            if (!$is_businessmanagement_enabled) {
                return; // Module not enabled, skip menu modification
            }

            if (auth()->user()->can('businessmanagement.view')) {
                // Business Management dropdown menu
                Menu::instance('admin-sidebar-menu')
                    ->dropdown(
                        __('businessmanagement::lang.business_management'),
                        function ($sub) {
                            // Purchase Register
                            if (auth()->user()->can('businessmanagement.purchase_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.purchase_register'), 
                                    ['active' => request()->routeIs('businessmanagement.purchase_register.index')]
                                );
                                // Date wise Purchase - sub menu under Purchase Register
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchase']), 
                                    __('businessmanagement::lang.date_wise_purchase'), 
                                    ['active' => request()->routeIs('businessmanagement.purchase_register.date_wise')]
                                );
                            }
                            
                            // Sales Register
                            if (auth()->user()->can('businessmanagement.sales_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.sales_register'), 
                                    ['active' => request()->routeIs('businessmanagement.sales_register.*')]
                                );
                            }
                            
                            // Stock Register
                            if (auth()->user()->can('businessmanagement.stock_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.stock_register'), 
                                    ['active' => request()->routeIs('businessmanagement.stock_register.*')]
                                );
                            }
                            
                            // Accounts Register
                            if (auth()->user()->can('businessmanagement.accounts_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.accounts_register'), 
                                    ['active' => request()->routeIs('businessmanagement.accounts_register.*')]
                                );
                            }
                        },
                        ['active' => request()->routeIs('businessmanagement.*')]
                    )
                    ->order(85);
            }
        } catch (\Exception $e) {
            \Log::error('BusinessManagement menu modification error: ' . $e->getMessage());
        }
    }
}

