<?php
/**
 * Test script to verify the license validation API endpoint
 * Run this on dev.posifyme.com server to test the endpoint
 */

$api_url = 'https://dev.posifyme.com/api/license/validate';

// Test data
$postData = http_build_query([
    'license_code' => 'TEST-LICENSE-123',
    'username' => 'testuser',
    'product_id' => 25,
    'email' => 'test@example.com',
    'url' => 'https://dev.posifyme.com',
    'path' => '/var/www/html'
]);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $api_url,
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CONNECTTIMEOUT => 10,
    CURLOPT_POSTFIELDS => $postData,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/x-www-form-urlencoded',
        'User-Agent: BusinessManagement-Module/1.0'
    ]
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
$curl_errno = curl_errno($ch);

curl_close($ch);

echo "=== API Endpoint Test ===\n";
echo "URL: {$api_url}\n";
echo "HTTP Code: {$http_code}\n";
echo "CURL Error: " . ($curl_error ?: 'None') . "\n";
echo "CURL Errno: " . ($curl_errno ?: 'None') . "\n";
echo "\nResponse:\n";
echo $response . "\n";
echo "\n=== End Test ===\n";

