<?php $request = app('Illuminate\Http\Request'); ?>
<!-- Main Header -->

<style>
    /* Modern White Glassmorphism Header with 3D Effects */
    .modern-header {
        background: #ffffff;
        backdrop-filter: blur(30px) saturate(200%);
        -webkit-backdrop-filter: blur(30px) saturate(200%);
        height: 80px;
        border-bottom: 1px solid rgba(0, 0, 0, 0.08);
        box-shadow: 
            0 4px 24px rgba(0, 0, 0, 0.06),
            0 1px 3px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.9);
        position: relative;
        z-index: 1000;
        overflow: visible;
    }

    .modern-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 10% 20%, rgba(99, 102, 241, 0.03) 0%, transparent 50%),
            radial-gradient(circle at 90% 80%, rgba(168, 85, 247, 0.03) 0%, transparent 50%);
        pointer-events: none;
        z-index: 0;
    }

    /* 3D Glassmorphism Button Style - Light Lemon Theme */
    .header-btn {
        background: rgba(254, 243, 199, 0.95);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        border: 1px solid rgba(253, 230, 138, 0.4);
        border-radius: 16px;
        padding: 10px 14px;
        color: #78350f;
        font-weight: 600;
        font-size: 0.875rem;
        transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        box-shadow: 
            0 4px 12px rgba(253, 224, 71, 0.3),
            0 2px 6px rgba(253, 224, 71, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.5),
            inset 0 -1px 0 rgba(217, 119, 6, 0.1);
        position: relative;
        overflow: hidden;
        transform-style: preserve-3d;
        perspective: 1000px;
        outline: none !important;
    }

    .header-btn:focus,
    .header-btn:active,
    .header-btn:focus-visible {
        outline: none !important;
        border: 1px solid rgba(253, 230, 138, 0.4) !important;
        box-shadow: 
            0 4px 12px rgba(253, 224, 71, 0.3),
            0 2px 6px rgba(253, 224, 71, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.5),
            inset 0 -1px 0 rgba(217, 119, 6, 0.1) !important;
    }

    .header-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, 
            rgba(255, 255, 255, 0.2) 0%, 
            rgba(255, 255, 255, 0.05) 50%,
            transparent 100%);
        opacity: 0;
        transition: opacity 0.4s ease;
        pointer-events: none;
    }

    .header-btn::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.3);
        transform: translate(-50%, -50%);
        transition: width 0.6s ease, height 0.6s ease;
    }

    .header-btn:hover {
        background: rgba(253, 230, 138, 1);
        border-color: rgba(250, 204, 21, 0.5);
        color: #78350f;
        transform: translateY(-6px) rotateX(5deg) scale(1.05);
        box-shadow: 
            0 20px 40px rgba(253, 224, 71, 0.5),
            0 10px 20px rgba(253, 224, 71, 0.4),
            0 0 0 1px rgba(250, 204, 21, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.6),
            inset 0 -2px 4px rgba(217, 119, 6, 0.15);
    }

    .header-btn:hover::before {
        opacity: 1;
    }

    .header-btn:hover::after {
        width: 300px;
        height: 300px;
    }

    .header-btn svg,
    .header-btn img {
        transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
        position: relative;
        z-index: 1;
    }

    .header-btn:hover svg,
    .header-btn:hover img {
        transform: scale(1.15) rotateZ(10deg) translateZ(10px);
        filter: drop-shadow(0 4px 8px rgba(120, 53, 15, 0.2));
    }

    .header-btn-icon {
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Multi-Color Button Variants - Matching Dashboard Colors */
    .header-btn-purple {
        background: rgba(139, 92, 246, 0.95) !important;
        border: 1px solid rgba(139, 92, 246, 0.3) !important;
        color: #ffffff !important;
        box-shadow: 
            0 4px 12px rgba(139, 92, 246, 0.3),
            0 2px 6px rgba(139, 92, 246, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1) !important;
    }
    .header-btn-purple:hover {
        background: rgba(124, 58, 237, 1) !important;
        border-color: rgba(124, 58, 237, 0.5) !important;
        box-shadow: 
            0 20px 40px rgba(139, 92, 246, 0.5),
            0 10px 20px rgba(139, 92, 246, 0.4),
            0 0 0 1px rgba(124, 58, 237, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    .header-btn-green {
        background: rgba(34, 197, 94, 0.95) !important;
        border: 1px solid rgba(34, 197, 94, 0.3) !important;
        color: #ffffff !important;
        box-shadow: 
            0 4px 12px rgba(34, 197, 94, 0.3),
            0 2px 6px rgba(34, 197, 94, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1) !important;
    }
    .header-btn-green:hover {
        background: rgba(22, 163, 74, 1) !important;
        border-color: rgba(22, 163, 74, 0.5) !important;
        box-shadow: 
            0 20px 40px rgba(34, 197, 94, 0.5),
            0 10px 20px rgba(34, 197, 94, 0.4),
            0 0 0 1px rgba(22, 163, 74, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    .header-btn-pink {
        background: rgba(236, 72, 153, 0.95) !important;
        border: 1px solid rgba(236, 72, 153, 0.3) !important;
        color: #ffffff !important;
        box-shadow: 
            0 4px 12px rgba(236, 72, 153, 0.3),
            0 2px 6px rgba(236, 72, 153, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1) !important;
    }
    .header-btn-pink:hover {
        background: rgba(219, 39, 119, 1) !important;
        border-color: rgba(219, 39, 119, 0.5) !important;
        box-shadow: 
            0 20px 40px rgba(236, 72, 153, 0.5),
            0 10px 20px rgba(236, 72, 153, 0.4),
            0 0 0 1px rgba(219, 39, 119, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    .header-btn-orange {
        background: rgba(249, 115, 22, 0.95) !important;
        border: 1px solid rgba(249, 115, 22, 0.3) !important;
        color: #ffffff !important;
        box-shadow: 
            0 4px 12px rgba(249, 115, 22, 0.3),
            0 2px 6px rgba(249, 115, 22, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1) !important;
    }
    .header-btn-orange:hover {
        background: rgba(234, 88, 12, 1) !important;
        border-color: rgba(234, 88, 12, 0.5) !important;
        box-shadow: 
            0 20px 40px rgba(249, 115, 22, 0.5),
            0 10px 20px rgba(249, 115, 22, 0.4),
            0 0 0 1px rgba(234, 88, 12, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    .header-btn-cyan {
        background: rgba(6, 182, 212, 0.95) !important;
        border: 1px solid rgba(6, 182, 212, 0.3) !important;
        color: #ffffff !important;
        box-shadow: 
            0 4px 12px rgba(6, 182, 212, 0.3),
            0 2px 6px rgba(6, 182, 212, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1) !important;
    }
    .header-btn-cyan:hover {
        background: rgba(8, 145, 178, 1) !important;
        border-color: rgba(8, 145, 178, 0.5) !important;
        box-shadow: 
            0 20px 40px rgba(6, 182, 212, 0.5),
            0 10px 20px rgba(6, 182, 212, 0.4),
            0 0 0 1px rgba(8, 145, 178, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    .header-btn-red {
        background: rgba(239, 68, 68, 0.95) !important;
        border: 1px solid rgba(239, 68, 68, 0.3) !important;
        color: #ffffff !important;
        box-shadow: 
            0 4px 12px rgba(239, 68, 68, 0.3),
            0 2px 6px rgba(239, 68, 68, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1) !important;
    }
    .header-btn-red:hover {
        background: rgba(220, 38, 38, 1) !important;
        border-color: rgba(220, 38, 38, 0.5) !important;
        box-shadow: 
            0 20px 40px rgba(239, 68, 68, 0.5),
            0 10px 20px rgba(239, 68, 68, 0.4),
            0 0 0 1px rgba(220, 38, 38, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    .header-btn-blue {
        background: rgba(59, 130, 246, 0.95) !important;
        border: 1px solid rgba(59, 130, 246, 0.3) !important;
        color: #ffffff !important;
        box-shadow: 
            0 4px 12px rgba(59, 130, 246, 0.3),
            0 2px 6px rgba(59, 130, 246, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1) !important;
    }
    .header-btn-blue:hover {
        background: rgba(37, 99, 235, 1) !important;
        border-color: rgba(37, 99, 235, 0.5) !important;
        box-shadow: 
            0 20px 40px rgba(59, 130, 246, 0.5),
            0 10px 20px rgba(59, 130, 246, 0.4),
            0 0 0 1px rgba(37, 99, 235, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    .pos-button {
        background: rgba(249, 115, 22, 0.95);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        border: 1px solid rgba(249, 115, 22, 0.4);
        border-radius: 18px;
        padding: 12px 20px;
        color: #ffffff;
        font-weight: 700;
        font-size: 0.875rem;
        transition: all 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
        display: inline-flex;
        align-items: center;
        gap: 10px;
        box-shadow: 
            0 6px 20px rgba(249, 115, 22, 0.4),
            0 3px 10px rgba(249, 115, 22, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.2),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1);
        position: relative;
        overflow: hidden;
        transform-style: preserve-3d;
        perspective: 1000px;
        outline: none !important;
    }

    .pos-button:focus,
    .pos-button:active,
    .pos-button:focus-visible {
        outline: none !important;
        border: 1px solid rgba(249, 115, 22, 0.4) !important;
    }

    .pos-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, 
            rgba(255, 255, 255, 0.4) 0%, 
            rgba(255, 255, 255, 0.1) 50%,
            transparent 100%);
        opacity: 0;
        transition: opacity 0.5s ease;
        pointer-events: none;
    }

    .pos-button::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.4);
        transform: translate(-50%, -50%);
        transition: width 0.8s ease, height 0.8s ease;
    }

    .pos-button:hover {
        background: rgba(234, 88, 12, 1);
        border-color: rgba(234, 88, 12, 0.6);
        color: #ffffff;
        transform: translateY(-8px) rotateX(8deg) scale(1.08);
        box-shadow: 
            0 25px 50px rgba(249, 115, 22, 0.5),
            0 12px 24px rgba(249, 115, 22, 0.4),
            0 0 0 2px rgba(234, 88, 12, 0.4),
            inset 0 3px 6px rgba(255, 255, 255, 0.3),
            inset 0 -3px 6px rgba(0, 0, 0, 0.2);
    }

    .pos-button:hover::before {
        opacity: 1;
    }

    .pos-button:hover::after {
        width: 400px;
        height: 400px;
    }

    .pos-button svg {
        transition: all 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
        position: relative;
        z-index: 1;
        filter: drop-shadow(0 2px 4px rgba(255, 255, 255, 0.3));
    }

    .pos-button:hover svg {
        transform: rotateZ(15deg) scale(1.2) translateZ(15px);
        filter: drop-shadow(0 6px 12px rgba(255, 255, 255, 0.4));
    }

    .date-button {
        background: rgba(59, 130, 246, 0.95);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        border: 1px solid rgba(59, 130, 246, 0.3);
        border-radius: 16px;
        padding: 10px 16px;
        color: #ffffff;
        font-weight: 700;
        font-size: 0.875rem;
        font-family: 'Courier New', monospace;
        transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
        box-shadow: 
            0 4px 12px rgba(59, 130, 246, 0.3),
            0 2px 6px rgba(59, 130, 246, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1);
        transform-style: preserve-3d;
        perspective: 1000px;
        outline: none !important;
    }

    .date-button:focus,
    .date-button:active,
    .date-button:focus-visible {
        outline: none !important;
        border: 1px solid rgba(59, 130, 246, 0.3) !important;
    }

    .date-button:hover {
        background: rgba(37, 99, 235, 1);
        border-color: rgba(37, 99, 235, 0.5);
        color: #ffffff;
        transform: translateY(-6px) rotateX(5deg) scale(1.05);
        box-shadow: 
            0 20px 40px rgba(59, 130, 246, 0.5),
            0 10px 20px rgba(59, 130, 246, 0.4),
            0 0 0 1px rgba(37, 99, 235, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1);
    }

    .user-profile-btn {
        background: rgba(236, 72, 153, 0.95);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        border: 1px solid rgba(236, 72, 153, 0.3);
        border-radius: 16px;
        padding: 8px 12px;
        transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
        box-shadow: 
            0 4px 12px rgba(236, 72, 153, 0.3),
            0 2px 6px rgba(236, 72, 153, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1);
        transform-style: preserve-3d;
        perspective: 1000px;
        outline: none !important;
    }

    .user-profile-btn:focus,
    .user-profile-btn:active,
    .user-profile-btn:focus-visible {
        outline: none !important;
        border: 1px solid rgba(236, 72, 153, 0.3) !important;
    }

    .user-profile-btn:hover {
        background: rgba(219, 39, 119, 1);
        border-color: rgba(219, 39, 119, 0.5);
        transform: translateY(-6px) rotateX(5deg) scale(1.05);
        box-shadow: 
            0 20px 40px rgba(236, 72, 153, 0.5),
            0 10px 20px rgba(236, 72, 153, 0.4),
            0 0 0 1px rgba(219, 39, 119, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1);
    }

    .user-profile-btn img {
        transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
        border-radius: 50%;
        border: 2px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3);
        position: relative;
        z-index: 1;
    }

    .user-profile-btn:hover img {
        transform: scale(1.2) rotateZ(10deg) translateZ(10px);
        border-color: rgba(255, 255, 255, 0.5);
        box-shadow: 0 6px 20px rgba(219, 39, 119, 0.5);
    }

    .notification-btn {
        position: relative;
        background: rgba(239, 68, 68, 0.95);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        border: 1px solid rgba(239, 68, 68, 0.3);
        border-radius: 16px;
        padding: 10px 14px;
        color: #ffffff;
        box-shadow: 
            0 4px 12px rgba(239, 68, 68, 0.3),
            0 2px 6px rgba(239, 68, 68, 0.2),
            inset 0 1px 0 rgba(255, 255, 255, 0.2),
            inset 0 -1px 0 rgba(0, 0, 0, 0.1);
    }

    .notification-btn:hover {
        background: rgba(220, 38, 38, 1);
        border-color: rgba(220, 38, 38, 0.5);
        transform: translateY(-6px) rotateX(5deg) scale(1.05);
        box-shadow: 
            0 20px 40px rgba(239, 68, 68, 0.5),
            0 10px 20px rgba(239, 68, 68, 0.4),
            0 0 0 1px rgba(220, 38, 38, 0.3),
            inset 0 2px 4px rgba(255, 255, 255, 0.3),
            inset 0 -2px 4px rgba(0, 0, 0, 0.1);
    }

    .notification-badge {
        position: absolute;
        top: -8px;
        right: -8px;
        background: #ef4444;
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        color: white;
        border-radius: 14px;
        padding: 4px 9px;
        font-size: 0.7rem;
        font-weight: 700;
        min-width: 22px;
        text-align: center;
        box-shadow: 
            0 6px 16px rgba(239, 68, 68, 0.5),
            0 3px 8px rgba(239, 68, 68, 0.4),
            inset 0 1px 0 rgba(255, 255, 255, 0.3),
            inset 0 -1px 0 rgba(0, 0, 0, 0.2);
        animation: pulse-badge 2s ease-in-out infinite;
        border: 2px solid rgba(255, 255, 255, 0.4);
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
        transform-style: preserve-3d;
        z-index: 10;
    }

    @keyframes pulse-badge {
        0%, 100% {
            transform: scale(1) translateZ(0);
            box-shadow: 
                0 6px 16px rgba(239, 68, 68, 0.5),
                0 3px 8px rgba(239, 68, 68, 0.4);
        }
        50% {
            transform: scale(1.2) translateZ(5px);
            box-shadow: 
                0 10px 24px rgba(239, 68, 68, 0.7),
                0 5px 12px rgba(239, 68, 68, 0.6),
                0 0 25px rgba(239, 68, 68, 0.5);
        }
    }

    @media (max-width: 768px) {
        .modern-header {
            height: 70px;
        }

        .header-btn {
            padding: 8px 12px;
            font-size: 0.8125rem;
        }

        .pos-button {
            padding: 10px 16px;
            font-size: 0.8125rem;
        }
    }
</style>

<div class="modern-header no-print">
    <div class="tw-px-5 tw-py-3" style="position: relative; z-index: 1;">
        <div class="tw-flex tw-items-start tw-justify-between tw-gap-6 lg:tw-items-center">
            <div class="tw-flex tw-items-center tw-gap-3">
                <button type="button" 
                    class="header-btn header-btn-blue small-view-button xl:tw-w-20 lg:tw-hidden">
                    <span class="tw-sr-only">
                        Sidebar Menu
                    </span>
                    <div class="header-btn-icon">
                    <svg aria-hidden="true" class="tw-size-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <path d="M4 6l16 0" />
                        <path d="M4 12l16 0" />
                        <path d="M4 18l16 0" />
                    </svg>
                    </div>
                </button>

                <button type="button"
                    class="header-btn header-btn-blue side-bar-collapse tw-hidden lg:tw-inline-flex">
                    <span class="tw-sr-only">
                        Collapse Sidebar
                    </span>
                    <div class="header-btn-icon">
                        <img src="<?php echo e(asset('img/icon/menu-flex.svg'), false); ?>" alt="" style="width: 20px; height: 20px;">
                    </div>
                </button>
            </div>


            
            <?php if(Module::has('Superadmin')): ?>
                <?php if ($__env->exists('superadmin::layouts.partials.active_subscription')) echo $__env->make('superadmin::layouts.partials.active_subscription', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            
            <?php if(!empty(session('previous_user_id')) && !empty(session('previous_username'))): ?>
                <a href="<?php echo e(route('sign-in-as-user', session('previous_user_id')), false); ?>" class="btn btn-flat btn-danger m-8 btn-sm mt-10"><i class="fas fa-undo"></i> <?php echo app('translator')->get('lang_v1.back_to_username', ['username' => session('previous_username')] ); ?></a>
            <?php endif; ?>


            <div class="tw-flex tw-flex-wrap tw-items-center tw-justify-end tw-gap-3">
                <?php if(Module::has('Essentials')): ?>
                    <?php if ($__env->exists('essentials::layouts.partials.header_part')) echo $__env->make('essentials::layouts.partials.header_part', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <details class="tw-dw-dropdown tw-relative tw-inline-block tw-text-left">
                    <summary class="header-btn header-btn-purple tw-cursor-pointer">
                        <div class="header-btn-icon">
                        <svg aria-hidden="true" class="tw-size-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round"
                            stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                            <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" />
                            <path d="M9 12h6" />
                            <path d="M12 9v6" />
                        </svg>
                        </div>
                    </summary>
                    <ul class="tw-dw-menu tw-dw-dropdown-content tw-dw-z-[1] tw-dw-bg-base-100 tw-dw-rounded-box tw-w-48 tw-absolute tw-left-0 tw-z-10 tw-mt-2 tw-origin-top-right tw-bg-white tw-rounded-lg tw-shadow-lg tw-ring-1 tw-ring-gray-200 focus:tw-outline-none"
                        role="menu" tabindex="-1">
                        <div class="tw-p-2" role="none">
                            <a href="<?php echo e(route('calendar'), false); ?>"
                                class="tw-flex tw-items-center tw-gap-2 tw-px-3 tw-py-2 tw-text-sm tw-font-medium tw-text-gray-600 tw-transition-all tw-duration-200 tw-rounded-lg hover:tw-text-gray-900 hover:tw-bg-gray-100"
                                role="menuitem" tabindex="-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-calendar"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <rect x="4" y="5" width="16" height="16" rx="2" />
                                    <line x1="16" y1="3" x2="16" y2="7" />
                                    <line x1="8" y1="3" x2="8" y2="7" />
                                    <line x1="4" y1="11" x2="20" y2="11" />
                                    <line x1="11" y1="15" x2="12" y2="15" />
                                    <line x1="12" y1="15" x2="12" y2="18" />
                                </svg>
                                <?php echo app('translator')->get('lang_v1.calendar'); ?>
                            </a>
                            <?php if(Module::has('Essentials')): ?>
                                <a href="#"
                                    data-href="<?php echo e(action([\Modules\Essentials\Http\Controllers\ToDoController::class, 'create']), false); ?>"
                                    data-container="#task_modal"
                                    class="btn-modal tw-flex tw-items-center tw-gap-2 tw-px-3 tw-py-2 tw-text-sm tw-font-medium tw-text-gray-600 tw-transition-all tw-duration-200 tw-rounded-lg hover:tw-text-gray-900 hover:tw-bg-gray-100"
                                    role="menuitem" tabindex="-1">
                                    <svg aria-hidden="true" class="tw-w-5 tw-h-5" xmlns="http://www.w3.org/2000/svg"
                                        viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path
                                            d="M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z" />
                                        <path d="M9 12l2 2l4 -4" />
                                    </svg>
                                    <?php echo app('translator')->get('essentials::lang.add_to_do'); ?>
                                </a>
                            <?php endif; ?>

                   




                            <?php if(auth()->user()->hasRole('Admin#' . auth()->user()->business_id)): ?>
                                <a href="#" id="start_tour"
                                    class="tw-flex tw-items-center tw-gap-2 tw-px-3 tw-py-2 tw-text-sm tw-font-medium tw-text-gray-600 tw-transition-all tw-duration-200 tw-rounded-lg hover:tw-text-gray-900 hover:tw-bg-gray-100"
                                    role="menuitem" tabindex="-1">
                                    <svg aria-hidden="true" class="tw-w-5 tw-h-5" xmlns="http://www.w3.org/2000/svg"
                                        viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                                        <path d="M12 17l0 .01" />
                                        <path d="M12 13.5a1.5 1.5 0 0 1 1 -1.5a2.6 2.6 0 1 0 -3 -4" />
                                    </svg>
                                    Application Tour
                                </a>
                            <?php endif; ?>
                        </div>
                    </ul>

                </details>

                
                <?php if(auth()->user()->hasRole('Admin#'.auth()->user()->business_id)): ?>
                    <div class="btn-group">
                        <button id="header_shortcut_dropdown" type="button" class="header-btn header-btn-orange" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <div class="header-btn-icon">
                                <i class="fas fa-cogs" style="font-size: 1.1rem;"></i>
                            </div>
                        </button>

                        <ul class="dropdown-menu">
                            <li>
                                <a href="<?php echo e(url('/log-viewer'), false); ?>" target="_blank">
                                    <i class="fas fa-clipboard-list" aria-hidden="true"></i> System Logs
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('commands.optimize.clear'), false); ?>">
                                    <i class="fas fa-cog" aria-hidden="true"></i> Optimize:Clear
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('commands.route.clear'), false); ?>">
                                    <i class="fas fa-cogs" aria-hidden="true"></i> Optimize:Route
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(url('/reports/product-stock-details'), false); ?>" target="_blank">
                                    <i class="fas fa-search" aria-hidden="true"></i> Product Mismatch
                                </a>
                            </li>
                        </ul>
                    </div>
                <?php endif; ?>


            
            

                

                <button id="btnCalculator" title="<?php echo app('translator')->get('lang_v1.calculator'); ?>" 
                    data-content='<?php echo $__env->make('layouts.partials.calculator', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>'
                    type="button" data-trigger="click" data-html="true" data-placement="bottom" 
                    class="header-btn header-btn-green tw-hidden md:tw-inline-flex popover-default">
                    <span class="tw-sr-only" aria-hidden="true">
                        Calculator
                    </span>
                    <div class="header-btn-icon">
                    <svg aria-hidden="true" class="tw-size-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <path d="M4 3m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z" />
                        <path d="M8 7m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z" />
                        <path d="M8 14l0 .01" />
                        <path d="M12 14l0 .01" />
                        <path d="M16 14l0 .01" />
                        <path d="M8 17l0 .01" />
                        <path d="M12 17l0 .01" />
                        <path d="M16 17l0 .01" />
                    </svg>
                    </div>
                </button>

                <?php if(in_array('pos_sale', $enabled_modules)): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sell.create')): ?>
                        <a href="<?php echo e(action([\App\Http\Controllers\SellPosController::class, 'create']), false); ?>"
                            class="pos-button sm:tw-inline-flex">
                            <svg aria-hidden="true" class="tw-size-5 tw-hidden md:tw-block" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M4 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                                <path d="M14 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                                <path d="M4 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                                <path d="M14 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                            </svg>
                            <?php echo app('translator')->get('sale.pos_sale'); ?>
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(Module::has('Repair')): ?>
                    
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('profit_loss_report.view')): ?>
                    <button type="button" id="view_todays_profit" title="<?php echo e(__('home.todays_profit'), false); ?>"
                        data-toggle="tooltip" data-placement="bottom"
                        class="header-btn header-btn-green tw-hidden sm:tw-inline-flex">
                        <span class="tw-sr-only">
                            Today's Profit
                        </span>
                        <div class="header-btn-icon">
                        <svg aria-hidden="true" class="tw-size-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round"
                            stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                            <path d="M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0" />
                            <path d="M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z" />
                            <path d="M18 12l.01 0" />
                            <path d="M6 12l.01 0" />
                        </svg>
                        </div>
                    </button>
                <?php endif; ?>

                <button type="button"
                    class="date-button tw-hidden lg:tw-inline-flex">
                    <?php echo e(\Carbon::createFromTimestamp(strtotime('now'))->format(session('business.date_format')), false); ?>

                </button>

                <?php echo $__env->make('layouts.partials.header-notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



                    <details class="tw-dw-dropdown tw-relative tw-inline-block tw-text-<?php echo e(App::getLocale() == 'ar' ? 'right' : 'left', false); ?>">
                    <summary data-toggle="popover"
                        class="user-profile-btn tw-cursor-pointer">
                        <span class="tw-hidden md:tw-block"></span>
                        <img src="<?php echo e(asset('img/icon/user-profile.png'), false); ?>" alt="" style="width: 32px; height: 32px;">
                    </summary>

                     <ul class="tw-p-2 tw-w-48 tw-absolute <?php echo e(App::getLocale() == 'ar' ? 'tw-left-0 tw-origin-top-left' : 'tw-right-0 tw-origin-top-right', false); ?> tw-z-10 tw-mt-2  tw-bg-white tw-rounded-lg tw-shadow-lg tw-ring-1 tw-ring-gray-200 focus:tw-outline-none"
                        role="menu" tabindex="-1">
                        <div class="tw-px-4 tw-pt-3 tw-pb-1" role="none">
                            <p class="tw-text-sm" role="none">
                                Signed in as
                            </p>
                            <p class="tw-text-sm tw-font-medium tw-text-gray-900 tw-truncate" role="none">
                                <?php echo e(Auth::User()->first_name, false); ?> <?php echo e(Auth::User()->last_name, false); ?>

                            </p>
                        </div>

                        <li>
                            <a href="<?php echo e(action([\App\Http\Controllers\UserController::class, 'getProfile']), false); ?>"
                                class="tw-flex tw-items-center tw-gap-2 tw-px-3 tw-py-2 tw-text-sm tw-font-medium tw-text-gray-600 tw-transition-all tw-duration-200 tw-rounded-lg hover:tw-text-gray-900 hover:tw-bg-gray-100"
                                role="menuitem" tabindex="-1">
                                <svg aria-hidden="true" class="tw-w-5 tw-h-5" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                                    <path d="M12 10m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0" />
                                    <path d="M6.168 18.849a4 4 0 0 1 3.832 -2.849h4a4 4 0 0 1 3.834 2.855" />
                                </svg>
                                <?php echo app('translator')->get('lang_v1.profile'); ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(action([\App\Http\Controllers\Auth\LoginController::class, 'logout']), false); ?>"
                                class="tw-flex tw-items-center tw-gap-2 tw-px-3 tw-py-2 tw-text-sm tw-font-medium tw-text-gray-600 tw-transition-all tw-duration-200 tw-rounded-lg hover:tw-text-gray-900 hover:tw-bg-gray-100"
                                role="menuitem" tabindex="-1">
                                <svg aria-hidden="true" class="tw-w-5 tw-h-5" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 24 24" stroke-width="1.75" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path
                                        d="M14 8v-2a2 2 0 0 0 -2 -2h-7a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h7a2 2 0 0 0 2 -2v-2" />
                                    <path d="M9 12h12l-3 -3" />
                                    <path d="M18 15l3 -3" />
                                </svg>
                                <?php echo app('translator')->get('lang_v1.sign_out'); ?>
                            </a>
                        </li>
                    </ul>
                </details>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragonpro\www\posyoo\resources\views/layouts/partials/header.blade.php ENDPATH**/ ?>