
<?php $__env->startSection('title', __('License Management')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1>
        <i class="fa fa-key"></i>
        <?php echo app('translator')->get('License Management'); ?>
    </h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                <div class="row">
                    <div class="col-md-12">
                        <h3>Generate New License</h3>
                        <hr>
                        
                        <?php if(session('status')): ?>
                            <div class="alert alert-<?php echo e(session('status')['success'] ? 'success' : 'danger', false); ?>">
                                <?php echo session('status')['msg']; ?>

                                <?php if(isset(session('status')['license_code'])): ?>
                                    <br><strong>License Code: <?php echo e(session('status')['license_code'], false); ?></strong>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <form action="<?php echo e(action([App\Http\Controllers\LicenseManagementController::class, 'generateLicense']), false); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="module_name">Module Name:*</label>
                                        <select name="module_name" id="module_name" class="form-control" required>
                                            <option value="businessmanagement">Business Management</option>
                                            <!-- Add more modules as needed -->
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="username">Username:*</label>
                                        <input type="text" name="username" id="username" class="form-control" required 
                                               placeholder="Enter purchase username">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email">Email:*</label>
                                        <input type="email" name="email" id="email" class="form-control" required 
                                               placeholder="Enter customer email">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="license_type">License Type:*</label>
                                        <select name="license_type" id="license_type" class="form-control" required>
                                            <option value="single">Single Site</option>
                                            <option value="multi">Multi Site</option>
                                            <option value="unlimited">Unlimited</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="expiry_date">Expiry Date (Optional):</label>
                                        <input type="date" name="expiry_date" id="expiry_date" class="form-control" 
                                               placeholder="Leave empty for lifetime license">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-key"></i> Generate License
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            <?php echo $__env->renderComponent(); ?>

            <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                <div class="row">
                    <div class="col-md-12">
                        <h3>Existing Licenses</h3>
                        <hr>
                        
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover" id="licenses_table">
                                <thead>
                                    <tr>
                                        <th>Module</th>
                                        <th>License Code</th>
                                        <th>Username</th>
                                        <th>Email</th>
                                        <th>Type</th>
                                        <th>Expiry Date</th>
                                        <th>Status</th>
                                        <th>Created At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($license->module_name ?? 'N/A', false); ?></td>
                                            <td><code><?php echo e($license->license_code ?? 'N/A', false); ?></code></td>
                                            <td><?php echo e($license->username ?? 'N/A', false); ?></td>
                                            <td><?php echo e($license->email ?? 'N/A', false); ?></td>
                                            <td>
                                                <span class="label label-info">
                                                    <?php echo e(ucfirst($license->license_type ?? 'single'), false); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php if($license->expiry_date ?? null): ?>
                                                    <?php echo e(\Carbon\Carbon::parse($license->expiry_date)->format('Y-m-d'), false); ?>

                                                <?php else: ?>
                                                    <span class="text-success">Lifetime</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php
                                                    $status = $license->status ?? 'active';
                                                    $statusClass = $status == 'active' ? 'success' : ($status == 'expired' ? 'danger' : 'warning');
                                                ?>
                                                <span class="label label-<?php echo e($statusClass, false); ?>">
                                                    <?php echo e(ucfirst($status), false); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php if(isset($license->created_at)): ?>
                                                    <?php echo e(\Carbon\Carbon::parse($license->created_at)->format('Y-m-d H:i'), false); ?>

                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center">
                                                <p class="text-muted">No licenses found. Generate a license above.</p>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable if licenses exist
        <?php if(count($licenses) > 0): ?>
            $('#licenses_table').DataTable({
                "pageLength": 25,
                "order": [[7, "desc"]]
            });
        <?php endif; ?>
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragonpro\www\posyoo\resources\views/license_management/index.blade.php ENDPATH**/ ?>