<?php $__env->startSection('title', __('home.home')); ?>

<?php $__env->startSection('content'); ?>

<?php
    use App\Utils\ColorUtil;
?>

    <style>
        /* Google Fonts - loaded from local file for offline support */
        @import url('<?php echo e(asset('fonts/google-fonts/inter-poppins-almarai-local.css'), false); ?>');
        
        /* Fallback fonts if Google Fonts fail to load */
        @font-face {
            font-family: 'Inter';
            font-style: normal;
            font-weight: 300 800;
            font-display: swap;
            src: local('Arial'), local('Helvetica'), local('sans-serif');
        }
        
        @font-face {
            font-family: 'Almarai';
            font-style: normal;
            font-weight: 300 800;
            font-display: swap;
            src: local('Arial'), local('Helvetica'), local('sans-serif');
        }

        :root {
            /* Enhanced Color System */
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            --primary-gradient-hover: linear-gradient(135deg, #7c8ef5 0%, #8a5fb8 50%, #f5a3fc 100%);
            --success-gradient: linear-gradient(135deg, #10b981 0%, #34d399 50%, #6ee7b7 100%);
            --warning-gradient: linear-gradient(135deg, #f59e0b 0%, #fbbf24 50%, #fcd34d 100%);
            --info-gradient: linear-gradient(135deg, #3b82f6 0%, #60a5fa 50%, #93c5fd 100%);
            --danger-gradient: linear-gradient(135deg, #ef4444 0%, #f87171 50%, #fca5a5 100%);
            --purple-gradient: linear-gradient(135deg, #8b5cf6 0%, #a78bfa 50%, #c4b5fd 100%);
            --teal-gradient: linear-gradient(135deg, #14b8a6 0%, #5eead4 50%, #99f6e4 100%);
            --pink-gradient: linear-gradient(135deg, #ec4899 0%, #f472b6 50%, #f9a8d4 100%);
            
            /* Glassmorphism System */
            --glass-bg: rgba(255, 255, 255, 0.85);
            --glass-bg-hover: rgba(255, 255, 255, 0.95);
            --glass-border: rgba(255, 255, 255, 0.3);
            --glass-border-hover: rgba(255, 255, 255, 0.5);
            --glass-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
            --glass-shadow-hover: 0 16px 48px rgba(102, 126, 234, 0.15);
            
            /* Enhanced Shadow System */
            --shadow-xs: 0 1px 2px rgba(0, 0, 0, 0.04);
            --shadow-sm: 0 2px 8px rgba(0, 0, 0, 0.06);
            --shadow-md: 0 4px 16px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 12px 40px rgba(0, 0, 0, 0.12);
            --shadow-xl: 0 24px 80px rgba(0, 0, 0, 0.16);
            --shadow-2xl: 0 32px 96px rgba(0, 0, 0, 0.2);
            --shadow-glow: 0 0 40px rgba(102, 126, 234, 0.4);
            --shadow-glow-strong: 0 0 60px rgba(102, 126, 234, 0.6);
            
            /* Typography System */
            --text-primary: #0f172a;
            --text-secondary: #334155;
            --text-muted: #64748b;
            --text-light: #94a3b8;
            --font-weight-light: 300;
            --font-weight-normal: 400;
            --font-weight-medium: 500;
            --font-weight-semibold: 600;
            --font-weight-bold: 700;
            --font-weight-extrabold: 800;
            
            /* Spacing System */
            --spacing-xs: 4px;
            --spacing-sm: 8px;
            --spacing-md: 16px;
            --spacing-lg: 24px;
            --spacing-xl: 32px;
            --spacing-2xl: 48px;
            --spacing-3xl: 64px;
            
            /* Border Radius System */
            --border-radius-xs: 6px;
            --border-radius-sm: 12px;
            --border-radius-md: 16px;
            --border-radius-lg: 24px;
            --border-radius-xl: 32px;
            --border-radius-2xl: 40px;
            --border-radius-full: 9999px;
            
            /* Transition System */
            --transition-fast: 0.15s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-base: 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-slow: 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-bounce: 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            
            /* Z-Index System */
            --z-base: 1;
            --z-dropdown: 1000;
            --z-sticky: 1020;
            --z-fixed: 1030;
            --z-modal-backdrop: 1040;
            --z-modal: 1050;
            --z-popover: 1060;
            --z-tooltip: 1070;
        }

        * {
            font-family: 'Inter', 'Almarai', sans-serif;
            font-size: 14px;
        }

        /* Premium Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        
        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes scaleIn {
            from {
                opacity: 0;
                transform: scale(0.9);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
        
        @keyframes shimmer {
            0% {
                background-position: -1000px 0;
            }
            100% {
                background-position: 1000px 0;
            }
        }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-10px);
            }
        }
        
        @keyframes glow {
            0%, 100% {
                box-shadow: 0 0 20px rgba(102, 126, 234, 0.3);
            }
            50% {
                box-shadow: 0 0 40px rgba(102, 126, 234, 0.6);
            }
        }

        .modern-dashboard-header {
            animation: fadeInUp 0.8s cubic-bezier(0.4, 0, 0.2, 1) 0.1s backwards;
        }
        
        .modern-metrics-grid {
            animation: fadeInUp 0.8s cubic-bezier(0.4, 0, 0.2, 1) 0.2s backwards;
        }
        
        .modern-statistics-section {
            animation: fadeInUp 0.8s cubic-bezier(0.4, 0, 0.2, 1) 0.3s backwards;
        }
        
        .modern-sales-charts-section {
            animation: fadeInUp 0.8s cubic-bezier(0.4, 0, 0.2, 1) 0.4s backwards;
        }

        /* Loading States */
        .metric-value i.fa-spin {
            color: var(--text-muted);
            opacity: 0.6;
        }

        /* Smooth Scroll */
        html {
            scroll-behavior: smooth;
        }

        /* Focus States for Accessibility */
        .modern-filter-btn:focus,
        .modern-select:focus {
            outline: 2px solid rgba(102, 126, 234, 0.5);
            outline-offset: 2px;
        }

        body {
            background: linear-gradient(135deg, 
                #f8fafc 0%, 
                #f1f5f9 25%, 
                #e2e8f0 50%, 
                #cbd5e1 75%, 
                #e2e8f0 100%);
            background-attachment: fixed;
            background-size: 200% 200%;
            animation: gradientShift 20s ease infinite;
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }
        
        @keyframes gradientShift {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 15% 30%, rgba(102, 126, 234, 0.15) 0%, transparent 45%),
                radial-gradient(circle at 85% 70%, rgba(118, 75, 162, 0.12) 0%, transparent 45%),
                radial-gradient(circle at 50% 10%, rgba(79, 172, 254, 0.1) 0%, transparent 40%),
                radial-gradient(circle at 30% 90%, rgba(240, 147, 251, 0.08) 0%, transparent 40%),
                radial-gradient(circle at 70% 40%, rgba(16, 185, 129, 0.06) 0%, transparent 35%);
            pointer-events: none;
            z-index: 0;
            animation: pulseGlow 25s ease-in-out infinite;
        }
        
        @keyframes pulseGlow {
            0%, 100% { opacity: 1; transform: scale(1); }
            50% { opacity: 0.85; transform: scale(1.05); }
        }
        
        body::after {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                repeating-linear-gradient(
                    0deg,
                    transparent,
                    transparent 2px,
                    rgba(102, 126, 234, 0.01) 2px,
                    rgba(102, 126, 234, 0.01) 4px
                );
            pointer-events: none;
            z-index: 0;
            opacity: 0.3;
        }

        body > * {
            position: relative;
            z-index: 1;
        }

        /* Modern Dashboard Header - Pixel Perfect */
        .modern-dashboard-header {
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.98) 0%, 
                rgba(255, 255, 255, 0.95) 50%,
                rgba(255, 255, 255, 0.98) 100%);
            backdrop-filter: blur(40px) saturate(180%);
            -webkit-backdrop-filter: blur(40px) saturate(180%);
            border-radius: 20px;
            padding: 24px 28px;
            margin-bottom: 10px;
            box-shadow: 
                0 8px 32px rgba(0, 0, 0, 0.08),
                0 4px 16px rgba(0, 0, 0, 0.04),
                inset 0 1px 0 rgba(255, 255, 255, 0.9),
                        inset 0 -1px 0 rgba(0, 0, 0, 0.02);
            border: 1px solid rgba(255, 255, 255, 0.6);
            position: relative;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
        }
        
        .modern-dashboard-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, 
                #667eea 0%, 
                #764ba2 25%,
                #f093fb 50%,
                #f5576c 75%,
                #667eea 100%);
            background-size: 200% 100%;
            opacity: 1;
            transform: scaleX(1);
            transform-origin: left;
            animation: gradientShift 3s ease infinite;
        }
        
        .modern-dashboard-header::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(102, 126, 234, 0.1) 0%, transparent 70%);
            opacity: 0;
            transition: opacity var(--transition-base);
            pointer-events: none;
        }

        .modern-dashboard-header:hover {
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 1) 0%, 
                rgba(255, 255, 255, 0.98) 50%,
                rgba(255, 255, 255, 1) 100%);
            border-color: rgba(102, 126, 234, 0.3);
            box-shadow: 
                0 12px 48px rgba(0, 0, 0, 0.12),
                0 6px 24px rgba(102, 126, 234, 0.15),
                inset 0 1px 0 rgba(255, 255, 255, 1),
                inset 0 -1px 0 rgba(0, 0, 0, 0.03);
            transform: translateY(-2px);
        }
        
        .modern-dashboard-header:hover::after {
            opacity: 0.6;
        }

        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 16px;
        }

        .header-left {
            flex: 1;
            min-width: 300px;
        }

        .welcome-section {
            margin-bottom: 0;
        }

        .business-name {
            font-size: 2.2rem;
            font-weight: 900;
            line-height: 1.15;
            background: linear-gradient(135deg, 
                #667eea 0%, 
                #764ba2 30%,
                #f093fb 60%,
                #f5576c 100%);
            background-size: 200% 200%;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin: 0 0 8px 0;
            font-family: 'Inter', 'Segoe UI', system-ui, sans-serif;
            letter-spacing: -0.5px;
            animation: gradientShift 6s ease infinite;
            position: relative;
            display: inline-block;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            text-shadow: 0 2px 4px rgba(102, 126, 234, 0.1);
        }
        
        .business-name:hover {
            transform: translateY(-1px);
            filter: brightness(1.15);
            animation-duration: 3s;
        }

        .welcome-message {
            font-size: 1rem;
            font-weight: 500;
            color: #64748b;
            margin: 0;
            line-height: 1.5;
            opacity: 0.95;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        
        .welcome-message::before {
            content: '👋';
            font-size: 1.1rem;
            animation: wave 2s ease-in-out infinite;
        }
        
        @keyframes wave {
            0%, 100% { transform: rotate(0deg); }
            25% { transform: rotate(20deg); }
            75% { transform: rotate(-20deg); }
        }

        .location-selector {
            margin-top: 10px;
        }

        .modern-select {
            border-radius: 12px;
            border: 1px solid rgba(100, 116, 139, 0.2);
            padding: 12px 16px;
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }

        .modern-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
        }

        .header-right {
            display: flex;
            align-items: center;
        }

        .modern-filter-btn {
            background: linear-gradient(135deg, 
                #667eea 0%, 
                #764ba2 50%,
                #f093fb 100%);
            color: white;
            border: none;
            border-radius: 14px;
            padding: 12px 24px;
            font-size: 0.9rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 
                0 4px 16px rgba(102, 126, 234, 0.35),
                0 2px 8px rgba(118, 75, 162, 0.25),
                inset 0 1px 0 rgba(255, 255, 255, 0.2);
            position: relative;
            overflow: hidden;
            letter-spacing: 0.3px;
        }

        .modern-filter-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, 
                transparent, 
                rgba(255, 255, 255, 0.4), 
                transparent);
            transition: left 0.6s ease;
        }

        .modern-filter-btn:hover {
            background: linear-gradient(135deg, 
                #764ba2 0%, 
                #f093fb 50%,
                #f5576c 100%);
            transform: translateY(-2px);
            box-shadow: 
                0 8px 24px rgba(102, 126, 234, 0.45),
                0 4px 12px rgba(118, 75, 162, 0.35),
                inset 0 1px 0 rgba(255, 255, 255, 0.3),
                0 0 20px rgba(102, 126, 234, 0.3);
        }

        .modern-filter-btn:hover::before {
            left: 100%;
        }

        .modern-filter-btn:active {
            transform: translateY(0);
            box-shadow: 
                0 2px 8px rgba(102, 126, 234, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.2);
        }

        .modern-filter-btn i {
            font-size: 1rem;
            filter: drop-shadow(0 1px 2px rgba(0, 0, 0, 0.1));
        }

        @media (max-width: 768px) {
            .modern-dashboard-header {
                padding: 16px 18px;
                margin-bottom: 8px;
            }

            .business-name {
                font-size: 1.5rem;
                margin-bottom: 4px;
            }

            .welcome-message {
                font-size: 0.85rem;
            }

            .header-content {
                flex-direction: column;
                align-items: stretch;
            }

            .header-right {
                width: 100%;
            }

            .modern-filter-btn {
                width: 100%;
                justify-content: center;
            }
        }

        /* Responsive Typography */
        @media (max-width: 768px) {
            * {
                font-size: 13px;
            }
        }

        @media (max-width: 480px) {
            * {
                font-size: 12px;
            }
        }

        /* Reduce space between dashboard charts */
        .row {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        .col-md-6 {
            padding-left: 8px !important;
            padding-right: 8px !important;
        }
        .card {
            max-width: 100%;
            margin-left: 0;
            margin-right: 0;
        }

        /* Set background color for anchor element with class "cont" */
        a.cont {
            background-color: #ffffff !important;
        }

        /* Set color for font awesome icon for plus circle */
        i.fas.fa-plus-circle {
            color: #20124d !important;
        }

        /* Set color for h3 elements inside anchor elements inside div elements */
        div a h3 {
            color: #000000 !important;
        }

        /* Set color for other font awesome icons */
        i.fas.fa-tasks,
        i.fas.fa-plus-square,
        i.fas.fa-th-large,
        i.fas.fa-cart-plus,
        i.fas.fa-address-book,
        i.fas.fa-users,
        i.fas.fa-minus-circle,
        i.fas.fa-business-time,
        i.fas.fa-cubes,
        i.fas.fa-cogs,
        i.fas.fa-money-check-alt,
        i.fas.fa-chart-line,
        i.fab.fa-whatsapp,
        i.fas.fa-print,
        i.fas.fa-shopping-bag,
        i.fas.fa-map-marked-alt,

        i.fas.fa-hdd,
        i.fas.fa-cog {
            /* color: #20124d !important; */
        }

        .parent-box {
            border: 1px solid #40485b;
            height: 200px;
            background: white;
            padding-top: 30px;
            color: #40485b;
            text-align: center;
        }

        .parent-box i {
            font-size: 40px;
        }

        .box-icon {
            color: #40485b !important;
            background: white !important;
            text-align: center;
            border: none;

        }

        .cont {
            background: white !important;
            border-radius: 20px !important;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08) !important;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
            border: 1px solid #e2e8f0 !important;
            overflow: hidden !important;
            position: relative;
            display: flex !important;
            flex-direction: column !important;
            height: 100% !important;
            min-height: 180px !important;
        }

        .cont::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(0, 198, 255, 0.1) 0%, rgba(0, 114, 255, 0.1) 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .cont::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #00c6ff, #0072ff);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .cont:hover {
            transform: translateY(-5px) !important;
            box-shadow: 0 12px 30px rgba(0,0,0,0.12) !important;
        }

        .cont:hover::before {
            opacity: 1;
        }

        .cont:hover::after {
            opacity: 1;
        }

        .cont h2 {
            margin: 0 !important;
            padding: 2rem 1.5rem !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            background: #f8fafc !important;
            position: relative;
            z-index: 1;
        }

        .cont h2::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(0, 198, 255, 0.05) 0%, rgba(0, 114, 255, 0.05) 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .cont:hover h2::before {
            opacity: 1;
        }

        .cont h2 img {
            width: 60px !important;
            height: 60px !important;
            transition: all 0.3s ease !important;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,0.1));
            position: relative;
            z-index: 1;
        }

        .cont:hover h2 img {
            transform: scale(1.1) rotate(5deg) !important;
        }

        .cont h3 {
            margin: 0 !important;
            padding: 1.5rem !important;
            text-align: center !important;
            font-size: 1.1rem !important;
            font-weight: 600 !important;
            color: #1e293b !important;
            background: white !important;
            border-top: 1px solid #e2e8f0 !important;
            position: relative;
            z-index: 1;
            flex-grow: 1;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .cont h3::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(0, 198, 255, 0.05) 0%, rgba(0, 114, 255, 0.05) 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .cont:hover h3::before {
            opacity: 1;
        }

        /* Add ripple effect */
        .cont {
            position: relative;
            overflow: hidden;
        }

        .cont::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 5px;
            height: 5px;
            background: rgba(255, 255, 255, 0.5);
            opacity: 0;
            border-radius: 100%;
            transform: scale(1, 1) translate(-50%);
            transform-origin: 50% 50%;
        }

        .cont:focus:not(:active)::after {
            animation: ripple 1s ease-out;
        }

        @keyframes ripple {
            0% {
                transform: scale(0, 0);
                opacity: 0.5;
            }
            100% {
                transform: scale(100, 100);
                opacity: 0;
            }
        }

        /* Add hover state for the entire button */
        .cont:hover {
            cursor: pointer;
        }

        .cont:hover h3 {
            color: #0072ff;
        }

        /* Add active state */
        .cont:active {
            transform: translateY(-2px) !important;
            box-shadow: 0 8px 20px rgba(0,0,0,0.1) !important;
        }

        /* Improve mobile responsiveness */
        @media (max-width: 768px) {
            .cont {
                min-height: 160px !important;
            }
            
            .cont h2 {
                padding: 1.5rem 1rem !important;
            }
            
            .cont h2 img {
                width: 50px !important;
                height: 50px !important;
            }
            
            .cont h3 {
                padding: 1rem !important;
                font-size: 1rem !important;
            }
        }

        .to-go {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .to-go h4 {
            margin: 0;
        }

        .to-go a {
            margin-left: 10px;
        }

        /* Fade animation */
        .fade-in {
            opacity: 0;
            animation: fadeAnimation 1s ease-in-out forwards;
        }

        @keyframes fadeAnimation {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        h4 {
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 18px;
            padding: 10px;
            background-color: #18466f;
            border-radius: 10px;
            max-width: 200px;
            margin: 0 auto;
            margin-top: 50px;
        }

        h4 i {
            margin-right: 5px;
        }

        h4:hover {
            background-color: #002e5a;
            cursor: pointer;
        }

        .info-box {
            background: linear-gradient(to bottom, rgb(244, 245, 246) 0%, rgb(244, 245, 246) 50%, rgb(244, 245, 246) 100%);
            border-radius: 10px;
            padding: 15px;
            transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out, background 0.3s ease-in-out;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            color: #ffffff;
            cursor: pointer;
            width: 95%;
            max-width: 500px;
            margin: 5px;
        }

        .icon-bg {
            width: 54px;
            height: 54px;
            border-radius: 16px;
            background: var(--accent-color, #6366f1);
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 18px rgba(99,102,241,0.18);
            margin-top: 1.2rem;
            margin-bottom: 1.1rem;
            transition: box-shadow 0.18s, background 0.18s;
        }
        .icon-bg img {
            width: 32px;
            height: 32px;
            filter: brightness(10) grayscale(1) invert(1);
        }
        .glass-card:hover .icon-bg {
            box-shadow: 0 8px 32px 0 rgba(99,102,241,0.22), 0 2px 8px rgba(24,49,83,0.10);
        }
    </style>


    <!-- Font Awesome - Load locally first, then CDN fallback for offline support -->
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css?v=' . $asset_v), false); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/fontawesome/all.min.css'), false); ?>" onerror="this.onerror=null; this.href='<?php echo e(asset('css/cdn/font-awesome-all.min.css'), false); ?>';">
    <link rel="stylesheet" href="<?php echo e(asset('css/cdn/font-awesome-all.min.css'), false); ?>" media="print" onload="this.media='all'" onerror="this.onerror=null; this.remove();">

    <style>
        /* Base Styles */
        .card {
            background: #fff;
            border-radius: 8px;
            padding: 12px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            margin-bottom: 15px;
        }

        /* Hover Effect */
        /* .card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 45px rgba(0, 0, 0, 0.15);
            background: rgba(255, 255, 255, 0.95);
        } */

        /* Image Container */
        .image-container {
            flex: 0 0 220px;
            position: relative;
            border-radius: 18px;
            overflow: hidden;
            transform: translateZ(30px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.08);
            transition: transform 0.4s ease;
        }

        .image-container img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.4s ease;
        }

        .image-container:hover {
            transform: translateZ(40px) rotate(-2deg);
        }

        .image-container:hover img {
            transform: scale(1.05);
        }

        /* Content Section */
        .content {
            flex: 2;
            min-width: 280px;
            padding: 15px;
        }

        h2 {
            font-size: 2.2rem;
            margin: 0 0 15px 0;
            font-weight: 500;
            background: linear-gradient(45deg, #2d3436, #576574);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            line-height: 1.2;
        }

        p {
            font-size: 1.1rem;
            line-height: 1.6;
            margin: 0 0 25px 0;
            color: #555;
            opacity: 0.95;
        }

        /* Interactive Buttons */
        .btn-group {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            padding: 14px 28px;
            border-radius: 14px;
            font-size: 1rem;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(8px);
            border: 1px solid rgba(0, 0, 0, 0.08);
            position: relative;
            overflow: hidden;
        }

        .btn::before {
            content: "";
            position: absolute;
            inset: 0;
            background: rgba(255, 255, 255, 0.15);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .btn:hover::before {
            opacity: 1;
        }

        .btn-launch {
            background: rgba(255, 255, 255, 0.7);
            color: #2d3436;
        }

        /* WhatsApp Button */
        .btn-chat {
            background: #25D366;
            color: white;
            display: flex;
            align-items: center;
            gap: 8px;  /* Space between icon and text */
            font-size: 1.1rem;
            font-weight: bold;
        }

        .btn-chat:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.12);
        }

        /* WhatsApp Icon */
        .btn-chat i {
            font-size: 1.4rem;
        }

        /* Floating Icon */
        .floating-icon {
            position: absolute;
            top: -30px;
            right: -30px;
            width: 120px;
            height: 120px;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 50%;
            backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: #2d3436;
            opacity: 0.8;
        }
    </style>
    </head>
    <body>

    











    <?php
        $is_admin = auth()
            ->user()
            ->hasRole('Admin#' . session('business.id'))
            ? true
            : false;
    ?>


    <div
        class="tw-pb-6 tw-from-<?php if(!empty(session('business.theme_color'))): ?> <?php echo e(session('business.theme_color'), false); ?><?php else: ?><?php echo e('primary', false); ?> <?php endif; ?>-800 tw-to-<?php if(!empty(session('business.theme_color'))): ?> <?php echo e(session('business.theme_color'), false); ?><?php else: ?><?php echo e('primary', false); ?> <?php endif; ?>-900 xl:tw-pb-0 ">

        <div class="dashboard-container">
            <!---quick menu dashbaord---->
            <div class="dashboard-wrapper">
                <?php if($is_admin): ?>
                    <div class="modern-dashboard-header">
                        <div class="header-content">
                            <div class="header-left">
                                <div class="welcome-section">
                                    <h1 class="business-name">
                                        <?php echo e(Session::get('business.name'), false); ?>

                                    </h1>
                                    <p class="welcome-message">
                                        <?php echo e(__('home.welcome_message', ['name' => Session::get('user.first_name')]), false); ?>

                                    </p>
                            </div>
                            <?php if(count($all_locations) > 1): ?>
                                    <div class="location-selector">
                                <?php echo Form::select('dashboard_location', $all_locations, null, [
                                            'class' => 'form-control select2 modern-select',
                                    'placeholder' => __('lang_v1.select_location'),
                                    'id' => 'dashboard_location',
                                ]); ?>

                                    </div>
                            <?php endif; ?>
                        </div>
                            <div class="header-right">
                                <button id="dashboard_date_filter" class="modern-filter-btn">
                                    <i class="fa-solid fa-filter"></i>
                                        <span><?php echo e(__('lang_v1.filter'), false); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>



                    <!-- Dashboard Content Wrapper -->
                    <div class="dashboard-content-wrapper">
                        <!-- Left Column - Metrics -->
                        <div class="dashboard-left-column">
                    <!-- Modern Metrics Grid -->
                    <div class="modern-metrics-grid">
                        <!-- Sales Section -->
                        <div class="modern-metric-card sales-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper sales-icon">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                                </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('home.total_sell'), false); ?></span>
                                <span class="metric-value total_sell">
                                        <i class="fas fa-sync fa-spin fa-fw"></i>
                                    </span>
                                </div>
                            <div class="metric-glow"></div>
                            </div>

                        <!-- Net Section -->
                        <div class="modern-metric-card net-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper net-icon">
                                    <i class="fa-solid fa-chart-line"></i>
                                </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('lang_v1.net'), false); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.net_home_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?></span>
                                <span class="metric-value net">
                                    <i class="fas fa-sync fa-spin fa-fw"></i>
                                </span>
                            </div>
                            <div class="metric-glow"></div>
                        </div>

                        <!-- Invoice Due Section -->
                        <div class="modern-metric-card invoice-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper invoice-icon">
                                    <i class="fa-solid fa-file-invoice-dollar"></i>
                                    </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                                </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('home.invoice_due'), false); ?></span>
                                <span class="metric-value invoice_due">
                                        <i class="fas fa-sync fa-spin fa-fw"></i>
                                    </span>
                                </div>
                            <div class="metric-glow"></div>
                            </div>

                        <!-- Return Section -->
                        <div class="modern-metric-card return-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper return-icon">
                                    <i class="fa-solid fa-rotate-left"></i>
                                </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('lang_v1.total_sell_return'), false); ?></span>
                                <span class="metric-value total_sell_return">
                                    <i class="fas fa-sync fa-spin fa-fw"></i>
                                </span>
                            </div>
                            <div class="metric-glow"></div>
                        </div>

                        <!-- Purchase Section -->
                        <div class="modern-metric-card purchase-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper purchase-icon">
                                    <i class="fa-solid fa-shopping-cart"></i>
                                    </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                                </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('home.total_purchase'), false); ?></span>
                                <span class="metric-value total_purchase">
                                        <i class="fas fa-sync fa-spin fa-fw"></i>
                                    </span>
                                </div>
                            <div class="metric-glow"></div>
                            </div>

                        <!-- Purchase Due Section -->
                        <div class="modern-metric-card due-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper due-icon">
                                    <i class="fa-solid fa-calendar-times"></i>
                                </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('home.purchase_due'), false); ?></span>
                                <span class="metric-value purchase_due">
                                    <i class="fas fa-sync fa-spin fa-fw"></i>
                                </span>
                            </div>
                            <div class="metric-glow"></div>
                        </div>

                        <!-- Expense Section -->
                        <div class="modern-metric-card expense-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper expense-icon">
                                    <i class="fa-solid fa-wallet"></i>
                                    </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                                </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('lang_v1.expense'), false); ?></span>
                                <span class="metric-value total_expense">
                                        <i class="fas fa-sync fa-spin fa-fw"></i>
                                    </span>
                                </div>
                            <div class="metric-glow"></div>
                            </div>

                        <!-- Purchase Return Section -->
                        <div class="modern-metric-card purchase-return-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper purchase-return-icon">
                                    <i class="fa-solid fa-rotate-left"></i>
                        </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                                                    </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('lang_v1.total_purchase_return'), false); ?></span>
                                <span class="metric-value total_purchase_return">
                                    <i class="fas fa-sync fa-spin fa-fw"></i>
                                </span>
                                                </div>
                            <div class="metric-glow"></div>
                        </div>
                    </div>

                    <!-- Additional KPIs Section -->
                    <div class="modern-metrics-grid additional-kpis">
                        <!-- Profit Margin -->
                        <div class="modern-metric-card profit-margin-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper profit-margin-icon">
                                    <i class="fa-solid fa-percent"></i>
                                </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label">Profit Margin</span>
                                <span class="metric-value profit_margin">
                                    <?php echo e(number_format($profit_margin ?? 0, 2), false); ?>%
                                                    </span>
                                                </div>
                            <div class="metric-glow"></div>
                                            </div>

                        <!-- Average Order Value -->
                        <div class="modern-metric-card aov-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper aov-icon">
                                    <i class="fa-solid fa-receipt"></i>
                                </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('lang_v1.average_order_value') ?: __('home.average_order_value') ?: 'Average Order Value', false); ?></span>
                                <span class="metric-value average_order_value">
                                    <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($average_order_value ?? 0, 2), false); ?></span>
                                </span>
                            </div>
                            <div class="metric-glow"></div>
                                        </div>

                        <!-- Growth Rate -->
                        <div class="modern-metric-card growth-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper growth-icon">
                                    <i class="fa-solid fa-arrow-trend-up"></i>
                                                    </div>
                                <span class="metric-badge"><?php echo e(__('lang_v1.vs_yesterday') ?: 'vs Yesterday', false); ?></span>
                                                </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('lang_v1.growth_rate') ?: __('home.growth_rate') ?: 'Growth Rate', false); ?></span>
                                <span class="metric-value growth_rate <?php echo e(($growth_rate ?? 0) >= 0 ? 'positive' : 'negative', false); ?>">
                                    <?php echo e(($growth_rate ?? 0) >= 0 ? '+' : '', false); ?><?php echo e(number_format($growth_rate ?? 0, 2), false); ?>%
                                                    </span>
                                                </div>
                            <div class="metric-glow"></div>
                                            </div>

                        <!-- Total Customers -->
                        <div class="modern-metric-card customers-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper customers-icon">
                                    <i class="fa-solid fa-users"></i>
                                </div>
                                <span class="metric-badge"><?php echo e(__('lang_v1.total') ?: 'Total', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('home.total_customers') ?: __('lang_v1.total_customers') ?: 'Total Customers', false); ?></span>
                                <span class="metric-value total_customers">
                                    <?php echo e(number_format($total_customers ?? 0), false); ?>

                                </span>
                            </div>
                            <div class="metric-glow"></div>
                                        </div>

                        <!-- Total Products -->
                        <div class="modern-metric-card products-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper products-icon">
                                    <i class="fa-solid fa-box"></i>
                                                    </div>
                                <span class="metric-badge"><?php echo e(__('lang_v1.total') ?: 'Total', false); ?></span>
                                                </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('home.total_products') ?: __('lang_v1.total_products') ?: 'Total Products', false); ?></span>
                                <span class="metric-value total_products">
                                    <?php echo e(number_format($total_products ?? 0), false); ?>

                                                    </span>
                                                </div>
                            <div class="metric-glow"></div>
                                            </div>

                        <!-- Total Transactions -->
                        <div class="modern-metric-card transactions-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper transactions-icon">
                                    <i class="fa-solid fa-list-check"></i>
                                </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label"><?php echo e(__('home.total_transactions') ?: __('lang_v1.total_transactions') ?: 'Total Transactions', false); ?></span>
                                <span class="metric-value total_transactions_today">
                                    <?php echo e(number_format($total_transactions_today ?? 0), false); ?>

                                </span>
                            </div>
                            <div class="metric-glow"></div>
                                        </div>

                        <!-- Cash Sales -->
                        <div class="modern-metric-card cash-sales-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper cash-sales-icon">
                                    <i class="fa-solid fa-money-bill-wave"></i>
                                                    </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                                                </div>
                            <div class="metric-content">
                                <span class="metric-label">Cash Sales</span>
                                <span class="metric-value cash_sales">
                                    <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($cash_sales ?? 0, 2), false); ?></span>
                                                    </span>
                                                </div>
                            <div class="metric-glow"></div>
                                            </div>

                        <!-- Credit Sales -->
                        <div class="modern-metric-card credit-sales-card">
                            <div class="metric-header">
                                <div class="metric-icon-wrapper credit-sales-icon">
                                    <i class="fa-solid fa-credit-card"></i>
                                </div>
                                <span class="metric-badge" data-update-date="true"><?php echo e(__('lang_v1.today') ?: 'Today', false); ?></span>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label">Credit Sales</span>
                                <span class="metric-value credit_sales">
                                    <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($credit_sales ?? 0, 2), false); ?></span>
                                </span>
                            </div>
                            <div class="metric-glow"></div>
                                        </div>
                    </div>
                        </div>
                        <!-- Right Column - Last Invoice -->
                        <div class="dashboard-right-column">
                    <!-- Last Invoice Section -->
                    <div class="modern-last-invoice-section">
                        <div class="last-invoice-header">
                            <div class="last-invoice-icon-wrapper">
                                <i class="fa-solid fa-file-invoice"></i>
                            </div>
                            <h3 class="last-invoice-title">Last Invoice</h3>
                        </div>
                        <div class="last-invoice-table-wrapper">
                            <table class="last-invoice-table">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Invoice Number</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $business_id = session('business.id');
                                        $location_id = session()->get('user.selected_location_id');
                                        $permitted_locations = auth()->user()->permitted_locations();
                                        
                                        $query = \DB::table('transactions')
                                            ->where('business_id', $business_id)
                                            ->where('type', 'sell')
                                            ->where('status', 'final');
                                        
                                        if ($permitted_locations != 'all') {
                                            $query->whereIn('location_id', $permitted_locations);
                                        } elseif (!empty($location_id)) {
                                            $query->where('location_id', $location_id);
                                        }
                                        
                                        $last_invoices = $query->orderBy('created_at', 'desc')
                                            ->limit(10)
                                            ->select('invoice_no', 'final_total', 'created_at')
                                            ->get();
                                    ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $last_invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($index + 1, false); ?></td>
                                            <td><?php echo e($invoice->invoice_no ?? 'N/A', false); ?></td>
                                            <td>
                                                <span class="display_currency" data-currency_symbol="true">
                                                    <?php echo e(number_format($invoice->final_total ?? 0, 2), false); ?>

                                                </span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="3" class="text-center">No invoices found</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                                        </div>
                    </div>

                    <!-- Business Statistics Section -->
                    <div class="modern-statistics-section">
                        <div class="statistics-header">
                            <div class="statistics-icon-wrapper">
                                <i class="fa-solid fa-chart-pie"></i>
                                    </div>
                            <h3 class="statistics-title">
                                        <?php echo e(__('home.business_statistics'), false); ?>

                                    </h3>
            </div>

                        <!-- First Row: 3 Cards -->
                        <div class="charts-grid-row-1">
                            <!-- Sales vs Purchase Chart -->
                            <div class="modern-chart-card">
                                <div class="chart-header">
                                    <div class="chart-header-icon-wrapper" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                        <i class="fa-solid fa-chart-pie"></i>
                                            </div>
                                    <div class="chart-title-wrapper">
                                        <h5 style="margin: 0; font-size: 1.1rem; font-weight: 700;"><?php echo e(__('home.sales_vs_purchase'), false); ?></h5>
                                        <span class="chart-subtitle"><?php echo e(__('lang_v1.revenue_breakdown') ?: 'Revenue Breakdown', false); ?></span>
                                        </div>
                                    </div>
                                <div class="chart-body">
                                    <canvas id="salesVsPurchaseChart"></canvas>
                                            </div>
                                        </div>
                            <!-- Invoice Due vs Purchase Due Pie Chart -->
                            <div class="modern-chart-card">
                                <div class="chart-header">
                                    <div class="chart-header-icon-wrapper" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                                        <i class="fa-solid fa-file-invoice-dollar"></i>
        </div>
                                    <div class="chart-title-wrapper">
                                        <h5 style="margin: 0; font-size: 1.1rem; font-weight: 700;"><?php echo e(__('lang_v1.invoice_due_vs_purchase_due') ?: __('home.invoice_due_vs_purchase_due') ?: 'Invoice Due vs Purchase Due', false); ?></h5>
                                        <span class="chart-subtitle"><?php echo e(__('lang_v1.outstanding_payments') ?: 'Outstanding Payments', false); ?></span>
                </div>
            </div>
                                <div class="chart-body">
                                    <canvas id="invoiceVsPurchaseDueChart"></canvas>
                                </div>
                            </div>
                            <!-- Net vs Expense Pie Chart -->
                            <div class="modern-chart-card">
                                <div class="chart-header">
                                    <div class="chart-header-icon-wrapper" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                                        <i class="fa-solid fa-chart-line"></i>
                                    </div>
                                    <div class="chart-title-wrapper">
                                        <h5 style="margin: 0; font-size: 1.1rem; font-weight: 700;"><?php echo e(__('lang_v1.net_vs_expense') ?: __('home.net_vs_expense') ?: 'Net vs Expense', false); ?></h5>
                                        <span class="chart-subtitle"><?php echo e(__('lang_v1.profit_analysis') ?: 'Profit Analysis', false); ?></span>
                                    </div>
                                </div>
                                <div class="chart-body">
                                    <canvas id="netVsExpenseChart"></canvas>
            </div>
        </div>
    </div>

                        <!-- Second Row: 3 Cards -->
                        <div class="charts-grid-row-2">
                            <!-- Cash vs Credit Sales Chart -->
                            <div class="modern-chart-card">
                                <div class="chart-header">
                                    <div class="chart-header-icon-wrapper" style="background: linear-gradient(135deg, #22c55e 0%, #4ade80 100%);">
                                        <i class="fa-solid fa-money-bill-wave"></i>
                                            </div>
                                    <div class="chart-title-wrapper">
                                        <h5 style="margin: 0; font-size: 1.1rem; font-weight: 700;"><?php echo e(__('lang_v1.cash_vs_credit_sales') ?: __('home.cash_vs_credit_sales') ?: 'Cash vs Credit Sales', false); ?></h5>
                                        <span class="chart-subtitle"><?php echo e(__('lang_v1.payment_methods') ?: 'Payment Methods', false); ?></span>
                                        </div>
                                    </div>
                                <div class="chart-body">
                                    <canvas id="cashVsCreditChart"></canvas>
                                            </div>
                                        </div>
                            <!-- Revenue Distribution Chart -->
                            <div class="modern-chart-card">
                                <div class="chart-header">
                                    <div class="chart-header-icon-wrapper" style="background: linear-gradient(135deg, #8b5cf6 0%, #a78bfa 100%);">
                                        <i class="fa-solid fa-chart-pie"></i>
                                    </div>
                                    <div class="chart-title-wrapper">
                                        <h5 style="margin: 0; font-size: 1.1rem; font-weight: 700;"><?php echo e(__('lang_v1.revenue_distribution') ?: __('home.revenue_distribution') ?: 'Revenue Distribution', false); ?></h5>
                                        <span class="chart-subtitle"><?php echo e(__('lang_v1.income_sources') ?: 'Income Sources', false); ?></span>
                                                </div>
                                            </div>
                                <div class="chart-body">
                                    <canvas id="revenueDistributionChart"></canvas>
                                        </div>
                    </div>
                            <!-- Profit Margin Trend Chart -->
                            <div class="modern-chart-card">
                                <div class="chart-header">
                                    <div class="chart-header-icon-wrapper" style="background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%);">
                                        <i class="fa-solid fa-chart-area"></i>
                                    </div>
                                    <div class="chart-title-wrapper">
                                        <h5 style="margin: 0; font-size: 1.1rem; font-weight: 700;"><?php echo e(__('lang_v1.profit_margin_trend') ?: __('home.profit_margin_trend') ?: 'Profit Margin Trend', false); ?></h5>
                                        <span class="chart-subtitle"><?php echo e(__('home.monthly_performance'), false); ?></span>
                                    </div>
                                </div>
                                <div class="chart-body">
                                    <canvas id="profitMarginChart"></canvas>
                                </div>
                            </div>
                                </div>

                        <div class="charts-grid-large">
                            <!-- Monthly Performance Chart -->
                            <div class="modern-chart-card large">
                                <div class="chart-header">
                                    <h5 class="chart-title"><?php echo e(__('home.monthly_performance'), false); ?></h5>
                                </div>
                                <div class="chart-body">
                                    <canvas id="monthlyPerformanceChart"></canvas>
                                </div>
                            </div>
                            <!-- Monthly Expenses Chart -->
                            <div class="modern-chart-card large">
                                <div class="chart-header">
                                    <h5 class="chart-title"><?php echo e(__('home.expenses_by_month') ?: __('lang_v1.expenses_by_month') ?: 'Expenses by Month', false); ?></h5>
                                </div>
                                <div class="chart-body">
                                    <canvas id="monthlyExpensesChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modern Sales Charts Section -->
                    <div class="modern-sales-charts-section">
                        <!-- Sales Last 30 Days Chart -->
                        <div class="modern-chart-wrapper">
                            <div class="modern-chart-header">
                                <div class="chart-header-icon">
                                    <i class="fa-solid fa-chart-line"></i>
                                </div>
                                <h3 class="modern-chart-title">
                                    <?php echo e(__('home.sells_last_30_days'), false); ?>

                                </h3>
                            </div>
                            <div class="modern-chart-container">
                                        <?php echo $sells_chart_1->container(); ?>


                                                </div>
                        </div>

                        <!-- Sales Current FY Chart -->
                        <div class="modern-chart-wrapper">
                            <div class="modern-chart-header">
                                <div class="chart-header-icon">
                                    <i class="fa-solid fa-chart-area"></i>
                                </div>
                                <h3 class="modern-chart-title">
                                                    <?php echo e(__('home.sells_current_fy'), false); ?>

                                                </h3>
                                            </div>
                            <div class="modern-chart-container">
                                                        <?php echo $sells_chart_2->container(); ?>

                            </div>
                        </div>
                    </div>

                    <div class="row" style="background: transparent; margin: 0; padding: 0;">
                                        <!-- Purchase -->
                                        
                                    </div>

                    <div class="row" style="background: transparent; margin: 0; padding: 0;">
                                      

                    <style>
                        /* Dashboard Content Wrapper - Two Column Layout - Pixel Perfect */
                        .dashboard-content-wrapper {
                            display: flex;
                            gap: 20px;
                            align-items: flex-start;
                            margin-top: 20px;
                            margin-bottom: 30px;
                            position: relative;
                            width: 100%;
                            max-width: 100%;
                            box-sizing: border-box;
                        }

                        .dashboard-left-column {
                            flex: 1;
                            min-width: 0;
                            width: 100%;
                            max-width: 100%;
                            box-sizing: border-box;
                        }

                        .dashboard-right-column {
                            width: 380px;
                            flex-shrink: 0;
                            position: sticky;
                            top: 20px;
                            align-self: flex-start;
                            max-height: calc(100vh - 100px);
                            overflow: visible;
                            box-sizing: border-box;
                        }

                        @media (max-width: 1400px) {
                            .dashboard-content-wrapper {
                                flex-direction: column;
                            }

                            .dashboard-right-column {
                                width: 100%;
                                position: relative;
                                top: 0;
                            }
                        }

                        /* Modern Metric Cards - 4x4 Grid - Pixel Perfect */
                        .modern-metrics-grid {
                            display: grid;
                            grid-template-columns: repeat(4, 1fr);
                            gap: 10px;
                            margin-bottom: 10px;
                            padding: 0;
                            padding-right: 12px;
                            justify-content: start;
                            width: 100%;
                            max-width: 100%;
                            box-sizing: border-box;
                        }

                        .modern-metric-card {
                            background: linear-gradient(135deg, 
                                rgba(255, 255, 255, 0.95) 0%, 
                                rgba(255, 255, 255, 0.9) 50%,
                                rgba(255, 255, 255, 0.95) 100%);
                            backdrop-filter: blur(32px) saturate(200%);
                            -webkit-backdrop-filter: blur(32px) saturate(200%);
                            border-radius: 14px;
                            padding: 14px 18px;
                            position: relative;
                            overflow: hidden;
                            border: 1px solid rgba(255, 255, 255, 0.4);
                            box-shadow: 
                                0 4px 20px rgba(0, 0, 0, 0.06),
                                0 2px 8px rgba(0, 0, 0, 0.04),
                                inset 0 1px 0 rgba(255, 255, 255, 0.8),
                                inset 0 -1px 0 rgba(0, 0, 0, 0.02);
                            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
                            cursor: pointer;
                            min-height: 100px;
                            height: auto;
                            width: 100%;
                            max-width: 100%;
                            display: flex;
                            flex-direction: column;
                            will-change: transform, box-shadow;
                            box-sizing: border-box;
                        }
                        
                        .modern-metric-card::after {
                            content: '';
                            position: absolute;
                            top: 0;
                            left: 0;
                            right: 0;
                            bottom: 0;
                            background: 
                                radial-gradient(circle at 20% 30%, rgba(102, 126, 234, 0.03) 0%, transparent 50%),
                                radial-gradient(circle at 80% 70%, rgba(118, 75, 162, 0.03) 0%, transparent 50%);
                            opacity: 0;
                            transition: opacity 0.4s ease;
                            pointer-events: none;
                            z-index: 0;
                        }

                        .modern-metric-card::before {
                            content: '';
                            position: absolute;
                            top: 0;
                            left: 0;
                            right: 0;
                            height: 5px;
                            background: linear-gradient(90deg, 
                                #667eea 0%, 
                                #764ba2 50%, 
                                #f093fb 100%);
                            transform: scaleX(0);
                            transform-origin: left;
                            transition: transform 0.5s cubic-bezier(0.4, 0, 0.2, 1);
                            z-index: 2;
                            border-radius: 20px 20px 0 0;
                        }

                        .modern-metric-card:hover {
                            transform: translateY(-12px) scale(1.03);
                            box-shadow: 
                                0 20px 60px rgba(0, 0, 0, 0.12),
                                0 8px 24px rgba(102, 126, 234, 0.15),
                                0 0 0 1px rgba(255, 255, 255, 0.5),
                                inset 0 1px 0 rgba(255, 255, 255, 0.9),
                                inset 0 -1px 0 rgba(0, 0, 0, 0.03);
                            border-color: rgba(102, 126, 234, 0.3);
                            background: linear-gradient(135deg, 
                                rgba(255, 255, 255, 1) 0%, 
                                rgba(255, 255, 255, 0.98) 50%,
                                rgba(255, 255, 255, 1) 100%);
                        }

                        .modern-metric-card:hover::before {
                            transform: scaleX(1);
                        }
                        
                        .modern-metric-card:hover::after {
                            opacity: 1;
                        }
                        
                        .modern-metric-card:active {
                            transform: translateY(-4px) scale(1.01);
                            transition: all var(--transition-fast);
                        }

                        .metric-header {
                            display: flex;
                            justify-content: space-between;
                            align-items: flex-start;
                            margin-bottom: 8px;
                            gap: 8px;
                            z-index: 1;
                        }

                        .metric-icon-wrapper {
                            width: 40px;
                            height: 40px;
                            border-radius: 10px;
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            font-size: 18px;
                            color: white;
                            position: relative;
                            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
                            box-shadow: 
                                0 4px 12px rgba(0, 0, 0, 0.1),
                                0 2px 6px rgba(0, 0, 0, 0.06),
                                inset 0 1px 0 rgba(255, 255, 255, 0.3);
                            z-index: 1;
                            flex-shrink: 0;
                        }
                        
                        .metric-icon-wrapper::before {
                            content: '';
                            position: absolute;
                            inset: 0;
                            border-radius: 16px;
                            background: linear-gradient(135deg, 
                                rgba(255, 255, 255, 0.3) 0%, 
                                rgba(255, 255, 255, 0) 100%);
                            opacity: 0;
                            transition: opacity 0.3s ease;
                        }

                        .modern-metric-card:hover .metric-icon-wrapper {
                            transform: rotate(5deg) scale(1.15);
                            box-shadow: 
                                0 12px 32px rgba(0, 0, 0, 0.2),
                                0 0 40px rgba(102, 126, 234, 0.4),
                                inset 0 1px 0 rgba(255, 255, 255, 0.4);
                            animation: float 3s ease-in-out infinite;
                        }
                        
                        .modern-metric-card:hover .metric-icon-wrapper::before {
                            opacity: 1;
                        }
                        
                        .metric-icon-wrapper::after {
                            content: '';
                            position: absolute;
                            inset: -4px;
                            border-radius: var(--border-radius-md);
                            padding: 2px;
                            background: linear-gradient(135deg, rgba(255, 255, 255, 0.4), rgba(255, 255, 255, 0.1));
                            -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
                            -webkit-mask-composite: xor;
                            mask-composite: exclude;
                            opacity: 0;
                            transition: opacity var(--transition-base);
                        }

                        .modern-metric-card:hover .metric-icon-wrapper::after {
                            opacity: 1;
                        }

                        .purchase-return-icon { background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%); }
                        .profit-margin-icon { background: linear-gradient(135deg, #10b981 0%, #34d399 100%); }
                        .aov-icon { background: linear-gradient(135deg, #8b5cf6 0%, #a78bfa 100%); }
                        .growth-icon { background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%); }
                        .customers-icon { background: linear-gradient(135deg, #3b82f6 0%, #60a5fa 100%); }
                        .products-icon { background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%); }
                        .transactions-icon { background: linear-gradient(135deg, #14b8a6 0%, #5eead4 100%); }
                        .cash-sales-icon { background: linear-gradient(135deg, #22c55e 0%, #4ade80 100%); }
                        .credit-sales-icon { background: linear-gradient(135deg, #6366f1 0%, #818cf8 100%); }

                        .metric-badge {
                            background: linear-gradient(135deg, 
                                rgba(241, 245, 249, 0.9) 0%, 
                                rgba(226, 232, 240, 0.8) 100%);
                            color: #475569;
                            font-size: 9px;
                            font-weight: 700;
                            padding: 4px 10px;
                            border-radius: 8px;
                            backdrop-filter: blur(12px) saturate(180%);
                            -webkit-backdrop-filter: blur(12px) saturate(180%);
                            border: 1px solid rgba(148, 163, 184, 0.2);
                            box-shadow: 
                                0 2px 6px rgba(0, 0, 0, 0.03),
                                inset 0 1px 0 rgba(255, 255, 255, 0.6);
                            text-transform: uppercase;
                            letter-spacing: 0.4px;
                            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                            z-index: 1;
                            white-space: nowrap;
                            flex-shrink: 0;
                        }
                        
                        .modern-metric-card:hover .metric-badge {
                            background: linear-gradient(135deg, 
                                rgba(102, 126, 234, 0.12) 0%, 
                                rgba(118, 75, 162, 0.1) 100%);
                            color: #667eea;
                            border-color: rgba(102, 126, 234, 0.3);
                            transform: translateY(-2px);
                            box-shadow: 
                                0 4px 12px rgba(102, 126, 234, 0.15),
                                inset 0 1px 0 rgba(255, 255, 255, 0.7);
                        }

                        .metric-content {
                            position: relative;
                            z-index: 1;
                            margin-top: auto;
                            padding-top: 2px;
                        }

                        .metric-label {
                            display: block;
                            color: #64748b;
                            font-size: 9px;
                            font-weight: 700;
                            margin-bottom: 4px;
                            text-transform: uppercase;
                            letter-spacing: 0.6px;
                            opacity: 0.85;
                            transition: all 0.3s ease;
                            z-index: 1;
                            line-height: 1.3;
                        }
                        
                        .modern-metric-card:hover .metric-label {
                            color: #475569;
                            opacity: 1;
                        }

                        .metric-value {
                            display: block;
                            color: var(--text-primary);
                            font-size: 24px;
                            font-weight: 900;
                            line-height: 1.1;
                            background: linear-gradient(135deg, 
                                #0f172a 0%, 
                                #1e293b 30%,
                                #334155 60%,
                                #475569 100%);
                            background-size: 200% 200%;
                            -webkit-background-clip: text;
                            -webkit-text-fill-color: transparent;
                            background-clip: text;
                            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
                            letter-spacing: -0.6px;
                            position: relative;
                            z-index: 1;
                        }
                        
                        .metric-value::after {
                            content: '';
                            position: absolute;
                            bottom: -2px;
                            left: 0;
                            width: 0;
                            height: 2px;
                            background: var(--primary-gradient);
                            transition: width var(--transition-slow);
                        }

                        .modern-metric-card:hover .metric-value {
                            transform: scale(1.08);
                            background-position: 100% 50%;
                        }
                        
                        .modern-metric-card:hover .metric-value::after {
                            width: 100%;
                        }

                        .metric-glow {
                            position: absolute;
                            top: -50%;
                            right: -50%;
                            width: 200%;
                            height: 200%;
                            background: radial-gradient(circle, rgba(102, 126, 234, 0.1) 0%, transparent 70%);
                            opacity: 0;
                            transition: opacity 0.4s ease;
                            pointer-events: none;
                        }

                        .modern-metric-card:hover .metric-glow {
                            opacity: 1;
                        }

                        .sales-icon { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
                        .net-icon { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
                        .invoice-icon { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
                        .return-icon { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }
                        .purchase-icon { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
                        .due-icon { background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); }
                        .expense-icon { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }

                        /* Sales Card Specific */
                        .sales-card:hover .metric-glow {
                            background: radial-gradient(circle, rgba(102, 126, 234, 0.15) 0%, transparent 70%);
                        }

                        /* Net Card Specific */
                        .net-card:hover .metric-glow {
                            background: radial-gradient(circle, rgba(17, 153, 142, 0.15) 0%, transparent 70%);
                        }

                        /* Invoice Card Specific */
                        .invoice-card:hover .metric-glow {
                            background: radial-gradient(circle, rgba(240, 147, 251, 0.15) 0%, transparent 70%);
                        }

                        /* Responsive - 4x4 Grid */
                        @media (max-width: 1400px) {
                            .modern-metrics-grid {
                                grid-template-columns: repeat(4, 1fr);
                                padding-right: 12px;
                            }
                        }

                        @media (max-width: 1200px) {
                            .modern-metrics-grid {
                                grid-template-columns: repeat(3, 1fr);
                                padding-right: 12px;
                            }
                        }

                        @media (max-width: 992px) {
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                padding-right: 10px;
                            }
                        }

                        @media (max-width: 768px) {
                            .modern-metrics-grid {
                                grid-template-columns: 1fr;
                                gap: 8px;
                                padding-right: 0;
                            }

                            .modern-metric-card {
                                width: 100%;
                                padding: 12px 16px;
                                min-height: 130px;
                                height: auto;
                            }

                            .metric-icon-wrapper {
                                width: 36px;
                                height: 36px;
                                font-size: 16px;
                            }

                            .metric-value {
                                font-size: 22px;
                            }

                            .metric-header {
                                margin-bottom: 6px;
                                gap: 6px;
                            }

                            .metric-label {
                                margin-bottom: 3px;
                                font-size: 9px;
                            }

                            .metric-badge {
                                font-size: 8px;
                                padding: 3px 8px;
                            }
                        }

                        /* Premium Animations */
                        .modern-metric-card {
                            animation: fadeInUp 0.8s cubic-bezier(0.4, 0, 0.2, 1) backwards;
                        }

                        .modern-metric-card:nth-child(1) { animation-delay: 0.05s; }
                        .modern-metric-card:nth-child(2) { animation-delay: 0.1s; }
                        .modern-metric-card:nth-child(3) { animation-delay: 0.15s; }
                        .modern-metric-card:nth-child(4) { animation-delay: 0.2s; }
                        .modern-metric-card:nth-child(5) { animation-delay: 0.25s; }
                        .modern-metric-card:nth-child(6) { animation-delay: 0.3s; }
                        .modern-metric-card:nth-child(7) { animation-delay: 0.35s; }
                        .modern-metric-card:nth-child(8) { animation-delay: 0.4s; }
                        .modern-metric-card:nth-child(9) { animation-delay: 0.45s; }
                        .modern-metric-card:nth-child(10) { animation-delay: 0.5s; }
                        .modern-metric-card:nth-child(11) { animation-delay: 0.55s; }
                        .modern-metric-card:nth-child(12) { animation-delay: 0.6s; }
                        .modern-metric-card:nth-child(13) { animation-delay: 0.65s; }
                        .modern-metric-card:nth-child(14) { animation-delay: 0.7s; }
                        .modern-metric-card:nth-child(15) { animation-delay: 0.75s; }
                        .modern-metric-card:nth-child(16) { animation-delay: 0.8s; }
                        
                        /* Skeleton Loading State */
                        @keyframes skeleton {
                            0% {
                                background-position: -200px 0;
                            }
                            100% {
                                background-position: calc(200px + 100%) 0;
                            }
                        }
                        
                        .metric-skeleton {
                            background: linear-gradient(
                                90deg,
                                rgba(100, 116, 139, 0.1) 0px,
                                rgba(100, 116, 139, 0.15) 40px,
                                rgba(100, 116, 139, 0.1) 80px
                            );
                            background-size: 200px 100%;
                            animation: skeleton 1.5s ease-in-out infinite;
                            border-radius: var(--border-radius-sm);
                        }
                        
                        /* Premium Scrollbar */
                        ::-webkit-scrollbar {
                            width: 10px;
                            height: 10px;
                        }
                        
                        ::-webkit-scrollbar-track {
                            background: rgba(241, 245, 249, 0.5);
                            border-radius: var(--border-radius-full);
                        }
                        
                        ::-webkit-scrollbar-thumb {
                            background: var(--primary-gradient);
                            border-radius: var(--border-radius-full);
                            border: 2px solid rgba(241, 245, 249, 0.5);
                        }
                        
                        ::-webkit-scrollbar-thumb:hover {
                            background: var(--primary-gradient-hover);
                        }
                        
                        /* Selection Styling */
                        ::selection {
                            background: rgba(102, 126, 234, 0.2);
                            color: var(--text-primary);
                        }
                        
                        ::-moz-selection {
                            background: rgba(102, 126, 234, 0.2);
                            color: var(--text-primary);
                        }

                        /* Additional KPIs Grid - 4 columns */
                        .additional-kpis {
                            margin-top: 10px;
                        }

                        /* Custom Design Implementation */
                        div.modern-dashboard-header {
                            margin-top: -40px;
                        }

                        div.modern-metrics-grid {
                            margin-top: 20px;
                        }

                        div.modern-metric-card.purchase-card {
                            margin-top: 10px;
                        }

                        div.modern-metric-card.due-card {
                            margin-top: 10px;
                        }

                        div.modern-metric-card.expense-card {
                            margin-top: 10px;
                        }

                        div.modern-metric-card.purchase-return-card {
                            margin-top: 10px;
                        }

                        div.modern-metric-card.products-card {
                            margin-top: 10px;
                        }

                        div.modern-metric-card.transactions-card {
                            margin-top: 10px;
                        }

                        div.modern-metric-card.cash-sales-card {
                            margin-top: 10px;
                        }

                        div.modern-metric-card.credit-sales-card {
                            margin-top: 10px;
                        }

                        /* Last Invoice Section */
                        .modern-last-invoice-section {
                            background: linear-gradient(135deg, 
                                rgba(255, 255, 255, 0.95) 0%, 
                                rgba(255, 255, 255, 0.9) 50%,
                                rgba(255, 255, 255, 0.95) 100%);
                            backdrop-filter: blur(32px) saturate(200%);
                            -webkit-backdrop-filter: blur(32px) saturate(200%);
                            border-radius: 16px;
                            padding: 20px;
                            margin-top: 17px;
                            margin-bottom: 20px;
                            border: 1px solid rgba(255, 255, 255, 0.4);
                            box-shadow: 
                                0 4px 20px rgba(0, 0, 0, 0.06),
                                0 2px 8px rgba(0, 0, 0, 0.04),
                                inset 0 1px 0 rgba(255, 255, 255, 0.8),
                                inset 0 -1px 0 rgba(0, 0, 0, 0.02);
                            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
                            display: flex;
                            flex-direction: column;
                            height: auto;
                            min-height: 400px;
                            max-height: calc(100vh - 180px);
                        }

                        .last-invoice-header {
                            display: flex;
                            align-items: center;
                            gap: 12px;
                            margin-bottom: 16px;
                            padding-bottom: 12px;
                            border-bottom: 2px solid rgba(102, 126, 234, 0.1);
                            position: sticky;
                            top: 0;
                            background: linear-gradient(135deg, 
                                rgba(255, 255, 255, 0.98) 0%, 
                                rgba(255, 255, 255, 0.95) 100%);
                            z-index: 10;
                            padding-top: 4px;
                        }

                        .last-invoice-icon-wrapper {
                            width: 48px;
                            height: 48px;
                            border-radius: 12px;
                            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            color: white;
                            font-size: 20px;
                            box-shadow: 
                                0 4px 12px rgba(102, 126, 234, 0.3),
                                0 2px 6px rgba(0, 0, 0, 0.1);
                        }

                        .last-invoice-title {
                            font-size: 1.4rem;
                            font-weight: 700;
                            color: var(--text-primary);
                            margin: 0;
                            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                            -webkit-background-clip: text;
                            -webkit-text-fill-color: transparent;
                            background-clip: text;
                        }

                        .last-invoice-table-wrapper {
                            overflow-x: hidden;
                            overflow-y: auto;
                            width: 100%;
                            flex: 1;
                            min-height: 0;
                        }

                        .last-invoice-table {
                            width: 100%;
                            border-collapse: collapse;
                            background: transparent;
                            table-layout: fixed;
                        }

                        .last-invoice-table thead {
                            background: linear-gradient(135deg, 
                                rgba(102, 126, 234, 0.08) 0%, 
                                rgba(118, 75, 162, 0.06) 100%);
                        }

                        .last-invoice-table th {
                            padding: 10px 12px;
                            text-align: left;
                            font-size: 0.75rem;
                            font-weight: 700;
                            color: #475569;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                            border-bottom: 2px solid rgba(102, 126, 234, 0.2);
                        }

                        .last-invoice-table th:first-child {
                            width: 15%;
                            text-align: center;
                        }

                        .last-invoice-table th:nth-child(2) {
                            width: 50%;
                        }

                        .last-invoice-table th:last-child {
                            width: 35%;
                            text-align: right;
                        }

                        .last-invoice-table tbody tr {
                            border-bottom: 1px solid rgba(148, 163, 184, 0.1);
                            transition: all 0.3s ease;
                        }

                        .last-invoice-table tbody tr:hover {
                            background: linear-gradient(135deg, 
                                rgba(102, 126, 234, 0.04) 0%, 
                                rgba(118, 75, 162, 0.03) 100%);
                            transform: translateX(2px);
                        }

                        .last-invoice-table tbody tr:last-child {
                            border-bottom: none;
                        }

                        .last-invoice-table td {
                            padding: 10px 12px;
                            font-size: 0.85rem;
                            color: var(--text-primary);
                        }

                        .last-invoice-table td:first-child {
                            text-align: center;
                            font-weight: 600;
                            color: #64748b;
                        }

                        .last-invoice-table td:nth-child(2) {
                            font-weight: 500;
                            color: var(--text-primary);
                            word-wrap: break-word;
                            overflow-wrap: break-word;
                            max-width: 0;
                        }

                        .last-invoice-table td:last-child {
                            text-align: right;
                            font-weight: 700;
                            color: #10b981;
                            font-size: 0.9rem;
                        }

                        .last-invoice-table tbody tr .text-center {
                            text-align: center;
                            color: #94a3b8;
                            font-style: italic;
                            padding: 24px;
                        }

                        /* ============================================
                           COMPREHENSIVE RESPONSIVE DESIGN SYSTEM
                           ============================================ */
                        
                        /* Extra Large Devices (Large Desktops, 1400px and up) */
                        @media (min-width: 1400px) {
                            .dashboard-content-wrapper {
                                gap: 24px;
                            }
                            
                            .dashboard-right-column {
                                width: 400px;
                            }
                            
                            .modern-metrics-grid {
                                gap: 12px;
                            }
                        }
                        
                        /* Large Devices (Desktops, 1200px to 1399px) */
                        @media (min-width: 1200px) and (max-width: 1399px) {
                            .modern-metrics-grid {
                                grid-template-columns: repeat(4, 1fr);
                                gap: 10px;
                                padding-right: 12px;
                            }
                            
                            .dashboard-right-column {
                                width: 360px;
                            }
                        }
                        
                        /* Medium Devices (Tablets, 992px to 1199px) */
                        @media (min-width: 992px) and (max-width: 1199px) {
                            .modern-metrics-grid {
                                grid-template-columns: repeat(3, 1fr);
                                gap: 10px;
                                padding-right: 12px;
                            }
                            
                            .modern-metric-card {
                                min-height: 140px;
                                height: 140px;
                            }
                            
                            .dashboard-right-column {
                                width: 340px;
                            }
                            
                            .business-name {
                                font-size: 1.9rem;
                            }
                        }
                        
                        /* Small Devices (Landscape Tablets, 768px to 991px) */
                        @media (min-width: 768px) and (max-width: 991px) {
                            .dashboard-content-wrapper {
                                flex-direction: column;
                                gap: 16px;
                            }
                            
                            .dashboard-right-column {
                                width: 100%;
                                position: relative;
                                top: 0;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 12px;
                            }
                            
                            .modern-metric-card {
                                min-height: 130px;
                                height: 130px;
                                padding: 14px 16px;
                            }
                            
                            .modern-dashboard-header {
                                padding: 20px 22px;
                            }
                            
                            .business-name {
                                font-size: 1.7rem;
                            }
                            
                            .modern-filter-btn {
                                padding: 10px 20px;
                                font-size: 0.85rem;
                            }
                        }
                        
                        /* Extra Small Devices (Portrait Tablets & Large Phones, 576px to 767px) */
                        @media (min-width: 576px) and (max-width: 767px) {
                            .dashboard-content-wrapper {
                                flex-direction: column;
                                gap: 14px;
                                margin-top: 16px;
                                margin-bottom: 20px;
                            }
                            
                            .dashboard-right-column {
                                width: 100%;
                                position: relative;
                                top: 0;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 10px;
                                padding-right: 10px;
                            }
                            
                            .modern-metric-card {
                                width: 100%;
                                min-height: 120px;
                                height: auto;
                                padding: 12px 14px;
                            }
                            
                            .metric-icon-wrapper {
                                width: 38px;
                                height: 38px;
                                font-size: 17px;
                            }
                            
                            .metric-value {
                                font-size: 20px;
                            }
                            
                            .modern-dashboard-header {
                                padding: 18px 20px;
                                margin-bottom: 12px;
                            }
                            
                            .business-name {
                                font-size: 1.6rem;
                                margin-bottom: 6px;
                            }
                            
                            .welcome-message {
                                font-size: 0.9rem;
                            }
                            
                            .modern-filter-btn {
                                padding: 10px 18px;
                                font-size: 0.85rem;
                            }
                            
                            .modern-last-invoice-section {
                                padding: 16px;
                                margin-top: 0;
                                margin-bottom: 16px;
                                max-height: none;
                                min-height: auto;
                            }
                        }
                        
                        /* Mobile Devices (Phones, up to 575px) */
                        @media (max-width: 575px) {
                            .dashboard-content-wrapper {
                                flex-direction: column;
                                gap: 12px;
                                margin-top: 12px;
                                margin-bottom: 16px;
                            }
                            
                            .dashboard-right-column {
                                width: 100%;
                                position: relative;
                                top: 0;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 8px;
                                margin-bottom: 12px;
                                padding-right: 8px;
                            }
                            
                            .modern-metric-card {
                                width: 100%;
                                min-height: 120px;
                                height: auto;
                                padding: 10px 12px;
                                border-radius: 12px;
                            }
                            
                            .metric-icon-wrapper {
                                width: 32px;
                                height: 32px;
                                font-size: 14px;
                                border-radius: 10px;
                            }
                            
                            .metric-value {
                                font-size: 18px;
                            }
                            
                            .metric-header {
                                margin-bottom: 6px;
                                gap: 6px;
                            }
                            
                            .metric-label {
                                margin-bottom: 3px;
                                font-size: 9px;
                            }
                            
                            .metric-badge {
                                font-size: 8px;
                                padding: 3px 8px;
                            }
                            
                            .modern-dashboard-header {
                                padding: 16px 18px;
                                margin-bottom: 12px;
                                border-radius: 16px;
                            }
                            
                            .business-name {
                                font-size: 1.4rem;
                                margin-bottom: 6px;
                                line-height: 1.2;
                            }
                            
                            .welcome-message {
                                font-size: 0.85rem;
                                line-height: 1.4;
                            }
                            
                            .welcome-message::before {
                                font-size: 1rem;
                            }
                            
                            .header-content {
                                flex-direction: column;
                                align-items: stretch;
                                gap: 12px;
                            }
                            
                            .header-left {
                                min-width: auto;
                            }
                            
                            .header-right {
                                width: 100%;
                            }
                            
                            .modern-filter-btn {
                                width: 100%;
                                justify-content: center;
                                padding: 12px 20px;
                                font-size: 0.9rem;
                                border-radius: 12px;
                            }
                            
                            .location-selector {
                                margin-top: 8px;
                            }
                            
                            .modern-select {
                                padding: 10px 14px;
                                font-size: 0.9rem;
                            }
                            
                            .modern-last-invoice-section {
                                padding: 14px;
                                margin-top: 0;
                                margin-bottom: 14px;
                                max-height: none;
                                min-height: auto;
                                border-radius: 14px;
                            }
                            
                            .last-invoice-header {
                                margin-bottom: 12px;
                                padding-bottom: 10px;
                                gap: 10px;
                            }
                            
                            .last-invoice-icon-wrapper {
                                width: 38px;
                                height: 38px;
                                font-size: 17px;
                                border-radius: 10px;
                            }
                            
                            .last-invoice-title {
                                font-size: 1.1rem;
                            }
                            
                            .last-invoice-table th,
                            .last-invoice-table td {
                                padding: 8px 10px;
                                font-size: 0.8rem;
                            }
                            
                            .last-invoice-table th {
                                font-size: 0.7rem;
                                padding: 10px 8px;
                            }
                            
                            .last-invoice-table th:first-child {
                                width: 12%;
                            }
                            
                            .last-invoice-table th:nth-child(2) {
                                width: 55%;
                            }
                            
                            .last-invoice-table th:last-child {
                                width: 33%;
                            }
                        }
                        
                        /* Very Small Devices (Small Phones, up to 375px) */
                        @media (max-width: 375px) {
                            .modern-dashboard-header {
                                padding: 14px 16px;
                            }
                            
                            .business-name {
                                font-size: 1.2rem;
                            }
                            
                            .welcome-message {
                                font-size: 0.8rem;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 6px;
                            }
                            
                            .modern-metric-card {
                                padding: 8px 10px;
                                min-height: 110px;
                            }
                            
                            .metric-icon-wrapper {
                                width: 30px;
                                height: 30px;
                                font-size: 13px;
                            }
                            
                            .metric-value {
                                font-size: 16px;
                            }
                            
                            .metric-label {
                                font-size: 8px;
                            }
                            
                            .metric-badge {
                                font-size: 7px;
                                padding: 2px 6px;
                            }
                            
                            .modern-last-invoice-section {
                                padding: 12px;
                            }
                            
                            .last-invoice-table th,
                            .last-invoice-table td {
                                padding: 6px 8px;
                                font-size: 0.75rem;
                            }
                        }
                        
                        /* Landscape Orientation */
                        @media (max-width: 991px) and (orientation: landscape) {
                            .modern-metrics-grid {
                                grid-template-columns: repeat(3, 1fr);
                            }
                            
                            .modern-metric-card {
                                min-height: 110px;
                            }
                        }
                        
                        /* Touch Device Optimizations */
                        @media (hover: none) and (pointer: coarse) {
                            .modern-metric-card,
                            .modern-filter-btn,
                            .modern-dashboard-header {
                                -webkit-tap-highlight-color: transparent;
                            }
                            
                            .modern-filter-btn {
                                min-height: 44px;
                                min-width: 44px;
                            }
                            
                            .metric-icon-wrapper {
                                min-width: 40px;
                                min-height: 40px;
                            }
                        }
                        
                        /* High DPI Displays */
                        @media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
                            .modern-dashboard-header,
                            .modern-metric-card,
                            .modern-last-invoice-section {
                                border-width: 0.5px;
                            }
                        }
                        
                        /* Container Responsive Styles */
                        .dashboard-container {
                            padding-left: 0 !important;
                            padding-right: 0 !important;
                            padding-top: 12px;
                            margin: 0;
                            width: 100%;
                            max-width: 100%;
                        }
                        
                        .dashboard-wrapper {
                            width: 100%;
                            max-width: 100%;
                            box-sizing: border-box;
                            margin-left: auto;
                            margin-right: auto;
                            margin-top: 20px;
                            padding: 20px 16px;
                            border-radius: 10px 10px 0 0;
                            background: transparent;
                        }
                        
                        @media (max-width: 768px) {
                            .dashboard-container {
                                padding-top: 8px;
                            }
                            
                            .dashboard-wrapper {
                                padding-left: 12px !important;
                                padding-right: 12px !important;
                                padding-top: 16px !important;
                                padding-bottom: 16px !important;
                                margin-top: 12px !important;
                            }
                        }
                        
                        @media (max-width: 575px) {
                            .dashboard-container {
                                padding-top: 6px;
                            }
                            
                            .dashboard-wrapper {
                                padding-left: 10px !important;
                                padding-right: 10px !important;
                                padding-top: 12px !important;
                                padding-bottom: 12px !important;
                                margin-top: 8px !important;
                                border-radius: 8px 8px 0 0 !important;
                            }
                        }
                        
                        @media (max-width: 375px) {
                            .dashboard-wrapper {
                                padding-left: 8px !important;
                                padding-right: 8px !important;
                            }
                        }
                        
                        /* Global Reset & Base Styles - Pixel Perfect */
        * {
            box-sizing: border-box;
        }
        
        html {
            scroll-behavior: smooth;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        
        body {
            overflow-x: hidden;
            max-width: 100vw;
            width: 100%;
            position: relative;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        
        /* Prevent horizontal scroll on all elements */
        img, video, iframe, table {
            max-width: 100%;
            height: auto;
        }
                        
                        /* ============================================
                           PIXEL PERFECT RESPONSIVE OPTIMIZATIONS
                           ============================================ */
                        
                        /* Ultra-wide screens (1920px+) */
                        @media (min-width: 1920px) {
                            .dashboard-wrapper {
                                max-width: 1920px;
                                margin-left: auto;
                                margin-right: auto;
                            }
                            
                            .modern-metrics-grid {
                                gap: 14px;
                            }
                        }
                        
                        /* Large Desktop (1600px to 1919px) */
                        @media (min-width: 1600px) and (max-width: 1919px) {
                            .dashboard-content-wrapper {
                                gap: 24px;
                            }
                            
                            .modern-metrics-grid {
                                gap: 12px;
                            }
                        }
                        
                        /* Standard Desktop (1400px to 1599px) */
                        @media (min-width: 1400px) and (max-width: 1599px) {
                            .dashboard-content-wrapper {
                                gap: 20px;
                            }
                            
                            .modern-metrics-grid {
                                gap: 10px;
                            }
                        }
                        
                        /* Tablet Landscape (1024px to 1199px) */
                        @media (min-width: 1024px) and (max-width: 1199px) {
                            .modern-metrics-grid {
                                grid-template-columns: repeat(3, 1fr);
                                gap: 10px;
                                padding-right: 12px;
                            }
                            
                            .modern-metric-card {
                                min-height: 120px;
                                height: auto;
                            }
                        }
                        
                        /* Tablet Portrait (768px to 1023px) */
                        @media (min-width: 768px) and (max-width: 1023px) {
                            .dashboard-content-wrapper {
                                gap: 16px;
                                margin-top: 16px;
                                margin-bottom: 24px;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 10px;
                                padding-right: 10px;
                            }
                            
                            .modern-metric-card {
                                min-height: 110px;
                                height: auto;
                                padding: 12px 14px;
                            }
                            
                            .modern-dashboard-header {
                                padding: 18px 20px;
                                margin-bottom: 12px;
                            }
                        }
                        
                        /* Large Mobile (576px to 767px) */
                        @media (min-width: 576px) and (max-width: 767px) {
                            .dashboard-wrapper {
                                padding: 16px 12px;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 8px;
                                padding-right: 8px;
                            }
                            
                            .modern-metric-card {
                                min-height: 100px;
                                height: auto;
                                padding: 10px 12px;
                            }
                            
                            .metric-icon-wrapper {
                                width: 36px;
                                height: 36px;
                                font-size: 16px;
                            }
                            
                            .metric-value {
                                font-size: 20px;
                            }
                        }
                        
                        /* Standard Mobile (481px to 575px) */
                        @media (min-width: 481px) and (max-width: 575px) {
                            .dashboard-wrapper {
                                padding: 14px 10px;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 8px;
                                padding-right: 8px;
                            }
                            
                            .modern-metric-card {
                                min-height: 95px;
                                height: auto;
                                padding: 10px 12px;
                            }
                            
                            .metric-icon-wrapper {
                                width: 32px;
                                height: 32px;
                                font-size: 14px;
                            }
                            
                            .metric-value {
                                font-size: 18px;
                            }
                        }
                        
                        /* Small Mobile (376px to 480px) */
                        @media (min-width: 376px) and (max-width: 480px) {
                            .dashboard-wrapper {
                                padding: 12px 8px;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 6px;
                                padding-right: 6px;
                            }
                            
                            .modern-metric-card {
                                min-height: 90px;
                                height: auto;
                                padding: 8px 10px;
                            }
                            
                            .metric-icon-wrapper {
                                width: 30px;
                                height: 30px;
                                font-size: 13px;
                            }
                            
                            .metric-value {
                                font-size: 16px;
                            }
                        }
                        
                        /* Extra Small Mobile (320px to 375px) */
                        @media (min-width: 320px) and (max-width: 375px) {
                            .dashboard-wrapper {
                                padding: 10px 6px;
                            }
                            
                            .modern-metrics-grid {
                                grid-template-columns: repeat(2, 1fr);
                                gap: 6px;
                                padding-right: 6px;
                            }
                            
                            .modern-metric-card {
                                min-height: 85px;
                                height: auto;
                                padding: 8px 10px;
                            }
                            
                            .metric-icon-wrapper {
                                width: 28px;
                                height: 28px;
                                font-size: 12px;
                            }
                            
                            .metric-value {
                                font-size: 14px;
                            }
                            
                            .metric-label {
                                font-size: 8px;
                            }
                        }
                        
                        /* Touch Device Optimizations - Enhanced */
                        @media (hover: none) and (pointer: coarse) {
                            .modern-metric-card {
                                min-height: 44px;
                                min-width: 44px;
                                -webkit-tap-highlight-color: rgba(102, 126, 234, 0.1);
                            }
                            
                            .modern-filter-btn {
                                min-height: 44px;
                                min-width: 44px;
                                padding: 12px 24px;
                            }
                            
                            .metric-icon-wrapper {
                                min-width: 44px;
                                min-height: 44px;
                            }
                            
                            .modern-dashboard-header {
                                -webkit-tap-highlight-color: transparent;
                            }
                        }
                        
                        /* High DPI / Retina Displays */
                        @media (-webkit-min-device-pixel-ratio: 2), 
                               (min-resolution: 192dpi),
                               (min-resolution: 2dppx) {
                            .modern-dashboard-header,
                            .modern-metric-card,
                            .modern-last-invoice-section {
                                border-width: 0.5px;
                            }
                            
                            .modern-metric-card {
                                box-shadow: 
                                    0 2px 10px rgba(0, 0, 0, 0.03),
                                    0 1px 4px rgba(0, 0, 0, 0.02),
                                    inset 0 0.5px 0 rgba(255, 255, 255, 0.8);
                            }
                        }
                        
                        /* Landscape Orientation Optimizations */
                        @media (orientation: landscape) and (max-height: 600px) {
                            .modern-dashboard-header {
                                padding: 16px 20px;
                                margin-bottom: 8px;
                            }
                            
                            .modern-metric-card {
                                min-height: 80px;
                            }
                            
                            .dashboard-content-wrapper {
                                margin-top: 12px;
                                margin-bottom: 20px;
                            }
                        }
                        
                        /* Print Styles */
                        @media print {
                            .modern-dashboard-header,
                            .modern-metric-card,
                            .modern-last-invoice-section {
                                break-inside: avoid;
                                page-break-inside: avoid;
                            }
                        }

                        /* Growth Rate Positive/Negative Colors */
                        .metric-value.positive {
                            color: #10b981;
                        }

                        .metric-value.negative {
                            color: #ef4444;
                        }

        /* Modern Statistics Section - Pixel Perfect */
        .modern-statistics-section {
            background: var(--glass-bg);
            backdrop-filter: blur(24px) saturate(180%);
            -webkit-backdrop-filter: blur(24px) saturate(180%);
            border-radius: var(--border-radius-lg);
            padding: 40px;
            margin-bottom: 40px;
            box-shadow: var(--shadow-lg), inset 0 1px 0 rgba(255, 255, 255, 0.6);
            border: 1px solid var(--glass-border);
            position: relative;
            overflow: hidden;
            overflow-x: hidden;
            transition: all var(--transition-base);
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
        }
        
        /* Ensure all sections prevent horizontal overflow */
        .modern-statistics-section,
        .modern-sales-charts-section,
        .modern-last-invoice-section,
        .dashboard-content-wrapper {
            overflow-x: hidden;
        }

        .modern-statistics-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--primary-gradient);
            opacity: 0.8;
        }

        .modern-statistics-section:hover {
            box-shadow: var(--shadow-xl), inset 0 1px 0 rgba(255, 255, 255, 0.7);
                            transform: translateY(-2px);
        }

        .statistics-header {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: 32px;
            padding-bottom: 24px;
            border-bottom: 2px solid rgba(102, 126, 234, 0.1);
        }

        .statistics-icon-wrapper {
            width: 64px;
            height: 64px;
            background: var(--primary-gradient);
            border-radius: var(--border-radius-md);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 28px;
            box-shadow: var(--shadow-lg), 0 0 25px rgba(102, 126, 234, 0.4);
            transition: all var(--transition-base);
            position: relative;
            overflow: hidden;
        }

        .statistics-icon-wrapper::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), transparent);
            opacity: 0;
            transition: opacity var(--transition-base);
        }

        .statistics-header:hover .statistics-icon-wrapper {
            transform: rotate(5deg) scale(1.1);
            box-shadow: var(--shadow-xl), 0 0 35px rgba(102, 126, 234, 0.5);
        }

        .statistics-header:hover .statistics-icon-wrapper::before {
            opacity: 1;
        }

        .statistics-title {
            font-size: 1.75rem;
            font-weight: 800;
            color: var(--text-primary);
            margin: 0;
            background: linear-gradient(135deg, #0f172a 0%, #334155 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -0.5px;
        }

        /* Modern KPI Chart Cards - Enhanced Design */
        .charts-grid-row-1 {
            display: grid;
            grid-template-columns: repeat(3, 420px);
            gap: 16px;
            margin-bottom: 0px;
            padding-top: 20px;
            padding-bottom: 20px;
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
            justify-content: center;
        }
        
        @media (max-width: 1400px) {
            .charts-grid-row-1 {
                grid-template-columns: repeat(auto-fit, minmax(350px, 420px));
                justify-content: center;
            }
        }
        
        @media (max-width: 992px) {
            .charts-grid-row-1 {
                grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
                gap: 12px;
            }
            
            .charts-grid-row-1 .modern-chart-card {
                width: 100% !important;
                max-width: 100% !important;
                min-width: 0 !important;
                height: auto !important;
                min-height: 350px !important;
                max-height: 400px !important;
            }
        }
        
        @media (max-width: 768px) {
            .charts-grid-row-1 {
                grid-template-columns: 1fr;
                gap: 12px;
                padding-top: 16px;
                padding-bottom: 16px;
            }
            
            .charts-grid-row-1 .modern-chart-card {
                width: 100% !important;
                max-width: 100% !important;
                min-width: 0 !important;
                height: auto !important;
                min-height: 300px !important;
                max-height: 350px !important;
                padding: 12px;
            }
            
            .modern-statistics-section {
                padding: 20px 16px;
                margin-bottom: 20px;
            }
            
            .statistics-title {
                font-size: 1.4rem;
            }
            
            .statistics-icon-wrapper {
                width: 44px;
                height: 44px;
                font-size: 20px;
            }
        }
        
        @media (max-width: 575px) {
            .charts-grid-row-1 {
                gap: 10px;
                padding-top: 12px;
                padding-bottom: 12px;
            }
            
            .charts-grid-row-1 .modern-chart-card {
                min-height: 280px !important;
                max-height: 320px !important;
                padding: 10px;
            }
            
            .modern-statistics-section {
                padding: 16px 12px;
                margin-bottom: 16px;
                border-radius: 14px;
            }
            
            .statistics-title {
                font-size: 1.2rem;
            }
        }
        
        /* Compact styling for first row donut charts - Fixed 420x420px */
        .charts-grid-row-1 .modern-chart-card {
            width: 420px !important;
            height: 420px !important;
            max-width: 420px !important;
            max-height: 420px !important;
            min-width: 420px !important;
            min-height: 420px !important;
            padding: 16px;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
        }
        
        .charts-grid-row-1 .chart-header {
            margin-bottom: 14px;
            padding-bottom: 12px;
            gap: 12px;
        }
        
        .charts-grid-row-1 .chart-header-icon-wrapper {
            width: 48px;
            height: 48px;
            font-size: 20px;
            border-radius: 14px;
        }
        
        .charts-grid-row-1 .chart-title-wrapper h5 {
            font-size: 1.05rem !important;
            font-weight: 800 !important;
            margin: 0 !important;
            line-height: 1.3;
        }
        
        .charts-grid-row-1 .chart-subtitle {
            font-size: 0.65rem !important;
            font-weight: 700 !important;
            line-height: 1.3;
            letter-spacing: 0.8px;
        }
        
        .charts-grid-row-1 .chart-body {
            flex: 1;
            min-height: 0 !important;
            height: auto !important;
            max-height: none !important;
            padding: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .charts-grid-row-1 .chart-body canvas {
            width: 100% !important;
            height: 100% !important;
            max-width: 100% !important;
            max-height: 100% !important;
            object-fit: contain;
        }
        
        /* Reduce spacing in legend for compact charts */
        .charts-grid-row-1 .modern-chart-card canvas + div {
            margin-top: 4px !important;
            flex-shrink: 0;
        }
        
        .charts-grid-row-1 .modern-chart-card canvas + div ul {
            gap: 4px !important;
            margin: 0 !important;
            padding: 0 !important;
        }
        
        /* Responsive adjustments - maintain 420x420 on larger screens */
        @media (max-width: 1350px) {
            .charts-grid-row-1 {
                grid-template-columns: repeat(auto-fit, 420px);
                justify-content: center;
            }
        }
        
        @media (max-width: 992px) {
            .charts-grid-row-1 {
                gap: 12px;
            }
        }
        
        @media (max-width: 768px) {
            .charts-grid-row-1 {
                grid-template-columns: 1fr;
                gap: 12px;
            }
            
            .charts-grid-row-1 .modern-chart-card {
                width: 100% !important;
                max-width: 420px !important;
                min-width: 0 !important;
                margin: 0 auto;
            }
        }
        
        @media (max-width: 450px) {
            .charts-grid-row-1 .modern-chart-card {
                width: 100% !important;
                max-width: 100% !important;
                min-width: 0 !important;
                height: auto !important;
                min-height: 420px !important;
            }
        }

        .charts-grid-row-2 {
            display: grid;
            grid-template-columns: repeat(3, 420px);
            gap: 16px;
            margin-bottom: 0px;
            padding-top: 20px;
            padding-bottom: 20px;
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
            justify-content: center;
        }
        
        @media (max-width: 1400px) {
            .charts-grid-row-2 {
                grid-template-columns: repeat(auto-fit, 420px);
                justify-content: center;
            }
        }
        
        /* Compact styling for second row charts - Fixed 420x420px */
        .charts-grid-row-2 .modern-chart-card {
            width: 420px !important;
            height: 420px !important;
            max-width: 420px !important;
            max-height: 420px !important;
            min-width: 420px !important;
            min-height: 420px !important;
            padding: 16px;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
        }
        
        .charts-grid-row-2 .chart-header {
            margin-bottom: 14px;
            padding-bottom: 12px;
            gap: 12px;
        }
        
        .charts-grid-row-2 .chart-header-icon-wrapper {
            width: 48px;
            height: 48px;
            font-size: 20px;
            border-radius: 14px;
        }
        
        .charts-grid-row-2 .chart-title-wrapper h5 {
            font-size: 1.05rem !important;
            font-weight: 800 !important;
            margin: 0 !important;
            line-height: 1.3;
        }
        
        .charts-grid-row-2 .chart-subtitle {
            font-size: 0.65rem !important;
            font-weight: 700 !important;
            line-height: 1.3;
            letter-spacing: 0.8px;
        }
        
        .charts-grid-row-2 .chart-body {
            flex: 1;
            min-height: 0 !important;
            height: auto !important;
            max-height: none !important;
            padding: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .charts-grid-row-2 .chart-body canvas {
            width: 100% !important;
            height: 100% !important;
            max-width: 100% !important;
            max-height: 100% !important;
            object-fit: contain;
        }
        
        /* Reduce spacing in legend for compact charts */
        .charts-grid-row-2 .modern-chart-card canvas + div {
            margin-top: 4px !important;
            flex-shrink: 0;
        }
        
        .charts-grid-row-2 .modern-chart-card canvas + div ul {
            gap: 4px !important;
            margin: 0 !important;
            padding: 0 !important;
        }
        
        /* Responsive adjustments for second row - maintain 420x420 */
        @media (max-width: 1350px) {
            .charts-grid-row-2 {
                grid-template-columns: repeat(auto-fit, 420px);
                justify-content: center;
            }
        }
        
        @media (max-width: 992px) {
            .charts-grid-row-2 {
                gap: 12px;
            }
        }
        
        @media (max-width: 768px) {
            .charts-grid-row-2 {
                grid-template-columns: 1fr;
                gap: 12px;
            }
            
            .charts-grid-row-2 .modern-chart-card {
                width: 100% !important;
                max-width: 420px !important;
                min-width: 0 !important;
                margin: 0 auto;
            }
        }
        
        @media (max-width: 450px) {
            .charts-grid-row-2 .modern-chart-card {
                width: 100% !important;
                max-width: 100% !important;
                min-width: 0 !important;
                height: auto !important;
                min-height: 420px !important;
            }
        }

        .charts-grid-large {
            display: grid;
            grid-template-columns: repeat(2, 600px);
            gap: 16px;
            margin-bottom: 0px;
            padding-top: 20px;
            padding-bottom: 20px;
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
            justify-content: center;
        }
        
        @media (max-width: 1300px) {
            .charts-grid-large {
                grid-template-columns: repeat(auto-fit, 600px);
                justify-content: center;
            }
        }
        
        /* Compact styling for large charts - Fixed 600x400px */
        .charts-grid-large .modern-chart-card {
            width: 600px !important;
            height: 400px !important;
            max-width: 600px !important;
            max-height: 400px !important;
            min-width: 600px !important;
            min-height: 400px !important;
            padding: 16px;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
        }
        
        .charts-grid-large .chart-header {
            margin-bottom: 10px;
            padding-bottom: 8px;
            flex-shrink: 0;
        }
        
        .charts-grid-large .chart-header-icon-wrapper {
            width: 32px;
            height: 32px;
            font-size: 14px;
        }
        
        .charts-grid-large .chart-title {
            font-size: 0.9rem !important;
            margin: 0 !important;
            line-height: 1.2;
        }
        
        .charts-grid-large .chart-subtitle {
            font-size: 0.6rem !important;
            line-height: 1.2;
        }
        
        .charts-grid-large .chart-body {
            flex: 1;
            min-height: 0 !important;
            height: auto !important;
            max-height: none !important;
            padding: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .charts-grid-large .chart-body canvas {
            width: 100% !important;
            height: 100% !important;
            max-width: 100% !important;
            max-height: 100% !important;
            object-fit: contain;
        }
        
        /* Responsive adjustments for large charts - maintain 600x400 */
        @media (max-width: 1300px) {
            .charts-grid-large {
                grid-template-columns: repeat(auto-fit, 600px);
                justify-content: center;
            }
        }
        
        @media (max-width: 768px) {
            .charts-grid-large {
                grid-template-columns: 1fr;
                gap: 12px;
            }
            
            .charts-grid-large .modern-chart-card {
                width: 100% !important;
                max-width: 600px !important;
                min-width: 0 !important;
                margin: 0 auto;
            }
        }
        
        @media (max-width: 650px) {
            .charts-grid-large .modern-chart-card {
                width: 100% !important;
                max-width: 100% !important;
                min-width: 0 !important;
                height: auto !important;
                min-height: 400px !important;
            }
        }

        .modern-chart-card {
            background: var(--glass-bg);
            backdrop-filter: blur(28px) saturate(200%);
            -webkit-backdrop-filter: blur(28px) saturate(200%);
            border-radius: var(--border-radius-lg);
            padding: var(--spacing-xl);
            border: 1px solid var(--glass-border);
            box-shadow: var(--glass-shadow), 
                        inset 0 1px 0 rgba(255, 255, 255, 0.8),
                        inset 0 -1px 0 rgba(0, 0, 0, 0.02);
            transition: all var(--transition-base);
            position: relative;
            overflow: hidden;
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
        }
        
        .modern-chart-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: var(--primary-gradient);
            transform: scaleX(0);
            transform-origin: left;
            transition: transform var(--transition-slow);
        }
        
        .modern-chart-card::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(102, 126, 234, 0.08) 0%, transparent 70%);
            opacity: 0;
            transition: opacity var(--transition-base);
            pointer-events: none;
        }


        .modern-chart-card:hover {
            transform: translateY(-6px) scale(1.01);
            box-shadow: var(--glass-shadow-hover), 
                        inset 0 1px 0 rgba(255, 255, 255, 1),
                        inset 0 -1px 0 rgba(0, 0, 0, 0.03);
            border-color: var(--glass-border-hover);
            background: var(--glass-bg-hover);
        }

        .modern-chart-card:hover::before {
            transform: scaleX(1);
        }

        .modern-chart-card:hover::after {
            opacity: 1;
        }

        .modern-chart-card.large {
            min-height: 400px;
        }

        .chart-header {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: var(--spacing-lg);
            padding-bottom: var(--spacing-lg);
            border-bottom: 2px solid rgba(102, 126, 234, 0.08);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }
        
        .chart-header::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary-gradient);
            transition: width 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .modern-chart-card:hover .chart-header {
            border-bottom-color: rgba(102, 126, 234, 0.15);
        }
        
        .modern-chart-card:hover .chart-header::after {
            width: 100%;
        }

        .chart-header-icon-wrapper {
            width: 64px;
            height: 64px;
            border-radius: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: var(--primary-gradient);
            color: white;
            font-size: 26px;
            box-shadow: 
                0 8px 24px rgba(0, 0, 0, 0.15),
                0 4px 12px rgba(0, 0, 0, 0.1),
                0 0 0 1px rgba(255, 255, 255, 0.2),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            flex-shrink: 0;
        }
        
        .chart-header-icon-wrapper::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.4) 0%, 
                rgba(255, 255, 255, 0.1) 50%,
                transparent 100%);
            opacity: 0;
            transition: opacity 0.4s ease;
        }
        
        .chart-header-icon-wrapper::after {
            content: '';
            position: absolute;
            inset: -2px;
            border-radius: 18px;
            padding: 2px;
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.5) 0%, 
                rgba(255, 255, 255, 0.2) 100%);
            -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
            opacity: 0;
            transition: opacity 0.4s ease;
        }
        
        .chart-header-icon-wrapper:hover {
            transform: rotate(5deg) scale(1.12);
            box-shadow: 
                0 12px 32px rgba(0, 0, 0, 0.2),
                0 0 50px rgba(102, 126, 234, 0.4),
                0 0 0 1px rgba(255, 255, 255, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.4);
        }
        
        .chart-header-icon-wrapper:hover::before {
            opacity: 1;
        }
        
        .modern-chart-card:hover .chart-header-icon-wrapper::after {
            opacity: 1;
        }
        
        .chart-header-icon-wrapper i {
            color: white;
            font-size: 26px;
            z-index: 1;
            position: relative;
            transition: transform 0.3s ease;
        }
        
        .chart-header-icon-wrapper:hover i {
            transform: scale(1.1);
        }
        
        .modern-chart-card:hover .chart-header-icon-wrapper {
            transform: rotate(5deg) scale(1.12);
        }

        .chart-title-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .chart-title-wrapper h5 {
            font-size: 1.25rem !important;
            font-weight: 800 !important;
            color: #0f172a;
            margin: 0 !important;
            letter-spacing: -0.5px;
            line-height: 1.3;
            background: linear-gradient(135deg, 
                #0f172a 0%, 
                #1e293b 30%,
                #334155 60%,
                #475569 100%);
            background-size: 200% 200%;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .modern-chart-card:hover .chart-title-wrapper h5 {
            transform: translateX(2px);
            background-position: 100% 50%;
        }

        .chart-subtitle {
            font-size: 0.7rem;
            color: #64748b;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            opacity: 0.85;
            transition: all 0.3s ease;
            margin-top: 2px;
        }
        
        .modern-chart-card:hover .chart-subtitle {
            color: #475569;
            opacity: 1;
            transform: translateX(2px);
        }

        .chart-body {
            position: relative;
            min-height: 280px;
            height: auto;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            max-width: 100%;
            overflow: visible;
        }
        
        /* Specific styling for profit margin chart container - fits in 400x400 card */
        .charts-grid-row-2 #profitMarginChart {
            max-height: 100% !important;
            height: 100% !important;
            width: 100% !important;
        }

        .chart-body canvas {
            width: 100% !important;
            height: 100% !important;
            max-width: 100%;
            object-fit: contain;
        }

        /* Chart Stats Badge */
        .chart-stats-badge {
            position: absolute;
            top: 16px;
            right: 16px;
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(102, 126, 234, 0.2);
        }

        /* Chart.js Legend - Horizontal Single Line */
        .modern-chart-card canvas + div {
            display: flex !important;
            flex-direction: row !important;
            justify-content: center !important;
            align-items: center !important;
            flex-wrap: nowrap !important;
            padding: 10px 0 !important;
            width: 100% !important;
        }

        .modern-chart-card canvas + div ul {
            display: flex !important;
            flex-direction: row !important;
            flex-wrap: nowrap !important;
            justify-content: center !important;
            align-items: center !important;
            list-style: none !important;
            margin: 0 !important;
            padding: 0 !important;
            gap: 12px !important;
        }

        .modern-chart-card canvas + div li {
            display: inline-flex !important;
            align-items: center !important;
            margin: 0 !important;
            padding: 0 !important;
            white-space: nowrap !important;
            float: none !important;
        }

        /* Revenue Distribution Chart - 2x2 Grid Layout */
        #revenueDistributionChart + div ul {
            display: grid !important;
            grid-template-columns: 1fr 1fr !important;
            grid-template-rows: 1fr 1fr !important;
            gap: 12px 20px !important;
            justify-items: center !important;
            align-items: center !important;
            list-style: none !important;
            margin: 0 !important;
            padding: 0 !important;
            width: 100% !important;
        }

        #revenueDistributionChart + div li {
            display: inline-flex !important;
            align-items: center !important;
            margin: 0 !important;
            padding: 0 !important;
            white-space: nowrap !important;
            width: auto !important;
        }

        @media (max-width: 1400px) {
            .charts-grid-row-1,
            .charts-grid-row-2 {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 992px) {
            .charts-grid-row-1,
            .charts-grid-row-2 {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .modern-chart-card {
                padding: 24px;
            }
            
            .chart-body {
                height: 240px;
            }
        }

        @media (max-width: 768px) {
            .charts-grid-row-1,
            .charts-grid-row-2,
            .charts-grid-large {
                grid-template-columns: 1fr;
            }

            .modern-chart-card {
                padding: 20px;
            }

            .chart-body {
                height: 220px;
            }
        }
        
        /* Ensure charts don't overflow - Additional constraints */
        .charts-grid-row-1,
        .charts-grid-row-2,
        .charts-grid-large {
            width: 100%;
            max-width: 100%;
            overflow-x: hidden;
            box-sizing: border-box;
        }

        /* Modern Sales Charts Section */
        .modern-sales-charts-section {
            display: grid;
            grid-template-columns: 1fr;
            gap: 32px;
            margin-bottom: 32px;
        }

        .modern-chart-wrapper {
            background: var(--glass-bg);
            backdrop-filter: blur(24px) saturate(180%);
            -webkit-backdrop-filter: blur(24px) saturate(180%);
            border-radius: var(--border-radius-lg);
            padding: 40px;
            box-shadow: var(--shadow-lg), inset 0 1px 0 rgba(255, 255, 255, 0.6);
            border: 1px solid var(--glass-border);
            transition: all var(--transition-base);
            position: relative;
            overflow: hidden;
            width: 100%;
            max-width: 100%;
            box-sizing: border-box;
        }
        
        @media (max-width: 992px) {
            .modern-sales-charts-section {
                gap: 24px;
                margin-bottom: 24px;
            }
            
            .modern-chart-wrapper {
                padding: 28px;
            }
        }
        
        @media (max-width: 768px) {
            .modern-sales-charts-section {
                gap: 20px;
                margin-bottom: 20px;
            }
            
            .modern-chart-wrapper {
                padding: 20px;
                border-radius: 16px;
            }
            
            .modern-chart-header {
                margin-bottom: 16px;
                padding-bottom: 12px;
                gap: 12px;
            }
            
            .modern-chart-title {
                font-size: 1.2rem;
            }
            
            .chart-header-icon {
                width: 40px;
                height: 40px;
                font-size: 18px;
            }
        }
        
        @media (max-width: 575px) {
            .modern-sales-charts-section {
                gap: 16px;
                margin-bottom: 16px;
            }
            
            .modern-chart-wrapper {
                padding: 16px;
                border-radius: 14px;
            }
            
            .modern-chart-header {
                margin-bottom: 12px;
                padding-bottom: 10px;
                gap: 10px;
                flex-wrap: wrap;
            }
            
            .modern-chart-title {
                font-size: 1.1rem;
            }
            
            .chart-header-icon {
                width: 36px;
                height: 36px;
                font-size: 16px;
            }
        }

        .modern-chart-wrapper::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.4s ease;
        }

        .modern-chart-wrapper:hover {
            transform: translateY(-6px);
            box-shadow: var(--shadow-xl), inset 0 1px 0 rgba(255, 255, 255, 0.7);
            background: var(--glass-bg-hover);
            border-color: var(--glass-border-hover);
        }

        .modern-chart-wrapper:hover::before {
            transform: scaleX(1);
        }

        .modern-chart-header {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: 24px;
            padding-bottom: 20px;
            border-bottom: 2px solid rgba(102, 126, 234, 0.1);
        }

        .chart-header-icon {
            width: 56px;
            height: 56px;
            background: var(--primary-gradient);
            border-radius: var(--border-radius-sm);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            box-shadow: var(--shadow-lg), 0 0 20px rgba(102, 126, 234, 0.4);
            transition: all var(--transition-base);
            position: relative;
            overflow: hidden;
        }

        .chart-header-icon::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), transparent);
            opacity: 0;
            transition: opacity var(--transition-base);
        }

        .modern-chart-header:hover .chart-header-icon {
            transform: rotate(8deg) scale(1.1);
            box-shadow: var(--shadow-xl), 0 0 30px rgba(102, 126, 234, 0.5);
        }

        .modern-chart-header:hover .chart-header-icon::before {
            opacity: 1;
        }

        .modern-chart-title {
            font-size: 1.625rem;
            font-weight: var(--font-weight-bold);
            color: var(--text-primary);
            margin: 0;
            background: linear-gradient(135deg, #0f172a 0%, #334155 50%, #475569 100%);
            background-size: 200% 200%;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -0.5px;
            transition: all var(--transition-base);
        }
        
        .modern-chart-wrapper:hover .modern-chart-title {
            transform: translateX(4px);
            background-position: 100% 50%;
        }

        .modern-chart-container {
            position: relative;
            min-height: 400px;
            padding: 24px;
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.03) 0%, rgba(118, 75, 162, 0.03) 100%);
            border-radius: var(--border-radius-md);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: inset 0 2px 8px rgba(0, 0, 0, 0.04);
        }

        /* Modern Chart Styling */
        .modern-chart-container .chartjs-render-monitor,
        .modern-chart-container canvas {
            border-radius: 12px;
        }

        /* Highcharts Minimalist Modern Styling */
        .modern-chart-container .highcharts-container {
            border-radius: 12px;
            overflow: hidden;
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.08), 0 0 0 1px rgba(0, 0, 0, 0.04);
        }

        .modern-chart-container .highcharts-background {
            fill: rgba(255, 255, 255, 0.98);
        }

        .modern-chart-container .highcharts-plot-background {
            fill: rgba(255, 255, 255, 1);
        }

        .modern-chart-container .highcharts-title {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif !important;
            font-weight: 600 !important;
            font-size: 15px !important;
            fill: #1e293b !important;
        }

        .modern-chart-container .highcharts-axis-labels {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif !important;
            font-size: 11px !important;
            font-weight: 400 !important;
            fill: #64748b !important;
        }

        .modern-chart-container .highcharts-axis-title {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif !important;
            font-weight: 500 !important;
            font-size: 11px !important;
            fill: #64748b !important;
        }

        /* Subtle horizontal grid lines only */
        .modern-chart-container .highcharts-grid-line {
            stroke: rgba(100, 116, 139, 0.12) !important;
            stroke-width: 1 !important;
        }

        /* Even more subtle grid lines for Sales Current FY (Analytics style) */
        /* Note: JavaScript handles this dynamically, this is a fallback */

        /* Hide vertical grid lines */
        .modern-chart-container .highcharts-grid-line.highcharts-xaxis-grid {
            stroke: transparent !important;
        }

        /* Sales Current FY Chart - Analytics Dashboard Style */
        /* Smooth continuous line with no visible data points */
        .modern-chart-container .highcharts-series-0 .highcharts-point {
            fill: transparent !important;
            stroke: transparent !important;
            stroke-width: 0 !important;
            r: 0 !important;
        }

        /* Show points only on hover */
        .modern-chart-container .highcharts-series-0 .highcharts-point:hover,
        .modern-chart-container .highcharts-series-0 .highcharts-point.highcharts-halo {
            fill: #667eea !important;
            stroke: #ffffff !important;
            stroke-width: 2 !important;
            r: 5 !important;
        }

        /* Very subtle or hidden axis lines */
        .modern-chart-container .highcharts-axis-line {
            stroke: transparent !important;
            stroke-width: 0 !important;
        }

        /* Smooth gradient area fill - light purple fading to transparent */
        .modern-chart-container .highcharts-area {
            fill-opacity: 0.3 !important;
        }

        .modern-chart-container .highcharts-series-0 .highcharts-area {
            fill: url(#minimalistGradient) !important;
        }

        /* Smooth, prominent purple line */
        .modern-chart-container .highcharts-series-0 .highcharts-graph {
            stroke: #667eea !important;
            stroke-width: 2.5 !important;
            stroke-linecap: round !important;
            stroke-linejoin: round !important;
        }

        /* Minimal or no data points for cleaner look */
        .modern-chart-container .highcharts-series-0 .highcharts-point {
            fill: transparent !important;
            stroke: transparent !important;
            stroke-width: 0 !important;
            r: 0 !important;
        }

        /* Show points on hover only */
        .modern-chart-container .highcharts-series-0 .highcharts-point:hover,
        .modern-chart-container .highcharts-series-0 .highcharts-point.highcharts-halo {
            fill: #667eea !important;
            stroke: #ffffff !important;
            stroke-width: 2 !important;
            r: 4 !important;
        }

        .modern-chart-container .highcharts-legend-item {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif !important;
            font-weight: 500 !important;
            font-size: 12px !important;
        }

        .modern-chart-container .highcharts-legend-item text {
            fill: #475569 !important;
        }

        .modern-chart-container .highcharts-legend-item rect {
            rx: 3 !important;
            ry: 3 !important;
        }

        /* Clean, minimal tooltip */
        .modern-chart-container .highcharts-tooltip {
            background: rgba(255, 255, 255, 0.98) !important;
            backdrop-filter: blur(10px) !important;
            border: 1px solid rgba(100, 116, 139, 0.15) !important;
            border-radius: 8px !important;
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1) !important;
            padding: 10px 14px !important;
        }

        .modern-chart-container .highcharts-tooltip-box {
            fill: rgba(255, 255, 255, 0.98) !important;
            stroke: rgba(100, 116, 139, 0.15) !important;
            stroke-width: 1 !important;
            rx: 8 !important;
            ry: 8 !important;
        }

        .modern-chart-container .highcharts-tooltip text {
            fill: #1e293b !important;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif !important;
            font-weight: 500 !important;
            font-size: 12px !important;
        }

        /* Add SVG Gradient Definitions */
        .modern-chart-container svg defs {
            position: absolute;
        }

        @media (max-width: 768px) {
            .modern-sales-charts-section {
                gap: 24px;
            }

            .modern-chart-wrapper {
                padding: 24px;
            }

            .modern-chart-container {
                min-height: 300px;
                padding: 16px;
            }

            .modern-chart-title {
                font-size: 1.125rem;
            }

            .chart-header-icon {
                width: 40px;
                height: 40px;
                font-size: 18px;
            }
                        }
                    </style>


                    <?php if(!empty($widgets['after_sale_purchase_totals'])): ?>
                        <?php $__currentLoopData = $widgets['after_sale_purchase_totals']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $widget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo $widget; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                <?php endif; ?>
            </div>

            <!---quick menu dashbaord---->
        </div>
    </div>


    <?php if(auth()->user()->can('dashboard.data')): ?>
        <?php if(auth()->user()->can('sell.view') || auth()->user()->can('direct_sell.view')): ?>
            <div class="tw-px-5">
                <?php if(!empty($all_locations)): ?>

                    <style>

                        div.col-md-3.col-sm-6.col-xs-12.col-custom {
                            margin-top: 30px;
                        }
                    </style>
                  
                <?php endif; ?>
            </div>
            
        <?php endif; ?>
    <?php endif; ?>



    <div
        class="tw-pb-6 tw-from-<?php if(!empty(session('business.theme_color'))): ?> <?php echo e(session('business.theme_color'), false); ?><?php else: ?><?php echo e('primary', false); ?> <?php endif; ?>-800 tw-to-<?php if(!empty(session('business.theme_color'))): ?> <?php echo e(session('business.theme_color'), false); ?><?php else: ?><?php echo e('primary', false); ?> <?php endif; ?>-900 xl:tw-pb-0 ">

        <div class="tw-px-5 tw-pt-3">
            <div class="">
                

                <style>
                    .quickmenu-section-header {
                      display: flex;
                      align-items: center;
                      gap: 0.75rem;
                      margin-bottom: 1.5rem;
                      font-size: 1.15rem;
                      font-weight: 700;
                    }
                    .quickmenu-section-header i {
                      background: #ffc107;
                      color: #fff;
                      border-radius: 50%;
                      width: 2.2rem;
                      height: 2.2rem;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      font-size: 1.3rem;
                    }

                    .quickmenu-card-grid {
                      display: flex;
                      flex-wrap: wrap;
                      gap: 1.5rem;
                      margin-bottom: 1.5rem;
                    }

                    .quickmenu-card {
                      display: flex;
                      align-items: center;
                      background: #fff;
                      border-radius: 16px;
                      box-shadow: 0 2px 4px rgba(0,0,0,0.05);
                      padding: 1.25rem;
                      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                      border: 1px solid #e2e8f0;
                      text-decoration: none;
                      gap: 1rem;
                      position: relative;
                      overflow: hidden;
                      min-height: 80px;
                    }

                    .quickmenu-card::before {
                      content: '';
                      position: absolute;
                      top: 0;
                      left: 0;
                      width: 100%;
                      height: 100%;
                      background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, rgba(99, 102, 241, 0) 100%);
                      opacity: 0;
                      transition: opacity 0.3s ease;
                    }

                    .quickmenu-card:hover {
                      transform: translateY(-3px) scale(1.02);
                      box-shadow: 0 8px 20px rgba(99, 102, 241, 0.15);
                      border-color: #6366f1;
                    }

                    .quickmenu-card:hover::before {
                      opacity: 1;
                    }

                    .quickmenu-card:hover .quickmenu-icon-bg {
                      transform: scale(1.1) rotate(5deg);
                      background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%);
                    }

                    .quickmenu-card:hover .quickmenu-label {
                      color: #4f46e5;
                      transform: translateX(2px);
                    }

                    .quickmenu-icon-bg {
                      width: 48px;
                      height: 48px;
                      border-radius: 14px;
                      background: #6366f1;
                      display: flex;
                      align-items: center;
                      justify-content: center;
                      font-size: 1.4rem;
                      flex-shrink: 0;
                      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                    }

                    .quickmenu-icon-bg i {
                      color: #FFB400;
                      font-size: 1.3rem;
                      transition: transform 0.3s ease, color 0.3s;
                    }

                    .quickmenu-card:hover .quickmenu-icon-bg i {
                      color: #fff;
                    }

                    .quickmenu-label {
                      color: #1e293b;
                      font-size: 1.1rem;
                      font-weight: 500;
                      transition: all 0.3s ease;
                    }

                    /* Add ripple effect */
                    .quickmenu-card::after {
                      content: '';
                      position: absolute;
                      top: 50%;
                      left: 50%;
                      width: 5px;
                      height: 5px;
                      background: rgba(99, 102, 241, 0.3);
                      opacity: 0;
                      border-radius: 100%;
                      transform: scale(1, 1) translate(-50%);
                      transform-origin: 50% 50%;
                    }

                    .quickmenu-card:active::after {
                      animation: ripple 0.6s ease-out;
                    }

                    @keyframes ripple {
                      0% {
                          transform: scale(0, 0);
                          opacity: 0.5;
                      }
                      100% {
                          transform: scale(100, 100);
                          opacity: 0;
                      }
                    }
                </style>

                <style>
                    .quickmenu-icon-bg i {
                        font-size: 2rem;
                        color: #fff;
                        filter: drop-shadow(0 2px 6px rgba(0,0,0,0.10));
                    }
                </style>

                <!----dashboard second section end----->





            </div>
        </div>
    </div>


    <?php if(auth()->user()->can('dashboard.data')): ?>
        <style>
            /* Modern Payment Due & Stock Alert Cards */
            .modern-data-card {
                background: var(--glass-bg);
                backdrop-filter: blur(20px) saturate(180%);
                -webkit-backdrop-filter: blur(20px) saturate(180%);
                border-radius: var(--border-radius-lg);
                padding: 28px;
                border: 1px solid var(--glass-border);
                box-shadow: var(--shadow-md), inset 0 1px 0 rgba(255, 255, 255, 0.5);
                transition: all var(--transition-slow);
                position: relative;
                overflow: hidden;
            }

            .modern-data-card::before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                height: 4px;
                background: var(--primary-gradient);
                transform: scaleX(0);
                transform-origin: left;
                transition: transform 0.4s ease;
            }

            .modern-data-card:hover {
                transform: translateY(-8px) scale(1.01);
                box-shadow: var(--shadow-xl), var(--shadow-glow), inset 0 1px 0 rgba(255, 255, 255, 0.7);
                border-color: var(--glass-border-hover);
                background: var(--glass-bg-hover);
            }

            .modern-data-card:hover::before {
                transform: scaleX(1);
            }

            .modern-data-card-header {
                display: flex;
                align-items: center;
                gap: 16px;
                margin-bottom: 24px;
                padding-bottom: 20px;
                border-bottom: 2px solid rgba(102, 126, 234, 0.1);
            }

            .modern-data-card-icon {
                width: 56px;
                height: 56px;
                border-radius: var(--border-radius-md);
                display: flex;
                align-items: center;
                justify-content: center;
                background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%);
                box-shadow: 0 8px 24px rgba(245, 158, 11, 0.3);
                transition: all var(--transition-base);
            }

            .modern-data-card-icon svg {
                width: 28px;
                height: 28px;
                color: white;
                filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.2));
            }

            .modern-data-card:hover .modern-data-card-icon {
                transform: rotate(5deg) scale(1.1);
                box-shadow: 0 12px 32px rgba(245, 158, 11, 0.4);
            }

            .modern-data-card-title {
                flex: 1;
                font-size: 1.35rem;
                font-weight: 800;
                color: var(--text-primary);
                background: linear-gradient(135deg, #0f172a 0%, #334155 100%);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
                letter-spacing: -0.5px;
            }

            .modern-data-card-select {
                min-width: 180px;
            }

            .modern-data-card-select .select2-container {
                width: 100% !important;
            }

            .modern-data-card-select .select2-selection {
                background: rgba(255, 255, 255, 0.8) !important;
                border: 1px solid rgba(102, 126, 234, 0.2) !important;
                border-radius: 12px !important;
                padding: 8px 12px !important;
                transition: all var(--transition-base) !important;
            }

            .modern-data-card-select .select2-selection:hover {
                background: rgba(255, 255, 255, 1) !important;
                border-color: rgba(102, 126, 234, 0.4) !important;
                box-shadow: 0 4px 12px rgba(102, 126, 234, 0.15) !important;
            }

            /* Modern Table Styling */
            .modern-data-card .table {
                width: 100%;
                border-collapse: separate;
                border-spacing: 0;
                background: transparent;
            }

            .modern-data-card .table thead {
                background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
            }

            .modern-data-card .table thead th {
                padding: 16px 20px;
                font-weight: 700;
                font-size: 13px;
                text-transform: uppercase;
                letter-spacing: 0.8px;
                color: var(--text-primary);
                border: none;
                border-bottom: 2px solid rgba(102, 126, 234, 0.2);
                background: transparent;
            }

            .modern-data-card .table tbody tr {
                background: rgba(255, 255, 255, 0.5);
                transition: all var(--transition-base);
                border-bottom: 1px solid rgba(102, 126, 234, 0.1);
            }

            .modern-data-card .table tbody tr:hover {
                background: rgba(102, 126, 234, 0.08);
                transform: translateX(4px);
                box-shadow: -4px 0 0 rgba(102, 126, 234, 0.3);
            }

            .modern-data-card .table tbody tr:nth-child(even) {
                background: rgba(255, 255, 255, 0.3);
            }

            .modern-data-card .table tbody tr:nth-child(even):hover {
                background: rgba(102, 126, 234, 0.1);
            }

            .modern-data-card .table tbody td {
                padding: 16px 20px;
                color: var(--text-primary);
                font-size: 14px;
                font-weight: 500;
                border: none;
                vertical-align: middle;
            }

            .modern-data-card .table tbody td:last-child {
                text-align: right;
            }

            /* DataTables Pagination Modernization */
            .modern-data-card .dataTables_wrapper .dataTables_paginate {
                margin-top: 24px;
                padding-top: 20px;
                border-top: 2px solid rgba(102, 126, 234, 0.1);
            }

            .modern-data-card .dataTables_wrapper .dataTables_paginate .paginate_button {
                padding: 10px 16px !important;
                margin: 0 4px !important;
                border-radius: 10px !important;
                border: 1px solid rgba(102, 126, 234, 0.2) !important;
                background: rgba(255, 255, 255, 0.6) !important;
                color: var(--text-primary) !important;
                font-weight: 600 !important;
                transition: all var(--transition-base) !important;
            }

            .modern-data-card .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                color: white !important;
                border-color: transparent !important;
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3) !important;
            }

            .modern-data-card .dataTables_wrapper .dataTables_paginate .paginate_button.current {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                color: white !important;
                border-color: transparent !important;
                box-shadow: 0 4px 16px rgba(102, 126, 234, 0.4) !important;
            }

            .modern-data-card .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
                opacity: 0.4 !important;
                cursor: not-allowed !important;
                background: rgba(255, 255, 255, 0.3) !important;
            }

            .modern-data-card .dataTables_wrapper .dataTables_info {
                padding-top: 20px;
                color: var(--text-muted);
                font-size: 13px;
                font-weight: 500;
            }

            /* Empty State Styling */
            .modern-data-card .dataTables_empty {
                padding: 40px 20px !important;
                text-align: center;
                color: var(--text-muted);
                font-size: 14px;
                font-weight: 500;
            }

            /* DataTables Buttons with FontAwesome Icons */
            .modern-data-card .dt-buttons {
                margin-bottom: 15px;
                display: flex;
                flex-wrap: wrap;
                gap: 8px;
            }

            .modern-data-card .dt-buttons .btn {
                display: inline-flex;
                align-items: center;
                gap: 6px;
                padding: 8px 16px;
                font-size: 13px;
                border-radius: 8px;
                transition: all 0.2s ease;
                border: 1px solid #e2e8f0;
                background: #ffffff;
                color: #475569;
            }

            .modern-data-card .dt-buttons .btn:hover {
                background: #f8fafc;
                border-color: #cbd5e1;
                color: #0f172a;
                transform: translateY(-1px);
                box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            }

            .modern-data-card .dt-buttons .btn i {
                font-size: 14px;
            }

            .modern-data-card .dt-buttons .btn.active {
                background: #667eea;
                border-color: #667eea;
                color: #ffffff;
            }

            .modern-data-card .dt-buttons .btn.disabled {
                opacity: 0.5;
                cursor: not-allowed;
            }

            /* DataTables Scrollbar - Always Visible */
            .modern-data-card .dataTables_scrollBody {
                overflow-x: auto !important;
                overflow-y: auto !important;
            }

            .modern-data-card .dataTables_scrollBody::-webkit-scrollbar {
                width: 12px;
                height: 12px;
                background: rgba(0, 0, 0, 0.05);
            }

            .modern-data-card .dataTables_scrollBody::-webkit-scrollbar-track {
                background: rgba(0, 0, 0, 0.05);
                border-radius: 10px;
            }

            .modern-data-card .dataTables_scrollBody::-webkit-scrollbar-thumb {
                background: rgba(102, 126, 234, 0.4);
                border-radius: 10px;
                border: 2px solid transparent;
                background-clip: padding-box;
            }

            .modern-data-card .dataTables_scrollBody::-webkit-scrollbar-thumb:hover {
                background: rgba(102, 126, 234, 0.6);
                background-clip: padding-box;
            }

            .modern-data-card .dataTables_scrollBody::-webkit-scrollbar-thumb:active {
                background: rgba(102, 126, 234, 0.8);
                background-clip: padding-box;
            }

            /* Ensure scrollbar is always visible, not auto-hiding */
            .modern-data-card .dataTables_scrollBody {
                scrollbar-width: thin;
                scrollbar-color: rgba(102, 126, 234, 0.4) rgba(0, 0, 0, 0.05);
            }

            /* Fix for horizontal scrollbar */
            .modern-data-card .dataTables_scrollBody::-webkit-scrollbar:horizontal {
                height: 12px;
            }

            /* Prevent scrollbar from hiding on hover */
            .modern-data-card .dataTables_wrapper .dataTables_scroll {
                position: relative;
            }

            .modern-data-card .dataTables_wrapper .dataTables_scrollBody {
                overflow: auto !important;
                overflow-x: auto !important;
                overflow-y: auto !important;
            }

            /* Ensure scrollbar container is always visible */
            .modern-data-card .dataTables_wrapper .dataTables_scrollBody:hover::-webkit-scrollbar,
            .modern-data-card .dataTables_wrapper .dataTables_scrollBody:hover::-webkit-scrollbar-thumb,
            .modern-data-card .dataTables_wrapper .dataTables_scrollBody:hover::-webkit-scrollbar-track {
                display: block !important;
                visibility: visible !important;
                opacity: 1 !important;
            }

            /* Additional fix for scrollbar visibility */
            .modern-data-card .dataTables_scrollBody {
                scrollbar-gutter: stable;
            }

            /* Prevent any hover effects that might hide scrollbar */
            .modern-data-card .dataTables_wrapper:hover .dataTables_scrollBody::-webkit-scrollbar {
                width: 12px !important;
                height: 12px !important;
            }

            /* Top Customers and Products Section - Modern Redesign */
            .top-customers-products-wrapper {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 24px;
                padding: 32px;
                box-shadow: 0 20px 60px rgba(102, 126, 234, 0.3);
                margin-bottom: 24px;
                position: relative;
                overflow: hidden;
            }

            .top-customers-products-wrapper::before {
                content: '';
                position: absolute;
                top: -50%;
                right: -50%;
                width: 200%;
                height: 200%;
                background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
                animation: topPulse 8s ease-in-out infinite;
            }

            @keyframes topPulse {
                0%, 100% { transform: scale(1); opacity: 0.5; }
                50% { transform: scale(1.1); opacity: 0.8; }
            }

            /* Main Header */
            .top-section-header {
                display: flex;
                align-items: center;
                gap: 20px;
                margin-bottom: 32px;
                position: relative;
                z-index: 1;
            }

            .top-section-icon-wrapper {
                flex-shrink: 0;
            }

            .top-section-icon-bg {
                width: 80px;
                height: 80px;
                background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
                border-radius: 20px;
                display: flex;
                align-items: center;
                justify-content: center;
                box-shadow: 0 10px 30px rgba(245, 87, 108, 0.4);
                animation: topIconFloat 3s ease-in-out infinite;
            }

            @keyframes topIconFloat {
                0%, 100% { transform: translateY(0px); }
                50% { transform: translateY(-10px); }
            }

            .top-section-icon-bg i {
                font-size: 36px;
                color: white;
            }

            .top-section-title-wrapper {
                flex: 1;
            }

            .top-section-main-title {
                font-size: 32px;
                font-weight: 800;
                color: white;
                margin: 0 0 8px 0;
                text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
                letter-spacing: -0.5px;
            }

            .top-section-subtitle {
                font-size: 16px;
                color: rgba(255, 255, 255, 0.9);
                margin: 0;
                font-weight: 400;
            }

            /* Grid Layout */
            .top-section-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(450px, 1fr));
                gap: 24px;
                position: relative;
                z-index: 1;
            }

            /* Card Styling */
            .top-card {
                background: white;
                border-radius: 20px;
                padding: 24px;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
                transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                position: relative;
                overflow: hidden;
            }

            .top-card::before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                height: 4px;
                background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
            }

            .top-customers-card::before {
                background: linear-gradient(90deg, #f093fb 0%, #f5576c 100%);
            }

            .top-products-card::before {
                background: linear-gradient(90deg, #4facfe 0%, #00f2fe 100%);
            }

            .top-card:hover {
                transform: translateY(-8px);
                box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
            }

            /* Card Header */
            .top-card-header {
                display: flex;
                align-items: center;
                justify-content: space-between;
                margin-bottom: 24px;
                padding-bottom: 20px;
                border-bottom: 2px solid #f0f0f0;
                gap: 16px;
                flex-wrap: wrap;
            }

            .top-card-header-left {
                display: flex;
                align-items: center;
                gap: 16px;
                flex: 1;
            }

            .top-card-header-right {
                display: flex;
                align-items: center;
                gap: 12px;
            }

            .top-card-filter {
                display: flex;
                align-items: center;
            }

            .top-card-filter .select2-container {
                min-width: 150px;
            }

            .top-card-filter .select2-container--default .select2-selection--single {
                height: 36px;
                border: 1px solid #e2e8f0;
                border-radius: 8px;
                background: white;
                transition: all 0.2s ease;
            }

            .top-card-filter .select2-container--default .select2-selection--single:hover {
                border-color: #667eea;
            }

            .top-card-filter .select2-container--default .select2-selection--single .select2-selection__rendered {
                line-height: 34px;
                padding-left: 12px;
                color: #4a5568;
                font-size: 13px;
            }

            .top-card-filter .select2-container--default .select2-selection--single .select2-selection__arrow {
                height: 34px;
                right: 8px;
            }

            .top-card-icon-circle {
                width: 56px;
                height: 56px;
                border-radius: 16px;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 24px;
                color: white;
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            }

            .top-card-icon-customers {
                background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            }

            .top-card-icon-products {
                background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            }

            .top-card-title {
                font-size: 20px;
                font-weight: 700;
                color: #1a202c;
                margin: 0 0 4px 0;
            }

            .top-card-subtitle {
                font-size: 13px;
                color: #718096;
                margin: 0;
                font-weight: 500;
            }

            .top-card-badge {
                width: 40px;
                height: 40px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-radius: 12px;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                font-weight: 700;
                font-size: 16px;
                box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
            }

            /* Table Styling - No Scrolling */
            .top-card-content {
                overflow: visible !important;
                max-height: none !important;
                height: auto !important;
            }

            .top-table-wrapper {
                overflow: visible !important;
                overflow-x: visible !important;
                overflow-y: visible !important;
            }

            .top-card .top-card-content,
            .top-card .top-table-wrapper,
            .top-card table {
                overflow: visible !important;
            }

            .top-modern-table {
                width: 100%;
                border-collapse: separate;
                border-spacing: 0;
            }

            .top-modern-table thead {
                position: relative;
                z-index: 10;
            }

            .top-modern-table thead tr {
                background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
            }

            .top-modern-table th {
                padding: 16px 12px;
                text-align: left;
                font-size: 12px;
                font-weight: 700;
                color: #4a5568;
                text-transform: uppercase;
                letter-spacing: 0.5px;
                border-bottom: 2px solid #e2e8f0;
            }

            .top-modern-table th.top-table-rank {
                width: 60px;
                text-align: center;
            }

            .top-modern-table th.top-table-name {
                width: auto;
            }

            .top-modern-table th.top-table-value {
                width: 120px;
                text-align: right;
            }

            .top-modern-table tbody tr {
                transition: all 0.2s ease;
                border-bottom: 1px solid #f0f0f0;
            }

            .top-modern-table tbody tr:hover {
                background: linear-gradient(90deg, rgba(102, 126, 234, 0.05) 0%, transparent 100%);
                transform: scale(1.01);
            }

            .top-modern-table tbody tr:last-child {
                border-bottom: none;
            }

            .top-modern-table td {
                padding: 16px 12px;
                font-size: 14px;
                color: #2d3748;
            }

            .top-modern-table tbody td:first-child {
                text-align: center;
                font-weight: 700;
                font-size: 16px;
                color: #667eea;
            }

            .top-modern-table tbody td:nth-child(2) {
                font-weight: 500;
                color: #1a202c;
            }

            .top-modern-table tbody td:last-child {
                text-align: right;
                font-weight: 700;
                color: #2d3748;
            }

            /* Rank Badge Styling */
            .top-modern-table tbody tr:nth-child(1) td:first-child {
                background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
                color: white;
                border-radius: 8px;
                width: 36px;
                height: 36px;
                display: inline-flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto;
            }

            .top-modern-table tbody tr:nth-child(2) td:first-child {
                background: linear-gradient(135deg, #94a3b8 0%, #64748b 100%);
                color: white;
                border-radius: 8px;
                width: 36px;
                height: 36px;
                display: inline-flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto;
            }

            .top-modern-table tbody tr:nth-child(3) td:first-child {
                background: linear-gradient(135deg, #cd7f32 0%, #b87333 100%);
                color: white;
                border-radius: 8px;
                width: 36px;
                height: 36px;
                display: inline-flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto;
            }


            /* Responsive Design */
            @media (max-width: 1024px) {
                .top-section-grid {
                    grid-template-columns: 1fr;
                }

                .top-customers-products-wrapper {
                    padding: 24px;
                }

                .top-section-main-title {
                    font-size: 28px;
                }
            }

            @media (max-width: 768px) {
                .top-customers-products-wrapper {
                    padding: 20px;
                    border-radius: 16px;
                }

                .top-section-header {
                    flex-direction: column;
                    text-align: center;
                }

                .top-section-icon-bg {
                    width: 64px;
                    height: 64px;
                }

                .top-section-icon-bg i {
                    font-size: 28px;
                }

                .top-section-main-title {
                    font-size: 24px;
                }

                .top-card {
                    padding: 20px;
                }

                .top-card-header {
                    flex-direction: column;
                    align-items: flex-start;
                    gap: 12px;
                }

                .top-card-header-right {
                    width: 100%;
                    justify-content: space-between;
                }

                .top-card-filter {
                    flex: 1;
                    max-width: 200px;
                }

                .top-modern-table {
                    font-size: 12px;
                }

                .top-modern-table th,
                .top-modern-table td {
                    padding: 12px 8px;
                }
            }

            /* Empty State */
            .top-modern-table tbody tr td[colspan] {
                text-align: center;
                padding: 40px 20px;
                color: #a0aec0;
                font-style: italic;
            }

            /* Responsive */
            @media (max-width: 768px) {
                .modern-data-card {
                    padding: 20px;
                }

                .modern-data-card-header {
                    flex-direction: column;
                    align-items: flex-start;
                    gap: 12px;
                }

                .modern-data-card-select {
                    width: 100%;
                }
            }
        </style>
        <div class="tw-px-5 tw-py-6">
            <div class="tw-grid tw-grid-cols-1 tw-gap-4 sm:tw-gap-5 lg:tw-grid-cols-2">
                <?php if(auth()->user()->can('sell.view') || auth()->user()->can('direct_sell.view')): ?>
                    <div class="modern-data-card lg:tw-col-span-1">
                        <div class="modern-data-card-header">
                            <div class="modern-data-card-icon">
                                <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M12 9v4"></path>
                                        <path
                                            d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                                        </path>
                                        <path d="M12 16h.01"></path>
                                    </svg>
                                </div>
                            <div style="flex: 1; display: flex; align-items: center; gap: 16px; flex-wrap: wrap;">
                                <h3 class="modern-data-card-title">
                                            <?php echo e(__('lang_v1.sales_payment_dues'), false); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.tooltip_sales_payment_dues') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                        </h3>
                                <div class="modern-data-card-select">
                                        <?php echo Form::select('sales_payment_dues_location', $all_locations, null, [
                                            'class' => 'form-control select2',
                                            'placeholder' => __('lang_v1.select_location'),
                                            'id' => 'sales_payment_dues_location',
                                        ]); ?>

                                    </div>
                                </div>
                            </div>


                        <div class="tw-flow-root tw-mt-5">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped" id="sales_payment_dues_table"
                                            style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('contact.customer'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.invoice_no'); ?></th>
                                                    <th><?php echo app('translator')->get('home.due_amount'); ?></th>
                                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.view')): ?>
                    <div class="modern-data-card lg:tw-col-span-1">
                        <div class="modern-data-card-header">
                            <div class="modern-data-card-icon">
                                <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                        stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M12 9v4"></path>
                                        <path
                                            d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                                        </path>
                                        <path d="M12 16h.01"></path>
                                    </svg>
                                </div>
                            <div style="flex: 1; display: flex; align-items: center; gap: 16px; flex-wrap: wrap;">
                                <h3 class="modern-data-card-title">
                                            <?php echo e(__('lang_v1.purchase_payment_dues'), false); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('tooltip.payment_dues') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                        </h3>
                                        <?php if(count($all_locations) > 1): ?>
                                    <div class="modern-data-card-select">
                                            <?php echo Form::select('purchase_payment_dues_location', $all_locations, null, [
                                                'class' => 'form-control select2 ',
                                                'placeholder' => __('lang_v1.select_location'),
                                                'id' => 'purchase_payment_dues_location',
                                            ]); ?>

                                    </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                        <div class="tw-flow-root tw-mt-5">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped" id="purchase_payment_dues_table"
                                            style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('purchase.supplier'); ?></th>
                                                    <th><?php echo app('translator')->get('purchase.ref_no'); ?></th>
                                                    <th><?php echo app('translator')->get('home.due_amount'); ?></th>
                                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report.view')): ?>
                    <div class="modern-data-card lg:tw-col-span-1">
                        <div class="modern-data-card-header">
                            <div class="modern-data-card-icon">
                                <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                        stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"></path>
                                        <path d="M12 8v4"></path>
                                        <path d="M12 16h.01"></path>
                                    </svg>
                                </div>
                            <div style="flex: 1; display: flex; align-items: center; gap: 16px; flex-wrap: wrap;">
                                <h3 class="modern-data-card-title">
                                            <?php echo e(__('home.product_stock_alert'), false); ?>

                                            <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('tooltip.product_stock_alert') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                        </h3>
                                        <?php if(count($all_locations) > 1): ?>
                                    <div class="modern-data-card-select">
                                            <?php echo Form::select('stock_alert_location', $all_locations, null, [
                                                'class' => 'form-control select2',
                                                'placeholder' => __('lang_v1.select_location'),
                                                'id' => 'stock_alert_location',
                                            ]); ?>

                                    </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                        <div class="tw-flow-root tw-mt-5">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped" id="stock_alert_table"
                                            style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('sale.product'); ?></th>
                                                    <th><?php echo app('translator')->get('business.location'); ?></th>
                                                    <th><?php echo app('translator')->get('report.current_stock'); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if(session('business.enable_product_expiry') == 1): ?>
                        <div class="modern-data-card lg:tw-col-span-1">
                            <div class="modern-data-card-header">
                                <div class="modern-data-card-icon">
                                    <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                        stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M12 9v4"></path>
                                            <path
                                                d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                                            </path>
                                            <path d="M12 16h.01"></path>
                                        </svg>
                                    </div>
                                <div style="flex: 1;">
                                    <h3 class="modern-data-card-title">
                                                <?php echo e(__('home.stock_expiry_alert'), false); ?>

                                                <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('tooltip.stock_expiry_alert', [
                                                'days'
                                                =>session('business.stock_expiry_alert_days', 30) ]) . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
                                            </h3>
                                        </div>
                                    </div>
                            <div class="tw-flow-root tw-mt-5">
                                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                            <input type="hidden" id="stock_expiry_alert_days"
                                                value="<?php echo e(\Carbon::now()->addDays(session('business.stock_expiry_alert_days', 30))->format('Y-m-d'), false); ?>">
                                            <table class="table table-bordered table-striped" id="stock_expiry_alert_table">
                                                <thead>
                                                    <tr>
                                                        <th><?php echo app('translator')->get('business.product'); ?></th>
                                                        <th><?php echo app('translator')->get('business.location'); ?></th>
                                                        <th><?php echo app('translator')->get('report.stock_left'); ?></th>
                                                        <th><?php echo app('translator')->get('product.expires_in'); ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Top Customers and Products Section - Modern Redesign -->
                <div class="top-customers-products-wrapper" style="grid-column: 1 / -1;">
                    <!-- Main Header -->
                    <div class="top-section-header">
                        <div class="top-section-icon-wrapper">
                            <div class="top-section-icon-bg">
                                <i class="fas fa-trophy"></i>
                            </div>
                        </div>
                        <div class="top-section-title-wrapper">
                            <h2 class="top-section-main-title">Top Performers</h2>
                            <p class="top-section-subtitle">Leading Customers & Best Selling Products</p>
                        </div>
                    </div>

                    <!-- Two Column Layout -->
                    <div class="top-section-grid">
                        <!-- Top Customers Card -->
                        <div class="top-card top-customers-card">
                            <div class="top-card-header">
                                <div class="top-card-header-left">
                                    <div class="top-card-icon-circle top-card-icon-customers">
                                        <i class="fas fa-users"></i>
                                    </div>
                                    <div>
                                        <h3 class="top-card-title">Top Customers</h3>
                                        <p class="top-card-subtitle">Highest Revenue Generators</p>
                                    </div>
                                </div>
                                <div class="top-card-header-right">
                                    <?php if(count($all_locations) > 1): ?>
                                        <div class="top-card-filter">
                                            <?php echo Form::select('top_customers_location', $all_locations, null, [
                                                'class' => 'form-control select2 top-filter-select',
                                                'placeholder' => __('lang_v1.all_locations'),
                                                'id' => 'top_customers_location',
                                                'style' => 'min-width: 150px;'
                                            ]); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div class="top-card-badge">10</div>
                                </div>
                            </div>
                            <div class="top-card-content">
                                <div class="top-table-wrapper">
                                    <table class="top-modern-table" id="top_customers_table">
                                        <thead>
                                            <tr>
                                                <th class="top-table-rank">Rank</th>
                                                <th class="top-table-name">Customer Name</th>
                                                <th class="top-table-value">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Data will be loaded via AJAX -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Products Card -->
                        <div class="top-card top-products-card">
                            <div class="top-card-header">
                                <div class="top-card-header-left">
                                    <div class="top-card-icon-circle top-card-icon-products">
                                        <i class="fas fa-box"></i>
                                    </div>
                                    <div>
                                        <h3 class="top-card-title">Top Products</h3>
                                        <p class="top-card-subtitle">Most Sold Items</p>
                                    </div>
                                </div>
                                <div class="top-card-badge">10</div>
                            </div>
                            <div class="top-card-content">
                                <div class="top-table-wrapper">
                                    <table class="top-modern-table" id="top_products_table">
                                        <thead>
                                            <tr>
                                                <th class="top-table-rank">Rank</th>
                                                <th class="top-table-name">Product Name</th>
                                                <th class="top-table-value">Quantity</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Data will be loaded via AJAX -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if(auth()->user()->can('so.view_all') || auth()->user()->can('so.view_own')): ?>
                    <div class="modern-data-card lg:tw-col-span-2">
                        <div class="modern-data-card-header">
                            <div class="modern-data-card-icon">
                                <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"></path>
                                        <path d="M12 8v4"></path>
                                        <path d="M12 16h.01"></path>
                                    </svg>
                                </div>
                            <div style="flex: 1; display: flex; align-items: center; gap: 16px; flex-wrap: wrap;">
                                <h3 class="modern-data-card-title">
                                            <?php echo e(__('lang_v1.sales_order'), false); ?>

                                        </h3>
                                        <?php if(count($all_locations) > 1): ?>
                                    <div class="modern-data-card-select">
                                            <?php echo Form::select('so_location', $all_locations, null, [
                                                'class' => 'form-control select2',
                                                'placeholder' => __('lang_v1.select_location'),
                                                'id' => 'so_location',
                                            ]); ?>

                                    </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                        <div class="tw-flow-root tw-mt-5">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped ajax_view"
                                            id="sales_order_table">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                                    <th><?php echo app('translator')->get('messages.date'); ?></th>
                                                    <th><?php echo app('translator')->get('restaurant.order_no'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.customer_name'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.contact_no'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.location'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.status'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.shipping_status'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.quantity_remaining'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.added_by'); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if(
                    !empty($common_settings['enable_purchase_requisition']) &&
                        (auth()->user()->can('purchase_requisition.view_all') || auth()->user()->can('purchase_requisition.view_own'))): ?>
                    <div
                        class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
                        <div class="tw-p-4 sm:tw-p-5">
                            <div class="tw-flex tw-items-center tw-gap-2.5">
                                <div
                                    class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                                    <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                                        xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                        stroke="currentColor" fill="none" stroke-linecap="round"
                                        stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M10 10v4a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-4"></path>
                                        <path d="M9 6h6"></path>
                                        <path d="M10 6v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2"></path>
                                        <circle cx="12" cy="16" r="2"></circle>
                                        <path d="M5 20h14a2 2 0 0 0 2 -2v-10"></path>
                                        <path d="M15 16v4"></path>
                                        <path d="M9 20v-4"></path>
                                    </svg>
                                </div>
                                <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                                    <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                                        <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                            <?php echo app('translator')->get('lang_v1.purchase_requisition'); ?>
                                        </h3>
                                    </div>
                                    <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                                        <?php if(count($all_locations) > 1): ?>
                                            <?php if(count($all_locations) > 1): ?>
                                                <?php echo Form::select('pr_location', $all_locations, null, [
                                                    'class' => 'form-control select2',
                                                    'placeholder' => __('lang_v1.select_location'),
                                                    'id' => 'pr_location',
                                                ]); ?>

                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped ajax_view"
                                            id="purchase_requisition_table" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                                    <th><?php echo app('translator')->get('messages.date'); ?></th>
                                                    <th><?php echo app('translator')->get('purchase.ref_no'); ?></th>
                                                    <th><?php echo app('translator')->get('purchase.location'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.status'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.required_by_date'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.added_by'); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(
                    !empty($common_settings['enable_purchase_order']) &&
                        (auth()->user()->can('purchase_order.view_all') || auth()->user()->can('purchase_order.view_own'))): ?>

                    <div
                        class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
                        <div class="tw-p-4 sm:tw-p-5">
                            <div class="tw-flex tw-items-center tw-gap-2.5">
                                <div
                                    class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                                    <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                                        xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                        stroke="currentColor" fill="none" stroke-linecap="round"
                                        stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <rect x="4" y="4" width="16" height="16" rx="2" />
                                        <line x1="4" y1="10" x2="20" y2="10" />
                                        <line x1="12" y1="4" x2="12" y2="20" />
                                        <line x1="12" y1="10" x2="16" y2="10" />
                                    </svg>
                                </div>
                                <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                                    <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                                        <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                            <?php echo app('translator')->get('lang_v1.purchase_order'); ?>
                                        </h3>
                                    </div>
                                    <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                                        <?php if(count($all_locations) > 1): ?>
                                            <?php echo Form::select('po_location', $all_locations, null, [
                                                'class' => 'form-control select2',
                                                'placeholder' => __('lang_v1.select_location'),
                                                'id' => 'po_location',
                                            ]); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped ajax_view"
                                            id="purchase_order_table" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                                    <th><?php echo app('translator')->get('messages.date'); ?></th>
                                                    <th><?php echo app('translator')->get('purchase.ref_no'); ?></th>
                                                    <th><?php echo app('translator')->get('purchase.location'); ?></th>
                                                    <th><?php echo app('translator')->get('purchase.supplier'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.status'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.quantity_remaining'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.added_by'); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endif; ?>
                <?php if(auth()->user()->can('access_pending_shipments_only') ||
                        auth()->user()->can('access_shipping') ||
                        auth()->user()->can('access_own_shipping')): ?>
                    <div class="modern-data-card lg:tw-col-span-2">
                        <div class="modern-data-card-header">
                            <div class="modern-data-card-icon">
                                <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                        <path d="M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                        <path d="M5 17h-2v-4m-1 -8h11v12m-4 0h6m4 0h2v-6h-8m0 -5h5l3 5"></path>
                                        <path d="M3 9l4 0"></path>
                                    </svg>
                                </div>
                            <div style="flex: 1; display: flex; align-items: center; gap: 16px; flex-wrap: wrap;">
                                <h3 class="modern-data-card-title">
                                            <?php echo app('translator')->get('lang_v1.pending_shipments'); ?>
                                        </h3>
                                        <?php if(count($all_locations) > 1): ?>
                                    <div class="modern-data-card-select">
                                            <?php echo Form::select('pending_shipments_location', $all_locations, null, [
                                                'class' => 'form-control select2 ',
                                                'placeholder' => __('lang_v1.select_location'),
                                                'id' => 'pending_shipments_location',
                                            ]); ?>

                                    </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                        <div class="tw-flow-root tw-mt-5">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped ajax_view" id="shipments_table">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                                    <th><?php echo app('translator')->get('messages.date'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.invoice_no'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.customer_name'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.contact_no'); ?></th>
                                                    <th><?php echo app('translator')->get('sale.location'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.shipping_status'); ?></th>
                                                    <?php if(!empty($custom_labels['shipping']['custom_field_1'])): ?>
                                                        <th>
                                                            <?php echo e($custom_labels['shipping']['custom_field_1'], false); ?>

                                                        </th>
                                                    <?php endif; ?>
                                                    <?php if(!empty($custom_labels['shipping']['custom_field_2'])): ?>
                                                        <th>
                                                            <?php echo e($custom_labels['shipping']['custom_field_2'], false); ?>

                                                        </th>
                                                    <?php endif; ?>
                                                    <?php if(!empty($custom_labels['shipping']['custom_field_3'])): ?>
                                                        <th>
                                                            <?php echo e($custom_labels['shipping']['custom_field_3'], false); ?>

                                                        </th>
                                                    <?php endif; ?>
                                                    <?php if(!empty($custom_labels['shipping']['custom_field_4'])): ?>
                                                        <th>
                                                            <?php echo e($custom_labels['shipping']['custom_field_4'], false); ?>

                                                        </th>
                                                    <?php endif; ?>
                                                    <?php if(!empty($custom_labels['shipping']['custom_field_5'])): ?>
                                                        <th>
                                                            <?php echo e($custom_labels['shipping']['custom_field_5'], false); ?>

                                                        </th>
                                                    <?php endif; ?>
                                                    <th><?php echo app('translator')->get('sale.payment_status'); ?></th>
                                                    <th><?php echo app('translator')->get('restaurant.service_staff'); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if(auth()->user()->can('account.access') && config('constants.show_payments_recovered_today') == true): ?>
                    <div
                        class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
                        <div class="tw-p-4 sm:tw-p-5">
                            <div class="tw-flex tw-items-center tw-gap-2.5">
                                <div
                                    class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                                    <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                                        xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                        stroke="currentColor" fill="none" stroke-linecap="round"
                                        stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M12 9v4"></path>
                                        <path
                                            d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                                        </path>
                                        <path d="M12 16h.01"></path>
                                    </svg>
                                </div>
                                <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                                    <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                                        <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                            <?php echo app('translator')->get('lang_v1.payment_recovered_today'); ?>
                                        </h3>
                                    </div>

                                </div>
                            </div>
                            <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                                <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                                        <table class="table table-bordered table-striped" id="cash_flow_table">
                                            <thead>
                                                <tr>
                                                    <th><?php echo app('translator')->get('messages.date'); ?></th>
                                                    <th><?php echo app('translator')->get('account.account'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.description'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.payment_method'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.payment_details'); ?></th>
                                                    <th><?php echo app('translator')->get('account.credit'); ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.account_balance'); ?>
                                                        <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.account_balance_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?></th>
                                                    <th><?php echo app('translator')->get('lang_v1.total_balance'); ?>
                                                        <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.total_balance_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?></th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr class="bg-gray font-17 footer-total text-center">
                                                    <td colspan="5"><strong><?php echo app('translator')->get('sale.total'); ?>:</strong></td>
                                                    <td class="footer_total_credit"></td>
                                                    <td colspan="2"></td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                
            </div>
        </div>
    <?php endif; ?>




<?php $__env->stopSection(); ?>


<div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade edit_pso_status_modal" tabindex="-1" role="dialog"></div>
<div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
</div>

<?php $__env->startSection('css'); ?>
    <style>
        .select2-container {
            width: 100% !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <!-- Defer non-critical scripts for faster page load -->
    <script src="<?php echo e(asset('js/home.js?v=' . $asset_v), false); ?>" defer></script>
    <script>
        // Ensure top customers/products load after page is ready
        $(document).ready(function() {
            // Wait a bit for home.js to load
            setTimeout(function() {
                if (typeof loadTopCustomersAndProducts === 'function') {
                    console.log('Calling loadTopCustomersAndProducts from blade');
                    loadTopCustomersAndProducts();
                } else {
                    console.log('loadTopCustomersAndProducts function not found, retrying...');
                    setTimeout(function() {
                        if (typeof loadTopCustomersAndProducts === 'function') {
                            loadTopCustomersAndProducts();
                        } else {
                            console.error('loadTopCustomersAndProducts function still not found');
                        }
                    }, 2000);
                }
            }, 3000);
        });
    </script>
    <script src="<?php echo e(asset('js/payment.js?v=' . $asset_v), false); ?>" defer></script>
    <?php if ($__env->exists('sales_order.common_js')) echo $__env->make('sales_order.common_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if ($__env->exists('purchase_order.common_js')) echo $__env->make('purchase_order.common_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(!empty($all_locations)): ?>
        <?php echo $sells_chart_1->script(); ?>

        <?php echo $sells_chart_2->script(); ?>

    <?php endif; ?>

    <!-- Chart.js - Load locally with CDN fallback for offline support -->
    <script>
        (function() {
            var script = document.createElement('script');
            script.src = "<?php echo e(asset('js/chart.min.js'), false); ?>";
            script.onload = function() {
                console.log('Chart.js loaded successfully from local file');
            };
            script.onerror = function() {
                console.log('Local Chart.js failed, trying local CDN backup...');
                // Fallback to local CDN backup if primary local file fails
                var fallbackScript = document.createElement('script');
                fallbackScript.src = '<?php echo e(asset('js/cdn/chart.umd.min.js'), false); ?>';
                fallbackScript.onload = function() {
                    console.log('Chart.js loaded successfully from local backup');
                };
                fallbackScript.onerror = function() {
                    console.error('Chart.js failed to load from local files');
                };
                document.head.appendChild(fallbackScript);
            };
            document.head.appendChild(script);
        })();
    </script>

    <!-- Modern Chart Styling Script -->
    <script type="text/javascript">
        $(document).ready(function() {
            // Wait for charts to render, then apply modern styling
            setTimeout(function() {
                modernizeCharts();
            }, 500);
        });

        function modernizeCharts() {
            // Add SVG gradients to all charts
            $('.modern-chart-container svg').each(function() {
                let svg = $(this);
                
                // Check if defs already exists
                if (svg.find('defs').length === 0) {
                    svg.prepend('<defs></defs>');
                }
                
                let defs = svg.find('defs');
                
                // Add modern gradient if not exists
                if (defs.find('#modernGradient1').length === 0) {
                    defs.append(`
                        <linearGradient id="modernGradient1" x1="0%" y1="0%" x2="0%" y2="100%">
                            <stop offset="0%" style="stop-color:#667eea;stop-opacity:0.8" />
                            <stop offset="50%" style="stop-color:#764ba2;stop-opacity:0.6" />
                            <stop offset="100%" style="stop-color:#667eea;stop-opacity:0.1" />
                        </linearGradient>
                    `);
                }
            });

            // Modernize Highcharts styling - Minimalist Style for Sales Charts
            $('.modern-chart-container').each(function() {
                let container = $(this);
                
                // Check if this is the Sales Current FY chart (has chart-area icon in parent)
                let isSalesCurrentFY = container.closest('.modern-chart-wrapper').find('.fa-chart-area').length > 0;
                
                // Create minimalist gradient - light blue/purple fading to transparent
                // Use unique ID for each chart to avoid conflicts
                let gradientId = 'minimalistGradient_' + Math.random().toString(36).substr(2, 9);
                if (container.find('svg defs').length === 0) {
                    container.find('svg').first().prepend('<defs></defs>');
                }
                if (container.find('svg defs linearGradient#' + gradientId).length === 0) {
                    // Use vibrant purple gradient for Sales Current FY (Analytics style), purple for others
                    let gradientColor = isSalesCurrentFY ? '#667eea' : '#667eea';
                    let opacityStart = isSalesCurrentFY ? '0.25' : '0.3';
                    let opacityMid = isSalesCurrentFY ? '0.12' : '0.15';
                    let opacityEnd = isSalesCurrentFY ? '0.02' : '0.05';
                    container.find('svg defs').first().append(`
                        <linearGradient id="${gradientId}" x1="0%" y1="0%" x2="0%" y2="100%">
                            <stop offset="0%" style="stop-color:${gradientColor};stop-opacity:${opacityStart}" />
                            <stop offset="50%" style="stop-color:${gradientColor};stop-opacity:${opacityMid}" />
                            <stop offset="100%" style="stop-color:${gradientColor};stop-opacity:${opacityEnd}" />
                        </linearGradient>
                    `);
                }
                
                // Store gradientId for use in area fills
                container.data('gradientId', gradientId);
                
                // Update area fills with light gradient (lighter for Sales Current FY)
                container.find('.highcharts-area').each(function() {
                    let gradId = container.data('gradientId') || gradientId;
                    $(this).attr('fill', 'url(#' + gradId + ')');
                    $(this).attr('fill-opacity', isSalesCurrentFY ? '0.2' : '0.3');
                });

                // Update line - vibrant purple for Sales Current FY (Analytics style), purple for others
                let lineColor = isSalesCurrentFY ? '#667eea' : '#667eea';
                container.find('.highcharts-graph').each(function() {
                    $(this).attr('stroke', lineColor);
                    $(this).attr('stroke-width', isSalesCurrentFY ? '2.5' : '3');
                    $(this).attr('stroke-linecap', 'round');
                    $(this).attr('stroke-linejoin', 'round');
                });

                // For Sales Current FY: Smooth line with NO visible data points (Analytics style)
                // For other charts: Hide points by default
                if (isSalesCurrentFY) {
                    // Hide data points completely for smooth continuous line (Analytics dashboard style)
                    container.find('.highcharts-point').each(function() {
                        $(this).attr('fill', 'transparent');
                        $(this).attr('stroke', 'transparent');
                        $(this).attr('stroke-width', '0');
                        $(this).attr('r', '0');
                    });
                    
                    // Show points only on hover for interactivity
                    container.find('.highcharts-point').on('mouseenter', function() {
                        $(this).attr('r', '5');
                        $(this).attr('fill', lineColor);
                        $(this).attr('stroke', '#ffffff');
                        $(this).attr('stroke-width', '2');
                    }).on('mouseleave', function() {
                        $(this).attr('r', '0');
                        $(this).attr('fill', 'transparent');
                        $(this).attr('stroke', 'transparent');
                        $(this).attr('stroke-width', '0');
                    });
                } else {
                    // Hide data points by default for cleaner look (other charts)
                    container.find('.highcharts-point').each(function() {
                        $(this).attr('fill', 'transparent');
                        $(this).attr('stroke', 'transparent');
                        $(this).attr('stroke-width', '0');
                        $(this).attr('r', '0');
                    });

                    // Show points only on hover
                    container.find('.highcharts-point').on('mouseenter', function() {
                        $(this).attr('r', '4');
                        $(this).attr('fill', lineColor);
                        $(this).attr('stroke', '#ffffff');
                        $(this).attr('stroke-width', '2');
                    }).on('mouseleave', function() {
                        $(this).attr('r', '0');
                        $(this).attr('fill', 'transparent');
                        $(this).attr('stroke', 'transparent');
                        $(this).attr('stroke-width', '0');
                    });
                }

                // Update grid lines - very subtle horizontal only (Analytics style)
                container.find('.highcharts-grid-line').each(function() {
                    if ($(this).hasClass('highcharts-yaxis-grid')) {
                        // Very subtle grid lines for Sales Current FY
                        let gridOpacity = isSalesCurrentFY ? '0.08' : '0.12';
                        $(this).attr('stroke', `rgba(100, 116, 139, ${gridOpacity})`);
                        $(this).attr('stroke-width', '1');
                    } else {
                        // Hide vertical grid lines
                        $(this).attr('stroke', 'transparent');
                        $(this).attr('stroke-width', '0');
                    }
                });

                // Hide axis lines
                container.find('.highcharts-axis-line').each(function() {
                    $(this).attr('stroke', 'transparent');
                    $(this).attr('stroke-width', '0');
                });

                // Update axis labels - small, subtle
                container.find('.highcharts-axis-labels text').each(function() {
                    $(this).attr('fill', '#64748b');
                    $(this).css('font-family', 'Inter, -apple-system, BlinkMacSystemFont, sans-serif');
                    $(this).css('font-size', '11px');
                    $(this).css('font-weight', '400');
                });

                // Update axis titles
                container.find('.highcharts-axis-title text').each(function() {
                    $(this).attr('fill', '#64748b');
                    $(this).css('font-family', 'Inter, -apple-system, BlinkMacSystemFont, sans-serif');
                    $(this).css('font-weight', '500');
                    $(this).css('font-size', '11px');
                });

                // Update title
                container.find('.highcharts-title').each(function() {
                    $(this).attr('fill', '#1e293b');
                    $(this).css('font-family', 'Inter, -apple-system, BlinkMacSystemFont, sans-serif');
                    $(this).css('font-weight', '600');
                    $(this).css('font-size', '15px');
                });

                // Update legend - minimal styling
                container.find('.highcharts-legend-item text').each(function() {
                    $(this).css('font-family', 'Inter, -apple-system, BlinkMacSystemFont, sans-serif');
                    $(this).css('font-weight', '500');
                    $(this).css('font-size', '12px');
                    $(this).attr('fill', '#475569');
                });

                // Update legend symbols
                container.find('.highcharts-legend-item rect').each(function() {
                    $(this).attr('rx', '3');
                    $(this).attr('ry', '3');
                });

                // Update tooltip - clean, light style
                container.find('.highcharts-tooltip').each(function() {
                    $(this).css('background', 'rgba(255, 255, 255, 0.98)');
                    $(this).css('backdrop-filter', 'blur(10px)');
                    $(this).css('border', '1px solid rgba(100, 116, 139, 0.15)');
                    $(this).css('border-radius', '8px');
                    $(this).css('box-shadow', '0 4px 16px rgba(0, 0, 0, 0.1)');
                });

                container.find('.highcharts-tooltip text').each(function() {
                    $(this).attr('fill', '#1e293b');
                    $(this).css('font-family', 'Inter, -apple-system, BlinkMacSystemFont, sans-serif');
                    $(this).css('font-weight', '500');
                    $(this).css('font-size', '12px');
                });
            });

            // Add smooth animations
            $('.modern-chart-container svg').css({
                'transition': 'all 0.3s ease',
                'opacity': '1'
            });

            // Add hover effects to chart containers
            $('.modern-chart-wrapper').hover(
                function() {
                    $(this).find('.modern-chart-container').css({
                        'transform': 'scale(1.01)',
                        'transition': 'transform 0.3s ease'
                    });
                },
                function() {
                    $(this).find('.modern-chart-container').css({
                        'transform': 'scale(1)'
                    });
                }
            );
        }

        // Re-apply styling when charts are redrawn
        if (typeof Highcharts !== 'undefined') {
            Highcharts.addEvent(Highcharts.Chart, 'render', function() {
                setTimeout(function() {
                    modernizeCharts();
                }, 200);
            });
            
            // Also apply styling after initial load
            setTimeout(function() {
                modernizeCharts();
            }, 500);
        }
        
        // Apply styling specifically to Sales charts after they load
        $(document).ready(function() {
            setTimeout(function() {
                modernizeCharts();
            }, 1000);
        });
    </script>

    <script type="text/javascript">
        // Wait for Chart.js to be fully loaded before initializing charts
        // Enhanced with timeout and error handling for offline support
        function waitForChartJS(callback, maxAttempts) {
            maxAttempts = maxAttempts || 50; // 5 seconds max wait (50 * 100ms)
            var attempts = 0;
            
            function checkChart() {
                attempts++;
                if (typeof Chart !== 'undefined') {
                    callback();
                } else if (attempts < maxAttempts) {
                    setTimeout(checkChart, 100);
                } else {
                    // Chart.js failed to load - show error message
                    console.error('Chart.js failed to load. Dashboard charts may not display correctly.');
                    // Try to initialize charts anyway (they may fail gracefully)
                    try {
                        callback();
                    } catch(e) {
                        console.error('Chart initialization failed:', e);
                    }
                }
            }
            checkChart();
        }

        $(document).ready(function() {
            // Wait for both jQuery and Chart.js to be ready
            waitForChartJS(function() {
                try {
                    console.log('Initializing Business Statistics Charts...');
            // Initialize Business Statistics Charts
            initializeBusinessStatisticsCharts();
                    console.log('Business Statistics Charts initialized successfully');
                } catch(e) {
                    console.error('Error initializing charts:', e);
                }
            });

            // ... existing code ...
        });

        function initializeBusinessStatisticsCharts() {
            // Check if Chart.js is available
            if (typeof Chart === 'undefined') {
                console.error('Chart.js is not loaded. Cannot initialize charts.');
                return;
            }
            
            try {
                // Sales vs Purchase Chart - Modern Style
                const salesVsPurchaseCanvas = document.getElementById('salesVsPurchaseChart');
                if (!salesVsPurchaseCanvas) {
                    console.error('salesVsPurchaseChart canvas not found');
                } else {
                    const salesVsPurchaseCtx = salesVsPurchaseCanvas.getContext('2d');
            
            // Create gradient for Sales
            const salesGradient = salesVsPurchaseCtx.createLinearGradient(0, 0, 0, 400);
            salesGradient.addColorStop(0, 'rgba(102, 126, 234, 1)');
            salesGradient.addColorStop(1, 'rgba(118, 75, 162, 1)');
            
            // Create gradient for Purchases
            const purchaseGradient = salesVsPurchaseCtx.createLinearGradient(0, 0, 0, 400);
            purchaseGradient.addColorStop(0, 'rgba(240, 147, 251, 1)');
            purchaseGradient.addColorStop(1, 'rgba(245, 87, 108, 1)');
            
            // Create gradient for Expenses
            const expenseGradient = salesVsPurchaseCtx.createLinearGradient(0, 0, 0, 400);
            expenseGradient.addColorStop(0, 'rgba(250, 225, 64, 1)');
            expenseGradient.addColorStop(1, 'rgba(250, 112, 154, 1)');
            
            const totalSalesAmount = <?php echo e($total_sell ?? 0, false); ?> + <?php echo e($total_purchase ?? 0, false); ?> + <?php echo e($total_expense ?? 0, false); ?>;
            const salesPercent = totalSalesAmount > 0 ? ((<?php echo e($total_sell ?? 0, false); ?> / totalSalesAmount) * 100).toFixed(1) : 0;
            
            new Chart(salesVsPurchaseCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Sales', 'Purchases', 'Expenses'],
                    datasets: [{
                        data: [
                            <?php echo e($total_sell ?? 0, false); ?>,
                            <?php echo e($total_purchase ?? 0, false); ?>,
                            <?php echo e($total_expense ?? 0, false); ?>

                        ],
                        backgroundColor: [
                            salesGradient,
                            purchaseGradient,
                            expenseGradient
                        ],
                        borderColor: [
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)'
                        ],
                        borderWidth: 3,
                        hoverOffset: 15,
                        hoverBorderWidth: 4,
                        spacing: 2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%',
                    animation: {
                        animateRotate: true,
                        animateScale: true,
                        duration: 2000,
                        easing: 'easeOutQuart'
                    },
                    plugins: {
                        legend: {
                            position: 'bottom',
                            display: true,
                            align: 'center',
                            labels: {
                                padding: 6,
                                boxWidth: 10,
                                boxHeight: 10,
                                usePointStyle: true,
                                pointStyle: 'circle',
                                pointStyleWidth: 10,
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 10,
                                    weight: '600'
                                },
                                color: '#475569',
                                generateLabels: function(chart) {
                                    const data = chart.data;
                                    if (data.labels.length && data.datasets.length) {
                                        const total = data.datasets[0].data.reduce((a, b) => a + b, 0);
                                        // Ensure order: Sales, Purchases, Expenses
                                        const order = ['Sales', 'Purchases', 'Expenses'];
                                        return order.map((labelName) => {
                                            const i = data.labels.indexOf(labelName);
                                            if (i === -1) return null;
                                            const value = data.datasets[0].data[i];
                                            const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                                            return {
                                                text: `${labelName}: ${percentage}%`,
                                                fillStyle: data.datasets[0].backgroundColor[i],
                                                strokeStyle: data.datasets[0].borderColor[i],
                                                lineWidth: data.datasets[0].borderWidth,
                                                hidden: false,
                                                index: i
                                            };
                                        }).filter(item => item !== null);
                                    }
                                    return [];
                                }
                            }
                        },
                        tooltip: {
                            enabled: true,
                            backgroundColor: 'rgba(15, 23, 42, 0.98)',
                            padding: 16,
                            titleFont: {
                                family: 'Inter, sans-serif',
                                size: 14,
                                weight: '700'
                            },
                            bodyFont: {
                                family: 'Inter, sans-serif',
                                size: 13,
                                weight: '600'
                            },
                            borderColor: 'rgba(102, 126, 234, 0.3)',
                            borderWidth: 2,
                            cornerRadius: 12,
                            displayColors: true,
                            callbacks: {
                                title: function(context) {
                                    // For Chart.js v3+, context is an array
                                    if (Array.isArray(context) && context.length > 0) {
                                        return context[0].label || '';
                                    }
                                    // Fallback for single context object
                                    if (context && context.label) {
                                        return context.label;
                                    }
                                    return '';
                                },
                                label: function(context) {
                                    try {
                                        let label = context.label || '';
                                        // For doughnut charts, get the value from context
                                        let value = 0;
                                        if (context.parsed !== undefined && context.parsed !== null) {
                                            value = context.parsed;
                                        } else if (context.raw !== undefined && context.raw !== null) {
                                            value = context.raw;
                                        } else if (context.dataset && context.dataset.data && context.dataIndex !== undefined) {
                                            value = context.dataset.data[context.dataIndex] || 0;
                                        }
                                        
                                        // Calculate total
                                        const total = context.dataset.data.reduce((a, b) => {
                                            const val = (b === 0.01 || b === null || b === undefined) ? 0 : b;
                                            return a + val;
                                        }, 0);
                                        
                                        // Calculate percentage
                                        const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : '0.0';
                                        
                                        // Format amount
                                        let formattedAmount;
                                        if (typeof __currency_trans_from_en !== 'undefined') {
                                            formattedAmount = __currency_trans_from_en(value, true);
                                        } else {
                                            formattedAmount = new Intl.NumberFormat('en-US', {
                                                style: 'currency',
                                                currency: 'USD',
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0
                                            }).format(value);
                                        }
                                        
                                        return [
                                            label + ' ' + percentage + '%',
                                            'Amount ' + formattedAmount
                                        ];
                                    } catch(e) {
                                        console.error('Tooltip error:', e);
                                        return [context.label || '', 'Error loading data'];
                                    }
                                }
                            }
                        }
                    },
                    interaction: {
                        intersect: false,
                        mode: 'point'
                    }
                },
                plugins: [{
                    id: 'centerText',
                    beforeDraw: function(chart) {
                        const ctx = chart.ctx;
                        const chartArea = chart.chartArea;
                        ctx.save();
                        ctx.font = 'bold 20px Inter, sans-serif';
                        ctx.fillStyle = '#1e293b';
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'middle';
                        const centerX = (chartArea.left + chartArea.right) / 2;
                        const centerY = (chartArea.top + chartArea.bottom) / 2;
                        ctx.fillText(salesPercent + '%', centerX, centerY - 8);
                        ctx.font = '600 11px Inter, sans-serif';
                        ctx.fillStyle = '#64748b';
                        ctx.fillText('Sales', centerX, centerY + 12);
                        ctx.restore();
                    }
                }]
            });
                } // Close else block for salesVsPurchaseChart
            } catch(e) {
                console.error('Error creating Sales vs Purchase chart:', e);
            }

            try {
            // Monthly Performance Chart
            const monthlyPerformanceCanvas = document.getElementById('monthlyPerformanceChart');
            if (!monthlyPerformanceCanvas) {
                console.error('monthlyPerformanceChart canvas not found');
            } else {
                const monthlyPerformanceCtx = monthlyPerformanceCanvas.getContext('2d');
            new Chart(monthlyPerformanceCtx, {
                type: 'bar',
                data: {
                    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                    datasets: [{
                        label: 'Sales',
                        data: [
                            <?php echo e($monthly_sales[1] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[2] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[3] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[4] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[5] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[6] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[7] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[8] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[9] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[10] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[11] ?? 0, false); ?>,
                            <?php echo e($monthly_sales[12] ?? 0, false); ?>

                        ],
                        backgroundColor: 'rgba(75, 192, 192, 0.8)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1
                    }, {
                        label: 'Purchases',
                        data: [
                            <?php echo e($monthly_purchases[1] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[2] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[3] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[4] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[5] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[6] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[7] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[8] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[9] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[10] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[11] ?? 0, false); ?>,
                            <?php echo e($monthly_purchases[12] ?? 0, false); ?>

                        ],
                        backgroundColor: 'rgba(255, 99, 132, 0.8)',
                        borderColor: 'rgba(255, 99, 132, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                padding: 8,
                                boxWidth: 12,
                                boxHeight: 12,
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 10,
                                    weight: '600'
                                }
                            }
                        },
                        title: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 9
                                }
                            },
                            grid: {
                                color: 'rgba(0, 0, 0, 0.05)'
                            }
                        },
                        x: {
                            ticks: {
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 9
                                }
                            },
                            grid: {
                                display: false
                            }
                        }
                    },
                    layout: {
                        padding: {
                            top: 10,
                            bottom: 10,
                            left: 10,
                            right: 10
                        }
                    }
                }
            });
                } // Close else block for monthlyPerformanceChart
            } catch(e) {
                console.error('Error creating Monthly Performance chart:', e);
            }

            try {
            // Monthly Expenses Chart
            const monthlyExpensesCanvas = document.getElementById('monthlyExpensesChart');
            if (!monthlyExpensesCanvas) {
                console.error('monthlyExpensesChart canvas not found');
            } else {
                const monthlyExpensesCtx = monthlyExpensesCanvas.getContext('2d');
            new Chart(monthlyExpensesCtx, {
                type: 'bar',
                data: {
                    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                    datasets: [{
                        label: 'Expenses',
                        data: [
                            <?php echo e($monthly_expenses[1] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[2] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[3] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[4] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[5] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[6] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[7] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[8] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[9] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[10] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[11] ?? 0, false); ?>,
                            <?php echo e($monthly_expenses[12] ?? 0, false); ?>

                        ],
                        backgroundColor: 'rgba(255, 206, 86, 0.8)',
                        borderColor: 'rgba(255, 206, 86, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                padding: 8,
                                boxWidth: 12,
                                boxHeight: 12,
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 10,
                                    weight: '600'
                                }
                            }
                        },
                        title: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 9
                                }
                            },
                            grid: {
                                color: 'rgba(0, 0, 0, 0.05)'
                            }
                        },
                        x: {
                            ticks: {
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 9
                                }
                            },
                            grid: {
                                display: false
                            }
                        }
                    },
                    layout: {
                        padding: {
                            top: 10,
                            bottom: 10,
                            left: 10,
                            right: 10
                        }
                    }
                }
            });
                } // Close else block for monthlyExpensesChart
            } catch(e) {
                console.error('Error creating Monthly Expenses chart:', e);
            }

            try {
            // Invoice Due vs Purchase Due Pie Chart - Modern Style
            const invoiceVsPurchaseDueCanvas = document.getElementById('invoiceVsPurchaseDueChart');
            if (!invoiceVsPurchaseDueCanvas) {
                console.error('invoiceVsPurchaseDueChart canvas not found');
            } else {
                const invoiceVsPurchaseDueCtx = invoiceVsPurchaseDueCanvas.getContext('2d');
            
            // Create gradient for Invoice Due
            const invoiceGradient = invoiceVsPurchaseDueCtx.createLinearGradient(0, 0, 0, 400);
            invoiceGradient.addColorStop(0, 'rgba(79, 172, 254, 1)');
            invoiceGradient.addColorStop(1, 'rgba(0, 242, 254, 1)');
            
            // Create gradient for Purchase Due
            const purchaseDueGradient = invoiceVsPurchaseDueCtx.createLinearGradient(0, 0, 0, 400);
            purchaseDueGradient.addColorStop(0, 'rgba(250, 112, 154, 1)');
            purchaseDueGradient.addColorStop(1, 'rgba(254, 225, 64, 1)');
            
            const totalDueAmount = <?php echo e($invoice_due ?? 0, false); ?> + <?php echo e($purchase_due ?? 0, false); ?>;
            const invoicePercent = totalDueAmount > 0 ? ((<?php echo e($invoice_due ?? 0, false); ?> / totalDueAmount) * 100).toFixed(1) : 0;
            
            // Ensure minimum values for chart display
            const invoiceDueValue = <?php echo e($invoice_due ?? 0, false); ?> || 0.01;
            const purchaseDueValue = <?php echo e($purchase_due ?? 0, false); ?> || 0.01;
            
            new Chart(invoiceVsPurchaseDueCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Invoice Due', 'Purchase Due'],
                    datasets: [{
                        data: [
                            invoiceDueValue,
                            purchaseDueValue
                        ],
                        backgroundColor: [
                            invoiceGradient,
                            purchaseDueGradient
                        ],
                        borderColor: [
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)'
                        ],
                        borderWidth: 3,
                        hoverOffset: 15,
                        hoverBorderWidth: 4,
                        spacing: 2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%',
                    animation: {
                        animateRotate: true,
                        animateScale: true,
                        duration: 1500,
                        easing: 'easeOutQuart'
                    },
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 4,
                                usePointStyle: true,
                                pointStyle: 'circle',
                                pointStyleWidth: 8,
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 9,
                                    weight: '600'
                                },
                                color: '#475569',
                                generateLabels: function(chart) {
                                    const data = chart.data;
                                    if (data.labels.length && data.datasets.length) {
                                        const total = data.datasets[0].data.reduce((a, b) => a + b, 0);
                                        return data.labels.map((label, i) => {
                                            const value = data.datasets[0].data[i];
                                            const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                                            return {
                                                text: `${label}: ${percentage}%`,
                                                fillStyle: data.datasets[0].backgroundColor[i],
                                                strokeStyle: data.datasets[0].borderColor[i],
                                                lineWidth: data.datasets[0].borderWidth,
                                                hidden: false,
                                                index: i
                                            };
                                        });
                                    }
                                    return [];
                                }
                            }
                        },
                        tooltip: {
                            enabled: true,
                            backgroundColor: 'rgba(15, 23, 42, 0.98)',
                            padding: 16,
                            titleFont: {
                                family: 'Inter, sans-serif',
                                size: 14,
                                weight: '700'
                            },
                            bodyFont: {
                                family: 'Inter, sans-serif',
                                size: 13,
                                weight: '600'
                            },
                            borderColor: 'rgba(79, 172, 254, 0.3)',
                            borderWidth: 2,
                            cornerRadius: 12,
                            displayColors: true,
                            callbacks: {
                                title: function(context) {
                                    // For Chart.js v3+, context is an array
                                    if (Array.isArray(context) && context.length > 0) {
                                        return context[0].label || '';
                                    }
                                    // Fallback for single context object
                                    if (context && context.label) {
                                        return context.label;
                                    }
                                    return '';
                                },
                                label: function(context) {
                                    try {
                                        let label = context.label || '';
                                        // For doughnut charts, get the value from context
                                        let value = 0;
                                        if (context.parsed !== undefined && context.parsed !== null) {
                                            value = context.parsed;
                                        } else if (context.raw !== undefined && context.raw !== null) {
                                            value = context.raw;
                                        } else if (context.dataset && context.dataset.data && context.dataIndex !== undefined) {
                                            value = context.dataset.data[context.dataIndex] || 0;
                                        }
                                        
                                        // Calculate total
                                        const total = context.dataset.data.reduce((a, b) => {
                                            const val = (b === 0.01 || b === null || b === undefined) ? 0 : b;
                                            return a + val;
                                        }, 0);
                                        
                                        // Calculate percentage
                                        const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : '0.0';
                                        
                                        // Format amount
                                        let formattedAmount;
                                        if (typeof __currency_trans_from_en !== 'undefined') {
                                            formattedAmount = __currency_trans_from_en(value, true);
                                        } else {
                                            formattedAmount = new Intl.NumberFormat('en-US', {
                                                style: 'currency',
                                                currency: 'USD',
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0
                                            }).format(value);
                                        }
                                        
                                        return [
                                            label + ' ' + percentage + '%',
                                            'Amount ' + formattedAmount
                                        ];
                                    } catch(e) {
                                        console.error('Tooltip error:', e);
                                        return [context.label || '', 'Error loading data'];
                                    }
                                }
                            }
                        }
                    }
                },
                plugins: [{
                    id: 'centerText',
                    beforeDraw: function(chart) {
                        const ctx = chart.ctx;
                        const chartArea = chart.chartArea;
                        ctx.save();
                        ctx.font = 'bold 20px Inter, sans-serif';
                        ctx.fillStyle = '#1e293b';
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'middle';
                        const centerX = (chartArea.left + chartArea.right) / 2;
                        const centerY = (chartArea.top + chartArea.bottom) / 2;
                        ctx.fillText(invoicePercent + '%', centerX, centerY - 8);
                        ctx.font = '600 11px Inter, sans-serif';
                        ctx.fillStyle = '#64748b';
                        ctx.fillText('Invoice Due', centerX, centerY + 12);
                        ctx.restore();
                    }
                }]
            });
                } // Close else block for invoiceVsPurchaseDueChart
            } catch(e) {
                console.error('Error creating Invoice Due vs Purchase Due chart:', e);
            }

            try {
            // Net vs Expense Pie Chart - Modern Style
            const netVsExpenseCanvas = document.getElementById('netVsExpenseChart');
            if (!netVsExpenseCanvas) {
                console.error('netVsExpenseChart canvas not found');
            } else {
                const netVsExpenseCtx = netVsExpenseCanvas.getContext('2d');
            
            // Create gradient for Net
            const netGradient = netVsExpenseCtx.createLinearGradient(0, 0, 0, 400);
            netGradient.addColorStop(0, 'rgba(17, 153, 142, 1)');
            netGradient.addColorStop(1, 'rgba(56, 239, 125, 1)');
            
            // Create gradient for Expense
            const expenseNetGradient = netVsExpenseCtx.createLinearGradient(0, 0, 0, 400);
            expenseNetGradient.addColorStop(0, 'rgba(250, 112, 154, 1)');
            expenseNetGradient.addColorStop(1, 'rgba(254, 225, 64, 1)');
            
            const totalNetAmount = <?php echo e($net ?? 0, false); ?> + <?php echo e($total_expense ?? 0, false); ?>;
            const netPercent = totalNetAmount > 0 ? ((<?php echo e($net ?? 0, false); ?> / totalNetAmount) * 100).toFixed(1) : 0;
            
            // Ensure minimum values for chart display - handle negative net as 0
            const netValue = Math.max(<?php echo e($net ?? 0, false); ?>, 0);
            const expenseValue = <?php echo e($total_expense ?? 0, false); ?> || 0.01;
            const netValueForChart = netValue || 0.01;
            
            new Chart(netVsExpenseCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Net', 'Expense'],
                    datasets: [{
                        data: [
                            netValueForChart,
                            expenseValue
                        ],
                        backgroundColor: [
                            netGradient,
                            expenseNetGradient
                        ],
                        borderColor: [
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)'
                        ],
                        borderWidth: 4,
                        hoverOffset: 20,
                        hoverBorderWidth: 5,
                        spacing: 3
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    cutout: '75%',
                    animation: {
                        animateRotate: true,
                        animateScale: true,
                        duration: 2000,
                        easing: 'easeOutQuart'
                    },
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 6,
                                usePointStyle: true,
                                pointStyle: 'circle',
                                pointStyleWidth: 10,
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 12,
                                    weight: '600'
                                },
                                color: '#475569',
                                generateLabels: function(chart) {
                                    const data = chart.data;
                                    if (data.labels.length && data.datasets.length) {
                                        const total = data.datasets[0].data.reduce((a, b) => a + (b === 0.01 ? 0 : b), 0);
                                        return data.labels.map((label, i) => {
                                            const value = data.datasets[0].data[i];
                                            const actualValue = value === 0.01 ? 0 : value;
                                            const percentage = total > 0 ? ((actualValue / total) * 100).toFixed(1) : 0;
                                            return {
                                                text: `${label}: ${percentage}%`,
                                                fillStyle: data.datasets[0].backgroundColor[i],
                                                strokeStyle: data.datasets[0].borderColor[i],
                                                lineWidth: data.datasets[0].borderWidth,
                                                hidden: false,
                                                index: i
                                            };
                                        });
                                    }
                                    return [];
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(15, 23, 42, 0.98)',
                            padding: 20,
                            titleFont: {
                                family: 'Inter, sans-serif',
                                size: 15,
                                weight: '700'
                            },
                            bodyFont: {
                                family: 'Inter, sans-serif',
                                size: 14,
                                weight: '600'
                            },
                            borderColor: 'rgba(17, 153, 142, 0.3)',
                            borderWidth: 2,
                            cornerRadius: 16,
                            displayColors: true,
                            callbacks: {
                                title: function(context) {
                                    // For Chart.js v3+, context is an array
                                    if (Array.isArray(context) && context.length > 0) {
                                        return context[0].label || '';
                                    }
                                    // Fallback for single context object
                                    if (context && context.label) {
                                        return context.label;
                                    }
                                    return '';
                                },
                                label: function(context) {
                                    try {
                                        let label = context.label || '';
                                        // For doughnut charts, get the value from context
                                        let value = 0;
                                        if (context.parsed !== undefined && context.parsed !== null) {
                                            value = context.parsed;
                                        } else if (context.raw !== undefined && context.raw !== null) {
                                            value = context.raw;
                                        } else if (context.dataset && context.dataset.data && context.dataIndex !== undefined) {
                                            value = context.dataset.data[context.dataIndex] || 0;
                                        }
                                        
                                        // Calculate total
                                        const total = context.dataset.data.reduce((a, b) => {
                                            const val = (b === 0.01 || b === null || b === undefined) ? 0 : b;
                                            return a + val;
                                        }, 0);
                                        
                                        // Calculate percentage
                                        const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : '0.0';
                                        
                                        // Format amount
                                        let formattedAmount;
                                        if (typeof __currency_trans_from_en !== 'undefined') {
                                            formattedAmount = __currency_trans_from_en(value, true);
                                        } else {
                                            formattedAmount = new Intl.NumberFormat('en-US', {
                                                style: 'currency',
                                                currency: 'USD',
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0
                                            }).format(value);
                                        }
                                        
                                        return [
                                            label + ' ' + percentage + '%',
                                            'Amount ' + formattedAmount
                                        ];
                                    } catch(e) {
                                        console.error('Tooltip error:', e);
                                        return [context.label || '', 'Error loading data'];
                                    }
                                }
                            }
                        }
                    }
                },
                plugins: [{
                    id: 'centerText',
                    beforeDraw: function(chart) {
                        const ctx = chart.ctx;
                        const chartArea = chart.chartArea;
                        ctx.save();
                        ctx.font = 'bold 20px Inter, sans-serif';
                        ctx.fillStyle = '#1e293b';
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'middle';
                        const centerX = (chartArea.left + chartArea.right) / 2;
                        const centerY = (chartArea.top + chartArea.bottom) / 2;
                        ctx.fillText(netPercent + '%', centerX, centerY - 8);
                        ctx.font = '600 11px Inter, sans-serif';
                        ctx.fillStyle = '#64748b';
                        ctx.fillText('Net', centerX, centerY + 12);
                        ctx.restore();
                    }
                }]
            });
                } // Close else block for netVsExpenseChart
            } catch(e) {
                console.error('Error creating Net vs Expense chart:', e);
            }

            try {
            // Cash vs Credit Sales Chart - Modern Style with Center Percentage
            const cashVsCreditCanvas = document.getElementById('cashVsCreditChart');
            if (!cashVsCreditCanvas) {
                console.error('cashVsCreditChart canvas not found');
            } else {
                const cashVsCreditCtx = cashVsCreditCanvas.getContext('2d');
            
            // Create gradient for Cash Sales
            const cashGradient = cashVsCreditCtx.createLinearGradient(0, 0, 0, 400);
            cashGradient.addColorStop(0, 'rgba(34, 197, 94, 1)');
            cashGradient.addColorStop(1, 'rgba(74, 222, 128, 1)');
            
            // Create gradient for Credit Sales
            const creditGradient = cashVsCreditCtx.createLinearGradient(0, 0, 0, 400);
            creditGradient.addColorStop(0, 'rgba(99, 102, 241, 1)');
            creditGradient.addColorStop(1, 'rgba(129, 140, 248, 1)');
            
            const totalCashCredit = <?php echo e($cash_sales ?? 0, false); ?> + <?php echo e($credit_sales ?? 0, false); ?>;
            const cashPercent = totalCashCredit > 0 ? ((<?php echo e($cash_sales ?? 0, false); ?> / totalCashCredit) * 100).toFixed(1) : 0;
            const cashValue = <?php echo e($cash_sales ?? 0, false); ?> || 0.01;
            const creditValue = <?php echo e($credit_sales ?? 0, false); ?> || 0.01;
            
            new Chart(cashVsCreditCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Cash Sales', 'Credit Sales'],
                    datasets: [{
                        data: [
                            cashValue,
                            creditValue
                        ],
                        backgroundColor: [
                            cashGradient,
                            creditGradient
                        ],
                        borderColor: [
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)'
                        ],
                        borderWidth: 4,
                        hoverOffset: 20,
                        hoverBorderWidth: 5,
                        spacing: 3
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%',
                    animation: {
                        animateRotate: true,
                        animateScale: true,
                        duration: 1500,
                        easing: 'easeOutQuart'
                    },
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 4,
                                usePointStyle: true,
                                pointStyle: 'circle',
                                pointStyleWidth: 8,
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 9,
                                    weight: '600'
                                },
                                color: '#475569',
                                generateLabels: function(chart) {
                                    const data = chart.data;
                                    if (data.labels.length && data.datasets.length) {
                                        const total = data.datasets[0].data.reduce((a, b) => a + (b === 0.01 ? 0 : b), 0);
                                        return data.labels.map((label, i) => {
                                            const value = data.datasets[0].data[i];
                                            const actualValue = value === 0.01 ? 0 : value;
                                            const percentage = total > 0 ? ((actualValue / total) * 100).toFixed(1) : 0;
                                            return {
                                                text: `${label}: ${percentage}%`,
                                                fillStyle: data.datasets[0].backgroundColor[i],
                                                strokeStyle: data.datasets[0].borderColor[i],
                                                lineWidth: data.datasets[0].borderWidth,
                                                hidden: false,
                                                index: i
                                            };
                                        });
                                    }
                                    return [];
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(15, 23, 42, 0.98)',
                            padding: 16,
                            titleFont: {
                                family: 'Inter, sans-serif',
                                size: 14,
                                weight: '700'
                            },
                            bodyFont: {
                                family: 'Inter, sans-serif',
                                size: 13,
                                weight: '600'
                            },
                            borderColor: 'rgba(34, 197, 94, 0.3)',
                            borderWidth: 2,
                            cornerRadius: 12,
                            displayColors: true,
                            callbacks: {
                                title: function(context) {
                                    // For Chart.js v3+, context is an array
                                    if (Array.isArray(context) && context.length > 0) {
                                        return context[0].label || '';
                                    }
                                    // Fallback for single context object
                                    if (context && context.label) {
                                        return context.label;
                                    }
                                    return '';
                                },
                                label: function(context) {
                                    try {
                                        let label = context.label || '';
                                        // For doughnut charts, get the value from context
                                        let value = 0;
                                        if (context.parsed !== undefined && context.parsed !== null) {
                                            value = context.parsed;
                                        } else if (context.raw !== undefined && context.raw !== null) {
                                            value = context.raw;
                                        } else if (context.dataset && context.dataset.data && context.dataIndex !== undefined) {
                                            value = context.dataset.data[context.dataIndex] || 0;
                                        }
                                        
                                        // Calculate total
                                        const total = context.dataset.data.reduce((a, b) => {
                                            const val = (b === 0.01 || b === null || b === undefined) ? 0 : b;
                                            return a + val;
                                        }, 0);
                                        
                                        // Calculate percentage
                                        const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : '0.0';
                                        
                                        // Format amount
                                        let formattedAmount;
                                        if (typeof __currency_trans_from_en !== 'undefined') {
                                            formattedAmount = __currency_trans_from_en(value, true);
                                        } else {
                                            formattedAmount = new Intl.NumberFormat('en-US', {
                                                style: 'currency',
                                                currency: 'USD',
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0
                                            }).format(value);
                                        }
                                        
                                        return [
                                            label + ' ' + percentage + '%',
                                            'Amount ' + formattedAmount
                                        ];
                                    } catch(e) {
                                        console.error('Tooltip error:', e);
                                        return [context.label || '', 'Error loading data'];
                                    }
                                }
                            }
                        }
                    }
                },
                plugins: [{
                    id: 'centerText',
                    beforeDraw: function(chart) {
                        const ctx = chart.ctx;
                        const chartArea = chart.chartArea;
                        ctx.save();
                        ctx.font = 'bold 20px Inter, sans-serif';
                        ctx.fillStyle = '#1e293b';
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'middle';
                        const centerX = (chartArea.left + chartArea.right) / 2;
                        const centerY = (chartArea.top + chartArea.bottom) / 2;
                        ctx.fillText(cashPercent + '%', centerX, centerY - 8);
                        ctx.font = '600 11px Inter, sans-serif';
                        ctx.fillStyle = '#64748b';
                        ctx.fillText('Cash Sales', centerX, centerY + 12);
                        ctx.restore();
                    }
                }]
            });
                } // Close else block for cashVsCreditChart
            } catch(e) {
                console.error('Error creating Cash vs Credit Sales chart:', e);
            }

            try {
            // Revenue Distribution Chart - Modern Style with Center Percentage
            const revenueDistributionCanvas = document.getElementById('revenueDistributionChart');
            if (!revenueDistributionCanvas) {
                console.error('revenueDistributionChart canvas not found');
            } else {
                const revenueDistributionCtx = revenueDistributionCanvas.getContext('2d');
            
            // Create gradients for each segment
            const salesRevGradient = revenueDistributionCtx.createLinearGradient(0, 0, 0, 400);
            salesRevGradient.addColorStop(0, 'rgba(102, 126, 234, 1)');
            salesRevGradient.addColorStop(1, 'rgba(118, 75, 162, 1)');
            
            const purchaseRevGradient = revenueDistributionCtx.createLinearGradient(0, 0, 0, 400);
            purchaseRevGradient.addColorStop(0, 'rgba(79, 70, 229, 1)');
            purchaseRevGradient.addColorStop(1, 'rgba(139, 92, 246, 1)');
            
            const expenseRevGradient = revenueDistributionCtx.createLinearGradient(0, 0, 0, 400);
            expenseRevGradient.addColorStop(0, 'rgba(245, 158, 11, 1)');
            expenseRevGradient.addColorStop(1, 'rgba(251, 191, 36, 1)');
            
            const returnRevGradient = revenueDistributionCtx.createLinearGradient(0, 0, 0, 400);
            returnRevGradient.addColorStop(0, 'rgba(239, 68, 68, 1)');
            returnRevGradient.addColorStop(1, 'rgba(248, 113, 113, 1)');
            
            const totalRevenue = <?php echo e($total_sell ?? 0, false); ?> + <?php echo e($total_purchase ?? 0, false); ?> + <?php echo e($total_expense ?? 0, false); ?> + <?php echo e($total_sell_return ?? 0, false); ?>;
            const salesRevPercent = totalRevenue > 0 ? ((<?php echo e($total_sell ?? 0, false); ?> / totalRevenue) * 100).toFixed(1) : 0;
            const salesValue = <?php echo e($total_sell ?? 0, false); ?> || 0.01;
            const purchaseValue = <?php echo e($total_purchase ?? 0, false); ?> || 0.01;
            const expenseValue = <?php echo e($total_expense ?? 0, false); ?> || 0.01;
            const returnValue = <?php echo e($total_sell_return ?? 0, false); ?> || 0.01;
            
            new Chart(revenueDistributionCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Sales', 'Purchases', 'Expenses', 'Returns'],
                    datasets: [{
                        data: [
                            salesValue,
                            purchaseValue,
                            expenseValue,
                            returnValue
                        ],
                        backgroundColor: [
                            salesRevGradient,
                            purchaseRevGradient,
                            expenseRevGradient,
                            returnRevGradient
                        ],
                        borderColor: [
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)',
                            'rgba(255, 255, 255, 1)'
                        ],
                        borderWidth: 4,
                        hoverOffset: 20,
                        hoverBorderWidth: 5,
                        spacing: 3
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%',
                    animation: {
                        animateRotate: true,
                        animateScale: true,
                        duration: 1500,
                        easing: 'easeOutQuart'
                    },
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 4,
                                boxWidth: 8,
                                boxHeight: 8,
                                usePointStyle: true,
                                pointStyle: 'circle',
                                pointStyleWidth: 8,
                                font: {
                                    family: 'Inter, sans-serif',
                                    size: 9,
                                    weight: '600'
                                },
                                color: '#475569',
                                generateLabels: function(chart) {
                                    const data = chart.data;
                                    if (data.labels.length && data.datasets.length) {
                                        const total = data.datasets[0].data.reduce((a, b) => a + (b === 0.01 ? 0 : b), 0);
                                        // Ensure order: Sales, Purchases, Expenses, Returns (2x2 grid)
                                        const order = ['Sales', 'Purchases', 'Expenses', 'Returns'];
                                        return order.map((labelName) => {
                                            const i = data.labels.indexOf(labelName);
                                            if (i === -1) return null;
                                            const value = data.datasets[0].data[i];
                                            const actualValue = value === 0.01 ? 0 : value;
                                            const percentage = total > 0 ? ((actualValue / total) * 100).toFixed(1) : 0;
                                            return {
                                                text: `${labelName}: ${percentage}%`,
                                                fillStyle: data.datasets[0].backgroundColor[i],
                                                strokeStyle: data.datasets[0].borderColor[i],
                                                lineWidth: data.datasets[0].borderWidth,
                                                hidden: false,
                                                index: i
                                            };
                                        }).filter(item => item !== null);
                                    }
                                    return [];
                                }
                            }
                        },
                        tooltip: {
                            enabled: true,
                            backgroundColor: 'rgba(15, 23, 42, 0.98)',
                            padding: 16,
                            titleFont: {
                                family: 'Inter, sans-serif',
                                size: 14,
                                weight: '700'
                            },
                            bodyFont: {
                                family: 'Inter, sans-serif',
                                size: 13,
                                weight: '600'
                            },
                            borderColor: 'rgba(102, 126, 234, 0.3)',
                            borderWidth: 2,
                            cornerRadius: 12,
                            displayColors: true,
                            callbacks: {
                                title: function(context) {
                                    // For Chart.js v3+, context is an array
                                    if (Array.isArray(context) && context.length > 0) {
                                        return context[0].label || '';
                                    }
                                    // Fallback for single context object
                                    if (context && context.label) {
                                        return context.label;
                                    }
                                    return '';
                                },
                                label: function(context) {
                                    try {
                                        let label = context.label || '';
                                        // For doughnut charts, get the value from context
                                        let value = 0;
                                        if (context.parsed !== undefined && context.parsed !== null) {
                                            value = context.parsed;
                                        } else if (context.raw !== undefined && context.raw !== null) {
                                            value = context.raw;
                                        } else if (context.dataset && context.dataset.data && context.dataIndex !== undefined) {
                                            value = context.dataset.data[context.dataIndex] || 0;
                                        }
                                        
                                        // Calculate total
                                        const total = context.dataset.data.reduce((a, b) => {
                                            const val = (b === 0.01 || b === null || b === undefined) ? 0 : b;
                                            return a + val;
                                        }, 0);
                                        
                                        // Calculate percentage
                                        const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : '0.0';
                                        
                                        // Format amount
                                        let formattedAmount;
                                        if (typeof __currency_trans_from_en !== 'undefined') {
                                            formattedAmount = __currency_trans_from_en(value, true);
                                        } else {
                                            formattedAmount = new Intl.NumberFormat('en-US', {
                                                style: 'currency',
                                                currency: 'USD',
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0
                                            }).format(value);
                                        }
                                        
                                        return [
                                            label + ' ' + percentage + '%',
                                            'Amount ' + formattedAmount
                                        ];
                                    } catch(e) {
                                        console.error('Tooltip error:', e);
                                        return [context.label || '', 'Error loading data'];
                                    }
                                }
                            }
                        },
                        interaction: {
                            intersect: false,
                            mode: 'point'
                        }
                    }
                },
                plugins: [{
                    id: 'centerText',
                    beforeDraw: function(chart) {
                        const ctx = chart.ctx;
                        const chartArea = chart.chartArea;
                        ctx.save();
                        ctx.font = 'bold 20px Inter, sans-serif';
                        ctx.fillStyle = '#1e293b';
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'middle';
                        const centerX = (chartArea.left + chartArea.right) / 2;
                        const centerY = (chartArea.top + chartArea.bottom) / 2;
                        ctx.fillText(salesRevPercent + '%', centerX, centerY - 8);
                        ctx.font = '600 11px Inter, sans-serif';
                        ctx.fillStyle = '#64748b';
                        ctx.fillText('Sales', centerX, centerY + 12);
                        ctx.restore();
                    }
                }]
            });
                } // Close else block for revenueDistributionChart
            } catch(e) {
                console.error('Error creating Revenue Distribution chart:', e);
            }

            try {
            // Profit Margin Trend Chart (Monthly) - Enhanced Design
            const profitMarginCanvas = document.getElementById('profitMarginChart');
            if (!profitMarginCanvas) {
                console.error('profitMarginChart canvas not found');
            } else {
                const profitMarginCtx = profitMarginCanvas.getContext('2d');
                
                // Calculate monthly profit margins using actual COGS (Cost of Goods Sold)
                const monthlyProfitMargins = [
                <?php for($month = 1; $month <= 12; $month++): ?>
                    <?php
                        $sales = $monthly_sales[$month] ?? 0;
                        $cogs = $monthly_cogs[$month] ?? 0;
                        // Profit Margin = (Revenue - COGS) / Revenue * 100
                        // This is Gross Profit Margin (before expenses)
                        $margin = ($sales > 0) ? (($sales - $cogs) / $sales) * 100 : 0;
                    ?>
                    <?php echo e(number_format($margin, 2), false); ?><?php echo e($month < 12 ? ',' : '', false); ?>

                <?php endfor; ?>
                ];
                
                // Create gradient for area fill
                const profitMarginGradient = profitMarginCtx.createLinearGradient(0, 0, 0, 400);
                profitMarginGradient.addColorStop(0, 'rgba(16, 185, 129, 0.3)');
                profitMarginGradient.addColorStop(0.5, 'rgba(16, 185, 129, 0.15)');
                profitMarginGradient.addColorStop(1, 'rgba(16, 185, 129, 0.05)');
                
                // Find min and max for better y-axis scaling with padding
                const minValue = Math.min(...monthlyProfitMargins);
                const maxValue = Math.max(...monthlyProfitMargins);
                const padding = Math.max(Math.abs(minValue), Math.abs(maxValue)) * 0.15; // 15% padding
                const yAxisMin = Math.floor((minValue - padding) / 10) * 10; // Round down to nearest 10
                const yAxisMax = Math.ceil((maxValue + padding) / 10) * 10; // Round up to nearest 10
                
                new Chart(profitMarginCtx, {
                    type: 'line',
                    data: {
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                        datasets: [{
                            label: 'Profit Margin %',
                            data: monthlyProfitMargins,
                            borderColor: 'rgba(16, 185, 129, 1)', // Green color
                            backgroundColor: profitMarginGradient,
                            borderWidth: 3,
                            fill: true,
                            tension: 0.4,
                            pointRadius: 6,
                            pointHoverRadius: 8,
                            pointBackgroundColor: 'rgba(16, 185, 129, 1)',
                            pointBorderColor: '#ffffff',
                            pointBorderWidth: 2,
                            pointHoverBackgroundColor: 'rgba(16, 185, 129, 1)',
                            pointHoverBorderColor: '#ffffff',
                            pointHoverBorderWidth: 3,
                            cubicInterpolationMode: 'monotone'
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false, // Allow chart to use full container height
                        layout: {
                            padding: {
                                top: 10,
                                bottom: 10,
                                left: 10,
                                right: 10
                            }
                        },
                        interaction: {
                            intersect: false,
                            mode: 'index'
                        },
                        plugins: {
                            legend: {
                                display: true,
                                position: 'top',
                                align: 'start',
                                labels: {
                                    usePointStyle: true,
                                    pointStyle: 'circle',
                                    padding: 15,
                                    font: {
                                        family: 'Inter, sans-serif',
                                        size: 12,
                                        weight: '600'
                                    },
                                    color: '#475569',
                                    generateLabels: function(chart) {
                                        return [{
                                            text: 'Profit Margin %',
                                            fillStyle: 'rgba(16, 185, 129, 1)',
                                            strokeStyle: 'rgba(16, 185, 129, 1)',
                                            lineWidth: 2,
                                            hidden: false,
                                            index: 0
                                        }];
                                    }
                                }
                            },
                            title: {
                                display: false // Hide Chart.js title, using HTML title instead
                            },
                            tooltip: {
                                backgroundColor: 'rgba(15, 23, 42, 0.98)',
                                padding: 16,
                                titleFont: {
                                    family: 'Inter, sans-serif',
                                    size: 14,
                                    weight: '700'
                                },
                                bodyFont: {
                                    family: 'Inter, sans-serif',
                                    size: 13,
                                    weight: '600'
                                },
                                borderColor: 'rgba(16, 185, 129, 0.3)',
                                borderWidth: 2,
                                cornerRadius: 12,
                                displayColors: true,
                                callbacks: {
                                    label: function(context) {
                                        let label = context.dataset.label || '';
                                        const value = context.parsed.y;
                                        return label + ': ' + value.toFixed(2) + '%';
                                    }
                                }
                            }
                        },
                        scales: {
                            x: {
                                grid: {
                                    display: false,
                                    drawBorder: false
                                },
                                ticks: {
                                    font: {
                                        family: 'Inter, sans-serif',
                                        size: 11,
                                        weight: '500'
                                    },
                                    color: '#64748b',
                                    padding: 10
                                }
                            },
                            y: {
                                beginAtZero: false,
                                min: yAxisMin, // Dynamic min based on data
                                max: yAxisMax, // Dynamic max based on data
                                ticks: {
                                    stepSize: Math.max(10, Math.ceil((yAxisMax - yAxisMin) / 6)), // Dynamic step size
                                    font: {
                                        family: 'Inter, sans-serif',
                                        size: 11,
                                        weight: '500'
                                    },
                                    color: '#64748b',
                                    padding: 10,
                                    callback: function(value) {
                                        return value + '%';
                                    }
                                },
                                grid: {
                                    color: 'rgba(100, 116, 139, 0.12)',
                                    lineWidth: 1,
                                    drawBorder: false
                                }
                            }
                        }
                    }
                });
            } // Close else block for profitMarginChart
            } catch(e) {
                console.error('Error creating Profit Margin Trend chart:', e);
            }
            
            console.log('All charts initialized successfully');
            
            // Force legend to display horizontally on single line (or 2x2 grid for Revenue Distribution)
            function forceLegendHorizontal() {
                $('.modern-chart-card').each(function() {
                    var $chartCard = $(this);
                    var $canvas = $chartCard.find('canvas');
                    
                    if ($canvas.length) {
                        var $legend = $canvas.next('div');
                        if ($legend.length) {
                            var canvasId = $canvas.attr('id');
                            
                            // Special handling for Revenue Distribution chart (2x2 grid)
                            if (canvasId === 'revenueDistributionChart') {
                                var $legendList = $legend.find('ul');
                                if ($legendList.length) {
                                    $legendList.css({
                                        'display': 'grid',
                                        'grid-template-columns': '1fr 1fr',
                                        'grid-template-rows': '1fr 1fr',
                                        'gap': '12px 20px',
                                        'justify-items': 'center',
                                        'align-items': 'center',
                                        'list-style': 'none',
                                        'margin': '0',
                                        'padding': '0',
                                        'width': '100%'
                                    });
                                    
                                    $legendList.find('li').css({
                                        'display': 'inline-flex',
                                        'align-items': 'center',
                                        'margin': '0',
                                        'padding': '0',
                                        'white-space': 'nowrap',
                                        'width': 'auto'
                                    });
                                }
                            } else {
                                // Force horizontal layout for other charts
                                $legend.css({
                                    'display': 'flex',
                                    'flex-direction': 'row',
                                    'flex-wrap': 'nowrap',
                                    'justify-content': 'center',
                                    'align-items': 'center',
                                    'width': '100%'
                                });
                                
                                var $legendList = $legend.find('ul');
                                if ($legendList.length) {
                                    $legendList.css({
                                        'display': 'flex',
                                        'flex-direction': 'row',
                                        'flex-wrap': 'nowrap',
                                        'justify-content': 'center',
                                        'align-items': 'center',
                                        'list-style': 'none',
                                        'margin': '0',
                                        'padding': '0',
                                        'gap': '12px'
                                    });
                                    
                                    $legendList.find('li').css({
                                        'display': 'inline-flex',
                                        'align-items': 'center',
                                        'margin': '0',
                                        'padding': '0',
                                        'white-space': 'nowrap',
                                        'float': 'none'
                                    });
                                }
                            }
                        }
                    }
                });
            }
            
            // Run after charts are rendered
            setTimeout(forceLegendHorizontal, 500);
            setTimeout(forceLegendHorizontal, 1000);
            setTimeout(forceLegendHorizontal, 2000);
        }
    </script>
<?php $__env->stopSection(); ?>

<!-- Floating Quick Menu Button -->
<button id="quickmenu-fab" class="quickmenu-fab" aria-label="Open Quick Menu">
    <i class="fa-solid fa-th-large"></i>
</button>

<!-- Quick Menu Modal -->
<div id="quickmenu-modal" class="quickmenu-modal" tabindex="-1" aria-modal="true" role="dialog">
    <div class="quickmenu-modal-overlay"></div>
    <div class="quickmenu-modal-container">
        <div class="quickmenu-header">
            <h2>Quick Menu</h2>
            <button id="quickmenu-close" class="quickmenu-close" aria-label="Close Quick Menu">
                <i class="fa-solid fa-times"></i>
            </button>
        </div>
        <div class="quickmenu-search">
            <i class="fa-solid fa-search"></i>
            <input type="text" placeholder="Search menu..." id="quickmenu-search-input" autocomplete="off" />
        </div>
        <div class="quickmenu-content">
            <!-- Sales & Invoicing -->
            <div class="quickmenu-section">
                <div class="quickmenu-section-header">
                    <i class="fas fa-chart-line"></i>
                    <h3>Sales & Invoicing</h3>
                </div>
                <div class="quickmenu-card-grid">
                    <a href="<?php echo e(route('pos.create'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-cash-register"></i></div>
                        <div class="quickmenu-label">POS Sale</div>
                    </a>
                    <a href="<?php echo e(route('sells.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-file-invoice"></i></div>
                        <div class="quickmenu-label">Invoice</div>
                    </a>
                    <a href="<?php echo e(route('sell-return.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-undo-alt"></i></div>
                        <div class="quickmenu-label">Sales Return</div>
                    </a>
                </div>
            </div>
            <!-- Products -->
            <div class="quickmenu-section">
                <div class="quickmenu-section-header">
                    <i class="fas fa-box"></i>
                    <h3>Products</h3>
                </div>
                <div class="quickmenu-card-grid">
                    <a href="<?php echo e(route('products.create'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-plus-square"></i></div>
                        <div class="quickmenu-label">Create Product</div>
                    </a>
                    <a href="<?php echo e(route('products.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-list"></i></div>
                        <div class="quickmenu-label">Product List</div>
                    </a>
                    <a href="<?php echo e(action([\App\Http\Controllers\ReportController::class, 'getStockReport']), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-chart-bar"></i></div>
                        <div class="quickmenu-label">Stock Report</div>
                    </a>
                </div>
            </div>
            <!-- Purchases -->
            <div class="quickmenu-section">
                <div class="quickmenu-section-header">
                    <i class="fas fa-shopping-cart"></i>
                    <h3>Purchases</h3>
                </div>
                <div class="quickmenu-card-grid">
                    <a href="<?php echo e(route('purchases.create'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-cart-plus"></i></div>
                        <div class="quickmenu-label">Purchase</div>
                    </a>
                    <a href="<?php echo e(route('purchases.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-clipboard-list"></i></div>
                        <div class="quickmenu-label">Purchase List</div>
                    </a>
                </div>
            </div>
            <!-- Contacts -->
            <div class="quickmenu-section">
                <div class="quickmenu-section-header">
                    <i class="fas fa-address-book"></i>
                    <h3>Contacts</h3>
                </div>
                <div class="quickmenu-card-grid">
                    <a href="<?php echo e(route('contacts.index', ['type' => 'customer']), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-user"></i></div>
                        <div class="quickmenu-label">Customer</div>
                    </a>
                    <a href="<?php echo e(route('contacts.index', ['type' => 'supplier']), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-truck"></i></div>
                        <div class="quickmenu-label">Supplier</div>
                    </a>
                </div>
            </div>
            <!-- Administration -->
            <div class="quickmenu-section">
                <div class="quickmenu-section-header">
                    <i class="fas fa-cog"></i>
                    <h3>Administration</h3>
                </div>
                <div class="quickmenu-card-grid">
                    <a href="<?php echo e(route('users.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-users"></i></div>
                        <div class="quickmenu-label">Users</div>
                    </a>
                    <a href="<?php echo e(route('expenses.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-money-bill-wave"></i></div>
                        <div class="quickmenu-label">Expenses</div>
                    </a>
                    <a href="<?php echo e(route('business-location.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-store-alt"></i></div>
                        <div class="quickmenu-label">Business Location</div>
                    </a>
                    <a href="<?php echo e(route('account.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-university"></i></div>
                        <div class="quickmenu-label">Accounts</div>
                    </a>
                    <a href="<?php echo e(route('backup.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-cloud-upload-alt"></i></div>
                        <div class="quickmenu-label">Backup</div>
                    </a>
                    <a href="<?php echo e(route('invoice-schemes.index'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-file-invoice-dollar"></i></div>
                        <div class="quickmenu-label">Invoice Schemes</div>
                    </a>
                    <a href="<?php echo e(route('business.getBusinessSettings'), false); ?>" class="quickmenu-card">
                        <div class="quickmenu-icon-bg"><i class="fas fa-cogs"></i></div>
                        <div class="quickmenu-label">Business Settings</div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.quickmenu-fab {
    position: fixed;
    bottom: 2rem;
    right: 2rem;
    width: 4.5rem;
    height: 4.5rem;
    border-radius: 16px;
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    border: none;
    box-shadow: 0 10px 40px rgba(99, 102, 241, 0.3);
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 1000;
    backdrop-filter: blur(10px);
}

.quickmenu-fab i {
    font-size: 1.8rem;
    color: white;
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.1));
    transition: transform 0.3s ease;
}

.quickmenu-fab:hover {
    transform: scale(1.1);
    box-shadow: 0 20px 60px rgba(99, 102, 241, 0.5);
    background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%);
}

.quickmenu-fab:hover i {
    transform: rotate(180deg);
}

.quickmenu-modal {
    display: none;
    position: fixed;
    inset: 0;
    z-index: 1001;
}

.quickmenu-modal.active {
    display: block;
    animation: fadeIn 0.3s ease-out;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

.quickmenu-modal-overlay {
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.7);
    backdrop-filter: blur(10px);
}

.quickmenu-modal-container {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 90vw;
    max-width: 1000px;
    background: #ffffff;
    border-radius: 20px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
    overflow: hidden;
    animation: modalSlideUp 0.3s cubic-bezier(0.4, 0, 0.2, 1) both;
}

@keyframes modalSlideUp {
    0% { 
        transform: translate(-50%, -40%);
        opacity: 0;
    }
    100% { 
        transform: translate(-50%, -50%);
        opacity: 1;
    }
}

.quickmenu-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1.5rem;
    background: #FFB400;
    color: white;
}

.quickmenu-header h2 {
    font-size: 1.5rem;
    font-weight: 600;
    margin: 0;
}

.quickmenu-close {
    background: rgba(255,255,255,0.15);
    border: none;
    color: white;
    font-size: 1.2rem;
    cursor: pointer;
    padding: 0.5rem;
    border-radius: 12px;
    transition: all 0.2s ease;
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.quickmenu-close:hover {
    background: rgba(255,255,255,0.3);
    transform: rotate(90deg);
}

.quickmenu-search {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem 1.5rem;
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
}

.quickmenu-search i {
    color: #6366f1;
    font-size: 1.3rem;
}

.quickmenu-search input {
    flex: 1;
    border: 1px solid #e2e8f0;
    outline: none;
    background: white;
    border-radius: 12px;
    padding: 0.75rem 1rem;
    font-size: 0.95rem;
    transition: all 0.2s ease;
}

.quickmenu-search input:focus {
    border-color: #6366f1;
    box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.1);
}

.quickmenu-content {
    padding: 1.5rem;
    max-height: 65vh;
    overflow-y: auto;
    background: #ffffff;
}

.quickmenu-section {
    margin-bottom: 1.5rem;
    padding: 1.25rem;
    background: #ffffff;
    border-radius: 16px;
    border: 1px solid #e2e8f0;
}

.quickmenu-section:hover {
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    transform: translateY(-2px);
}

.quickmenu-section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.25rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #e2e8f0;
}

.quickmenu-section-header::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 100px;
    height: 2px;
    background: linear-gradient(90deg, #6366f1, #4f46e5);
}

.quickmenu-section-header i {
    font-size: 1.4rem;
    color: #6366f1;
    background: rgba(99, 102, 241, 0.1);
    padding: 0.75rem;
    border-radius: 12px;
}

.quickmenu-section-header h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1e293b;
    margin: 0;
}

.quickmenu-card-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
    gap: 1.25rem;
}

.quickmenu-card {
    display: flex;
    align-items: center;
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    padding: 1.25rem;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border: 1px solid #e2e8f0;
    text-decoration: none;
    gap: 1rem;
    position: relative;
    overflow: hidden;
    min-height: 80px;
}

.quickmenu-card::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: linear-gradient(135deg, rgba(99, 102, 241, 0.1) 0%, rgba(99, 102, 241, 0) 100%);
  opacity: 0;
  transition: opacity 0.3s ease;
}

.quickmenu-card:hover {
  transform: translateY(-3px) scale(1.02);
  box-shadow: 0 8px 20px rgba(99, 102, 241, 0.15);
  border-color: #6366f1;
}

.quickmenu-card:hover::before {
  opacity: 1;
}

.quickmenu-card:hover .quickmenu-icon-bg {
  transform: scale(1.1) rotate(5deg);
  background: linear-gradient(135deg, #FFB400 0%, #FFB400 100%);
}

.quickmenu-card:hover .quickmenu-label {
  color: #4f46e5;
  transform: translateX(2px);
}

.quickmenu-icon-bg {
  width: 48px;
  height: 48px;
  border-radius: 14px;
  background: #6366f1;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 1.4rem;
  flex-shrink: 0;
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.quickmenu-icon-bg i {
  color: #FFB400;
  font-size: 1.3rem;
  transition: transform 0.3s ease, color 0.3s;
}

.quickmenu-card:hover .quickmenu-icon-bg i {
  color: #fff;
}

.quickmenu-label {
  color: #1e293b;
  font-size: 1.1rem;
  font-weight: 500;
  transition: all 0.3s ease;
}

/* Add ripple effect */
.quickmenu-card::after {
  content: '';
  position: absolute;
  top: 50%;
  left: 50%;
  width: 5px;
  height: 5px;
  background: rgba(99, 102, 241, 0.3);
  opacity: 0;
  border-radius: 100%;
  transform: scale(1, 1) translate(-50%);
  transform-origin: 50% 50%;
}

.quickmenu-card:active::after {
  animation: ripple 0.6s ease-out;
}

@keyframes ripple {
  0% {
      transform: scale(0, 0);
      opacity: 0.5;
  }
  100% {
      transform: scale(100, 100);
      opacity: 0;
  }
}

@media (max-width: 768px) {
    .quickmenu-card-grid {
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    }
    
    .quickmenu-card {
        padding: 1rem;
        min-height: 70px;
    }
    
    .quickmenu-icon-bg {
        width: 42px;
        height: 42px;
        font-size: 1.2rem;
    }
    
    .quickmenu-icon-bg i {
        font-size: 1.2rem;
    }
    
    .quickmenu-label {
        font-size: 1rem;
    }
}

/* Add loading state styles */
.cont.loading {
    position: relative;
    pointer-events: none;
}

.cont.loading::after {
    content: '';
    position: absolute;
    inset: 0;
    background: rgba(255, 255, 255, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 20px;
}

.cont.loading::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 30px;
    height: 30px;
    border: 3px solid #6366f1;
    border-top-color: transparent;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    z-index: 1;
}

@keyframes spin {
    to { transform: translate(-50%, -50%) rotate(360deg); }
}

/* Add error state styles */
.cont.error {
    border-color: #ef4444 !important;
}

.cont.error h3 {
    color: #ef4444 !important;
}

/* Add tooltip styles */
.cont[data-tooltip] {
    position: relative;
}

.cont[data-tooltip]::after {
    content: attr(data-tooltip);
    position: absolute;
    bottom: 100%;
    left: 50%;
    transform: translateX(-50%);
    padding: 0.5rem 1rem;
    background: rgba(0, 0, 0, 0.8);
    color: white;
    border-radius: 8px;
    font-size: 0.875rem;
    white-space: nowrap;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.cont[data-tooltip]:hover::after {
    opacity: 1;
    visibility: visible;
    transform: translateX(-50%) translateY(-8px);
}

.quickmenu-icon-bg {
    background-color: #FFB400 !important;
    /* ...existing styles... */
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const fab = document.getElementById('quickmenu-fab');
    const modal = document.getElementById('quickmenu-modal');
    const close = document.getElementById('quickmenu-close');
    const overlay = document.querySelector('.quickmenu-modal-overlay');
    const searchInput = document.getElementById('quickmenu-search-input');
    const menuItems = document.querySelectorAll('.cont');

    // Performance optimization: Use Intersection Observer for lazy loading
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const img = entry.target.querySelector('img');
                if (img && img.dataset.src) {
                    img.src = img.dataset.src;
                    img.removeAttribute('data-src');
                }
                observer.unobserve(entry.target);
            }
        });
    }, {
        rootMargin: '50px'
    });

    menuItems.forEach(item => {
        observer.observe(item);
    });

    // Error handling for menu items
    function handleMenuItemClick(e) {
        const item = e.currentTarget;
        const href = item.getAttribute('href');
        
        if (!href) return;

        item.classList.add('loading');
        
        fetch(href, { method: 'HEAD' })
            .then(response => {
                if (!response.ok) throw new Error('Network response was not ok');
                window.location.href = href;
            })
            .catch(error => {
                console.error('Error:', error);
                item.classList.remove('loading');
                item.classList.add('error');
                item.setAttribute('data-tooltip', 'Failed to load. Please try again.');
                
                // Remove error state after 3 seconds
                setTimeout(() => {
                    item.classList.remove('error');
                    item.removeAttribute('data-tooltip');
                }, 3000);
            });
    }

    // Add click handlers with error handling
    menuItems.forEach(item => {
        item.addEventListener('click', handleMenuItemClick);
    });

    // Open modal with animation
    fab.addEventListener('click', () => {
        modal.classList.add('active');
        document.body.style.overflow = 'hidden';
        
        // Animate menu items sequentially
        menuItems.forEach((item, index) => {
            item.style.opacity = '0';
            item.style.transform = 'translateY(20px)';
            
            setTimeout(() => {
                item.style.transition = 'all 0.3s ease';
                item.style.opacity = '1';
                item.style.transform = 'translateY(0)';
            }, 50 * index);
        });

        if (searchInput) searchInput.focus();
    });

    // Close modal with animation
    function closeModal() {
        // Animate menu items out
        menuItems.forEach((item, index) => {
            item.style.transition = 'all 0.2s ease';
            item.style.opacity = '0';
            item.style.transform = 'translateY(20px)';
        });

        setTimeout(() => {
            modal.classList.remove('active');
            document.body.style.overflow = '';
            
            // Reset menu items
            menuItems.forEach(item => {
                item.style.opacity = '';
                item.style.transform = '';
            });
        }, 200);
    }

    close.addEventListener('click', closeModal);
    overlay.addEventListener('click', closeModal);

    // Close on Escape key
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && modal.classList.contains('active')) {
            closeModal();
        }
    });

    // Keyboard navigation with improved focus management
    let currentFocusIndex = -1;
    
    document.addEventListener('keydown', (e) => {
        if (!modal.classList.contains('active')) return;
        
        switch(e.key) {
            case 'ArrowDown':
                e.preventDefault();
                currentFocusIndex = Math.min(currentFocusIndex + 1, menuItems.length - 1);
                menuItems[currentFocusIndex].focus();
                break;
            case 'ArrowUp':
                e.preventDefault();
                currentFocusIndex = Math.max(currentFocusIndex - 1, 0);
                menuItems[currentFocusIndex].focus();
                break;
            case 'Enter':
                if (currentFocusIndex >= 0) {
                    menuItems[currentFocusIndex].click();
                }
                break;
            case 'Tab':
                // Prevent tabbing outside modal
                if (e.shiftKey && document.activeElement === menuItems[0]) {
                    e.preventDefault();
                    searchInput.focus();
                } else if (!e.shiftKey && document.activeElement === close) {
                    e.preventDefault();
                    menuItems[0].focus();
                }
                break;
        }
    });

    // Debounced search with improved performance
    if (searchInput) {
        let debounceTimer;
        const searchResults = new Map();
        
        searchInput.addEventListener('input', (e) => {
            clearTimeout(debounceTimer);
            debounceTimer = setTimeout(() => {
                const searchTerm = e.target.value.toLowerCase();
                
                // Check cache first
                if (searchResults.has(searchTerm)) {
                    applySearchResults(searchResults.get(searchTerm));
                    return;
                }
                
                const results = new Map();
                document.querySelectorAll('.quickmenu-section').forEach(section => {
                    let hasVisible = false;
                    section.querySelectorAll('.quickmenu-card').forEach(item => {
                        const text = item.textContent.toLowerCase();
                        const isVisible = text.includes(searchTerm);
                        results.set(item, isVisible);
                        if (isVisible) hasVisible = true;
                    });
                    section.style.display = hasVisible ? 'block' : 'none';
                });
                
                // Cache results
                searchResults.set(searchTerm, results);
                applySearchResults(results);
            }, 300);
        });
    }

    function applySearchResults(results) {
        results.forEach((isVisible, item) => {
            item.style.display = isVisible ? 'flex' : 'none';
        });
    }

    // Add focus styles with improved accessibility
    menuItems.forEach(item => {
        item.setAttribute('tabindex', '0');
        item.setAttribute('role', 'button');
        item.setAttribute('aria-label', item.querySelector('h3').textContent);
        
        item.addEventListener('focus', () => {
            item.style.transform = 'translateY(-5px) scale(1.03)';
            item.style.boxShadow = '0 12px 30px rgba(0,0,0,0.12)';
        });
        
        item.addEventListener('blur', () => {
            item.style.transform = '';
            item.style.boxShadow = '';
        });
    });
});
</script>

<script>
// Open sidebar menu programmatically
document.addEventListener('DOMContentLoaded', function() {
    // Try to trigger the sidebar button click
    const sidebarButton = document.querySelector('.small-view-button');
    
    if (sidebarButton) {
        // Trigger click on the sidebar button
        sidebarButton.click();
    } else {
        // Fallback: manually open the sidebar if button doesn't exist
        const sidebar = document.querySelector('.side-bar');
        const overlay = document.querySelector('.overlay');
        
        if (sidebar && overlay) {
            sidebar.classList.add('small-view-side-active');
            overlay.classList.remove('tw-hidden');
            overlay.style.display = 'block';
            $(overlay).fadeIn('slow');
        }
    }
});
</script>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragonpro\www\posyoo\resources\views/home/index.blade.php ENDPATH**/ ?>