<?php

use Illuminate\Http\Request;
use Modules\BusinessManagement\Http\Controllers\Api\LicenseValidationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Public License Validation API (No authentication required)
// This endpoint is used during module installation to validate licenses
Route::post('/license/validate', [LicenseValidationController::class, 'validate'])
    ->name('api.license.validate')
    ->middleware('api'); // Only throttle, no auth required

// API endpoint info (GET request for testing/documentation)
Route::get('/license/validate', [LicenseValidationController::class, 'info'])
    ->name('api.license.info')
    ->middleware('api');

// Protected routes (require authentication)
Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
