@extends('layouts.app')

@section('title', "Add Service")
@section('content')


<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>Add Service</h1>
</section>


<!-- Main content -->
<section class="content no-print">

  {!! Form::open(['url' => action([\App\Http\Controllers\WarrantyController::class, 'WarrantyEditPost']), 'method' => 'post', 'id' => 'add_warranty_service_form' ]) !!}

  <div class="box box-solid">
    <div class="box-body">
      <br><br><br>

      <div class="row">

        <div class="col-sm-8 col-sm-offset-2">

      
          <div class="form-group">
            {!! Form::label('serial_number', __('Enter Product serial number') . ':*') !!}
            <input type="text" readonly class="form-control" value="{{ $serial_number }}" name="serial_number">
          </div>
        </div>

      </div>
      <br><br><br>


      <div class="row" id="warrnty_service_box">
        <div class="col-sm-12 no-print">

            <div class="row">
                <div class="col-md-4">
                    <h3>Product Info: </h3>
                    <input name="product_id" id="service_fee" type="hidden" value="{{ $product_info->id }}">
                    <input name="serial_id" type="hidden" value="{{ $check_serialhash->id }}">
                    <input name="is_service" type="hidden" value="1">
        
                    <div class="form-group">
                        <label>Product name:
                            @if (!empty($product_info->name))
                            {{ $product_info->name  }}
                            @endif
                        </label>
                    </div>
                    <div class="form-group">
                        <label>
                            Product Entry Date:
                            @if (!empty($product_info->created_at))
                            {{@format_date($product_info->created_at)}}
                            @endif
                        </label>
                    </div>
                    {{-- Product Info --}}
        
                </div>
                <div class="col-md-4">
        
                    <h3>Purchase Info: </h3>
                    <div class="form-group">
                        <label>Supplier Name :
                            @if (!empty($suplier_info->name))
                            {{$suplier_info->name}}
                            @endif
                        </label>
                    </div>
                    <div class="form-group">
                        <label>Purchase Price:
                            @if (!empty($purchase_info->purchase_price))
                            {{$purchase_info->purchase_price}}
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>Purchase date:
                            @if (!empty($purchase_info->created_at))
                            {{@format_date($purchase_info->created_at)}}
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>Purchase Invoice No:
                            @if (!empty($purcesh_transaction_info->invoice_no))
                            {{$purcesh_transaction_info->invoice_no}}
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>See Invoice:
                            <a href="#" class="print-invoice"
                                data-href="{{ action([\App\Http\Controllers\PurchaseController::class, 'printInvoice'], [$purcesh_transaction_info->id]) }}">
                                <i class="fas fa-file-alt" aria-hidden="true"></i>
                            </a>
                        </label>
                    </div>
        
                </div>
        
        
                <div class="col-md-4">
        
                    @if (!empty($sell_info))
                    <h3>Sell Info: </h3>
        
                    <div class="form-group">
                        <label>Sell Date:
                            @if (!empty($sell_info->created_at))
                                {{@format_date($sell_info->created_at)}}
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>Customer Name:
                            @if (!empty($customer_info->name))
                            <input type="hidden" name="contact_id" value="{{ $customer_info->id }}">
                            {{$customer_info->name}}
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>Sell Amount:
                            @if (!empty($sell_info->unit_price))
                            {{$sell_info->unit_price}}
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>Sell Invoice No:
                            @if (!empty($sell_transaction_info->invoice_no))
                            {{$sell_transaction_info->invoice_no}}
                            @endif
                        </label>
                    </div>
                    <div class="form-group">
                        <label>
                            See Invoice:
                            <a href="#" data-href="{{ action([\App\Http\Controllers\SellController::class, 'show'], [$sell_transaction_info->id]) }}" class="btn-modal" data-container=".view_modal">
                                <i class="fas fa-eye" aria-hidden="true"></i>
                                 Show
                            </a>
        
                        </label>
                    </div>
        
                    @endif
        
        
                </div>
            </div>
        
        
            <div class="row">
                <div class="col-md-6">
                    <h3>Warranty info: </h3>
        
                    @if (empty($warranty_info))
                        <div class="form-group">
                            <label>No Warranty Include For this</label>
                        </div>
                    @else
        
        
                    <div class="form-group">
                        <label>Warranty name: {{ $warranty_info->name }}</label>
                    </div>
        
        
        
                    <div class="form-group">
                        <label>Warranty Duration: {{ $warranty_info->duration}} {{ $warranty_info->duration_type  }}</label>
                    </div>
        
                    @php
                        $w_duration_type = $warranty_info->duration_type;
                        $w_duration = $warranty_info->duration;
                        $w_total_day = 0;
                        if ($w_duration_type == "days") {
                            $w_total_day = $warranty_info->duration;
                        }
                        if ($w_duration_type == "years") {
                            $w_total_day = $warranty_info->duration * 365;
                        } 
                        if ($w_duration_type == "months") {
                            $w_total_day = $warranty_info->duration * 30;
                        }
                        $w_start_date = \Carbon\Carbon::parse($sell_transaction_info->transaction_date);
                        $w_end_date = $w_start_date->addDays($w_total_day)->toDateString();
        
                        $running_date = \Carbon\Carbon::now();
        
                        $diffInDays = $running_date->diffInDays($sell_transaction_info->transaction_date);
        
                        $w_Deadline = $w_total_day - $diffInDays;
        
                    @endphp
                    
                    <div class="form-group">
                        <label>Warranty Start Date: {{ \Carbon\Carbon::parse($sell_transaction_info->transaction_date)->toDateString() }}</label>
                    </div>
        
                    
                    <div class="form-group">
                        <label>Warranty End Date: {{ $w_end_date }}</label>
                    </div>
        
                    
        
                    <div class="form-group">
                        <label>
                            Warranty Deadline: @if ($w_Deadline <= 0) 0 @else {{ $w_Deadline }} @endif Days
                        </label>
                    </div>
        
        
                    @endif
        
                </div>
        
                <div class="col-md-6">
                    <h3>Warranty Service info: </h3>
        
                    <div class="form-group">
                        <label>Recived Date: 
                            @if (!empty($warranti_service_info->created_at))
                                {{@format_date($warranti_service_info->created_at)}}
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>Service Status : 
                            @if ($warranti_service_info->status == "delivered")
                                Delivered
                            @else
                                Servicing
                            @endif
                        </label>
                    </div>
        
                    <div class="form-group">
                        <label>Warranty Service Free: @format_currency($warranti_service_info->service_fee)</label>
                    </div>
        
                    <div class="form-group">
                        <label>Service Free Recived: 
                            @if (!empty($trans_payment))
                                @format_currency($trans_payment->amount)
                            @else
                                ৳ 0.00
                            @endif
                        </label>
                    </div>

                    <div class="form-group">
                        <label>Recived Observation: 
                            @if (!empty($service_transaction))
                                {{ $service_transaction->service_custom_field_1 }}
                            @endif
                        </label>
                    </div>
        
                </div>
                {{-- {{ $service_transaction_info }} --}}

                @if (!empty($warranty_info))
                    <div class="row text-center">
                        <div class="col-md-12 mt-15">
                            <label class="radio-inline">
                                <input type="radio" name="service_type_radio" class="servicetype" {{ $service_transaction_info->sub_type == "Service" ? "":"checked" }}  value="replacement">
                                Replacement                
                            </label>
                            <label class="radio-inline">
                                <input type="radio" name="service_type_radio" class="servicetype" {{ $service_transaction_info->sub_type == "Service" ? "checked":"" }} value="service">
                                Received for service                
                            </label>
                        </div>
                    </div>
                @endif

                {{-- Service Warranty --}}
                <div class="row mt-10">



                    <div class="col-md-12 replacement" style="{{ $service_transaction_info->sub_type == "Service" ? 'display: none;':'' }}">

                        @php
                            $row_index = 0;
                            $show_date = true;
                            $show_denomination = true;
                        @endphp

                            <div class="row">
                                @php
                                    $product_serial_numbers = App\SerialNumber::where('product_id', $product_info->id)->where('stock_status',"available")->get();
                                @endphp
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {!! Form::label("old_serial" ,__('Old Serial') . ':*') !!}
                                        <div class="input-group" style="width: 50%;">
                                            {!! Form::text("old_serial", $serial_number, ['class' => 'form-control', 'required', 'id' => "old_serial",'readonly']); !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {!! Form::label("new_serial" ,__('Select Replace Serial') . ':*') !!}
                                        <div class="input-group" style="width: 50%;">
                                            <select class="select invalid form-control productserialnumber" id="new_serial_input" required name="new_serial">
                                                <option value="">Please Select Replace Serial</option>
                                                @foreach ($product_serial_numbers as $product_serial_number)
                                                    <option value="{{ $product_serial_number->serial_number }}">{{ $product_serial_number->serial_number }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <label id="new_serial-error" style="display: none" class="error" for="name">This field is required.</label>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="note_0">Replacement Note:</label>
                                        {!! Form::textarea("service_custom_field_1", null, ['class' => 'form-control', 'id' => "service_custom_field_1",'rows'=>'2']); !!}
                                    </div>
                                </div>
                   
                            </div>
                            <div class="row text-center">
                                <button type="submit" id="warranty_replace" class="btn btn-primary btn-big print-invoice">Delevary</button>
                            </div>

    
                    </div>

                    <div class="col-md-12 service" style="{{ $service_transaction_info->sub_type == "Service" ? '':'display: none;' }}">

                            @php
                                $row_index = 0;
                                $show_date = true;
                                $show_denomination = true;
                            @endphp


                            <div class="row">
                    
                                @php
                                    $col_class = 'col-md-6';
                                if(!empty($accounts)){
                                    $col_class = 'col-md-4';
                                }


                                @endphp
                                <div class="{{$col_class}}">
                                    <div class="form-group">
                                        {!! Form::label("amount_sservice_free" ,__('Service Fee') . ':*') !!}
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <i class="fas fa-money-bill-alt"></i>
                                            </span>
                                            {!! Form::text("total_amount", $warranti_service_info->service_fee ? $warranti_service_info->service_fee : 0, ['class' => 'form-control payment-amount input_number', 'required', 'id' => "amount_sservice_free"]); !!}
                                        </div>
                                    </div>
                                </div>

                                <div class="{{$col_class}}">
                                    <div class="form-group">
                                        {!! Form::label("amount_sservice_free_recived" ,__('Received Service Fee') . ':*') !!}
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <i class="fas fa-money-bill-alt"></i>
                                            </span>
                                            {!! Form::text("recived_amount", $trans_payment? $trans_payment->amount : 0, ['class' => 'form-control payment-amount input_number', 'required', 'id' => "amount_sservice_free_recived"]); !!}
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="note_0">Problem note:</label>
                                            {!! Form::textarea("service_custom_field_1", null, ['class' => 'form-control', 'id' => "service_custom_field_1",'rows'=>'2']); !!}
                                    </div>
                                </div>
                                        

                            </div>

                            <div class="row text-center">
                                <button type="submit" id="warranty_recived" class="btn btn-primary btn-big print-invoice">Save</button>
                            </div>
                    </div>
                </div>
                {{-- /Service Warranty --}}
       
        
            </div>
        </div>
      </div>


    </div>
  </div>





  {!! Form::close() !!}
</section>
<!-- /.content -->

@stop



@section('javascript')

<script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/purchase.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>
{{-- <script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script> --}}
<!-- Call restaurant module if defined -->

<script type="text/javascript">


    $(document).ready(function () {

        $('.productserialnumber').select2({
            width: '100%'
        });
                  
        $(document).on('click', '#warranty_replace', function (e) {
            e.preventDefault(); // Prevent the form from submitting normally
            var form = $(this).closest('form'); // Get the closest form element
            var url = form.attr('action'); // Get the form action URL


            var input = document.getElementById('new_serial_input');
            var error_message = document.getElementById('new_serial-error');
            var value = input.value.trim();
            if (value === '') {
                // Remove style display: none
                error_message.style.display = '';
            }else{

                // Remove style display: none
                error_message.style.display = 'none';

                $.ajax({
                type: 'POST',
                url: url,
                data: form.serialize(), // Serialize the form data
                success: function (result) {
                    if (result.success == true) {
                        toastr.success(result.msg);
                    }else{
                        toastr.error(result.msg);
                    }
                },
                error: function (xhr, status, error) {
                    // Handle the error here
                    console.error(error);
                }
            });
            }


        });

        $(document).on('click', '#warranty_recived', function (e) {
            e.preventDefault(); // Prevent the form from submitting normally
            var form = $(this).closest('form'); // Get the closest form element
            var url = form.attr('action'); // Get the form action URL

            $.ajax({
                type: 'POST',
                url: url,
                data: form.serialize(), // Serialize the form data
                success: function (result) {
                    if (result.success == true) {
                        toastr.success(result.msg);
                    }else{
                        toastr.error(result.msg);
                    }
                },
                error: function (xhr, status, error) {
                    // Handle the error here
                    console.error(error);
                }
            });



        });

        $(document).on('click', '.servicetype', function() {
            if (this.value == 'replacement') {
                $('div.replacement').show();
                $('div.service').hide();
            } else if (this.value == 'service') {
                $('div.replacement').hide();
                $('div.service').show();
            }

        });


    });


    window.addEventListener('afterprint', function() {
		location.reload();
	});


</script>
@endsection