@extends('layouts.app')
@section('title', __('lang_v1.warranties'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    @lang('lang_v1.warranties')
  </h1>
</section>

<!-- Main content -->
<section class="content no-print">


       <!-- Sub Menu -->
       <div class="horizontal-scroll mb-10">
        @include('layouts.sub_menu.product')
    </div>
    <!---submenu end--->

  @component('components.widget', ['class' => 'box-primary', 'title' => __( 'All Warranty Service' )])
  @slot('tool')
  <div class="box-tools">
    <a class="btn btn-block btn-primary" href="{{ route('add.warranty.service') }}">
      <i class="fa fa-plus"></i>
      @lang( 'messages.add' )
    </a>
  </div>
  @endslot
  
  <table class="table table-bordered table-striped" id="service_warranty_table">
    <thead>
      <tr>
        <th>@lang( 'messages.action' )</th>
        <th>Product</th>
        <th>Serial N.</th>
        <th>Customer</th>
        <th>@lang( 'Warranty Name' )</th>
        <th>Duration</th>
        <th>Service Amount</th>
        <th>Total Paid</th>
        <th>Total Due</th>
        <th>Recived Invoice</th>
        <th>Delevary Invoice</th>
        <th style="text-align: center;">Service Status</th>
      </tr>
    </thead>



    <tbody>

      @foreach ($serviceWarranties as $servise_warranty)

      <tr>


        <td>
          <div class="btn-group">
            <button type="button" class="btn btn-info dropdown-toggle btn-xs" data-toggle="dropdown" aria-expanded="false">Actions
              <span class="caret"></span>
              <span class="sr-only">
                Toggle Dropdown
              </span>
            </button>

            <ul class="dropdown-menu dropdown-menu-left" role="menu">

      

                <li>
                  <a target="_blank" href="{{ route('warranty.edit', $servise_warranty->id) }}">
                    <i class="fas fa-edit"></i> 
                    Edit
                  </a>
                </li>

        


                <li>
                  <a href="{{ action([\App\Http\Controllers\WarrantyController::class, 'WarrantyDelete'], [$servise_warranty->id]) }}" class="delete-sale">
                    <i class="fas fa-trash"></i>
                      Delete
                  </a>
                </li>

                <li class="divider"></li>

                @if (!empty($servise_warranty->payment_id))
                  <li>
                      <a href="#" data-href="{{action([\App\Http\Controllers\TransactionPaymentController::class, 'viewPayment'], [$servise_warranty->payment_id])}}" class="btn-modal" data-container=".view_modal">
                        <i class="fas fa-eye" aria-hidden="true"></i> 
                        View Payments
                      </a>
                  </li>
                @endif

            </ul>

        </td>

        <td>{{ $servise_warranty->product_name }}</td>
        <td>{{ $servise_warranty->serial_number }}</td>
        <td>{{ $servise_warranty->contact_name }}</td>
        <td>{{ $servise_warranty->warranty_name }}</td>
        <td>{{ $servise_warranty->duration }} &nbsp; {{ $servise_warranty->duration_type }}</td>

        <td>
          @format_currency($servise_warranty->final_total)
        </td>

        <td>
          @format_currency($servise_warranty->paid_amount)
        </td>


        <td>
          @php
              $recived_amount = $servise_warranty->final_total - $servise_warranty->paid_amount;
          @endphp
          @format_currency($recived_amount)
        </td>

        <td>
          <a href="#" class="print-invoice btn btn-primary" data-href="{{route('warranty.RecivedprintInvoice', [$servise_warranty->id])}}"><i class="fa fa-print" aria-hidden="true"></i> Invoice</a>
        </td>
        <td>
          @if ($servise_warranty->service_status == "delivered")
            <a href="#" class="print-invoice btn btn-primary" data-href="{{route('warranty.DelevaryprintInvoice', [$servise_warranty->id])}}"><i class="fa fa-print" aria-hidden="true"></i> Invoice</a>
          @endif
        </td>

      
       
        <td class="service_status_box" style="display: flex;justify-content: space-evenly;">
          <span class="service_status" style="font-size: 13px;font-weight: 800;">
            @if ($servise_warranty->service_status == "delivered")
              Delivered
            @else
              Servicing
            @endif
          </span>
        </td>
        
      </tr>

      @endforeach
    </tbody>
  </table>
  @endcomponent

</section>
<!-- /.content -->
@stop

@section('javascript')
<script type="text/javascript">
  $(document).ready(function () {
    
    //Status table
    $('#service_warranty_table').DataTable({
      processing: true,
    });

  });

</script>
@endsection