@extends('layouts.app')
@section('title', __('lang_v1.warehouses'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('lang_v1.warehouses')
        <small class="tw-text-sm md:tw-text-base tw-text-gray-700 tw-font-semibold">@lang('lang_v1.manage_your_warehouses')</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_your_warehouses')])
        @slot('tool')
            <div class="box-tools">
                @can('warehouse.create')
                <button class="tw-dw-btn tw-bg-gradient-to-r tw-from-indigo-600 tw-to-blue-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full pull-right tw-mb-2 btn-modal"
                    data-href="{{action([\App\Http\Controllers\WarehouseController::class, 'create'])}}" 
                    data-container=".warehouse_modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <path d="M12 5l0 14" />
                        <path d="M5 12l14 0" />
                    </svg> @lang('messages.add')
                </button>
                @endcan
            </div>
        @endslot
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="warehouse_table">
                <thead>
                    <tr>
                        <th>@lang('invoice.name')</th>
                        <th>@lang('lang_v1.code')</th>
                        <th>@lang('business.city')</th>
                        <th>@lang('business.state')</th>
                        <th>@lang('lang_v1.status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade warehouse_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var warehouse_table = $('#warehouse_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ action([\App\Http\Controllers\WarehouseController::class, "index"]) }}',
            columns: [
                { data: 'name', name: 'name' },
                { data: 'code', name: 'code' },
                { data: 'city', name: 'city' },
                { data: 'state', name: 'state' },
                { data: 'is_active', name: 'is_active' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#warehouse_table'));
            }
        });

        $(document).on('click', '.delete_warehouse_button', function(e) {
            e.preventDefault();
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(result) {
                            if (result.success) {
                                toastr.success(result.msg);
                                warehouse_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });

        // Handle warehouse form submission (create)
        $(document).on('submit', 'form#warehouse_add_form', function(e) {
            e.preventDefault();
            var form = $(this);
            var submit_button = form.find('button[type="submit"]');
            
            $.ajax({
                method: 'POST',
                url: form.attr('action'),
                data: form.serialize(),
                dataType: 'json',
                beforeSend: function() {
                    submit_button.prop('disabled', true);
                },
                success: function(result) {
                    if (result.success) {
                        $('.warehouse_modal').modal('hide');
                        toastr.success(result.msg);
                        warehouse_table.ajax.reload();
                        form[0].reset();
                    } else {
                        toastr.error(result.msg);
                    }
                    submit_button.prop('disabled', false);
                },
                error: function(xhr) {
                    var errorMsg = 'Something went wrong';
                    if (xhr.responseJSON && xhr.responseJSON.msg) {
                        errorMsg = xhr.responseJSON.msg;
                    }
                    toastr.error(errorMsg);
                    submit_button.prop('disabled', false);
                }
            });
        });

        // Handle warehouse form submission (edit)
        $(document).on('submit', 'form#warehouse_edit_form', function(e) {
            e.preventDefault();
            var form = $(this);
            var submit_button = form.find('button[type="submit"]');
            
            $.ajax({
                method: 'PUT',
                url: form.attr('action'),
                data: form.serialize(),
                dataType: 'json',
                beforeSend: function() {
                    submit_button.prop('disabled', true);
                },
                success: function(result) {
                    if (result.success) {
                        $('.warehouse_modal').modal('hide');
                        toastr.success(result.msg);
                        warehouse_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                    submit_button.prop('disabled', false);
                },
                error: function(xhr) {
                    var errorMsg = 'Something went wrong';
                    if (xhr.responseJSON && xhr.responseJSON.msg) {
                        errorMsg = xhr.responseJSON.msg;
                    }
                    toastr.error(errorMsg);
                    submit_button.prop('disabled', false);
                }
            });
        });
    });
</script>
@endsection

